/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.scanner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import oracle.dbtools.migration.parser.ParserFactoryProvider;
import oracle.dbtools.migration.translation.api.TranslationAPI;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.recognisers.FileTypeRecognizerRegistry;
import oracle.dbtools.raptor.migration.applications.rules.parser.Regex;
import oracle.dbtools.raptor.migration.applications.rules.parser.RuleSet;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorArtifactEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorFileEvent;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessorListener;
import oracle.dbtools.raptor.migration.applications.scanner.IScanner;
import oracle.dbtools.raptor.migration.applications.utils.Utils;

public class FilePattern {
    private ArrayList<FileProcessorArtifactEvent> pf = new ArrayList();
    private File currentFile;
    private ArrayList<RuleSet> filePatterns;
    private ArrayList<String> backedup;
    private ArrayList<FileProcessorListener> m_listeners;
    private ScannerDetails m_options;
    private boolean changesMade = false;
    private int lines = 0;
    private BufferedReader bReader;

    public FilePattern(File file, ArrayList<RuleSet> arrayList, ArrayList<FileProcessorListener> arrayList2, ScannerDetails scannerDetails) {
        this.currentFile = file;
        this.filePatterns = arrayList;
        this.m_listeners = arrayList2;
        this.m_options = scannerDetails;
    }

    public ArrayList<String> getBackedUpFiles() {
        return this.backedup;
    }

    public void notifyListeners(FileProcessorEvent fileProcessorEvent) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            this.m_listeners.get(i).raiseEvent(fileProcessorEvent);
        }
    }

    public void notifyListeners(ArrayList<FileProcessorArtifactEvent> arrayList) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            this.m_listeners.get(i).raiseEvent(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Object object;
        boolean bl = this.m_options.isInPlace() || this.m_options.isOutputSpecified();
        BufferedWriter bufferedWriter = null;
        File file = null;
        int n = 0;
        String string = FileTypeRecognizerRegistry.getType(this.currentFile);
        FileProcessorFileEvent fileProcessorFileEvent = new FileProcessorFileEvent(this.currentFile.getName(), FileProcessorEvent.FILE, "open", Utils.getURI(this.currentFile, this.m_options), string, "START", 0);
        this.notifyListeners(fileProcessorFileEvent);
        if (this.filePatterns != null) {
            try {
                Object object2;
                Object object3;
                Reader reader;
                object = null;
                boolean bl2 = false;
                ArrayList<Regex> arrayList = new ArrayList<Regex>();
                this.lines = this.countLines(this.currentFile);
                if (this.currentFile.length() < 0x100000L) {
                    reader = new FileReader(this.currentFile);
                    object3 = new char[(int)(this.currentFile.length() * 2L)];
                    reader.read((char[])object3);
                    object = new String((char[])object3);
                    this.workOutPossibleMatches(string, (String)object, arrayList);
                } else {
                    bl2 = true;
                }
                reader = null;
                reader = object == null ? new FileReader(this.currentFile) : new StringReader(((String)object).trim());
                if (this.m_options.isOutputSpecified() || this.m_options.isInPlace()) {
                    object3 = new Random();
                    file = File.createTempFile("application" + ((Random)object3).nextInt(), ".tmp");
                    object2 = new FileWriter(file);
                    bufferedWriter = new BufferedWriter((Writer)object2);
                }
                if (bl2 || arrayList.size() > 0) {
                    this.bReader = new BufferedReader(reader);
                    object3 = null;
                    object2 = null;
                    boolean bl3 = false;
                    if (arrayList.size() > 0) {
                        Object object4 = object;
                        for (Regex regex : arrayList) {
                            object4 = object2 = this.searchFile(this.m_options, regex, (String)object4);
                        }
                        if (!((String)object2).equals(object3)) {
                            bl3 = true;
                        }
                        if (bufferedWriter != null) {
                            bufferedWriter.write((String)((object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf("\n"))) == null ? object3 : object2));
                        }
                        object2 = null;
                    } else {
                        while ((object3 = this.bReader.readLine()) != null) {
                            ++n;
                            Object object5 = object3;
                            for (RuleSet ruleSet : this.filePatterns) {
                                if (ruleSet.getSource() != null && ruleSet.getSource().toLowerCase().equals(string)) {
                                    for (Regex regex : ruleSet.getExpressions()) {
                                        object5 = object2 = this.searchFile(this.m_options, regex, (String)object5, n);
                                        if (((String)object2).equals(object3)) continue;
                                        bl3 = true;
                                        break;
                                    }
                                }
                                if (bufferedWriter == null) continue;
                                bufferedWriter.write((String)(object2 == null ? object3 : object2) + "\n");
                            }
                        }
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    reader.close();
                    if (bufferedWriter != null) {
                        if (bl3 && bl) {
                            this.backup();
                        }
                        Utils.copyFile(file, this.currentFile);
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).fine("Cannot open or read application file");
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
        this.notifyListeners(this.getResults());
        object = new FileProcessorFileEvent(this.currentFile.getName(), FileProcessorEvent.FILE, bl && this.changesMade ? "modified" : "scanned", Utils.getURI(this.currentFile, this.m_options), string, "FINISH", this.lines);
        this.notifyListeners((FileProcessorEvent)object);
    }

    private void workOutPossibleMatches(String string, String string2, ArrayList<Regex> arrayList) {
        for (RuleSet ruleSet : this.filePatterns) {
            Regex regex;
            Matcher matcher;
            if (ruleSet.getSource() == null || !ruleSet.getSource().toLowerCase().equals(string) && !ruleSet.getSource().toLowerCase().equals("ANY".toLowerCase()) || !ruleSet.isEnabled() || !(matcher = (regex = ruleSet.getRequiredExpression()).getPattern().matcher(string2)).find()) continue;
            Logger.getLogger(this.getClass().getName()).fine("\t Passed reqs:" + ruleSet.getName() + ":" + ruleSet.getRequiredExpression().getExpression());
            for (Regex regex2 : ruleSet.getExpressions()) {
                if (regex2.getExpression().trim().equals("")) continue;
                Matcher matcher2 = regex2.getPattern().matcher(string2);
                if (matcher2.find()) {
                    arrayList.add(regex2);
                }
                matcher2.reset();
            }
        }
    }

    private int countLines(File file) {
        int n = 0;
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while (bufferedReader.readLine() != null) {
                ++n;
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).fine("File cannot be found.");
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).fine("File cannot be opened.");
        }
        return n;
    }

    public ArrayList<FileProcessorArtifactEvent> getResults() {
        return this.pf;
    }

    private String searchFile(ScannerDetails scannerDetails, Regex regex, String string) {
        return this.searchFile(scannerDetails, regex, string, 0);
    }

    private String searchFile(ScannerDetails scannerDetails, Regex regex, String string, int n) {
        if (regex != null && regex.getExpression() != null) {
            Pattern pattern = regex.getPattern();
            Matcher matcher = null;
            matcher = pattern.matcher(string);
            boolean bl = scannerDetails.isInPlace() || scannerDetails.isOutputSpecified();
            try {
                ArrayList<StringsFound> arrayList = new ArrayList<StringsFound>();
                while (matcher.find() && !matcher.group().equals("")) {
                    String string2 = matcher.group();
                    int n2 = matcher.start();
                    int n3 = matcher.end();
                    int n4 = this.getLineNumber(string, n2);
                    if (n4 != 0) {
                        n = n4;
                    }
                    String string3 = "";
                    if (regex.hasParams()) {
                        string3 = this.getParameterString(string.substring(n3));
                    }
                    StringsFound stringsFound = new StringsFound(string2, n2, n3, n, string3);
                    arrayList.add(stringsFound);
                }
                string = this.checkAndMakeChanges(regex, string, bl, arrayList);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (matcher != null) {
                matcher.reset();
            }
        }
        return string;
    }

    private int getLineNumber(String string, int n) {
        int n2 = 0;
        if (string.substring(0, n).contains("\n")) {
            String string2 = string.substring(0, n);
            Matcher matcher = Pattern.compile("\n").matcher(string2);
            while (matcher.find()) {
                ++n2;
            }
        }
        return n2;
    }

    private String checkAndMakeChanges(Regex regex, String string, boolean bl, ArrayList<StringsFound> arrayList) {
        for (StringsFound stringsFound : arrayList) {
            FileProcessorArtifactEvent fileProcessorArtifactEvent;
            if (bl && this.makeWhatChanges(regex)) {
                String string2;
                string = string2 = this.doReplacement(string, regex, stringsFound);
                fileProcessorArtifactEvent = new FileProcessorArtifactEvent(this.currentFile.getAbsolutePath(), regex.getExpression(), regex.getReplacement(), stringsFound.getStringFound() + stringsFound.getParamString(), string2, stringsFound.getStart(), stringsFound.getEnd(), stringsFound.getLineNum(), "REPLACED", regex.getcodeType(), regex.getDescription(), this.m_options.getType());
                this.changesMade = true;
            } else {
                fileProcessorArtifactEvent = new FileProcessorArtifactEvent(this.currentFile.getAbsolutePath(), regex.getExpression(), regex.getReplacement(), stringsFound.getStringFound() + stringsFound.getParamString(), null, stringsFound.getStart(), stringsFound.getEnd(), stringsFound.getLineNum(), "SCANNED", regex.getcodeType(), regex.getDescription(), this.m_options.getType());
                this.changesMade = false;
            }
            if (fileProcessorArtifactEvent == null) continue;
            this.pf.add(fileProcessorArtifactEvent);
        }
        return string;
    }

    private boolean makeWhatChanges(Regex regex) {
        return regex.validReplacement();
    }

    private String doReplacement(String string, Regex regex, StringsFound stringsFound) {
        String string2;
        block18: {
            string2 = string;
            String string3 = stringsFound.getStringFound();
            if (regex.isDirectReplacement()) {
                String string4 = regex.getReplacement();
                if (string4 == null) {
                    string4 = "";
                }
                string2 = string2.replace(string3, string4);
            } else if (regex.isTranslatorSet()) {
                try {
                    String string5 = ParserFactoryProvider.getInstance().getParserString(this.m_options.getType().toLowerCase());
                    String string6 = TranslationAPI.translate((String)string3, (String)string5).getTargetString();
                    if (string6 != null && !string6.equals("")) {
                        string2 = string2.replace(string3, string6.replaceAll("\\$", "xXDOLLARXx")).replaceAll("xXDOLLARXx", "\\$");
                        break block18;
                    }
                    string2 = string2.replace(string3, regex.getErrorTags() + string3);
                }
                catch (TranslationException translationException) {
                    Logger.getLogger(this.getClass().getName()).fine("\t Translation Class not found");
                    string2 = string;
                }
            } else if (regex.isClassReplacementSet()) {
                try {
                    String string7 = regex.getClassString();
                    Class<?> clazz = Class.forName(string7);
                    IScanner iScanner = (IScanner)clazz.newInstance();
                    string2 = iScanner.doReplacement(string, string3);
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(FilePattern.class.getClass().getName()).finer("Failed to get anything from class in " + regex.getName() + " " + regex.getClassString());
                    string2 = string;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(FilePattern.class.getClass().getName()).finer("Failed to get anything from class in " + regex.getName() + " " + regex.getClassString());
                    string2 = string;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(FilePattern.class.getClass().getName()).finer("Failed to get anything from class in " + regex.getName() + " " + regex.getClassString());
                    string2 = string;
                }
            } else if (regex.isScriptReplacement()) {
                try {
                    ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                    ScriptEngine scriptEngine = scriptEngineManager.getEngineByExtension(regex.getScriptType());
                    scriptEngine.put("line", string3);
                    scriptEngine.eval(regex.getReplacement());
                    String string8 = scriptEngine.get("newString").toString();
                    if (string8 != null && string8.length() > 0) {
                        string2 = string2.replace(string3, string8);
                    }
                }
                catch (ScriptException scriptException) {
                    Logger.getLogger(FilePattern.class.getClass().getName()).finer("Failed to get anything from script in " + regex.getName());
                    string2 = string;
                }
            }
        }
        return string2;
    }

    private ArrayList<String> getParameters(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        char[] cArray = string.toCharArray();
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '(') {
                bl = true;
                if (++n <= 1) continue;
                string2 = string2 + cArray[i];
                continue;
            }
            if (cArray[i] == ')') {
                if (--n > 0) {
                    string2 = string2 + cArray[i];
                    continue;
                }
                if (n != 0) continue;
                arrayList.add(string2.trim());
                bl = false;
                continue;
            }
            if (cArray[i] == ',' && n == 1) {
                arrayList.add(string2.trim());
                string2 = "";
                continue;
            }
            if (!bl) continue;
            string2 = string2 + cArray[i];
        }
        return arrayList;
    }

    private String getParameterString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.getParameters(string).iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return "(" + stringBuilder.toString() + ")";
        }
        return "";
    }

    private boolean validateGroup(Regex regex, String string, String string2) {
        String string3 = "[<|\\(|[:blank:]]+" + regex.getExpression();
        Matcher matcher = Pattern.compile(string3).matcher(string);
        return matcher.find();
    }

    private void backup() {
        if (this.backedup == null) {
            this.backedup = new ArrayList();
        }
        if (!this.backedup.contains(this.currentFile.getAbsolutePath())) {
            Utils.copyFile(this.currentFile, new File(this.currentFile.getAbsolutePath() + ".backup"));
            this.backedup.add(this.currentFile.getAbsolutePath());
        }
    }

    private class StringsFound {
        private String stringFound = "";
        private String paramString = "";
        private int lineNum = 0;
        private int start = 0;
        private int end = 0;

        StringsFound(String string, int n, int n2, int n3, String string2) {
            this.stringFound = string;
            this.start = n;
            this.end = n2;
            this.lineNum = n3;
            this.paramString = string2;
        }

        public String getStringFound() {
            return this.stringFound;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getParamString() {
            return this.paramString;
        }

        public int getLineNum() {
            return this.lineNum;
        }
    }
}

