/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.beans.PropertyEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import oracle.bali.inspector.BorderlessTextField;
import oracle.bali.inspector.InspectorGroup;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.swing.NonNullComboBoxModel;

class PropertyEditorValueEditor
extends DefaultCellEditor {
    private PropertyEditor _editor;
    private JTable _table;
    private int _row;
    private static PropertyEditorValueEditor _sTextInstance;

    private PropertyEditorValueEditor() {
        super(new BorderlessTextField());
        JTextField textField = (JTextField)this.editorComponent;
        textField.removeActionListener(this.delegate);
        this.delegate = new Delegate();
        textField.addActionListener(this.delegate);
    }

    public void dispose() {
        this._editor = null;
        this._table = null;
    }

    private PropertyEditorValueEditor(JComboBox combobox) {
        super(combobox);
        combobox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        combobox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    }

    public static TableCellEditor getTextFieldEditor() {
        if (_sTextInstance == null) {
            _sTextInstance = new PropertyEditorValueEditor();
        }
        return _sTextInstance;
    }

    public static TableCellEditor getComboBoxEditor(String[] items) {
        NonNullComboBoxModel model = new NonNullComboBoxModel(items);
        return new PropertyEditorValueEditor(new JComboBox(model));
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        PropertyEditorAdapter editorFactory = PropertyEditorValueEditor._getEditorFactory(table, row);
        if (editorFactory != null) {
            this._editor = editorFactory.getPropertyEditor();
            this._table = table;
            this._row = row;
            value = this._editor.getAsText();
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean stopCellEditing() {
        if (this._editor != null) {
            String value = null;
            try {
                value = (String)super.getCellEditorValue();
                this._editor.setAsText(value);
            }
            catch (Exception e) {
                PropertyModel m = (PropertyModel)this._table.getModel();
                Object id = m.getPropertyID(this._row);
                PropertyEditorFactory factory = m.getPropertyEditorFactory(this._row);
                if (this._table instanceof PropertyInspector.ExtendedTable) {
                    PropertyInspector pi = ((PropertyInspector.ExtendedTable)this._table).__getInspector();
                    pi.getInspectorGroup().showErrorMessage(id, factory, pi, e, value);
                } else {
                    InspectorGroup.showErrorMessage(id, factory, this._table, e, value);
                }
                this.cancelCellEditing();
                return true;
            }
        }
        return super.stopCellEditing();
    }

    public Object getCellEditorValue() {
        if (this._editor != null) {
            this._editor.setAsText((String)super.getCellEditorValue());
            return this._editor.getValue();
        }
        return super.getCellEditorValue();
    }

    private static PropertyEditorAdapter _getEditorFactory(JTable table, int row) {
        if (table.getModel() instanceof PropertyModel) {
            PropertyModel m = (PropertyModel)table.getModel();
            return (PropertyEditorAdapter)m.getPropertyEditorFactory(row);
        }
        return null;
    }

    private class Delegate
    extends DefaultCellEditor.EditorDelegate {
        private Delegate() {
            super(PropertyEditorValueEditor.this);
        }

        public void setValue(Object value) {
            JTextField textField = (JTextField)PropertyEditorValueEditor.this.editorComponent;
            textField.setText(value != null ? value.toString() : null);
        }

        public Object getCellEditorValue() {
            JTextField textField = (JTextField)PropertyEditorValueEditor.this.editorComponent;
            String result = textField.getText();
            if (result != null && result.length() == 0) {
                result = null;
            }
            return result;
        }
    }
}

