/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.ComboBoxEditor;
import oracle.bali.inspector.editor.ComboBoxEditorSetup;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentInfo;

public final class ComboBoxEditorFactory
extends EditorComponentFactory {
    public boolean canCreateEditorFrom(Object creationInfo) {
        if (creationInfo instanceof EditorComponentInfo) {
            Object initialValue = ((EditorComponentInfo)creationInfo).initialValue();
            return this.isComboBoxModel(initialValue) || this.isStringArray(initialValue);
        }
        return this.isComboBoxModel(creationInfo) || this.isStringArray(creationInfo);
    }

    private boolean isComboBoxModel(Object creationInfo) {
        return creationInfo instanceof ComboBoxModel;
    }

    private boolean isStringArray(Object creationInfo) {
        if (creationInfo == null) {
            return false;
        }
        Class<?> creationInfoType = creationInfo.getClass();
        if (!creationInfoType.isArray()) {
            return false;
        }
        return String.class.isAssignableFrom(creationInfoType.getComponentType());
    }

    public JComboBox createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (this.isComboBoxModel(initialValue)) {
            return this.comboBox((ComboBoxModel)initialValue, propertyEditor);
        }
        if (this.isStringArray(initialValue)) {
            return this.comboBox(propertyEditor, (String[])initialValue);
        }
        return null;
    }

    public JComboBox updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.canCreateEditorFrom(initialValue)) {
            return null;
        }
        JComboBox editor = this.editorFrom(current, propertyEditor);
        if (this.isComboBoxModel(initialValue)) {
            return this.comboBox(editor, (ComboBoxModel)initialValue);
        }
        if (this.isStringArray(initialValue)) {
            return this.comboBox(editor, propertyEditor, (String[])initialValue);
        }
        return null;
    }

    private JComboBox editorFrom(Component current, PropertyEditorFactory2 propertyEditor) {
        if (current instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)current;
            ComboBoxEditorSetup.removeCurrentListeners(comboBox);
            return comboBox;
        }
        JComboBox comboBox = this.comboBox();
        return comboBox;
    }

    JComboBox comboBox(ComboBoxModel model, PropertyEditorFactory2 propertyEditor) {
        JComboBox editor = this.comboBox();
        return this.comboBox(editor, model);
    }

    JComboBox comboBox(JComboBox editor, ComboBoxModel model) {
        boolean popupVisible = editor.isPopupVisible();
        editor.setModel(model);
        if (popupVisible) {
            editor.setPopupVisible(true);
        }
        return editor;
    }

    JComboBox comboBox(PropertyEditorFactory2 propertyEditor, String[] model) {
        JComboBox editor = this.comboBox();
        return this.comboBox(editor, propertyEditor, model);
    }

    private JComboBox comboBox(JComboBox editor, PropertyEditorFactory2 propertyEditor, String[] model) {
        ComboBoxEditor.setItems(editor, model);
        editor.setSelectedItem(propertyEditor.getAsText());
        return editor;
    }

    private JComboBox comboBox() {
        return new ComboBoxEditor();
    }
}

