/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.builder;

import java.util.concurrent.atomic.AtomicLong;

public class Version {
    private final Class<?> type;
    private final Version parent;
    private final long version;
    private final AtomicLong count;

    Version(Class<?> type, Version parent, long version) {
        this.type = type;
        this.parent = parent;
        this.version = version;
        this.count = new AtomicLong();
    }

    Class<?> type() {
        return this.type;
    }

    Version child() {
        return new Version(this.type, this, this.count.incrementAndGet());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Version.name(this.type));
        if (this.version > 0L) {
            builder.append("(#");
            int pos = builder.length();
            Version current = this;
            while (current != null) {
                Version parent = current.parent;
                builder.insert(pos, Long.toString(current.version));
                if (parent != null) {
                    builder.insert(pos, '.');
                }
                current = parent;
            }
            builder.append(")");
        }
        return builder.toString();
    }

    private static String name(Class<?> type) {
        String name = type.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1 || dot == name.length() - 1) {
            return name;
        }
        return name.substring(dot + 1);
    }
}

