/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.activation.Activatables;
import oracle.dbtools.common.di.ConstrainedProvider;
import oracle.dbtools.common.di.CyclicDependencyException;
import oracle.dbtools.common.di.Dependencies;
import oracle.dbtools.common.di.DependencyArc;
import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.di.DependencyGraph;
import oracle.dbtools.common.di.DependencyInjectionException;
import oracle.dbtools.common.di.ExternalProviders;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.di.LogPipe;
import oracle.dbtools.common.di.MissingDependencyException;
import oracle.dbtools.common.di.ProviderLocatorImpl;
import oracle.dbtools.common.di.ServiceChooser;
import oracle.dbtools.common.di.ServiceFactory;
import oracle.dbtools.common.di.ServiceLocator;
import oracle.dbtools.common.di.Singletons;
import oracle.dbtools.common.di.TypeDependencies;
import oracle.dbtools.common.logging.JDKLogSink;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.plugin.api.di.Annotations;
import oracle.dbtools.plugin.api.logging.Log;

public class Services
implements ServiceLocator,
Dependencies,
Factory,
Closeable {
    final DependencyGraph graph;
    private final Activatables activatables;
    private final ServiceChooser chooser;
    private final ExternalProviders externals;
    private final Factory factory;
    private final Runnable onClose;
    private final SelfServices self = new SelfServices();
    private final Singletons singletons;
    public static final String SERVICES_ATTRIBUTE = Services.class.getName();
    private static final Log FALLBACK_LOG = new LogPipe(Iterables.iterable(new JDKLogSink()));
    private static final DependencyConstraints NO_CONSTRAINTS = DependencyConstraints.constraints(new Annotation[0]);

    private Services(String scopeName, DependencyGraph graph, ExternalProviders externals, Singletons parentScope, Runnable onClose) {
        if (parentScope != null && scopeName.equals(parentScope.scopeName())) {
            throw new IllegalArgumentException("A scope cannot have the same name as it's parent scope: " + scopeName);
        }
        this.graph = graph;
        this.chooser = new ServiceChooser(graph);
        this.externals = ExternalProviders.builder(externals).set(Annotations.class, Annotations.INSTANCE).set(ServiceLocator.class, this.self).set(Dependencies.class, this.self).set(Factory.class, this.self).build();
        ProviderLocatorImpl providerLocator = new ProviderLocatorImpl(this);
        this.activatables = new Activatables(FALLBACK_LOG);
        ServiceFactory factory = new ServiceFactory(scopeName, FALLBACK_LOG, graph, providerLocator, parentScope, this.externals, this.activatables);
        this.singletons = factory.singletons();
        this.factory = factory;
        this.onClose = onClose;
    }

    public <T> T acquire(Class<T> service) {
        return this.acquire(service, NO_CONSTRAINTS);
    }

    public <T> T acquire(Class<T> service, DependencyConstraints constraints) {
        Iterable<T> all = this._acquireAll(service, constraints, false);
        T impl = Iterables.first(all);
        if (impl == null) {
            throw MissingDependencyException.noProvider(null, service, constraints);
        }
        return service.cast(impl);
    }

    @Override
    public <T> Iterable<T> acquireAll(Class<T> service, DependencyConstraints constraints) {
        return this.acquireAll(service, constraints, false);
    }

    @Override
    public <T> Iterable<T> acquireAll(Class<T> type, DependencyConstraints constraints, boolean ignoreMissingDependencies) {
        return this._acquireAll(type, constraints, ignoreMissingDependencies);
    }

    @Override
    public boolean canProvide(Class<?> type, DependencyConstraints constraints) {
        boolean provides = this.externals.canProvide(type, constraints);
        if (!provides) {
            provides = this.graph.canProvide(type, constraints);
        }
        return provides;
    }

    @Override
    public void close() throws IOException {
        this.activatables.close();
        this.externals.close();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public String dump() {
        StringBuilder b = new StringBuilder();
        b.append(super.toString());
        b.append("\n");
        b.append(this.externals);
        b.append("\n");
        b.append(this.graph);
        b.append("\n");
        b.append(this.singletons);
        b.append(this.activatables);
        return b.toString();
    }

    public Builder extend() {
        return Services.builder(this);
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        return this.factory.newInstance(type);
    }

    @Override
    public Iterable<Class<?>> providers(Class<?> type) {
        ArrayList providers = new ArrayList();
        for (Class<?> implementation : this.graph.providers(type)) {
            Collection<DependencyArc> unresolved = this.unresolved(implementation);
            if (unresolved.isEmpty()) {
                providers.add(implementation);
                continue;
            }
            String scopeName = this.singletons.scopeName();
            FALLBACK_LOG.finest("Ignoring: " + implementation.getName() + " due to missing dependencies: " + unresolved + " in scope: " + scopeName);
        }
        return providers;
    }

    public String toString() {
        return this.singletons.scopeName();
    }

    private <T> Iterable<T> _acquireAll(Class<T> service, DependencyConstraints constraints, boolean ignoreMissingDependencies) {
        LinkedHashSet<T> all = new LinkedHashSet<T>();
        Iterable<T> externals = this.externals.acquireAll(service, constraints);
        Iterables.add(all, externals);
        Iterable<Class<?>> matches = this.chooser.choose(service, constraints);
        for (Class<?> provider : matches) {
            try {
                Object impl = this.factory.newInstance(provider);
                if (null == impl) continue;
                T instance = service.cast(impl);
                all.add(instance);
            }
            catch (MissingDependencyException e) {
                if (ignoreMissingDependencies) {
                    FALLBACK_LOG.finest((Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        return all;
    }

    private Collection<DependencyArc> unresolved(Class<?> type) {
        LinkedHashSet<DependencyArc> unresolved = new LinkedHashSet<DependencyArc>();
        Iterable<TypeDependencies> allDependencies = this.graph.allDependencies(type);
        block0: for (TypeDependencies dependenciesForType : allDependencies) {
            for (DependencyArc arc : dependenciesForType.arcs()) {
                boolean resolved;
                if (!arc.isRequired() || arc.hasMultiple() || !arc.external() || (resolved = this.externals.canProvide(arc.dependency().type(), arc.constraints()))) continue;
                unresolved.add(arc);
                continue block0;
            }
        }
        return unresolved;
    }

    public static Builder builder() {
        return Services.builder(null);
    }

    public static Builder builder(Services existing) {
        return new Builder(existing);
    }

    private class SelfServices
    implements ServiceLocator,
    Dependencies,
    Factory {
        private SelfServices() {
        }

        @Override
        public <T> Iterable<T> acquireAll(Class<T> type, DependencyConstraints constraints) {
            return Services.this.acquireAll(type, constraints);
        }

        @Override
        public <T> Iterable<T> acquireAll(Class<T> type, DependencyConstraints constraints, boolean ignoreMissingDependencies) {
            return Services.this.acquireAll(type, constraints, ignoreMissingDependencies);
        }

        @Override
        public boolean canProvide(Class<?> type, DependencyConstraints constraints) {
            return Services.this.canProvide(type, constraints);
        }

        @Override
        public <T> T newInstance(Class<T> type) {
            return Services.this.newInstance(type);
        }

        @Override
        public Iterable<Class<?>> providers(Class<?> type) {
            return Services.this.providers(type);
        }

        public String toString() {
            return Services.this.toString();
        }
    }

    public static class Builder {
        private final DependencyGraph.Builder graph;
        private String name = "Test Scope";
        private Runnable onClose;
        private final Services parent;
        private final ExternalProviders.Builder providers;

        private Builder(Services existing) {
            this.graph = DependencyGraph.builder(null == existing ? null : existing.graph);
            this.providers = ExternalProviders.builder(null == existing ? null : existing.externals);
            this.parent = existing;
        }

        public Builder add(Class<?> providerType) {
            if (!this.graph.contains(providerType)) {
                this.graph.add(providerType);
            }
            return this;
        }

        public Builder add(Class<?> provides, Object impl, DependencyConstraints constraints) {
            this.providers.add(provides, impl, constraints);
            return this;
        }

        public Builder add(Iterable<Class<?>> providerTypes) {
            for (Class<?> providerType : providerTypes) {
                this.add(providerType);
            }
            return this;
        }

        public Services build() {
            this.add(LogPipe.class);
            DependencyGraph graph = this.graph.build();
            ExternalProviders providers = this.providers.build();
            Services scope = new Services(this.name, graph, providers, null == this.parent ? null : this.parent.singletons, this.onClose);
            return scope;
        }

        public Services build(String scopeName) throws CyclicDependencyException {
            return this.name(scopeName).build();
        }

        public Builder ignore(Class<?> serviceType) {
            this.graph.ignore(serviceType);
            this.providers.remove(serviceType);
            return this;
        }

        public Builder load(ClassLoader scope) {
            try {
                LinkedHashSet services = new LinkedHashSet();
                Enumeration<URL> resources = scope.getResources("META-INF/oracle.dbtools.plugin.api.di.providers");
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    services.addAll(Builder.load(scope, resource));
                }
                if (services.isEmpty()) {
                    throw DependencyInjectionException.noProvidersFound();
                }
                this.add(services);
            }
            catch (IOException e) {
                throw DependencyInjectionException.ioError(e);
            }
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder onClose(Runnable onClose) {
            this.onClose = onClose;
            return this;
        }

        public Services parent() {
            return this.parent;
        }

        public Builder remove(Class<?> providerType) {
            this.graph.remove(providerType);
            return this;
        }

        public Builder set(Class<?> provides, ConstrainedProvider<?> provider) {
            this.providers.set(provides, provider);
            return this;
        }

        public Builder set(Class<?> provides, Object impl, DependencyConstraints constraints) {
            this.providers.set(provides, impl, constraints);
            return this;
        }

        private static Class<?> load(ClassLoader scope, String serviceName) {
            try {
                Class<?> clazz = scope.loadClass(serviceName);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                FALLBACK_LOG.warning((Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Set<Class<?>> load(ClassLoader scope, URL resource) throws IOException {
            FALLBACK_LOG.fine("Loading services from manifest: " + resource.toString());
            LinkedHashSet classes = new LinkedHashSet();
            try (BufferedReader r = null;){
                r = new BufferedReader(new InputStreamReader(resource.openStream(), "UTF-8"));
                String service = r.readLine();
                while (service != null) {
                    Class<?> type = Builder.load(scope, service);
                    if (type != null) {
                        classes.add(type);
                    }
                    service = r.readLine();
                }
                LinkedHashSet linkedHashSet = classes;
                return linkedHashSet;
            }
        }
    }
}

