/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.VertexLookup;

class EdgeImpl<V, E>
implements Edge<V, E> {
    private final int destinationIndex;
    private final E value;
    private final transient VertexLookup<V, E> vertices;

    EdgeImpl(E value, int destinationIndex, VertexLookup<V, E> vertices) {
        this.value = value;
        this.destinationIndex = destinationIndex;
        this.vertices = vertices;
    }

    @Override
    public Vertex<V, E> destination() {
        return this.vertices.vertex(this.destinationIndex);
    }

    @Override
    public int destinationIndex() {
        return this.destinationIndex;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeImpl)) {
            return false;
        }
        EdgeImpl other = (EdgeImpl)obj;
        if (this.destinationIndex != other.destinationIndex) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.destinationIndex;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EdgeImpl [value=");
        builder.append(this.value);
        builder.append(", destinationIndex=");
        builder.append(this.destinationIndex);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public E value() {
        return this.value;
    }
}

