/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.locale;

import java.net.URI;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.headers.QualityValue;
import oracle.dbtools.common.headers.QualityValuesParser;
import oracle.dbtools.common.locale.LocalePreference;
import oracle.dbtools.common.locale.LocalePreferenceImpl;
import oracle.dbtools.common.locale.LocalePreferences;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TransformCache;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class LocalePreferencesProvider
implements LocalePreferences {
    private final QualityValuesParser<Locale> parser = new QualityValuesParser<Locale>(new LocaleFactory());
    static final TransformCache<Pair<URI, LocalePreference>, URI> BEST_MATCHES = new TransformCache<Pair<URI, LocalePreference>, URI>(new BestLocaleMatch(), false);
    static final Locale DEFAULT_LOCALE = new Locale("en");
    private static final String ACCEPT_LANGUAGE = "Accept-Language";

    @Inject
    LocalePreferencesProvider() {
    }

    @Override
    public LocalePreference preference(HttpServletRequest request) {
        if (request == null) {
            return LocalePreference.DEFAULT;
        }
        Enumeration values = request.getHeaders(ACCEPT_LANGUAGE);
        return this.preference(Iterables.iterable(Iterators.iterator(values)));
    }

    @Override
    public LocalePreference preference(String acceptLanguage) {
        if (NullOrEmpty.nullOrEmpty(acceptLanguage)) {
            return LocalePreference.DEFAULT;
        }
        return this.preference(Iterables.iterable(acceptLanguage));
    }

    private LocalePreference preference(Iterable<String> headerValues) {
        Iterable<Locale> prefs = this.parser.ordered(headerValues);
        if (NullOrEmpty.nullOrEmpty(prefs)) {
            return LocalePreference.DEFAULT;
        }
        return new LocalePreferenceImpl(prefs);
    }

    public void reset() {
        BEST_MATCHES.clear();
    }

    private static String asPath(Locale locale, Constraint constraint) {
        StringBuilder b = new StringBuilder();
        b.append(locale.getLanguage().toLowerCase());
        String country = locale.getCountry().toUpperCase();
        if (!(constraint != Constraint.COUNTRY && constraint != Constraint.VARIANT || NullOrEmpty.nullOrEmpty(country))) {
            b.append('_');
            b.append(country);
        }
        String variant = locale.getVariant().toUpperCase();
        if (constraint == Constraint.VARIANT && !NullOrEmpty.nullOrEmpty(variant)) {
            b.append('_');
            b.append(variant);
        }
        b.append('/');
        return b.toString();
    }

    private static URI bestMatch(URI root, Locale locale) {
        Constraint constraint;
        URI candidate = null;
        Constraint[] arr$ = Constraint.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !URIs.exists(candidate = URIs.resolve(root, LocalePreferencesProvider.asPath(locale, constraint = arr$[i$]))); ++i$) {
            candidate = null;
        }
        return candidate;
    }

    private static enum Constraint {
        COUNTRY,
        LANGUAGE,
        VARIANT;

    }

    private static class BestLocaleMatch
    implements Transform<Pair<URI, LocalePreference>, URI> {
        private BestLocaleMatch() {
        }

        @Override
        public URI apply(Pair<URI, LocalePreference> x) {
            Locale locale;
            URI root = x.first();
            LocalePreference pref = x.second();
            URI candidate = root;
            Iterator i$ = pref.iterator();
            while (i$.hasNext() && (candidate = LocalePreferencesProvider.bestMatch(root, locale = (Locale)i$.next())) == null) {
            }
            if (candidate == null) {
                candidate = LocalePreferencesProvider.bestMatch(root, DEFAULT_LOCALE);
            }
            if (candidate == null) {
                candidate = root;
            }
            return candidate;
        }
    }

    private static class LocaleFactory
    implements QualityValue.Factory<Locale> {
        private LocaleFactory() {
        }

        @Override
        public Locale apply(String langRegion) {
            String[] lr = langRegion.split("-");
            Locale locale = new Locale(lr[0].toLowerCase());
            if (lr.length == 2) {
                locale = new Locale(lr[0].toLowerCase(), lr[1].toUpperCase());
            }
            return locale;
        }
    }
}

