/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import oracle.dbtools.common.reflect.MethodInvocation;
import oracle.dbtools.common.reflect.MethodInvocationDecorator;
import oracle.dbtools.common.reflect.MethodInvocationHandler;
import oracle.dbtools.common.util.Reflections;

public class MethodInvocationTracer
extends MethodInvocationDecorator {
    private final MethodInvocationDecorator decorator;
    private final Class<?>[] tracedTypes;
    private static final Method EQUALS = Reflections.method(Object.class, "equals", Object.class);

    public MethodInvocationTracer(MethodInvocationDecorator decorator, Class<?> ... tracedTypes) {
        this.decorator = decorator;
        this.tracedTypes = tracedTypes;
    }

    @Override
    public Object after(Object result, MethodInvocation invocation) throws InvocationTargetException {
        Class<?> type = invocation.method().getReturnType();
        if (this.isEqualsOnSelf(invocation)) {
            result = Boolean.TRUE;
        }
        Object traced = this.trace(result, type);
        return this.decorator.after(traced, invocation);
    }

    @Override
    public MethodInvocation before(MethodInvocation invocation) throws InvocationTargetException {
        return this.decorator.before(invocation);
    }

    @Override
    public Throwable onException(Throwable e, MethodInvocation invocation) {
        return this.decorator.onException(e, invocation);
    }

    private Class<?>[] superInterfaces(Class<?> type) {
        LinkedHashSet interfaces = new LinkedHashSet();
        Class<?> current = type;
        while (current != null) {
            for (Class<?> iface : current.getInterfaces()) {
                interfaces.add(iface);
            }
            if ((current = current.getSuperclass()) != Object.class) continue;
            current = null;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public <T> T trace(Object target, Class<?> type) {
        Object result = null;
        result = target != null && this.shouldTrace(target) ? type.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), this.superInterfaces(target.getClass()), (InvocationHandler)new MethodInvocationHandler(target, this))) : target;
        Object value = result;
        return (T)value;
    }

    protected boolean shouldTrace(Object target) {
        return !this.isTraced(target) && this.superInterfaces(target.getClass()).length > 0 && !Reflections.isPrimitive(target.getClass()) && this.isTracedType(target.getClass());
    }

    private boolean isEqualsOnSelf(MethodInvocation invocation) {
        if (Reflections.matches(EQUALS, invocation.method())) {
            Object arg = invocation.parameters()[0];
            Object self = invocation.proxy();
            return self == arg;
        }
        return false;
    }

    private boolean isTraced(Object target) {
        InvocationHandler invocationHandler;
        return target != null && target instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(target)) instanceof MethodInvocationHandler;
    }

    private boolean isTracedType(Class<? extends Object> type) {
        if (this.tracedTypes.length == 0) {
            return true;
        }
        for (Class<? extends Object> clazz : this.tracedTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }
}

