/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Comparator;

public class ComparatorBase<T>
implements Comparator<T> {
    private final boolean manualCompare;

    protected ComparatorBase() {
        this(false);
    }

    protected ComparatorBase(boolean manualCompare) {
        this.manualCompare = manualCompare;
    }

    @Override
    public final int compare(T expected, T actual) {
        if (expected == null && actual == null) {
            return 0;
        }
        if (expected != null && actual == null) {
            return 1;
        }
        if (expected == null && actual == null) {
            return -1;
        }
        if (!this.manualCompare && expected instanceof Comparable && actual instanceof Comparable) {
            Comparable e = (Comparable)expected;
            T a = actual;
            return e.compareTo(a);
        }
        return this.manualCompare(expected, actual);
    }

    protected int manualCompare(T expected, T actual) {
        StringBuilder msg = new StringBuilder("The ComparatorBase#manualCompare() method must be overridden to compare the: ");
        msg.append(expected.getClass().getName() + " type");
        if (!expected.getClass().equals(actual.getClass())) {
            msg.append(" and the ");
            msg.append(actual.getClass().getName());
            msg.append(" type");
        }
        throw new IllegalStateException(msg.toString());
    }
}

