/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.PerThread;
import oracle.dbtools.common.util.PerThreadable;
import oracle.dbtools.common.util.Transform;

public class PerThreadCache<K, V>
implements PerThreadable {
    private final PerThread<DisposableMap<K, V>> cache = new PerThread();
    private final Transform<K, V> factory;
    private static final Log LOG = Log.get(PerThreadCache.class);

    public PerThreadCache(Transform<K, V> factory) {
        this.factory = factory;
    }

    public V get(K key) {
        Object value = null;
        if (this.cache.isSetup()) {
            DisposableMap<K, V> cache = this.cache.get();
            value = cache.get(key);
            if (null == value && (value = (Object)this.factory.apply(key)) != null) {
                cache.put(key, value);
            }
        } else {
            value = this.factory.apply(key);
        }
        return value;
    }

    @Override
    public boolean isSetup() {
        return this.cache.isSetup();
    }

    @Override
    public void setup() {
        this.cache.setup();
        LOG.finest("Setup PerThreadCache(" + this.factory + ")");
    }

    @Override
    public void setupThread() {
        this.cache.setupThread(this.disposable(this.newMap()));
        LOG.finest("Setup thread for  PerThreadCache(" + this.factory + ")");
    }

    @Override
    public void teardown() {
        this.cache.teardown();
    }

    @Override
    public void teardownThread() {
        this.cache.teardownThread();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PerThreadCache [factory=");
        builder.append(this.factory);
        builder.append(", cache=");
        builder.append(this.cache);
        builder.append("]");
        return builder.toString();
    }

    protected Map<K, V> newMap() {
        return new HashMap();
    }

    private DisposableMap<K, V> disposable(Map<K, V> target) {
        return new DisposableMap(target);
    }

    private static final class DisposableMap<K, V>
    implements Closeable {
        private final Map<K, V> target;

        private DisposableMap(Map<K, V> target) {
            this.target = target;
        }

        @Override
        public void close() throws IOException {
            for (K key : this.target.keySet()) {
                V value = this.target.get(key);
                if (!(value instanceof Cached)) continue;
                ((Cached)value).dispose();
            }
            this.target.clear();
        }

        public V get(Object key) {
            return this.target.get(key);
        }

        public V put(K key, V value) {
            return this.target.put(key, value);
        }
    }

    public static interface Cached {
        public void dispose();
    }
}

