/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.api;

import java.sql.SQLException;

public class JsonStoreException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final int UNKNOWN_ERROR_CODE = -1;
    private final int errorCode;
    private final String errorPrefix;
    private static final String DEFAULT_ERROR_PREFIX = "SODA";
    private static final String SQL_ERROR_PREFIX = "SQL";

    public JsonStoreException(Exception exception) {
        super(exception);
        this.errorCode = -1;
        this.errorPrefix = exception instanceof SQLException ? SQL_ERROR_PREFIX : null;
    }

    public JsonStoreException(String string) {
        this(string, -1);
    }

    public JsonStoreException(String string, int n) {
        this(string, n, DEFAULT_ERROR_PREFIX);
    }

    public JsonStoreException(String string, int n, String string2) {
        super(string);
        this.errorCode = n;
        this.errorPrefix = string2;
    }

    public int getErrorCode() {
        int n = this.errorCode;
        Throwable throwable = this.getCause();
        if (throwable != null && throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            n = sQLException.getErrorCode();
        }
        return n;
    }

    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    public String getErrorMessage() {
        String string = this.getMessage();
        Throwable throwable = this.getCause();
        if (throwable != null && throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            string = sQLException.getMessage();
        }
        return string;
    }
}

