/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.json.rdbms.CollectionDescriptor;

public class CollectionCache {
    private final ConcurrentHashMap<String, CollectionDescriptor> scache;
    private final HashMap<String, CollectionDescriptor> tcache;
    private final String accountName;
    private static final Logger log = Logger.getLogger(CollectionCache.class.getName());

    public CollectionCache(CollectionCache collectionCache) {
        this(collectionCache.accountName, collectionCache.scache, new HashMap<String, CollectionDescriptor>());
    }

    public CollectionCache(String string) {
        this(string, false);
    }

    public CollectionCache(String string, boolean bl) {
        this(string, bl ? new ConcurrentHashMap<String, CollectionDescriptor>() : null, bl ? null : new HashMap());
    }

    private CollectionCache(String string, ConcurrentHashMap<String, CollectionDescriptor> concurrentHashMap, HashMap<String, CollectionDescriptor> hashMap) {
        this.accountName = string;
        this.scache = concurrentHashMap;
        this.tcache = hashMap;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public CollectionDescriptor put(CollectionDescriptor collectionDescriptor) {
        String string = collectionDescriptor.getName();
        if (this.scache != null) {
            log.fine("Caching " + string + " shared");
            CollectionDescriptor collectionDescriptor2 = this.scache.putIfAbsent(string, collectionDescriptor);
            if (collectionDescriptor2 == null) {
                collectionDescriptor2 = collectionDescriptor;
            }
            return collectionDescriptor2;
        }
        if (this.tcache.containsKey(string)) {
            return this.tcache.get(string);
        }
        log.fine("Caching " + string + " unshared");
        this.tcache.put(string, collectionDescriptor);
        return collectionDescriptor;
    }

    public CollectionDescriptor get(String string) {
        CollectionDescriptor collectionDescriptor = null;
        if (this.tcache != null) {
            collectionDescriptor = this.tcache.get(string);
        }
        if (collectionDescriptor == null && this.scache != null) {
            collectionDescriptor = this.scache.get(string);
        }
        if (collectionDescriptor != null) {
            log.fine("Returning " + string + " from cache");
        }
        return collectionDescriptor;
    }

    public void remove(String string) {
        CollectionDescriptor collectionDescriptor = null;
        if (this.tcache != null) {
            collectionDescriptor = this.tcache.remove(string);
        }
        if (collectionDescriptor == null && this.scache != null) {
            this.scache.remove(string);
        }
    }
}

