/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.json.common.PooledConnection;

public class ConnectionPool {
    private static final int MIN_POOL_SIZE = 5;
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_LOCK_WAIT = 100;
    private static final int MAX_REUSE_COUNT = 1000;
    private static final Logger log = Logger.getLogger(ConnectionPool.class.getName());
    private final OracleDataSource ds;
    private final ReentrantLock lock = new ReentrantLock();
    private final ArrayList<PooledConnection> pool;
    private volatile boolean closeFlag = false;
    private volatile OracleConnection[] destruct = null;
    private static String ORA_DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";

    private void close() {
        this.lock.lock();
        if (this.ds != null) {
            log.fine("Closing Oracle data source");
        }
        this.lock.unlock();
    }

    public ConnectionPool(String string, String string2, String string3, int n) {
        OracleConnectionPoolDataSource oracleConnectionPoolDataSource = null;
        this.pool = new ArrayList(n);
        if (string == null) {
            this.ds = null;
            return;
        }
        try {
            oracleConnectionPoolDataSource = new OracleConnectionPoolDataSource();
            oracleConnectionPoolDataSource.setURL(string);
            if (string2 != null && string3 != null) {
                oracleConnectionPoolDataSource.setUser(string2);
                oracleConnectionPoolDataSource.setPassword(string3);
            }
        }
        catch (SQLException sQLException) {
            log.severe("Data source " + string + " creation failed with " + sQLException.getMessage());
        }
        log.info("Data source " + string + " created");
        this.ds = oracleConnectionPoolDataSource;
    }

    public ConnectionPool(String string, String string2, String string3) {
        this(string, string2, string3, 100);
    }

    public ConnectionPool(String string, int n) {
        this(string, null, null, n);
    }

    public ConnectionPool(String string) {
        this(string, 100);
    }

    private boolean getLock(int n) {
        boolean bl;
        if (n == 0) {
            this.lock.lock();
            return true;
        }
        try {
            bl = this.lock.tryLock(n, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        return bl;
    }

    private void closeConnection(OracleConnection oracleConnection) {
        if (oracleConnection != null) {
            try {
                oracleConnection.close();
            }
            catch (SQLException sQLException) {
                log.warning("Destroy connection failed with " + sQLException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnection getConnection() {
        PooledConnection pooledConnection = null;
        if (this.closeFlag) {
            return pooledConnection;
        }
        if (this.getLock(100)) {
            try {
                int n = this.pool.size();
                if (n > 0) {
                    pooledConnection = this.pool.get(--n);
                    this.pool.remove(n);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (pooledConnection == null) {
            OracleConnection oracleConnection = null;
            try {
                if (this.ds != null) {
                    oracleConnection = (OracleConnection)this.ds.getConnection();
                    oracleConnection.setImplicitCachingEnabled(true);
                    oracleConnection.setStatementCacheSize(50);
                }
                if (oracleConnection != null) {
                    if (oracleConnection.getAutoCommit()) {
                        log.fine("Connection started in auto-commit mode");
                        oracleConnection.setAutoCommit(false);
                    }
                    pooledConnection = new PooledConnection(oracleConnection);
                }
            }
            catch (SQLException sQLException) {
                log.severe("Failed to create connection with " + sQLException.getMessage());
            }
        }
        return pooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnection(OracleConnection oracleConnection) {
        PooledConnection pooledConnection = null;
        boolean bl = true;
        if (oracleConnection == null) {
            return;
        }
        if (oracleConnection.isUsable() && !this.closeFlag && oracleConnection instanceof PooledConnection) {
            pooledConnection = (PooledConnection)oracleConnection;
            pooledConnection.setLastAccessTime();
            pooledConnection.countUsage();
            boolean bl2 = bl = pooledConnection.getUsageCount() >= 1000;
        }
        if (!bl) {
            oracleConnection = null;
            if (this.getLock(100)) {
                try {
                    int n = this.pool.size();
                    if (n < 100 && !this.closeFlag) {
                        this.pool.add(n, pooledConnection);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        this.closeConnection(oracleConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long sweep(long l) {
        int n;
        int n2 = 0;
        long l2 = Long.MAX_VALUE;
        long l3 = System.currentTimeMillis();
        this.getLock(0);
        try {
            int n3 = this.pool.size();
            if (n3 == 0) {
                long l4 = l2;
                return l4;
            }
            int n4 = n3 - 5;
            if (this.destruct != null && this.destruct.length < n3) {
                this.destruct = null;
            }
            if (this.destruct == null) {
                this.destruct = new OracleConnection[n3];
            }
            n = n3;
            while (n > 0) {
                PooledConnection pooledConnection = this.pool.get(--n);
                long l5 = l3 - pooledConnection.getLastAccessTime();
                if (n3 <= n4 || l5 > l) {
                    this.pool.remove(n);
                    this.destruct[n2++] = pooledConnection;
                    --n4;
                    continue;
                }
                if ((l5 = l - l5) >= l2) continue;
                l2 = l5;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.destruct != null) {
            if (n2 > 0) {
                log.fine("Destroying " + n2 + " stale database connections");
            }
            for (n = 0; n < n2; ++n) {
                OracleConnection oracleConnection = this.destruct[n];
                this.destruct[n] = null;
                this.closeConnection(oracleConnection);
            }
        }
        if (l2 < Long.MAX_VALUE) {
            log.fine("Oldest database expires in " + l2);
        }
        return l2;
    }

    public void clear() {
        this.sweep(0L);
        this.close();
    }

    public void shutdown() {
        this.closeFlag = true;
        this.clear();
        this.close();
    }

    private static void initDriver(ConnectionPool connectionPool) throws SQLException {
        try {
            Class.forName(ORA_DRIVER_NAME);
        }
        catch (Exception exception) {
            throw new SQLException(ORA_DRIVER_NAME + ":" + exception.getMessage());
        }
    }

    public static OracleConnection defaultConnection() throws SQLException {
        ConnectionPool.initDriver(null);
        OracleDriver oracleDriver = new OracleDriver();
        Object object = (OracleConnection)oracleDriver.defaultConnection();
        if (object != null) {
            object = new PooledConnection((OracleConnection)object, true);
        }
        return object;
    }

    public static void closeInvalid(Connection connection) {
        try {
            if (connection instanceof PooledConnection) {
                ((PooledConnection)((Object)connection)).closeInvalid();
            } else if (connection instanceof OracleConnection) {
                ((OracleConnection)connection).close(4096);
            }
        }
        catch (SQLException sQLException) {
            log.warning(sQLException.getMessage());
        }
    }
}

