/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.util.logging.Logger;
import oracle.json.common.Configuration;
import oracle.json.common.SharedServices;

abstract class Daemon
extends Thread {
    protected static long WAIT_INCREMENT = -1L;
    protected static long SLEEP_INCREMENT = 100L;
    protected static long DEFAULT_INTERVAL = 1000L;
    protected static final Logger log = Logger.getLogger(Daemon.class.getName());
    private volatile boolean killRequested = false;
    protected final SharedServices shared;
    private final long pollInterval;

    public Daemon(String string, SharedServices sharedServices) {
        super(string);
        this.shared = sharedServices;
        Configuration configuration = sharedServices.getConfiguration();
        this.pollInterval = configuration.getPollInterval();
        log.info("Created " + string + " polling " + this.pollInterval);
    }

    public synchronized void kill() {
        String string = this.getName();
        this.killRequested = true;
        try {
            this.join(this.pollInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.getState() != Thread.State.TERMINATED) {
            this.interrupt();
        }
        log.info(string + " shut down");
    }

    @Override
    public void run() {
        String string = this.getName();
        long l = this.pollInterval;
        log.info(string + " starting with poll interval = " + this.pollInterval);
        while (!this.killRequested) {
            long l2 = this.runService();
            l = l2 < 0L ? (l += SLEEP_INCREMENT) : l2;
            if (l > this.pollInterval) {
                l = this.pollInterval;
            }
            if (l > 0L) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    log.info(interruptedException.getMessage());
                }
            }
            log.fine(string + " polling");
        }
        this.cleanup();
        log.info(string + " exiting");
    }

    public abstract void initialize();

    public abstract long runService();

    public abstract void cleanup();
}

