/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogFormatter {
    private StringBuilder formatBuffer = new StringBuilder(100);
    private static String NO_MESSAGE = "";
    private final Level level;
    private static final char MIN_ALLOWED_CHARVAL = ' ';
    private static final char MAX_ALLOWED_CHARVAL = '\ufffd';

    public LogFormatter() {
        this(null);
    }

    public LogFormatter(Logger logger) {
        if (logger == null) {
            logger = Logger.getLogger("global");
        }
        Level level = null;
        while (logger != null && (level = logger.getLevel()) == null) {
            logger = logger.getParent();
        }
        if (level == null) {
            level = Level.WARNING;
        }
        this.level = level;
    }

    private String format(String string, Object ... objectArray) {
        Formatter formatter = new Formatter(this.formatBuffer);
        this.formatBuffer.setLength(0);
        formatter.format(string, objectArray);
        formatter.close();
        return this.formatBuffer.toString();
    }

    public String error(String string, Object ... objectArray) {
        if (this.level.intValue() < Level.SEVERE.intValue()) {
            return NO_MESSAGE;
        }
        return this.format(string, objectArray);
    }

    public String warn(String string, Object ... objectArray) {
        if (this.level.intValue() < Level.WARNING.intValue()) {
            return NO_MESSAGE;
        }
        return this.format(string, objectArray);
    }

    public String info(String string, Object ... objectArray) {
        if (this.level.intValue() < Level.INFO.intValue()) {
            return NO_MESSAGE;
        }
        return this.format(string, objectArray);
    }

    public String debug(String string, Object ... objectArray) {
        if (this.level.intValue() < Level.FINE.intValue()) {
            return NO_MESSAGE;
        }
        return this.format(string, objectArray);
    }

    public static String sanitizeString(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= ' ' && c <= '\ufffd') continue;
                char[] cArray = new char[n];
                string.getChars(0, n, cArray, 0);
                for (int j = i; j < n; ++j) {
                    c = cArray[j];
                    if (c >= ' ' && c <= '\ufffd') continue;
                    cArray[j] = 191;
                }
                return new String(cArray);
            }
        }
        return string;
    }
}

