/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleConnectionWrapper;

public class PooledConnection
extends OracleConnectionWrapper {
    private static final Logger log = Logger.getLogger(PooledConnection.class.getName());
    private long lastAccessed = System.currentTimeMillis();
    private int counter = 0;
    private boolean isDefault = false;
    public static final int ORA_SQL_OBJECT_EXISTS = 955;
    public static final int ORA_SQL_OBJECT_NOT_EXISTS = 942;
    public static final int ORA_SQL_INDEX_NOT_EXISTS = 1418;
    public static final int BATCH_FETCH_SIZE = 1000;
    public static final int LOB_PREFETCH_SIZE = 65000;
    public static final int BATCH_ROUND_INCREMENT = 10;
    public static final int BATCH_MAX_SIZE = 100;
    public static final int SQL_STATEMENT_SIZE = 1000;

    public boolean getDefault() {
        return this.isDefault;
    }

    PooledConnection(OracleConnection oracleConnection) {
        this(oracleConnection, false);
    }

    PooledConnection(OracleConnection oracleConnection, boolean bl) {
        super(oracleConnection);
        this.isDefault = bl;
    }

    OracleConnection getConnection() {
        return this.unwrap();
    }

    long getLastAccessTime() {
        return this.lastAccessed;
    }

    void setLastAccessTime() {
        this.lastAccessed = System.currentTimeMillis();
    }

    void countUsage() {
        ++this.counter;
    }

    int getUsageCount() {
        return this.counter;
    }

    public int roundRows(int n) {
        int n2 = n == 1 ? n : (n < 10 ? 10 : (n > 100 ? 100 : n - n % 10));
        return n2;
    }

    public void closeInvalid() {
        try {
            this.close(4096);
        }
        catch (SQLException sQLException) {
            log.warning(sQLException.getMessage());
        }
    }
}

