/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;

public class DocumentLoader {
    protected final JsonParser parser;

    public DocumentLoader(byte[] byArray) throws JsonException {
        this(new ByteArrayInputStream(byArray));
    }

    public DocumentLoader(String string) throws JsonException {
        this.parser = Json.createParser((Reader)new StringReader(string));
    }

    public DocumentLoader(InputStream inputStream) throws JsonException {
        this.parser = Json.createParser((InputStream)inputStream);
    }

    public DocumentLoader(InputStream inputStream, Charset charset) throws JsonException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        this.parser = Json.createParser((Reader)inputStreamReader);
    }

    protected JsonObjectBuilder parseObject(int n) throws JsonParsingException {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        String string = null;
        block11: while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case START_OBJECT: {
                    jsonObjectBuilder.add(string, this.parseObject(n + 1));
                    string = null;
                    continue block11;
                }
                case START_ARRAY: {
                    jsonObjectBuilder.add(string, this.parseArray(n + 1));
                    string = null;
                    continue block11;
                }
                case END_OBJECT: {
                    return jsonObjectBuilder;
                }
                case KEY_NAME: {
                    string = this.parser.getString();
                    continue block11;
                }
                case VALUE_STRING: {
                    jsonObjectBuilder.add(string, this.parser.getString());
                    string = null;
                    continue block11;
                }
                case VALUE_NUMBER: {
                    BigDecimal bigDecimal = this.parser.getBigDecimal();
                    if (bigDecimal.scale() <= 0) {
                        jsonObjectBuilder.add(string, bigDecimal.toBigInteger());
                    } else {
                        jsonObjectBuilder.add(string, bigDecimal);
                    }
                    string = null;
                    continue block11;
                }
                case VALUE_NULL: {
                    jsonObjectBuilder.addNull(string);
                    string = null;
                    continue block11;
                }
                case VALUE_TRUE: {
                    jsonObjectBuilder.add(string, true);
                    string = null;
                    continue block11;
                }
                case VALUE_FALSE: {
                    jsonObjectBuilder.add(string, false);
                    string = null;
                    continue block11;
                }
            }
            throw new IllegalStateException();
        }
        return jsonObjectBuilder;
    }

    protected JsonArrayBuilder parseArray(int n) throws JsonParsingException {
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        block10: while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case START_OBJECT: {
                    jsonArrayBuilder.add(this.parseObject(n + 1));
                    continue block10;
                }
                case START_ARRAY: {
                    jsonArrayBuilder.add(this.parseArray(n + 1));
                    continue block10;
                }
                case END_ARRAY: {
                    return jsonArrayBuilder;
                }
                case VALUE_STRING: {
                    jsonArrayBuilder.add(this.parser.getString());
                    continue block10;
                }
                case VALUE_NUMBER: {
                    BigDecimal bigDecimal = this.parser.getBigDecimal();
                    if (bigDecimal.scale() <= 0) {
                        jsonArrayBuilder.add(bigDecimal.toBigInteger());
                        continue block10;
                    }
                    jsonArrayBuilder.add(bigDecimal);
                    continue block10;
                }
                case VALUE_NULL: {
                    jsonArrayBuilder.addNull();
                    continue block10;
                }
                case VALUE_TRUE: {
                    jsonArrayBuilder.add(true);
                    continue block10;
                }
                case VALUE_FALSE: {
                    jsonArrayBuilder.add(false);
                    continue block10;
                }
            }
            throw new IllegalStateException();
        }
        return jsonArrayBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonStructure parse() throws JsonParsingException, JsonException {
        JsonObject jsonObject = null;
        try {
            block7: while (this.parser.hasNext()) {
                JsonParser.Event event = this.parser.next();
                switch (event) {
                    case START_OBJECT: {
                        jsonObject = this.parseObject(0).build();
                        continue block7;
                    }
                    case START_ARRAY: {
                        jsonObject = this.parseArray(0).build();
                        continue block7;
                    }
                }
            }
            return jsonObject;
            throw new IllegalStateException();
        }
        finally {
            this.parser.close();
        }
    }
}

