/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class FindSpecification {
    private boolean is_filter = true;
    private String projection = null;
    private HashSet<String> idList = null;

    public FindSpecification(InputStream inputStream) throws QueryException {
        this.parse(inputStream);
    }

    private void makeException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        QueryException.throwSyntaxException(queryMessage, objectArray);
    }

    private void findKeys(JsonParser jsonParser) throws QueryException, JsonParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        boolean bl = false;
        while (jsonParser.hasNext()) {
            if (bl) {
                this.makeException(QueryMessage.EX_EXTRA_INPUT, new Object[0]);
            }
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case VALUE_STRING: {
                    String string2 = jsonParser.getString();
                    arrayList.add(string2);
                    break;
                }
                case VALUE_NUMBER: {
                    BigDecimal bigDecimal = jsonParser.getBigDecimal();
                    arrayList.add(bigDecimal.toString());
                    break;
                }
                case END_ARRAY: {
                    bl = true;
                    break;
                }
                case START_ARRAY: {
                    string = "array";
                    break;
                }
                case START_OBJECT: {
                    string = "array";
                    break;
                }
                case VALUE_TRUE: {
                    string = "true";
                    break;
                }
                case VALUE_FALSE: {
                    string = "false";
                    break;
                }
                case VALUE_NULL: {
                    string = "null";
                    break;
                }
                default: {
                    string = event.toString();
                }
            }
            if (string == null) continue;
            this.makeException(QueryMessage.EX_INVALID_ARRAY_KEY, string);
        }
        this.idList = new HashSet(arrayList.size());
        for (String string2 : arrayList) {
            this.idList.add(string2);
        }
    }

    private void findProjection(JsonParser jsonParser) throws QueryException, JsonParsingException, JsonGenerationException {
        String string = null;
        StringWriter stringWriter = null;
        JsonGenerator jsonGenerator = null;
        int n = 0;
        while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            if (event == JsonParser.Event.KEY_NAME) {
                string = jsonParser.getString();
                if (n != 0 || !string.equals("$project")) continue;
                stringWriter = new StringWriter();
                jsonGenerator = Json.createGenerator((Writer)stringWriter);
                continue;
            }
            if (jsonGenerator == null) {
                if (event == JsonParser.Event.START_ARRAY || event == JsonParser.Event.START_OBJECT) {
                    ++n;
                } else if (event == JsonParser.Event.END_ARRAY || event == JsonParser.Event.END_OBJECT) {
                    --n;
                }
                string = null;
                continue;
            }
            if (event == JsonParser.Event.START_OBJECT) {
                if (string == null || n == 0) {
                    jsonGenerator.writeStartObject();
                } else {
                    jsonGenerator.writeStartObject(string);
                }
                ++n;
                string = null;
                continue;
            }
            if (n == 0) {
                this.makeException(QueryMessage.EX_INVALID_PROJECTION, new Object[0]);
            }
            if (event == JsonParser.Event.VALUE_STRING) {
                if (string != null) {
                    jsonGenerator.write(string, jsonParser.getString());
                } else {
                    jsonGenerator.write(jsonParser.getString());
                }
            } else if (event == JsonParser.Event.VALUE_NUMBER) {
                BigDecimal bigDecimal = jsonParser.getBigDecimal();
                if (bigDecimal.scale() <= 0) {
                    if (string != null) {
                        jsonGenerator.write(string, bigDecimal.toBigInteger());
                    } else {
                        jsonGenerator.write(bigDecimal.toBigInteger());
                    }
                } else if (string != null) {
                    jsonGenerator.write(string, bigDecimal);
                } else {
                    jsonGenerator.write(bigDecimal);
                }
            } else if (event == JsonParser.Event.VALUE_TRUE) {
                if (string != null) {
                    jsonGenerator.write(string, true);
                } else {
                    jsonGenerator.write(true);
                }
            } else if (event == JsonParser.Event.VALUE_FALSE) {
                if (string != null) {
                    jsonGenerator.write(string, false);
                } else {
                    jsonGenerator.write(false);
                }
            } else if (event == JsonParser.Event.VALUE_NULL) {
                if (string != null) {
                    jsonGenerator.writeNull(string);
                } else {
                    jsonGenerator.writeNull();
                }
            } else if (event == JsonParser.Event.START_ARRAY) {
                ++n;
                if (string == null) {
                    jsonGenerator.writeStartArray();
                } else {
                    jsonGenerator.writeStartArray(string);
                }
            } else if (event == JsonParser.Event.END_OBJECT) {
                --n;
                jsonGenerator.writeEnd();
            } else if (event == JsonParser.Event.END_ARRAY) {
                --n;
                jsonGenerator.writeEnd();
            }
            string = null;
            if (n != 0) continue;
            jsonGenerator.flush();
            jsonGenerator.close();
            this.projection = stringWriter.toString();
        }
    }

    private void parse(InputStream inputStream) throws QueryException {
        JsonParser jsonParser = null;
        boolean bl = true;
        if (inputStream == null) {
            this.makeException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
        }
        try {
            jsonParser = Json.createParser((InputStream)inputStream);
            JsonParser.Event event = jsonParser.next();
            if (event == JsonParser.Event.START_OBJECT) {
                this.findProjection(jsonParser);
            } else if (event == JsonParser.Event.START_ARRAY) {
                this.findKeys(jsonParser);
                this.is_filter = false;
            } else {
                this.makeException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
            }
            bl = false;
        }
        catch (JsonException jsonException) {
            throw new QueryException(QueryMessage.EX_SYNTAX_ERROR.get(new Object[0]), (Exception)((Object)jsonException));
        }
        finally {
            block15: {
                try {
                    jsonParser.close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (bl) break block15;
                    throw new QueryException(QueryMessage.EX_SYNTAX_ERROR.get(new Object[0]), iOException);
                }
            }
        }
    }

    public boolean isFilter() {
        return this.is_filter;
    }

    public HashSet<String> getKeys() {
        return this.idList;
    }

    public String getProjection() {
        return this.projection;
    }
}

