/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import oracle.json.parser.DocumentLoader;
import oracle.json.parser.IndexColumn;
import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.util.JsonByteArray;

public class ProjectionSpec {
    private final InputStream source;
    private boolean is_parsed = false;
    private static final IndexColumn[] NO_COLUMNS = new IndexColumn[0];
    private IndexColumn[] columns = NO_COLUMNS;
    private String[] jtpaths = null;
    private final FieldStep template = new FieldStep(null);

    private void makeStrings() {
        String[] stringArray;
        int n = this.columns.length;
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = this.columns[i].getSteps();
            stringArray = new String[stringArray2.length];
            FieldStep fieldStep = this.template;
            for (int j = 0; j < stringArray2.length; ++j) {
                String string = PathParser.unescapeStep(stringArray2[j]);
                FieldStep fieldStep2 = fieldStep.getChild(string);
                if (fieldStep2 == null) {
                    fieldStep2 = new FieldStep(string);
                    fieldStep.addChild(string, fieldStep2);
                }
                fieldStep = fieldStep2;
            }
            fieldStep.setColumnPosition(i);
        }
        this.jtpaths = new String[n];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringArray = this.columns[i].getSteps();
            stringBuilder.setLength(0);
            stringBuilder.append("$");
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                if (string == null || string.charAt(0) == '[') continue;
                stringBuilder.append(".");
                stringBuilder.append(string);
                stringBuilder.append("[0]");
            }
            this.jtpaths[i] = stringBuilder.toString();
        }
    }

    public ProjectionSpec(InputStream inputStream) {
        this.source = inputStream;
    }

    private void makeException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        QueryException.throwSyntaxException(queryMessage, objectArray);
    }

    private void close(boolean bl) throws QueryException {
        block2: {
            try {
                this.source.close();
            }
            catch (IOException iOException) {
                if (bl) break block2;
                throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), iOException);
            }
        }
    }

    public IndexColumn[] parse() throws QueryException {
        try {
            DocumentLoader documentLoader = new DocumentLoader(this.source);
            JsonObject jsonObject = (JsonObject)documentLoader.parse();
            this.close(false);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                Object object;
                String string = (String)entry.getKey();
                JsonValue jsonValue = (JsonValue)entry.getValue();
                JsonValue.ValueType valueType = jsonValue.getValueType();
                String string2 = null;
                if (valueType == JsonValue.ValueType.FALSE || valueType == JsonValue.ValueType.NULL || valueType == JsonValue.ValueType.OBJECT || valueType == JsonValue.ValueType.ARRAY || valueType == JsonValue.ValueType.NUMBER && ((BigDecimal)(object = ((JsonNumber)jsonValue).bigDecimalValue())).compareTo(BigDecimal.ONE) != 0) continue;
                if (valueType == JsonValue.ValueType.STRING) {
                    string2 = ((JsonString)jsonValue).getString();
                }
                object = new IndexColumn();
                PathParser pathParser = new PathParser(string);
                String[] stringArray = pathParser.splitAndSQLEscape();
                if (stringArray == null) {
                    this.makeException(QueryMessage.EX_INDEX_ILLEGAL_PATH, string);
                }
                ((IndexColumn)object).setPath(stringArray);
                if (string2 != null) {
                    ((IndexColumn)object).setSqlType(string2);
                }
                arrayList.add(object);
            }
            int n = arrayList.size();
            if (n > 0) {
                this.columns = new IndexColumn[n];
                this.columns = arrayList.toArray(this.columns);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), illegalArgumentException);
        }
        catch (JsonParsingException jsonParsingException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), (Exception)((Object)jsonParsingException));
        }
        catch (JsonException jsonException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), (Exception)((Object)jsonException));
        }
        finally {
            this.close(true);
        }
        this.is_parsed = true;
        this.makeStrings();
        return this.columns;
    }

    public IndexColumn[] getColumns() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.columns;
    }

    public int numColumns() {
        return this.columns.length;
    }

    public String getColumnPath(int n) {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.jtpaths[n];
    }

    public int getSqlType(int n) {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.columns[n].getSqlType();
    }

    private int projectObject(FieldStep fieldStep, String[] stringArray, JsonByteArray jsonByteArray) {
        int n = 0;
        boolean bl = true;
        jsonByteArray.appendOpenBrace();
        for (Map.Entry<String, FieldStep> entry : fieldStep.children.entrySet()) {
            String string = entry.getKey();
            FieldStep fieldStep2 = entry.getValue();
            if (bl) {
                bl = false;
            } else {
                jsonByteArray.appendComma();
            }
            jsonByteArray.appendValue(string);
            jsonByteArray.appendColon();
            int n2 = fieldStep2.columnNum;
            if (n2 == -1) {
                n += this.projectObject(fieldStep2, stringArray, jsonByteArray);
                continue;
            }
            String string2 = n2 < stringArray.length ? stringArray[n2] : null;
            ++n;
            if (string2 == null) {
                jsonByteArray.append("null");
                continue;
            }
            if (this.getSqlType(n2) == 2) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string2);
                    jsonByteArray.append(bigDecimal.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    jsonByteArray.appendValue(string2);
                }
                continue;
            }
            jsonByteArray.appendValue(string2);
        }
        jsonByteArray.appendCloseBrace();
        return n;
    }

    public byte[] projectValues(String[] stringArray) {
        JsonByteArray jsonByteArray = new JsonByteArray();
        this.projectObject(this.template, stringArray, jsonByteArray);
        return jsonByteArray.toArray();
    }

    class FieldStep {
        static final int CONTAINER_STEP = -1;
        String name;
        int columnNum = -1;
        HashMap<String, FieldStep> children = null;

        FieldStep(String string) {
            this.name = string;
        }

        void setColumnPosition(int n) {
            if (this.columnNum == -1) {
                this.columnNum = n;
            }
        }

        FieldStep getChild(String string) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(string);
        }

        void addChild(String string, FieldStep fieldStep) {
            if (this.children == null) {
                this.children = new HashMap();
                if (this.columnNum >= 0) {
                    this.columnNum = -1;
                }
            }
            this.children.put(string, fieldStep);
        }
    }
}

