/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import oracle.json.api.JsonStoreException;
import oracle.json.common.Configuration;
import oracle.json.parser.DocumentLoader;
import oracle.json.util.JsonByteArray;

public class CollectionDescriptor {
    static final CollectionDescriptor NULL_DESCRIPTOR = new CollectionDescriptor(null);
    static final int STRING_KEY = 1;
    static final int NCHAR_KEY = 2;
    static final int INTEGER_KEY = 3;
    static final int RAW_KEY = 4;
    static final int CHAR_CONTENT = 1;
    static final int RAW_CONTENT = 2;
    static final int NCHAR_CONTENT = 3;
    static final int BLOB_CONTENT = 4;
    static final int CLOB_CONTENT = 5;
    static final int NCLOB_CONTENT = 6;
    static final int LOB_COMPRESS_NONE = 0;
    static final int LOB_COMPRESS_HIGH = 1;
    static final int LOB_COMPRESS_MEDIUM = 2;
    static final int LOB_COMPRESS_LOW = 3;
    static final int LOB_ENCRYPT_NONE = 0;
    static final int LOB_ENCRYPT_3DES168 = 1;
    static final int LOB_ENCRYPT_AES128 = 2;
    static final int LOB_ENCRYPT_AES192 = 3;
    static final int LOB_ENCRYPT_AES256 = 4;
    static final int KEY_ASSIGN_CLIENT = 1;
    static final int KEY_ASSIGN_UUID = 2;
    static final int KEY_ASSIGN_GUID = 3;
    static final int KEY_ASSIGN_SEQUENCE = 4;
    static final int VERSION_NONE = 0;
    static final int VERSION_TIMESTAMP = 1;
    static final int VERSION_SEQUENTIAL = 2;
    static final int VERSION_UUID = 3;
    static final int VERSION_SHA256 = 4;
    static final int VERSION_MD5 = 5;
    private static final int DEFAULT_KEY_LENGTH = 255;
    private static final int DEFAULT_VARCHAR2_CONTENT_LENGTH = 4000;
    private static final int DEFAULT_RAW_CONTENT_LENGTH = 2000;
    private static final int DEFAULT_NVARCHAR2_CONTENT_LENGTH = 2000;
    private static final String DEFAULT_KEY_NAME = "ID";
    private static final String DEFAULT_CONTENT_NAME = "JSON_DOCUMENT";
    static final int MAX_KEY_LENGTH = 255;
    static final Properties STANDARD_PROPERTIES;
    String uriName = null;
    String dbObjectName = null;
    String dbSchema = null;
    long createdOn = -1L;
    boolean writable = true;
    boolean plsqlBased = false;
    boolean viewBased = false;
    boolean strictMode = true;
    String timeIndex = null;
    int keyAssignmentMethod = 2;
    String keySequenceName = null;
    int versioningMethod = 0;
    String keyColumnName = "ID";
    int keyDataType = 1;
    int keyLength = 255;
    String contentColumnName = "JSON_DOCUMENT";
    int contentDataType = 4;
    int contentLength = 0;
    int contentLobCompress = 0;
    int contentLobEncrypt = 0;
    boolean contentLobCache = false;
    String timestampColumnName = null;
    String versionColumnName = null;
    String doctypeColumnName = null;
    String creationColumnName = null;

    static String stringToIdentifier(String string) {
        String string2 = null;
        if (string != null) {
            char[] cArray = string.toCharArray();
            if (cArray.length == 0) {
                return "";
            }
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '\"') {
                    cArray[i] = 95;
                    continue;
                }
                if (c >= ' ') continue;
                cArray[i] = 95;
            }
            string2 = new String(cArray);
        }
        return string2;
    }

    private static int stringToLength(String string) {
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    private static int stringToKeyType(String string) {
        int n = 1;
        if (string != null) {
            if (string.equalsIgnoreCase("string")) {
                n = 1;
            } else if (string.equalsIgnoreCase("char")) {
                n = 1;
            } else if (string.equalsIgnoreCase("varchar")) {
                n = 1;
            } else if (string.equalsIgnoreCase("varchar2")) {
                n = 1;
            } else if (string.equalsIgnoreCase("nchar")) {
                n = 2;
            } else if (string.equalsIgnoreCase("nvarchar")) {
                n = 2;
            } else if (string.equalsIgnoreCase("nvarchar2")) {
                n = 2;
            } else if (string.equalsIgnoreCase("integer")) {
                n = 3;
            } else if (string.equalsIgnoreCase("number")) {
                n = 3;
            } else if (string.equalsIgnoreCase("raw")) {
                n = 4;
            } else if (string.equalsIgnoreCase("guid")) {
                n = 4;
            } else if (string.equalsIgnoreCase("uuid")) {
                n = 4;
            } else if (string.equalsIgnoreCase("uid")) {
                n = 4;
            }
        }
        return n;
    }

    private static int stringToContentType(String string) {
        int n = 4;
        if (string != null) {
            if (string.equalsIgnoreCase("char")) {
                n = 1;
            } else if (string.equalsIgnoreCase("varchar")) {
                n = 1;
            } else if (string.equalsIgnoreCase("varchar2")) {
                n = 1;
            } else if (string.equalsIgnoreCase("raw")) {
                n = 2;
            } else if (string.equalsIgnoreCase("nchar")) {
                n = 3;
            } else if (string.equalsIgnoreCase("nvarchar")) {
                n = 3;
            } else if (string.equalsIgnoreCase("nvarchar2")) {
                n = 3;
            } else if (string.equalsIgnoreCase("blob")) {
                n = 4;
            } else if (string.equalsIgnoreCase("clob")) {
                n = 5;
            } else if (string.equalsIgnoreCase("nclob")) {
                n = 6;
            }
        }
        return n;
    }

    private static int stringToCompressType(String string) {
        int n = 0;
        if (string != null) {
            if (string.equalsIgnoreCase("high")) {
                n = 1;
            } else if (string.equalsIgnoreCase("medium")) {
                n = 2;
            } else if (string.equalsIgnoreCase("low")) {
                n = 3;
            }
        }
        return n;
    }

    private static int stringToEncryptType(String string) {
        int n = 0;
        if (string != null) {
            if (string.equalsIgnoreCase("3DES168")) {
                n = 1;
            } else if (string.equalsIgnoreCase("AES128")) {
                n = 2;
            } else if (string.equalsIgnoreCase("AES192")) {
                n = 3;
            } else if (string.equalsIgnoreCase("AES256")) {
                n = 4;
            }
        }
        return n;
    }

    private static int stringToVersionMethod(String string) {
        int n = 0;
        if (string != null) {
            if (string.equalsIgnoreCase("timestamp")) {
                n = 1;
            } else if (string.equalsIgnoreCase("sequential")) {
                n = 2;
            } else if (string.equalsIgnoreCase("uuid")) {
                n = 3;
            } else if (string.equalsIgnoreCase("SHA256")) {
                n = 4;
            } else if (string.equalsIgnoreCase("MD5")) {
                n = 5;
            }
        }
        return n;
    }

    private static int stringToKeyAssignMethod(String string) {
        int n = 2;
        if (string != null) {
            if (string.equalsIgnoreCase("sequence")) {
                n = 4;
            } else if (string.equalsIgnoreCase("guid")) {
                n = 3;
            } else if (string.equalsIgnoreCase("uuid")) {
                n = 2;
            } else if (string.equalsIgnoreCase("client")) {
                n = 1;
            }
        }
        return n;
    }

    public CollectionDescriptor(String string) {
        this.uriName = string;
        this.dbObjectName = CollectionDescriptor.stringToIdentifier(string);
    }

    CollectionDescriptor(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, String string8, int n2, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, String string21) {
        this(string);
        this.setProperties(string2, string3, string4, string5, string6, n, string7, string8, n2, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21);
    }

    public CollectionDescriptor(String string, Properties properties) {
        this(string);
        if (properties != null) {
            String string2 = "TABLE";
            String string3 = properties.getProperty("rdbms.table_name");
            String string4 = properties.getProperty("rdbms.view_name");
            String string5 = properties.getProperty("rdbms.package_name");
            if (string5 != null) {
                string3 = string5;
                string2 = "PACKAGE";
            } else if (string4 != null) {
                string3 = string4;
                string2 = "VIEW";
            }
            if (string3 != null) {
                string3 = CollectionDescriptor.stringToIdentifier(string3);
            }
            String string6 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.schema_name"));
            String string7 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.key_name"));
            String string8 = properties.getProperty("rdbms.key_type");
            int n = CollectionDescriptor.stringToLength(properties.getProperty("rdbms.key_len"));
            String string9 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.content_name"));
            String string10 = properties.getProperty("rdbms.content_type");
            int n2 = CollectionDescriptor.stringToLength(properties.getProperty("rdbms.content_len"));
            String string11 = properties.getProperty("rdbms.lob_compress");
            String string12 = properties.getProperty("rdbms.lob_cache");
            String string13 = properties.getProperty("rdbms.lob_encrypt");
            String string14 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.doctype_name"));
            String string15 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.creation_name"));
            String string16 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.timestamp_name"));
            String string17 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.version_name"));
            String string18 = properties.getProperty("rdbms.version_method");
            String string19 = properties.getProperty("rdbms.key_assign_method");
            String string20 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.key_sequence_name"));
            String string21 = properties.getProperty("rdbms.write_enable");
            String string22 = properties.getProperty("rdbms.strict_mode");
            String string23 = CollectionDescriptor.stringToIdentifier(properties.getProperty("rdbms.time_index"));
            this.setProperties(string6, string3, string2, string7, string8, n, string9, string10, n2, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21, string22, string23);
        }
    }

    private void setProperties(String string, String string2, String string3, String string4, String string5, int n, String string6, String string7, int n2, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20) {
        boolean bl;
        if (string != null) {
            this.dbSchema = string;
        }
        if (string2 != null) {
            this.dbObjectName = string2;
        }
        if (string3 != null) {
            this.setBasisType(string3);
        }
        if (string4 != null) {
            this.setKeyColumn(string4);
        }
        this.setKeyType(CollectionDescriptor.stringToKeyType(string5), n);
        if (string6 != null) {
            this.setContentColumn(string6);
        }
        this.setContentType(CollectionDescriptor.stringToContentType(string7), n2);
        if (string8 != null) {
            this.setContentLobCompress(CollectionDescriptor.stringToCompressType(string8));
        }
        if (string10 != null) {
            this.setContentLobEncrypt(CollectionDescriptor.stringToEncryptType(string10));
        }
        if (string9 != null && string9.equalsIgnoreCase("true")) {
            this.setContentLobCache(true);
        }
        if (string11 != null && this.contentDataType == 4) {
            this.setDoctypeColumn(string11);
        }
        if (string12 != null) {
            this.setCreationColumn(string12);
        }
        if (string13 != null) {
            this.setTimestampColumn(string13);
            if (string20 != null) {
                this.timeIndex = string20;
            }
        }
        if (string14 != null) {
            this.setVersionColumn(string14);
        }
        if (string15 != null) {
            this.setVersioningMethod(CollectionDescriptor.stringToVersionMethod(string15));
        }
        if (string17 != null) {
            this.setKeySequence(string17);
        } else if (string16 != null) {
            this.setKeyAssignmentMethod(CollectionDescriptor.stringToKeyAssignMethod(string16));
        }
        if (string18 != null) {
            bl = true;
            if (string18.equalsIgnoreCase("readonly")) {
                bl = false;
            } else if (string18.equalsIgnoreCase("false")) {
                bl = false;
            }
            this.setWriteMode(bl);
        }
        if (string19 != null) {
            bl = false;
            if (string19.equalsIgnoreCase("strict")) {
                bl = false;
            } else if (string19.equalsIgnoreCase("lax")) {
                bl = true;
            } else if (string19.equalsIgnoreCase("false")) {
                bl = true;
            } else if (string19.equalsIgnoreCase("true")) {
                bl = false;
            }
            this.setStrictMode(!bl);
        }
    }

    void setTableName(String string) {
        this.dbObjectName = string;
    }

    void setBasisType(String string) {
        this.viewBased = false;
        this.plsqlBased = false;
        if (string.equalsIgnoreCase("PACKAGE")) {
            this.plsqlBased = true;
        } else if (string.equalsIgnoreCase("VIEW")) {
            this.viewBased = true;
        }
    }

    void setKeyColumn(String string) {
        this.keyColumnName = string;
    }

    void setKeyType(int n, int n2) {
        this.keyDataType = n;
        switch (n) {
            case 1: 
            case 2: {
                if (n2 <= 0) {
                    this.keyLength = 255;
                    break;
                }
                if (n2 > 255) {
                    this.keyLength = 255;
                    break;
                }
                this.keyLength = n2;
                break;
            }
            default: {
                this.keyLength = 0;
            }
        }
    }

    void setContentColumn(String string) {
        this.contentColumnName = string;
    }

    void setContentType(int n, int n2) {
        this.contentDataType = n;
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                this.contentLength = 0;
                break;
            }
            case 1: {
                this.contentLength = n2 <= 0 ? 4000 : n2;
                break;
            }
            case 3: {
                this.contentLength = n2 <= 0 ? 2000 : n2;
                break;
            }
            case 2: {
                this.contentLength = n2 <= 0 ? 2000 : n2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void setDoctypeColumn(String string) {
        this.doctypeColumnName = string;
    }

    void setCreationColumn(String string) {
        this.creationColumnName = string;
    }

    void setTimestampColumn(String string) {
        this.timestampColumnName = string;
    }

    void setVersionColumn(String string) {
        this.versionColumnName = string;
    }

    void setVersioningMethod(int n) {
        this.versioningMethod = n;
    }

    void setKeyAssignmentMethod(int n) {
        this.keyAssignmentMethod = n;
        if ((n == 2 || n == 3) && this.keyLength > 0 && this.keyLength < 32) {
            this.keyLength = 32;
        }
    }

    void setKeySequence(String string) {
        this.keyAssignmentMethod = 4;
        this.keySequenceName = string;
    }

    void setWriteMode(boolean bl) {
        this.writable = bl;
    }

    void setStrictMode(boolean bl) {
        this.strictMode = bl;
    }

    void setContentLobCompress(int n) {
        this.contentLobCompress = n;
    }

    void setContentLobCache(boolean bl) {
        this.contentLobCache = bl;
    }

    void setContentLobEncrypt(int n) {
        this.contentLobEncrypt = n;
    }

    public String getName() {
        return this.uriName;
    }

    String getWriteMode() {
        return this.writable ? "READWRITE" : "READONLY";
    }

    String getStrictMode() {
        return this.strictMode ? "STRICT" : "LAX";
    }

    String getTimeIndex() {
        return this.timeIndex;
    }

    String getKeyAssignmentMethod() {
        String string = "UUID";
        switch (this.keyAssignmentMethod) {
            case 1: {
                string = "CLIENT";
                break;
            }
            case 2: {
                string = "UUID";
                break;
            }
            case 3: {
                string = "GUID";
                break;
            }
            case 4: {
                string = "SEQUENCE";
            }
        }
        return string;
    }

    String getVersioningMethod() {
        String string = "NONE";
        switch (this.versioningMethod) {
            case 1: {
                string = "TIMESTAMP";
                break;
            }
            case 2: {
                string = "SEQUENTIAL";
                break;
            }
            case 3: {
                string = "UUID";
                break;
            }
            case 4: {
                string = "SHA256";
                break;
            }
            case 5: {
                string = "MD5";
                break;
            }
        }
        return string;
    }

    String getKeyDataType() {
        String string = "VARCHAR2";
        switch (this.keyDataType) {
            case 3: {
                string = "NUMBER";
                break;
            }
            case 4: {
                string = "RAW";
                break;
            }
            case 2: {
                string = "NVARCHAR2";
                break;
            }
        }
        return string;
    }

    String getContentDataType() {
        String string = "BLOB";
        switch (this.contentDataType) {
            case 1: {
                string = "VARCHAR2";
                break;
            }
            case 2: {
                string = "RAW";
                break;
            }
            case 3: {
                string = "NVARCHAR2";
                break;
            }
            case 4: {
                string = "BLOB";
                break;
            }
            case 5: {
                string = "CLOB";
                break;
            }
            case 6: {
                string = "NCLOB";
            }
        }
        return string;
    }

    String getCollectionBasis() {
        return this.plsqlBased ? "PACKAGE" : (this.viewBased ? "VIEW" : "TABLE");
    }

    String getLobCompression() {
        String string = "NONE";
        switch (this.contentLobCompress) {
            case 1: {
                string = "HIGH";
                break;
            }
            case 2: {
                string = "MEDIUM";
                break;
            }
            case 3: {
                string = "LOW";
            }
        }
        return string;
    }

    String getLobEncryption() {
        String string = "NONE";
        switch (this.contentLobEncrypt) {
            case 1: {
                string = "3DES168";
                break;
            }
            case 2: {
                string = "AES128";
                break;
            }
            case 3: {
                string = "AES192";
                break;
            }
            case 4: {
                string = "AES256";
            }
        }
        return string;
    }

    private boolean compareStrings(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    boolean matches(CollectionDescriptor collectionDescriptor) {
        if (this == collectionDescriptor) {
            return true;
        }
        if (this.versioningMethod != collectionDescriptor.versioningMethod) {
            return false;
        }
        if (this.keyAssignmentMethod != collectionDescriptor.keyAssignmentMethod) {
            return false;
        }
        if (this.keyDataType != collectionDescriptor.keyDataType) {
            return false;
        }
        if (this.contentDataType != collectionDescriptor.contentDataType) {
            return false;
        }
        if (this.contentLobCache != collectionDescriptor.contentLobCache) {
            return false;
        }
        if (this.contentLobEncrypt != collectionDescriptor.contentLobEncrypt) {
            return false;
        }
        if (this.contentLobCompress != collectionDescriptor.contentLobCompress) {
            return false;
        }
        if (this.keyLength != collectionDescriptor.keyLength) {
            return false;
        }
        if (this.contentLength != collectionDescriptor.contentLength) {
            return false;
        }
        if (this.writable != collectionDescriptor.writable) {
            return false;
        }
        if (this.plsqlBased != collectionDescriptor.plsqlBased) {
            return false;
        }
        if (this.viewBased != collectionDescriptor.viewBased) {
            return false;
        }
        if (this.strictMode != collectionDescriptor.strictMode) {
            return false;
        }
        if (!this.compareStrings(this.timeIndex, collectionDescriptor.timeIndex)) {
            return false;
        }
        if (!this.compareStrings(this.uriName, collectionDescriptor.uriName)) {
            return false;
        }
        if (!this.compareStrings(this.dbSchema, collectionDescriptor.dbSchema)) {
            return false;
        }
        if (!this.compareStrings(this.dbObjectName, collectionDescriptor.dbObjectName)) {
            return false;
        }
        if (!this.compareStrings(this.keyColumnName, collectionDescriptor.keyColumnName)) {
            return false;
        }
        if (!this.compareStrings(this.contentColumnName, collectionDescriptor.contentColumnName)) {
            return false;
        }
        if (!this.compareStrings(this.keySequenceName, collectionDescriptor.keySequenceName)) {
            return false;
        }
        if (!this.compareStrings(this.timestampColumnName, collectionDescriptor.timestampColumnName)) {
            return false;
        }
        if (!this.compareStrings(this.versionColumnName, collectionDescriptor.versionColumnName)) {
            return false;
        }
        if (!this.compareStrings(this.doctypeColumnName, collectionDescriptor.doctypeColumnName)) {
            return false;
        }
        return this.compareStrings(this.creationColumnName, collectionDescriptor.creationColumnName);
    }

    public String getDescription() {
        JsonByteArray jsonByteArray = new JsonByteArray();
        jsonByteArray.appendOpenBrace();
        if (this.dbSchema != null) {
            jsonByteArray.appendValue("schemaName");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.dbSchema);
            jsonByteArray.appendComma();
        }
        if (this.plsqlBased) {
            jsonByteArray.appendValue("packageName");
        } else if (this.viewBased) {
            jsonByteArray.appendValue("viewName");
        } else {
            jsonByteArray.appendValue("tableName");
        }
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.dbObjectName);
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("keyColumn");
        jsonByteArray.appendColon();
        jsonByteArray.appendOpenBrace();
        jsonByteArray.appendValue("name");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.keyColumnName);
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("sqlType");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.getKeyDataType());
        if (this.keyLength > 0) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("maxLength");
            jsonByteArray.appendColon();
            jsonByteArray.append(Integer.toString(this.keyLength));
        }
        jsonByteArray.appendComma();
        if (this.keySequenceName != null) {
            jsonByteArray.appendValue("sequenceName");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.keySequenceName);
            jsonByteArray.appendComma();
        }
        jsonByteArray.appendValue("assignmentMethod");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.getKeyAssignmentMethod());
        jsonByteArray.appendCloseBrace();
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("contentColumn");
        jsonByteArray.appendColon();
        jsonByteArray.appendOpenBrace();
        jsonByteArray.appendValue("name");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.contentColumnName);
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("sqlType");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.getContentDataType());
        if (this.contentLength > 0) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("maxLength");
            jsonByteArray.appendColon();
            jsonByteArray.append(Integer.toString(this.contentLength));
        } else {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("compress");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.getLobCompression());
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("cache");
            jsonByteArray.appendColon();
            jsonByteArray.append(this.contentLobCache ? "true" : "false");
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("encrypt");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.getLobEncryption());
        }
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("validation");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.strictMode ? "STRICT" : "LAX");
        jsonByteArray.appendCloseBrace();
        if (this.versionColumnName != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("versionColumn");
            jsonByteArray.appendColon();
            jsonByteArray.appendOpenBrace();
            jsonByteArray.appendValue("name");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.versionColumnName);
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("type");
            jsonByteArray.appendColon();
            switch (this.versioningMethod) {
                case 1: 
                case 2: {
                    jsonByteArray.appendValue("Integer");
                    break;
                }
                default: {
                    jsonByteArray.appendValue("String");
                }
            }
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("method");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.getVersioningMethod());
            jsonByteArray.appendCloseBrace();
        }
        if (this.timestampColumnName != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("lastModifiedColumn");
            jsonByteArray.appendColon();
            jsonByteArray.appendOpenBrace();
            jsonByteArray.appendValue("name");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.timestampColumnName);
            if (this.timeIndex != null) {
                jsonByteArray.appendComma();
                jsonByteArray.appendValue("index");
                jsonByteArray.appendColon();
                jsonByteArray.appendValue(this.timeIndex);
            }
            jsonByteArray.appendCloseBrace();
        }
        if (this.creationColumnName != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("creationTimeColumn");
            jsonByteArray.appendColon();
            jsonByteArray.appendOpenBrace();
            jsonByteArray.appendValue("name");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.creationColumnName);
            jsonByteArray.appendCloseBrace();
        }
        if (this.doctypeColumnName != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("mediaTypeColumn");
            jsonByteArray.appendColon();
            jsonByteArray.appendOpenBrace();
            jsonByteArray.appendValue("name");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.doctypeColumnName);
            jsonByteArray.appendCloseBrace();
        }
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("readOnly");
        jsonByteArray.appendColon();
        jsonByteArray.append(this.writable ? "false" : "true");
        jsonByteArray.appendCloseBrace();
        return new String(jsonByteArray.getArray(), 0, jsonByteArray.getLength(), Configuration.DEFAULT_CHARSET);
    }

    public static Properties buildCollectionProperties(InputStream inputStream) throws JsonStoreException {
        JsonObject jsonObject;
        DocumentLoader documentLoader;
        if (inputStream == null) {
            return STANDARD_PROPERTIES;
        }
        Properties properties = new Properties();
        try {
            documentLoader = new DocumentLoader(inputStream);
        }
        catch (JsonException jsonException) {
            return STANDARD_PROPERTIES;
        }
        try {
            jsonObject = (JsonObject)documentLoader.parse();
        }
        catch (JsonParsingException jsonParsingException) {
            throw new JsonStoreException((Exception)((Object)jsonParsingException));
        }
        catch (JsonException jsonException) {
            throw new JsonStoreException((Exception)((Object)jsonException));
        }
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string;
            JsonValue jsonValue;
            Object object;
            String string2 = (String)entry.getKey();
            JsonValue jsonValue2 = (JsonValue)entry.getValue();
            String string3 = null;
            Set set = null;
            boolean bl = false;
            if (jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                object = (JsonString)jsonValue2;
                string3 = object.getString();
            } else if (jsonValue2.getValueType() == JsonValue.ValueType.NUMBER) {
                object = (JsonNumber)jsonValue2;
                string3 = object.toString();
            } else if (jsonValue2.getValueType() == JsonValue.ValueType.TRUE) {
                string3 = "true";
            } else if (jsonValue2.getValueType() == JsonValue.ValueType.FALSE) {
                string3 = "false";
            } else if (jsonValue2.getValueType() == JsonValue.ValueType.NULL) {
                string3 = "null";
            } else if (jsonValue2.getValueType() == JsonValue.ValueType.OBJECT) {
                bl = true;
                set = ((JsonObject)jsonValue2).entrySet();
            } else if (jsonValue2.getValueType() == JsonValue.ValueType.ARRAY) {
                // empty if block
            }
            if (string2.equalsIgnoreCase("schemaName")) {
                if (string3 == null) continue;
                properties.setProperty("rdbms.schema_name", string3);
                continue;
            }
            if (string2.equalsIgnoreCase("tableName")) {
                if (string3 == null) continue;
                properties.setProperty("rdbms.table_name", string3);
                continue;
            }
            if (string2.equalsIgnoreCase("viewName")) {
                if (string3 == null) continue;
                properties.setProperty("rdbms.view_name", string3);
                continue;
            }
            if (string2.equalsIgnoreCase("packageName")) {
                if (string3 == null) continue;
                properties.setProperty("rdbms.package_name", string3);
                continue;
            }
            if (string2.equalsIgnoreCase("contentColumn")) {
                if (!bl) continue;
                for (Map.Entry entry2 : set) {
                    jsonValue = (JsonValue)entry2.getValue();
                    string = (String)entry2.getKey();
                    if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        string3 = ((JsonString)jsonValue).getString();
                    } else if (jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                        string3 = ((JsonNumber)jsonValue).toString();
                    } else if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                        string3 = "true";
                    } else if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                        string3 = "false";
                    } else if (jsonValue.getValueType() == JsonValue.ValueType.NULL) {
                        string3 = "null";
                    }
                    if (string.equalsIgnoreCase("name")) {
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.content_name", string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("sqlType")) {
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.content_type", string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("maxLength")) {
                        if (string3 == null && jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                            string3 = ((JsonNumber)jsonValue).toString();
                        }
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.content_len", string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("validation")) {
                        if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                            string3 = "STRICT";
                        } else if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                            string3 = "LAX";
                        }
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.strict_mode", string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("compress")) {
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.lob_compress", string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("cache")) {
                        string3 = "FALSE";
                        if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                            string3 = "TRUE";
                        }
                        properties.setProperty("rdbms.lob_cache", string3);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("encrypt") || string3 == null) continue;
                    properties.setProperty("rdbms.lob_encrypt", string3);
                }
                continue;
            }
            if (string2.equalsIgnoreCase("keyColumn")) {
                if (!bl) continue;
                for (Map.Entry entry2 : set) {
                    jsonValue = (JsonValue)entry2.getValue();
                    string = (String)entry2.getKey();
                    if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        string3 = ((JsonString)jsonValue).getString();
                    } else if (jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                        string3 = ((JsonNumber)jsonValue).toString();
                    } else if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                        string3 = "true";
                    } else if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                        string3 = "false";
                    } else if (jsonValue.getValueType() == JsonValue.ValueType.NULL) {
                        string3 = "null";
                    }
                    if (string.equalsIgnoreCase("name")) {
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.key_name", string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("sqlType")) {
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.key_type", string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("maxLength")) {
                        if (string3 == null && jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                            string3 = ((JsonNumber)jsonValue).toString();
                        }
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.key_len", string3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("sequenceName")) {
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.key_sequence_name", string3);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("assignmentMethod") || string3 == null) continue;
                    properties.setProperty("rdbms.key_assign_method", string3);
                }
                continue;
            }
            if (string2.equalsIgnoreCase("creationTimeColumn")) {
                if (!bl) continue;
                for (Map.Entry entry2 : set) {
                    jsonValue = (JsonValue)entry2.getValue();
                    string = (String)entry2.getKey();
                    if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        string3 = ((JsonString)jsonValue).getString();
                    }
                    if (!string.equalsIgnoreCase("name") || string3 == null) continue;
                    properties.setProperty("rdbms.creation_name", string3);
                }
                continue;
            }
            if (string2.equalsIgnoreCase("lastModifiedColumn")) {
                if (!bl) continue;
                for (Map.Entry entry2 : set) {
                    jsonValue = (JsonValue)entry2.getValue();
                    string = (String)entry2.getKey();
                    if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        string3 = ((JsonString)jsonValue).getString();
                    }
                    if (string.equalsIgnoreCase("name")) {
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.timestamp_name", string3);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("index") || string3 == null) continue;
                    properties.setProperty("rdbms.time_index", string3);
                }
                continue;
            }
            if (string2.equalsIgnoreCase("versionColumn")) {
                if (!bl) continue;
                for (Map.Entry entry2 : set) {
                    jsonValue = (JsonValue)entry2.getValue();
                    string = (String)entry2.getKey();
                    if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        string3 = ((JsonString)jsonValue).getString();
                    }
                    if (string.equalsIgnoreCase("name")) {
                        if (string3 == null) continue;
                        properties.setProperty("rdbms.version_name", string3);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("method") || string3 == null) continue;
                    properties.setProperty("rdbms.version_method", string3);
                }
                continue;
            }
            if (string2.equalsIgnoreCase("mediaTypeColumn")) {
                if (!bl) continue;
                for (Map.Entry entry2 : set) {
                    jsonValue = (JsonValue)entry2.getValue();
                    string = (String)entry2.getKey();
                    if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        string3 = ((JsonString)jsonValue).getString();
                    }
                    if (!string.equalsIgnoreCase("name") || string3 == null) continue;
                    properties.setProperty("rdbms.doctype_name", string3);
                }
                continue;
            }
            if (!string2.equalsIgnoreCase("readOnly")) continue;
            if (jsonValue2.getValueType() == JsonValue.ValueType.TRUE) {
                string3 = "READONLY";
            } else if (jsonValue2.getValueType() == JsonValue.ValueType.FALSE) {
                string3 = "READWRITE";
            }
            if (string3 == null) continue;
            properties.setProperty("rdbms.write_enable", string3);
        }
        return properties;
    }

    public static Properties buildCollectionProperties(String string) throws JsonStoreException {
        byte[] byArray = string.getBytes(Configuration.DEFAULT_CHARSET);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return CollectionDescriptor.buildCollectionProperties(byteArrayInputStream);
    }

    public String toString() {
        return this.getName();
    }

    static {
        Properties properties = STANDARD_PROPERTIES = new Properties();
        properties.setProperty("rdbms.key_type", "VARCHAR2");
        properties.setProperty("rdbms.content_type", "BLOB");
        properties.setProperty("rdbms.version_name", "VERSION");
        properties.setProperty("rdbms.version_method", "SHA256");
        properties.setProperty("rdbms.lob_cache", "true");
        properties.setProperty("rdbms.timestamp_name", "LAST_MODIFIED");
        properties.setProperty("rdbms.creation_name", "CREATED_ON");
        properties.setProperty("rdbms.key_assign_method", "UUID");
        properties.setProperty("rdbms.write_enable", "READWRITE");
        properties.setProperty("rdbms.strict_mode", "STRICT");
    }
}

