/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import java.math.BigDecimal;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.json.api.JsonCursor;
import oracle.json.api.JsonDocument;
import oracle.json.api.JsonStoreException;
import oracle.json.api.OracleJsonCollection;
import oracle.json.common.Configuration;
import oracle.json.common.MetricsCollector;
import oracle.json.common.PooledConnection;
import oracle.json.parser.JsonPath;
import oracle.json.rdbms.CollectionDescriptor;
import oracle.json.rdbms.CollectionsMessage;
import oracle.json.rdbms.JsonDatabaseImpl;
import oracle.json.util.ByteArray;
import oracle.json.util.HashFuncs;
import oracle.json.util.JsonByteArray;

abstract class JsonCollectionImpl
implements OracleJsonCollection {
    static ArrayList<JsonDocument> EMPTY_LIST = new ArrayList();
    static byte[] EMPTY_DATA = new byte[0];
    protected static final Logger log = Logger.getLogger(JsonCollectionImpl.class.getName());
    protected static final int SET_FETCH_LIMIT = 16;
    protected final String collectionName;
    protected final OracleConnection conn;
    protected final JsonDatabaseImpl db;
    protected final MetricsCollector metrics;
    protected final CollectionDescriptor options;
    protected StringBuilder sb = new StringBuilder(1000);
    protected boolean internalDriver = false;
    protected static final boolean limitedReads = false;

    JsonCollectionImpl(JsonDatabaseImpl jsonDatabaseImpl, String string) {
        this(jsonDatabaseImpl, string, new CollectionDescriptor(string));
    }

    JsonCollectionImpl(JsonDatabaseImpl jsonDatabaseImpl, String string, CollectionDescriptor collectionDescriptor) {
        this.db = jsonDatabaseImpl;
        this.collectionName = string;
        this.options = collectionDescriptor;
        this.metrics = jsonDatabaseImpl.getMetrics();
        this.conn = jsonDatabaseImpl.getConnection();
        this.setAvoid();
    }

    public void setAvoid() {
        PooledConnection pooledConnection;
        if (this.conn != null && this.conn instanceof PooledConnection && (pooledConnection = (PooledConnection)this.conn).getDefault()) {
            this.internalDriver = true;
            log.fine("Avoid returning clauses for internal connections");
        }
    }

    protected void closeCursor(Statement statement, ResultSet resultSet) {
        this.db.closeCursor(statement, resultSet);
    }

    @Override
    public String getName() {
        return this.collectionName;
    }

    @Override
    public boolean isReadOnly() {
        return !this.options.writable;
    }

    @Override
    public boolean isHeterogeneous() {
        return this.options.doctypeColumnName != null && this.options.contentDataType == 4;
    }

    @Override
    public boolean isBinary() {
        return this.options.contentDataType == 4 || this.options.contentDataType == 2;
    }

    public boolean payloadBasedVersioning() {
        return this.options.versioningMethod == 5 || this.options.versioningMethod == 4 || this.options.versioningMethod == 0;
    }

    public boolean matches(CollectionDescriptor collectionDescriptor) {
        return this.options.matches(collectionDescriptor);
    }

    @Override
    public void drop() throws JsonStoreException {
        this.db.dropCollection(this.collectionName);
    }

    protected JsonStoreException makeException(CollectionsMessage collectionsMessage, Object ... objectArray) {
        return this.db.makeException(collectionsMessage, objectArray);
    }

    protected void writeCheck(String string) throws JsonStoreException {
        if (this.isReadOnly()) {
            log.warning("Write to " + this.options.uriName + " not allowed");
            throw this.makeException(CollectionsMessage.EX_READ_ONLY, this.options.uriName, string);
        }
    }

    protected String computeVersion(byte[] byArray) throws JsonStoreException {
        if (byArray == null) {
            byArray = EMPTY_DATA;
        }
        String string = null;
        this.metrics.startTiming();
        switch (this.options.versioningMethod) {
            case 5: {
                try {
                    byte[] byArray2 = HashFuncs.MD5(byArray);
                    if (byArray2 == null) {
                        throw this.makeException(CollectionsMessage.EX_MD5_NOT_SUPP, new Object[0]);
                    }
                    string = ByteArray.rawToHex(byArray2);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw this.makeException(CollectionsMessage.EX_MD5_NOT_SUPP, new Object[0]);
                }
            }
            case 4: {
                try {
                    byte[] byArray3 = HashFuncs.SHA256(byArray);
                    if (byArray3 == null) {
                        throw this.makeException(CollectionsMessage.EX_SHA256_NOT_SUPP, new Object[0]);
                    }
                    string = ByteArray.rawToHex(byArray3);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw this.makeException(CollectionsMessage.EX_SHA256_NOT_SUPP, new Object[0]);
                }
            }
        }
        this.metrics.recordChecksum();
        return string;
    }

    protected String uidToDecimal(String string) {
        byte[] byArray = ByteArray.hexToRaw(string);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = new BigDecimal(256L);
        for (int i = 0; i < byArray.length; ++i) {
            bigDecimal = bigDecimal.multiply(bigDecimal2).add(new BigDecimal(byArray[i] & 0xFF));
        }
        return bigDecimal.toPlainString();
    }

    private boolean isInteger(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if ("0123456789".indexOf(cArray[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    private String zeroStrip(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        for (n = 0; n < n2 && string.charAt(n) == '0'; ++n) {
        }
        if (n == 0) {
            return string;
        }
        if (n == n2) {
            return "0";
        }
        return string.substring(n);
    }

    protected String canonicalKey(String string) throws JsonStoreException {
        if (this.options.keyDataType == 3) {
            if (!this.isInteger(string = this.zeroStrip(string))) {
                throw this.makeException(CollectionsMessage.EX_INVALID_KEY, string, this.options.getKeyDataType());
            }
        } else if (this.options.keyAssignmentMethod == 3 || this.options.keyAssignmentMethod == 2) {
            int n;
            int n2 = string.length();
            if (n2 < (n = 32)) {
                String string2 = "00000000000000000000000000000000";
                string = string2.substring(1, n - n2) + string;
            } else if (n2 > n) {
                throw this.makeException(CollectionsMessage.EX_INVALID_KEY, string, this.options.getKeyAssignmentMethod());
            }
            if (!ByteArray.isHex(string)) {
                throw this.makeException(CollectionsMessage.EX_INVALID_KEY, string, this.options.getKeyAssignmentMethod());
            }
        } else if (this.options.keyDataType == 4) {
            if (!ByteArray.isHex(string)) {
                throw this.makeException(CollectionsMessage.EX_INVALID_KEY, string, this.options.getKeyDataType());
            }
        } else if (this.options.keyAssignmentMethod == 4 && !this.isInteger(string = this.zeroStrip(string))) {
            throw this.makeException(CollectionsMessage.EX_INVALID_KEY, string, "INTEGER");
        }
        return string;
    }

    protected String stringFromBytes(byte[] byArray) throws JsonStoreException {
        if (byArray == null) {
            return "";
        }
        if (byArray.length == 0) {
            return "";
        }
        Charset charset = JsonByteArray.getJsonCharset(byArray);
        try {
            return ByteArray.bytesToString(byArray, charset);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new JsonStoreException(characterCodingException);
        }
    }

    abstract JsonCursor openCursor(boolean var1, int var2, long var3) throws JsonStoreException;

    @Override
    public JsonCursor find() throws JsonStoreException {
        return this.find(JsonDatabaseImpl.UNLIMITED, 0L);
    }

    @Override
    public JsonCursor find(int n) throws JsonStoreException {
        return this.find(n, 0L);
    }

    @Override
    public JsonCursor find(int n, long l) throws JsonStoreException {
        return this.openCursor(false, n, l);
    }

    @Override
    public JsonCursor findKeys() throws JsonStoreException {
        return this.findKeys(JsonDatabaseImpl.UNLIMITED, 0L);
    }

    @Override
    public JsonCursor findKeys(int n) throws JsonStoreException {
        return this.findKeys(n, 0L);
    }

    @Override
    public JsonCursor findKeys(int n, long l) throws JsonStoreException {
        return this.openCursor(true, n, l);
    }

    @Override
    public List<JsonDocument> findSet(String[] stringArray) throws JsonStoreException {
        if (stringArray == null) {
            return EMPTY_LIST;
        }
        if (stringArray.length == 0) {
            return EMPTY_LIST;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            hashSet.add(string);
        }
        return this.findSet(hashSet);
    }

    @Override
    public JsonCursor find(JsonDocument jsonDocument) throws JsonStoreException {
        return this.find(jsonDocument, null);
    }

    @Override
    public JsonDocument findOne(String string) throws JsonStoreException {
        return this.findOne(string, 0L, JsonDatabaseImpl.UNLIMITED);
    }

    @Override
    public void createIndex(String string, boolean bl, String string2) throws JsonStoreException {
        this.createIndex(string, bl, new JsonPath(string2));
    }

    @Override
    public void createIndex(String string, boolean bl, String[] stringArray) throws JsonStoreException {
        this.createIndex(string, bl, new JsonPath(stringArray));
    }

    @Override
    public void createIndex(String string, boolean bl, JsonPath jsonPath) throws JsonStoreException {
        JsonPath[] jsonPathArray = new JsonPath[]{jsonPath};
        this.createIndex(string, bl, jsonPathArray);
    }

    @Override
    public void createIndex(String string, boolean bl, List<JsonPath> list) throws JsonStoreException {
        JsonPath[] jsonPathArray = new JsonPath[list.size()];
        this.createIndex(string, bl, list.toArray(jsonPathArray));
    }

    @Override
    public List<JsonDocument> insert(List<JsonDocument> list) throws JsonStoreException {
        if (list == null) {
            return EMPTY_LIST;
        }
        int n = list.size();
        if (n == 0) {
            return EMPTY_LIST;
        }
        return this.insert(list.iterator());
    }

    @Override
    public void truncate() throws JsonStoreException {
        this.writeCheck("truncate");
        if (this.options.viewBased || this.options.plsqlBased) {
            throw this.makeException(CollectionsMessage.EX_TRUNCATE_NOT_SUPP, this.options.uriName);
        }
        this.sb.setLength(0);
        this.sb.append("truncate table \"");
        this.sb.append(this.options.dbObjectName);
        this.sb.append("\"");
        String string = this.sb.toString();
        PreparedStatement preparedStatement = null;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.execute();
            log.fine("Truncated collection " + this.collectionName);
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
            this.closeCursor(preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, null);
                throw throwable;
            }
        }
    }

    protected byte[] readPayloadColumn(ResultSet resultSet, int n) throws SQLException {
        String string = "";
        byte[] byArray = EMPTY_DATA;
        switch (this.options.contentDataType) {
            case 5: {
                if (this.internalDriver) {
                    // empty if block
                }
            }
            case 1: {
                string = resultSet.getString(n);
                if (string == null) break;
                byArray = string.getBytes(Configuration.DEFAULT_CHARSET);
                break;
            }
            case 6: {
                if (this.internalDriver) {
                    // empty if block
                }
            }
            case 3: {
                string = resultSet.getNString(n);
                if (string == null) break;
                byArray = string.getBytes(Configuration.DEFAULT_CHARSET);
                break;
            }
            case 4: {
                if (this.internalDriver) {
                    // empty if block
                }
            }
            case 2: {
                byArray = resultSet.getBytes(n);
            }
        }
        return byArray;
    }

    public String toString() {
        return this.options.toString();
    }

    @Override
    public String getDescription() {
        return this.options.getDescription();
    }
}

