/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.json.api.JsonCursor;
import oracle.json.api.JsonDocument;
import oracle.json.api.JsonStoreException;
import oracle.json.common.Configuration;
import oracle.json.common.LobInputStream;
import oracle.json.common.MetricsCollector;
import oracle.json.parser.ProjectionSpec;
import oracle.json.rdbms.CollectionDescriptor;
import oracle.json.rdbms.JsonCollectionImpl;
import oracle.json.rdbms.JsonDocumentImpl;

public class JsonCursorImpl
implements JsonCursor {
    private static final Logger log = Logger.getLogger(JsonCursor.class.getName());
    private Statement stmt;
    private ResultSet rows;
    private long cumTime = 0L;
    private int rowCount = 0;
    private final CollectionDescriptor desc;
    private final MetricsCollector metrics;
    private final boolean keysOnly;
    private final boolean isQBE;
    private boolean limitedReads = false;
    private byte[] sql_query = null;
    private ProjectionSpec proj = null;

    JsonCursorImpl(CollectionDescriptor collectionDescriptor, MetricsCollector metricsCollector, boolean bl, Statement statement, ResultSet resultSet) {
        this(collectionDescriptor, metricsCollector, bl, false, statement, resultSet);
    }

    JsonCursorImpl(CollectionDescriptor collectionDescriptor, MetricsCollector metricsCollector, boolean bl, boolean bl2, Statement statement, ResultSet resultSet) {
        this.desc = collectionDescriptor;
        this.metrics = metricsCollector;
        this.keysOnly = bl;
        this.isQBE = bl2;
        this.stmt = statement;
        this.rows = resultSet;
    }

    void setLimitedReads() {
        this.limitedReads = true;
    }

    void setElapsedTime(long l) {
        this.cumTime += l;
    }

    @Override
    public JsonDocument next() throws JsonStoreException {
        JsonDocumentImpl jsonDocumentImpl = null;
        if (this.rows != null) {
            LobInputStream lobInputStream = null;
            try {
                long l = this.metrics.getTime();
                if (this.rows.next()) {
                    int n = 0;
                    byte[] byArray = null;
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    boolean bl = this.desc.doctypeColumnName != null;
                    String string5 = this.rows.getString(++n);
                    if (bl) {
                        string4 = this.rows.getString(++n);
                    }
                    if (this.proj != null) {
                        int n2 = this.proj.numColumns();
                        String[] stringArray = new String[n2];
                        for (int i = 0; i < n2; ++i) {
                            stringArray[i] = this.rows.getString(++n);
                        }
                        byArray = this.proj.projectValues(stringArray);
                    } else if (!this.keysOnly) {
                        String string6 = "";
                        switch (this.desc.contentDataType) {
                            case 5: {
                                if (this.limitedReads) {
                                    long l2;
                                    Clob clob;
                                    if ((clob = this.rows.getClob(++n)) != null && (l2 = clob.length()) > 0L) {
                                        string6 = clob.getSubString(1L, (int)l2);
                                    }
                                    byArray = string6.getBytes(Configuration.DEFAULT_CHARSET);
                                    break;
                                }
                            }
                            case 1: {
                                string6 = this.rows.getString(++n);
                                if (string6 == null) break;
                                byArray = string6.getBytes(Configuration.DEFAULT_CHARSET);
                                break;
                            }
                            case 6: {
                                if (this.limitedReads) {
                                    long l3;
                                    NClob nClob;
                                    if ((nClob = this.rows.getNClob(++n)) != null && (l3 = nClob.length()) > 0L) {
                                        string6 = nClob.getSubString(1L, (int)l3);
                                    }
                                    byArray = string6.getBytes(Configuration.DEFAULT_CHARSET);
                                    break;
                                }
                            }
                            case 3: {
                                string6 = this.rows.getNString(++n);
                                if (string6 == null) break;
                                byArray = string6.getBytes(Configuration.DEFAULT_CHARSET);
                                break;
                            }
                            case 4: {
                                if (this.limitedReads || bl && !this.isQBE) {
                                    Blob blob;
                                    if ((blob = this.rows.getBlob(++n)) != null) {
                                        long l4 = blob.length();
                                        int n3 = (int)l4;
                                        if (l4 == 0L) {
                                            byArray = JsonCollectionImpl.EMPTY_DATA;
                                            blob.free();
                                        } else {
                                            InputStream inputStream = blob.getBinaryStream();
                                            if (inputStream != null) {
                                                lobInputStream = new LobInputStream(blob, inputStream, n3);
                                                lobInputStream.setMetrics(this.metrics);
                                            }
                                        }
                                    }
                                    if (lobInputStream != null || byArray != null) break;
                                    lobInputStream = new LobInputStream();
                                    break;
                                }
                            }
                            case 2: {
                                byArray = this.rows.getBytes(++n);
                            }
                        }
                    }
                    if (this.desc.timestampColumnName != null) {
                        string = this.rows.getString(++n);
                    }
                    if (this.desc.creationColumnName != null) {
                        string2 = this.rows.getString(++n);
                    }
                    if (this.desc.versionColumnName != null) {
                        string3 = this.rows.getString(++n);
                    }
                    if (lobInputStream != null) {
                        jsonDocumentImpl = new JsonDocumentImpl(string5, string3, string, lobInputStream, string4);
                        lobInputStream = null;
                    } else {
                        jsonDocumentImpl = new JsonDocumentImpl(string5, string3, string, byArray);
                        if (string4 != null) {
                            jsonDocumentImpl.setContentType(string4);
                        }
                    }
                    if (string2 != null) {
                        jsonDocumentImpl.setCreatedOn(string2);
                    }
                    ++this.rowCount;
                    this.cumTime += this.metrics.getTimeDiff(l);
                } else {
                    this.closeInternal();
                }
            }
            catch (SQLException sQLException) {
                log.severe(sQLException.toString());
                try {
                    if (lobInputStream != null) {
                        lobInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.severe(iOException.toString());
                }
                throw new JsonStoreException(sQLException);
            }
        }
        return jsonDocumentImpl;
    }

    public byte[] getQuery() {
        return this.sql_query;
    }

    void setQuery(byte[] byArray) {
        this.sql_query = byArray;
    }

    void setProjection(ProjectionSpec projectionSpec) {
        this.proj = projectionSpec;
    }

    private void closeInternal() throws SQLException {
        this.rows.close();
        this.rows = null;
        this.stmt.close();
        this.stmt = null;
    }

    @Override
    public void close() throws IOException {
        if (this.rows != null) {
            try {
                this.closeInternal();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException);
            }
            this.metrics.recordCursorReads(this.rowCount, 1000, this.cumTime);
        }
    }
}

