/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.json.api.JsonDocument;
import oracle.json.api.JsonStoreException;
import oracle.json.api.OracleJsonCollection;
import oracle.json.api.OracleJsonDatabase;
import oracle.json.common.CollectionCache;
import oracle.json.common.MetadataCache;
import oracle.json.common.MetricsCollector;
import oracle.json.rdbms.CollectionDescriptor;
import oracle.json.rdbms.CollectionsMessage;
import oracle.json.rdbms.JsonCollectionImpl;
import oracle.json.rdbms.JsonDocumentImpl;
import oracle.json.rdbms.PlsqlCollectionImpl;
import oracle.json.rdbms.TableCollectionImpl;
import oracle.json.util.ByteArray;
import oracle.json.util.ComponentTime;
import oracle.json.util.HashFuncs;
import oracle.sql.Datum;

public class JsonDatabaseImpl
implements OracleJsonDatabase {
    static int UNLIMITED = -1;
    static int MAX_COL_NAME = 30;
    static ArrayList<String> EMPTY_LIST = new ArrayList();
    private static final String SELECT_GUID = "select SYS_GUID() from SYS.DUAL";
    private static final String SELECT_GUID_BATCH = "declare\n  type VCTAB is table of varchar2(255) index by binary_integer;\n  N number;\n  X varchar2(255);\n  K vctab;\nbegin\n  N := ?;\n  for I in 1..N loop\n    select rawtohex(SYS_GUID()) into X from SYS.DUAL;\n    K(I) := X;\n  end loop;\n  ? := K;\nend;";
    private static final String ENABLE_QBE = "alter session set events '40500 trace name context forever, level 0x10'";
    private static final Logger log = Logger.getLogger(JsonDatabaseImpl.class.getName());
    private final String accountName;
    private final OracleConnection conn;
    private final CollectionCache cache;
    private final MetricsCollector metrics;
    private final HashMap<String, JsonCollectionImpl> map = new HashMap();
    private int rawMaxLength = -1;
    private int nvarcharMaxLength = -1;
    private int varcharMaxLength = -1;
    private boolean metadataTableExists = true;
    private boolean enableAutoCreate = false;
    private static final long TIME_REFRESH_INTERVAL = 100000000L;
    private static String SELECT_DB_TIMESTAMP = "select to_char(sys_extract_utc(SYSTIMESTAMP),'YYYY-MM-DD\"T\"HH24:MI:SS.FF') from SYS.DUAL";
    private String tz = null;
    private long currentTimestamp = 0L;
    private long updateNanos = 0L;
    private static final int GUID_BATCH_SIZE = 10;
    private final String[] guidCache = new String[10];
    private int guidCachePos = 10;
    private HashFuncs generator = new HashFuncs();

    public JsonDatabaseImpl(OracleConnection oracleConnection, String string, MetadataCache metadataCache, MetricsCollector metricsCollector) {
        this(oracleConnection, string, new CollectionCache(metadataCache.get(string)), metricsCollector);
    }

    public JsonDatabaseImpl(OracleConnection oracleConnection, String string, CollectionCache collectionCache, MetricsCollector metricsCollector) {
        this.conn = oracleConnection;
        this.accountName = string;
        this.cache = collectionCache;
        this.metrics = metricsCollector;
        this.getMaxLengths();
    }

    public JsonDatabaseImpl(OracleConnection oracleConnection, String string) {
        this(oracleConnection, string, new CollectionCache(string, false), new MetricsCollector());
    }

    JsonStoreException makeException(CollectionsMessage collectionsMessage, Object ... objectArray) {
        return new JsonStoreException(collectionsMessage.get(objectArray), collectionsMessage.getKey());
    }

    void closeCursor(Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            log.severe(sQLException.getMessage());
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            log.severe(sQLException.getMessage());
        }
    }

    private ArrayList<CollectionDescriptor> loadCollections(int n, int n2) throws JsonStoreException {
        if (!this.metadataTableExists) {
            return null;
        }
        return this.callListCollections(null, n, n2);
    }

    private ArrayList<CollectionDescriptor> loadCollections(int n, String string) throws JsonStoreException {
        if (!this.metadataTableExists) {
            return null;
        }
        return this.callListCollections(string, n, 0);
    }

    @Override
    public OracleJsonCollection createCollection(String string) throws JsonStoreException {
        return this.createCollection(string, CollectionDescriptor.NULL_DESCRIPTOR);
    }

    @Override
    public OracleJsonCollection createCollection(String string, Properties properties) throws JsonStoreException {
        if (properties == null) {
            return this.createCollection(string);
        }
        return this.createCollection(string, new CollectionDescriptor(string, properties));
    }

    OracleJsonCollection createCollection(String string, CollectionDescriptor collectionDescriptor) throws JsonStoreException {
        if (string == null) {
            throw this.makeException(CollectionsMessage.EX_NO_COLLECTION_NAME, new Object[0]);
        }
        OracleJsonCollection oracleJsonCollection = this.openCollection(string, collectionDescriptor, false);
        if (oracleJsonCollection != null) {
            String string2 = oracleJsonCollection.getName();
            if (!string.equals(string2)) {
                throw this.makeException(CollectionsMessage.EX_COLLECTION_EXISTS, string2);
            }
            return oracleJsonCollection;
        }
        if (collectionDescriptor == CollectionDescriptor.NULL_DESCRIPTOR) {
            collectionDescriptor = new CollectionDescriptor(string);
        }
        collectionDescriptor = this.callCreatePLSQL(string, collectionDescriptor);
        return this.openCollection(string, collectionDescriptor, false);
    }

    @Override
    public OracleJsonCollection openCollection(String string) throws JsonStoreException {
        return this.openCollection(string, CollectionDescriptor.NULL_DESCRIPTOR);
    }

    @Override
    public OracleJsonCollection openCollection(String string, Properties properties) throws JsonStoreException {
        if (properties == null) {
            return this.openCollection(string);
        }
        return this.openCollection(string, new CollectionDescriptor(string, properties));
    }

    private OracleJsonCollection openCollection(String string, CollectionDescriptor collectionDescriptor) throws JsonStoreException {
        return this.openCollection(string, collectionDescriptor, this.enableAutoCreate);
    }

    private OracleJsonCollection openCollection(String string, CollectionDescriptor collectionDescriptor, boolean bl) throws JsonStoreException {
        if (string == null) {
            throw this.makeException(CollectionsMessage.EX_NO_COLLECTION_NAME, new Object[0]);
        }
        JsonCollectionImpl jsonCollectionImpl = this.map.get(string);
        if (jsonCollectionImpl != null) {
            if (collectionDescriptor != CollectionDescriptor.NULL_DESCRIPTOR && !jsonCollectionImpl.matches(collectionDescriptor)) {
                throw this.makeException(CollectionsMessage.EX_MISMATCHED_DESCRIPTORS, new Object[0]);
            }
            return jsonCollectionImpl;
        }
        CollectionDescriptor collectionDescriptor2 = this.cache.get(string);
        if (collectionDescriptor2 == null) {
            collectionDescriptor2 = this.loadCollection(string);
        }
        boolean bl2 = false;
        if (collectionDescriptor2 != null) {
            if (collectionDescriptor != CollectionDescriptor.NULL_DESCRIPTOR && !collectionDescriptor2.matches(collectionDescriptor)) {
                throw this.makeException(CollectionsMessage.EX_MISMATCHED_DESCRIPTORS, new Object[0]);
            }
            bl2 = true;
            string = collectionDescriptor2.getName();
        } else if (collectionDescriptor != CollectionDescriptor.NULL_DESCRIPTOR && bl) {
            bl2 = true;
            collectionDescriptor2 = collectionDescriptor;
        }
        if (bl2) {
            jsonCollectionImpl = collectionDescriptor2.plsqlBased ? new PlsqlCollectionImpl(this, string, collectionDescriptor2) : new TableCollectionImpl(this, string, collectionDescriptor2);
            this.map.put(string, jsonCollectionImpl);
        }
        return jsonCollectionImpl;
    }

    @Override
    public void dropCollection(String string) throws JsonStoreException {
        if (string == null) {
            throw this.makeException(CollectionsMessage.EX_NO_COLLECTION_NAME, new Object[0]);
        }
        CollectionDescriptor collectionDescriptor = this.cache.get(string);
        if (collectionDescriptor == null) {
            collectionDescriptor = this.loadCollection(string);
        }
        if (collectionDescriptor == null) {
            collectionDescriptor = new CollectionDescriptor(string);
        }
        if (collectionDescriptor != null) {
            this.callDropPLSQL(string);
            this.cache.remove(string);
            this.map.remove(string);
        }
    }

    @Override
    public List<String> getCollectionNames() throws JsonStoreException {
        return this.getCollectionNames(UNLIMITED, 0);
    }

    @Override
    public List<String> getCollectionNames(int n) throws JsonStoreException {
        return this.getCollectionNames(n, 0);
    }

    @Override
    public List<String> getCollectionNames(int n, int n2) throws JsonStoreException {
        ArrayList<CollectionDescriptor> arrayList = this.loadCollections(n, n2);
        int n3 = arrayList.size();
        ArrayList<String> arrayList2 = EMPTY_LIST;
        if (n3 > 0) {
            arrayList2 = new ArrayList(n3);
            for (CollectionDescriptor collectionDescriptor : arrayList) {
                arrayList2.add(collectionDescriptor.uriName);
            }
        }
        return arrayList2;
    }

    @Override
    public List<String> getCollectionNames(int n, String string) throws JsonStoreException {
        ArrayList<CollectionDescriptor> arrayList = this.loadCollections(n, string);
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = EMPTY_LIST;
        if (n2 > 0) {
            arrayList2 = new ArrayList(n2);
            for (CollectionDescriptor collectionDescriptor : arrayList) {
                arrayList2.add(collectionDescriptor.uriName);
            }
        }
        return arrayList2;
    }

    @Override
    public JsonDocument newDocument(InputStream inputStream) {
        return this.newDocument(null, inputStream);
    }

    @Override
    public JsonDocument newDocument(InputStream inputStream, String string) {
        return new JsonDocumentImpl(null, inputStream, string);
    }

    @Override
    public JsonDocument newDocument(String string) {
        return this.newDocument((String)null, string);
    }

    @Override
    public JsonDocument newDocument(byte[] byArray) {
        return this.newDocument((String)null, byArray);
    }

    @Override
    public JsonDocument newDocument(String string, InputStream inputStream) {
        return new JsonDocumentImpl(string, inputStream);
    }

    @Override
    public JsonDocument newDocument(String string, InputStream inputStream, String string2) {
        return new JsonDocumentImpl(string, inputStream, string2);
    }

    @Override
    public JsonDocument newDocument(String string, String string2) {
        return new JsonDocumentImpl(string, string2);
    }

    @Override
    public JsonDocument newDocument(String string, byte[] byArray) {
        return new JsonDocumentImpl(string, byArray);
    }

    MetricsCollector getMetrics() {
        return this.metrics;
    }

    @Override
    public OracleConnection getConnection() {
        return this.conn;
    }

    long getDatabaseTime() throws SQLException {
        long l = System.nanoTime();
        long l2 = this.updateNanos == 0L ? -1L : l - this.updateNanos;
        if (l2 > 100000000L || l2 < 0L) {
            this.refreshDatabaseTime(l);
        } else {
            long l3;
            long l4 = l2 / 1000L;
            if (l4 <= 0L) {
                l4 = 1L;
            }
            if ((l3 = ComponentTime.increment(this.currentTimestamp, l4)) < 0L) {
                this.refreshDatabaseTime(l);
            } else {
                this.currentTimestamp = l3;
            }
        }
        return this.currentTimestamp;
    }

    private void setDatabaseTime(long l, String string) {
        ComponentTime componentTime;
        long l2;
        if (string.length() > 27) {
            this.tz = string.substring(27);
        }
        if (string.length() > 26) {
            string = string.substring(0, 26);
        }
        if ((l2 = (componentTime = new ComponentTime(string)).getValue()) <= this.currentTimestamp) {
            l2 = ComponentTime.plus(this.currentTimestamp, 1L);
        }
        this.updateNanos = l;
        this.currentTimestamp = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDatabaseTime(long l) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = SELECT_DB_TIMESTAMP;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.setFetchSize(1);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.setDatabaseTime(l, resultSet.getString(1));
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordTimestampRead();
            this.closeCursor(preparedStatement, resultSet);
        }
        catch (Throwable throwable) {
            this.closeCursor(preparedStatement, resultSet);
            throw throwable;
        }
    }

    String nextGuid() throws JsonStoreException {
        if (this.guidCachePos >= this.guidCache.length) {
            this.fetchGuids();
        }
        return this.guidCache[this.guidCachePos++];
    }

    private void fetchGuids() throws JsonStoreException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = SELECT_GUID_BATCH;
        int n = 10;
        try {
            Datum[] datumArray = null;
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setInt(1, n);
            oracleCallableStatement.registerIndexTableOutParameter(2, n, 12, 255);
            oracleCallableStatement.execute();
            datumArray = oracleCallableStatement.getOraclePlsqlIndexTable(2);
            n = datumArray.length;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.guidCache[i] = datumArray[i].stringValue();
                }
            }
            this.guidCachePos -= n;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordReads(n, n);
            this.closeCursor((Statement)oracleCallableStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fetchGuid() {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = SELECT_GUID;
        byte[] byArray = null;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                byArray = resultSet.getBytes(1);
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordReads(1, 1);
            this.closeCursor(preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                this.closeCursor(preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, resultSet);
                throw throwable;
            }
        }
        return byArray;
    }

    String generateKey() {
        byte[] byArray = null;
        try {
            byArray = HashFuncs.getRandom();
        }
        catch (Exception exception) {
            log.warning(exception.toString());
        }
        if (byArray == null) {
            try {
                byArray = this.generator.getSecureRandom();
            }
            catch (Exception exception) {
                log.warning(exception.toString());
            }
        }
        if (byArray == null) {
            byArray = this.fetchGuid();
        }
        if (byArray == null) {
            byArray = HashFuncs.getTimeRandom();
        }
        return ByteArray.rawToHex(byArray);
    }

    public static OracleJsonDatabase create(OracleConnection oracleConnection) throws SQLException {
        return new JsonDatabaseImpl(oracleConnection, oracleConnection.getCurrentSchema());
    }

    @Override
    public Properties getCollectionStandardProperties() {
        return CollectionDescriptor.STANDARD_PROPERTIES;
    }

    @Override
    public Properties buildCollectionProperties(InputStream inputStream) throws JsonStoreException {
        return CollectionDescriptor.buildCollectionProperties(inputStream);
    }

    private Properties buildCollectionProperties(String string) throws JsonStoreException {
        return CollectionDescriptor.buildCollectionProperties(string);
    }

    private void callDropPLSQL(String string) throws JsonStoreException {
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.DROP_COLLECTION(P_URI_NAME => ?);\nend;";
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setNString(1, string);
            oracleCallableStatement.execute();
            log.info("Dropped collection " + string);
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordDDL();
            this.closeCursor((Statement)oracleCallableStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
    }

    private CollectionDescriptor callCreatePLSQL(String string, CollectionDescriptor collectionDescriptor) throws JsonStoreException {
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.CREATE_COLLECTION(\n                   P_URI_NAME    => ?,\n                   P_CREATE_MODE => ?,\n                   P_DESCRIPTOR  => ?,\n                   P_CREATE_TIME => ?);\nend;";
        String string3 = collectionDescriptor.getDescription();
        String string4 = "NEW";
        CollectionDescriptor collectionDescriptor2 = null;
        log.info("Creating collection:\n" + string3);
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setNString(1, string);
            oracleCallableStatement.setString(2, string4);
            oracleCallableStatement.setString(3, string3);
            oracleCallableStatement.registerOutParameter(3, 12, 4000);
            oracleCallableStatement.registerOutParameter(4, 12, 255);
            oracleCallableStatement.execute();
            log.info("Created collection " + string);
            String string5 = oracleCallableStatement.getString(4);
            string3 = oracleCallableStatement.getString(3);
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordDDL();
            if (string5 != null) {
                Properties properties = this.buildCollectionProperties(string3);
                collectionDescriptor2 = new CollectionDescriptor(string, properties);
            }
            this.closeCursor((Statement)oracleCallableStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        return collectionDescriptor2;
    }

    private CollectionDescriptor loadCollection(String string) throws JsonStoreException {
        if (!this.metadataTableExists) {
            return null;
        }
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.DESCRIBE_COLLECTION(\n                   P_URI_NAME   => ?,\n                   P_DESCRIPTOR => ?);\nend;";
        CollectionDescriptor collectionDescriptor = null;
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setNString(1, string);
            oracleCallableStatement.registerOutParameter(1, 12, 255);
            oracleCallableStatement.registerOutParameter(2, 12, 4000);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getNString(1);
            String string3 = oracleCallableStatement.getString(2);
            collectionDescriptor = this.cache.get(string);
            if (collectionDescriptor == null && string3 != null) {
                Properties properties = this.buildCollectionProperties(string3);
                collectionDescriptor = new CollectionDescriptor(string, properties);
                collectionDescriptor = this.cache.put(collectionDescriptor);
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordCall();
            this.closeCursor((Statement)oracleCallableStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        return collectionDescriptor;
    }

    private ArrayList<CollectionDescriptor> callListCollections(String string, int n, int n2) throws JsonStoreException {
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.LIST_COLLECTIONS(\n                   P_START_NAME => ?,\n                   P_RESULTS    => ?);\nend;";
        boolean bl = false;
        ArrayList<CollectionDescriptor> arrayList = new ArrayList<CollectionDescriptor>();
        try {
            int n3 = 0;
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            if (string == null) {
                oracleCallableStatement.setNull(1, 12);
            } else {
                oracleCallableStatement.setNString(1, string);
            }
            oracleCallableStatement.registerOutParameter(2, -10);
            oracleCallableStatement.execute();
            resultSet = oracleCallableStatement.getCursor(2);
            log.fine("Loaded collections");
            while (resultSet.next()) {
                String string3 = resultSet.getNString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                CollectionDescriptor collectionDescriptor = this.cache.get(string3);
                if (collectionDescriptor == null) {
                    Properties properties = this.buildCollectionProperties(string4);
                    collectionDescriptor = new CollectionDescriptor(string3, properties);
                    collectionDescriptor = this.cache.put(collectionDescriptor);
                }
                if (n3 >= n2 && !bl) {
                    arrayList.add(collectionDescriptor);
                }
                if (n <= 0 || ++n3 < n2 + n) continue;
                if (n3 > 1000) break;
                bl = true;
            }
            resultSet.close();
            resultSet = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordCall();
            this.closeCursor((Statement)oracleCallableStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, resultSet);
                throw throwable;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMaxLengths() {
        if (!this.metadataTableExists) {
            return;
        }
        OracleCallableStatement oracleCallableStatement = null;
        String string = "begin\n  DBMS_SODA_ADMIN.GET_PARAMETERS(\n                   P_KEY   => ?,\n                   P_VALUE => ?);\nend;";
        try {
            int n = 3;
            Datum[] datumArray = null;
            Datum[] datumArray2 = null;
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.registerIndexTableOutParameter(1, n, 12, 60);
            oracleCallableStatement.registerIndexTableOutParameter(2, n, 12, 60);
            oracleCallableStatement.execute();
            datumArray = oracleCallableStatement.getOraclePlsqlIndexTable(1);
            datumArray2 = oracleCallableStatement.getOraclePlsqlIndexTable(2);
            n = datumArray.length;
            if (n > datumArray2.length) {
                n = datumArray2.length;
            }
            for (int i = 0; i < n; ++i) {
                String string2 = datumArray[i].stringValue();
                String string3 = datumArray2[i].stringValue();
                try {
                    if (string2.equalsIgnoreCase("VARCHAR2_MAX")) {
                        this.varcharMaxLength = Integer.parseInt(string3);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("NVARCHAR2_MAX")) {
                        this.nvarcharMaxLength = Integer.parseInt(string3);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("RAW_MAX")) continue;
                    this.rawMaxLength = Integer.parseInt(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    log.warning(numberFormatException.toString());
                }
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordCall();
            this.closeCursor((Statement)oracleCallableStatement, null);
        }
        catch (SQLException sQLException) {
            log.severe(sQLException.toString());
        }
        finally {
            this.closeCursor((Statement)oracleCallableStatement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableQBE() {
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            oraclePreparedStatement = (OraclePreparedStatement)this.conn.prepareStatement(ENABLE_QBE);
            oraclePreparedStatement.execute();
            oraclePreparedStatement.close();
            oraclePreparedStatement = null;
            log.fine("QBE switched on");
        }
        catch (SQLException sQLException) {
            log.severe(sQLException.toString());
        }
        finally {
            this.closeCursor((Statement)oraclePreparedStatement, null);
        }
    }

    public void setAutoCreate() {
        this.enableAutoCreate = true;
    }
}

