/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import oracle.json.api.JsonDocument;
import oracle.json.common.Configuration;
import oracle.json.util.ByteArray;
import oracle.json.util.LimitedInputStream;

class JsonDocumentImpl
implements JsonDocument {
    private static final String UNKNOWN_KEY = "";
    private static final int UNKNOWN_LENGTH = -1;
    private static final Logger log = Logger.getLogger(JsonDocumentImpl.class.getName());
    private final String docid;
    private final String tstamp;
    private final String version;
    private byte[] payload = null;
    private InputStream payloadStream = null;
    private String ctype = "application/json";
    private String creationTime = null;
    private int len = -1;
    private long offset = 0L;
    private long totalSize = -1L;

    JsonDocumentImpl(String string, String string2, String string3, byte[] byArray, String string4) {
        this.docid = string;
        this.version = string2;
        this.tstamp = string3;
        this.payload = byArray;
        if (string4 != null) {
            this.ctype = string4;
        }
        if (byArray != null) {
            this.len = byArray.length;
        }
    }

    JsonDocumentImpl(String string, String string2, String string3, InputStream inputStream, String string4) {
        this.docid = string;
        this.version = string2;
        this.tstamp = string3;
        this.payloadStream = inputStream;
        if (string4 != null) {
            this.ctype = string4;
        }
        if (inputStream != null && (inputStream instanceof LimitedInputStream || inputStream instanceof ByteArrayInputStream)) {
            try {
                this.len = inputStream.available();
            }
            catch (IOException iOException) {
                this.len = -1;
            }
        }
    }

    JsonDocumentImpl(String string, String string2, String string3, byte[] byArray) {
        this(string, string2, string3, byArray, null);
    }

    JsonDocumentImpl(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string3, string4 == null ? (byte[])null : string4.getBytes(Configuration.DEFAULT_CHARSET), string5);
    }

    public JsonDocumentImpl(String string, String string2, String string3) {
        this(string, string2, string3, (byte[])null, null);
    }

    public JsonDocumentImpl(String string, String string2) {
        this(string, null, null, string2 == null ? (byte[])null : string2.getBytes(Configuration.DEFAULT_CHARSET), null);
    }

    public JsonDocumentImpl(String string, byte[] byArray) {
        this(string, null, null, byArray, null);
    }

    public JsonDocumentImpl(String string, InputStream inputStream) {
        this(string, inputStream, null);
    }

    public JsonDocumentImpl(String string, InputStream inputStream, String string2) {
        this(string, null, null, inputStream, string2);
    }

    public JsonDocumentImpl(byte[] byArray) {
        this(UNKNOWN_KEY, null, null, byArray, null);
    }

    @Override
    public String getKey() {
        return this.docid;
    }

    @Override
    public String getLastModified() {
        return this.tstamp;
    }

    @Override
    public String getCreatedOn() {
        return this.creationTime;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public byte[] getContent() {
        if (this.payloadStream != null) {
            try {
                this.payload = ByteArray.loadStream(this.payloadStream).toArray();
            }
            catch (IOException iOException) {
                log.severe(iOException.toString());
            }
            this.payloadStream = null;
        }
        return this.payload;
    }

    @Override
    public InputStream getContentStream() {
        if (this.payloadStream != null) {
            return this.payloadStream;
        }
        return this.payload == null ? null : new ByteArrayInputStream(this.payload);
    }

    boolean hasStreamContent() {
        return this.payloadStream != null;
    }

    @Override
    public String getContentType() {
        return this.ctype;
    }

    @Override
    public int getContentLength() {
        return this.len;
    }

    void setContentType(String string) {
        this.ctype = string;
    }

    void setContentLength(int n) {
        this.len = n;
    }

    void setFragmentInfo(long l, long l2) {
        this.offset = l;
        this.totalSize = l2;
    }

    @Override
    public long getFragmentOffset() {
        return this.offset;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    void setCreatedOn(String string) {
        this.creationTime = string;
    }

    @Override
    public void close() throws IOException {
        if (this.payloadStream != null) {
            this.payloadStream.close();
            this.payloadStream = null;
        }
    }

    public String toString() {
        return this.docid;
    }
}

