/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.jdbc.OracleCallableStatement;
import oracle.json.api.JsonCursor;
import oracle.json.api.JsonDocument;
import oracle.json.api.JsonStoreException;
import oracle.json.common.Configuration;
import oracle.json.common.LobInputStream;
import oracle.json.parser.JsonPath;
import oracle.json.rdbms.CollectionDescriptor;
import oracle.json.rdbms.CollectionsMessage;
import oracle.json.rdbms.JsonCollectionImpl;
import oracle.json.rdbms.JsonCursorImpl;
import oracle.json.rdbms.JsonDatabaseImpl;
import oracle.json.rdbms.JsonDocumentImpl;

class PlsqlCollectionImpl
extends JsonCollectionImpl {
    PlsqlCollectionImpl(JsonDatabaseImpl jsonDatabaseImpl, String string) {
        super(jsonDatabaseImpl, string);
    }

    PlsqlCollectionImpl(JsonDatabaseImpl jsonDatabaseImpl, String string, CollectionDescriptor collectionDescriptor) {
        super(jsonDatabaseImpl, string, collectionDescriptor);
    }

    private void appendPackage(StringBuilder stringBuilder) {
        stringBuilder.append("\"");
        if (this.options.dbSchema != null) {
            stringBuilder.append(this.options.dbSchema);
            stringBuilder.append("\".\"");
        }
        stringBuilder.append(this.options.dbObjectName);
        stringBuilder.append("\".");
    }

    private String buildGet() {
        this.sb.setLength(0);
        this.sb.append("begin\n  ");
        this.appendPackage(this.sb);
        this.sb.append("GET_DOC(ID=>?,LAST_MODIFIED=>?,VERSION=>?,JCONTENT=>?);\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private String buildFind(boolean bl) {
        this.sb.setLength(0);
        this.sb.append("begin\n  ");
        this.appendPackage(this.sb);
        if (bl) {
            this.sb.append("LIST_KEYS");
        } else {
            this.sb.append("LIST_DOCS");
        }
        this.sb.append("(MAX_ROWS=>?,START_ROW=>?,RESULTS=>?);\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private String buildInsert() {
        this.sb.setLength(0);
        this.sb.append("begin\n  ");
        this.appendPackage(this.sb);
        this.sb.append("INSERT_DOC(ID=>?,LAST_MODIFIED=>?,VERSION=>?,JCONTENT=>?);\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private String buildReplace() {
        this.sb.setLength(0);
        this.sb.append("begin\n  ");
        this.appendPackage(this.sb);
        this.sb.append("REPLACE_DOC(ID=>?,LAST_MODIFIED=>?,VERSION=>?,JCONTENT=>?);\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private String buildCount() {
        this.sb.setLength(0);
        this.sb.append("begin\n  ");
        this.appendPackage(this.sb);
        this.sb.append("COUNT_DOCS(NUM=>?);\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private String buildDelete() {
        this.sb.setLength(0);
        this.sb.append("begin\n  ");
        this.appendPackage(this.sb);
        this.sb.append("DELETE_DOC(ID=>?,VERSION=>?);\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private String buildDeleteSet() {
        this.sb.setLength(0);
        this.sb.append("begin\n  ");
        this.appendPackage(this.sb);
        this.sb.append("DELETE_SET(ID_LIST=>?,NUM=>?);\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private String buildGetSet() {
        this.sb.setLength(0);
        this.sb.append("begin\n  ");
        this.appendPackage(this.sb);
        this.sb.append("GET_DOCS(ID_LIST=>?,NUM=>?,RESULTS=>?);\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    @Override
    public long count() throws JsonStoreException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = this.buildCount();
        long l = 0L;
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.execute();
            l = oracleCallableStatement.getNUMBER(3).longValue();
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, null);
        return l;
    }

    @Override
    public JsonDocument insert(JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("insert");
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = this.buildInsert();
        boolean bl = false;
        boolean bl2 = false;
        switch (this.options.keyAssignmentMethod) {
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                string = this.db.generateKey();
                if (this.options.keyDataType == 3) {
                    string = this.uidToDecimal(string);
                }
                bl = true;
                break;
            }
            default: {
                string = jsonDocument.getKey();
                bl = true;
            }
        }
        byte[] byArray = jsonDocument.getContent();
        JsonDocumentImpl jsonDocumentImpl = null;
        try {
            switch (this.options.versioningMethod) {
                case 2: {
                    break;
                }
                case 1: {
                    string2 = Long.toString(this.db.getDatabaseTime());
                    bl2 = true;
                    break;
                }
                case 3: {
                    string2 = this.db.generateKey();
                    bl2 = true;
                    break;
                }
                default: {
                    string2 = this.computeVersion(byArray);
                    bl2 = true;
                }
            }
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string4);
            if (bl && string != null) {
                oracleCallableStatement.setString(1, string);
            } else {
                oracleCallableStatement.setNull(1, 12);
            }
            oracleCallableStatement.setNull(2, 12);
            if (bl2 && string2 != null) {
                oracleCallableStatement.setString(3, string2);
            } else {
                oracleCallableStatement.setNull(3, 12);
            }
            Blob blob = null;
            Clob clob = null;
            NClob nClob = null;
            switch (this.options.contentDataType) {
                case 5: {
                    if (byArray == null) {
                        oracleCallableStatement.setNull(4, 2005);
                        break;
                    }
                    clob = this.conn.createClob();
                    clob.setString(1L, this.stringFromBytes(byArray));
                    oracleCallableStatement.setClob(4, clob);
                    break;
                }
                case 1: {
                    String string5 = this.stringFromBytes(byArray);
                    oracleCallableStatement.setString(4, string5);
                    break;
                }
                case 6: {
                    if (byArray == null) {
                        oracleCallableStatement.setNull(4, 2011);
                        break;
                    }
                    nClob = this.conn.createNClob();
                    nClob.setString(1L, this.stringFromBytes(byArray));
                    oracleCallableStatement.setNClob(4, nClob);
                    break;
                }
                case 3: {
                    String string6 = this.stringFromBytes(byArray);
                    oracleCallableStatement.setNString(4, string6);
                    break;
                }
                case 4: {
                    if (byArray == null) {
                        oracleCallableStatement.setNull(4, 2004);
                        break;
                    }
                    blob = this.conn.createBlob();
                    blob.setBytes(1L, byArray);
                    oracleCallableStatement.setBlob(4, blob);
                    break;
                }
                case 2: {
                    if (byArray != null) {
                        oracleCallableStatement.setBytes(4, byArray);
                        break;
                    }
                    oracleCallableStatement.setNull(4, -3);
                }
            }
            oracleCallableStatement.registerOutParameter(1, 12);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            if (blob != null) {
                blob.free();
            }
            if (clob != null) {
                clob.free();
            }
            if (nClob != null) {
                nClob.free();
            }
            string = oracleCallableStatement.getString(1);
            string3 = oracleCallableStatement.getString(2);
            string2 = oracleCallableStatement.getString(3);
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            jsonDocumentImpl = new JsonDocumentImpl(string, string2, string3);
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, null);
        return jsonDocumentImpl;
    }

    @Override
    public List<JsonDocument> insert(Iterator<JsonDocument> iterator) throws JsonStoreException {
        this.writeCheck("insert");
        ArrayList<JsonDocument> arrayList = new ArrayList<JsonDocument>();
        while (iterator.hasNext()) {
            arrayList.add(this.insert(iterator.next()));
        }
        return arrayList;
    }

    @Override
    public JsonDocument replace(String string, JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("replace");
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = null;
        String string3 = null;
        String string4 = this.buildReplace();
        boolean bl = false;
        byte[] byArray = jsonDocument.getContent();
        JsonDocumentImpl jsonDocumentImpl = null;
        try {
            switch (this.options.versioningMethod) {
                case 2: {
                    break;
                }
                case 1: {
                    string2 = Long.toString(this.db.getDatabaseTime());
                    bl = true;
                    break;
                }
                case 3: {
                    string2 = this.db.generateKey();
                    bl = true;
                    break;
                }
                default: {
                    string2 = this.computeVersion(byArray);
                    bl = true;
                }
            }
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string4);
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.setNull(2, 12);
            if (bl && string2 != null) {
                oracleCallableStatement.setString(3, string2);
            } else {
                oracleCallableStatement.setNull(3, 12);
            }
            Blob blob = null;
            Clob clob = null;
            NClob nClob = null;
            switch (this.options.contentDataType) {
                case 5: {
                    if (byArray == null) {
                        oracleCallableStatement.setNull(4, 2005);
                        break;
                    }
                    clob = this.conn.createClob();
                    clob.setString(1L, this.stringFromBytes(byArray));
                    oracleCallableStatement.setClob(4, clob);
                    break;
                }
                case 1: {
                    String string5 = this.stringFromBytes(byArray);
                    oracleCallableStatement.setString(4, string5);
                    break;
                }
                case 6: {
                    if (byArray == null) {
                        oracleCallableStatement.setNull(4, 2011);
                        break;
                    }
                    nClob = this.conn.createNClob();
                    nClob.setString(1L, this.stringFromBytes(byArray));
                    oracleCallableStatement.setNClob(4, nClob);
                    break;
                }
                case 3: {
                    String string6 = this.stringFromBytes(byArray);
                    oracleCallableStatement.setNString(4, string6);
                    break;
                }
                case 4: {
                    if (byArray == null) {
                        oracleCallableStatement.setNull(4, 2004);
                        break;
                    }
                    blob = this.conn.createBlob();
                    blob.setBytes(1L, byArray);
                    oracleCallableStatement.setBlob(4, blob);
                    break;
                }
                case 2: {
                    if (byArray != null) {
                        oracleCallableStatement.setBytes(4, byArray);
                        break;
                    }
                    oracleCallableStatement.setNull(4, -3);
                }
            }
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            if (blob != null) {
                blob.free();
            }
            if (clob != null) {
                clob.free();
            }
            if (nClob != null) {
                nClob.free();
            }
            string3 = oracleCallableStatement.getString(2);
            string2 = oracleCallableStatement.getString(3);
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            jsonDocumentImpl = new JsonDocumentImpl(string, string2, string3);
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, null);
        return jsonDocumentImpl;
    }

    @Override
    public boolean update(String string, JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("update");
        throw this.makeException(CollectionsMessage.EX_UPDATES_NOT_SUPP, this.options.uriName);
    }

    @Override
    public boolean update(Set<String> set, JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("update");
        throw this.makeException(CollectionsMessage.EX_UPDATES_NOT_SUPP, this.options.uriName);
    }

    @Override
    public boolean update(JsonDocument jsonDocument, JsonDocument jsonDocument2) throws JsonStoreException {
        this.writeCheck("update");
        throw this.makeException(CollectionsMessage.EX_FEATURE_NOT_SUPP, this.options.uriName);
    }

    @Override
    public boolean remove(String string) throws JsonStoreException {
        this.writeCheck("delete");
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = this.buildDelete();
        boolean bl = false;
        string = this.canonicalKey(string);
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.execute();
            String string3 = oracleCallableStatement.getString(2);
            if (!oracleCallableStatement.wasNull() && string3 != null && string3.length() > 0) {
                bl = true;
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, null);
        return bl;
    }

    @Override
    public int remove(Set<String> set) throws JsonStoreException {
        int n = 0;
        if (set == null) {
            return n;
        }
        int n2 = set.size();
        if (n2 == 0) {
            return n;
        }
        this.writeCheck("delete");
        OracleCallableStatement oracleCallableStatement = null;
        String string = this.buildDeleteSet();
        int n3 = n2;
        n3 += 15;
        String[] stringArray = new String[n3 &= 0xFFFFFFF0];
        int n4 = 0;
        for (String string2 : set) {
            stringArray[n4++] = this.canonicalKey(string2);
        }
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setPlsqlIndexTable(1, (Object)stringArray, n3, n2, 12, 255);
            oracleCallableStatement.setInt(2, n2);
            oracleCallableStatement.execute();
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            n = n2;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, null);
        return n;
    }

    @Override
    public int remove(JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("delete");
        throw this.makeException(CollectionsMessage.EX_FILTERS_NOT_SUPP, this.options.uriName);
    }

    @Override
    JsonCursor openCursor(boolean bl, int n, long l) throws JsonStoreException {
        JsonCursorImpl jsonCursorImpl = null;
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        String string = this.buildFind(bl);
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            if (n <= 0) {
                n = JsonDatabaseImpl.UNLIMITED;
            }
            if (l <= 0L) {
                l = 1L;
            }
            oracleCallableStatement.setInt(1, n);
            oracleCallableStatement.setLong(2, l);
            oracleCallableStatement.registerOutParameter(3, -10);
            oracleCallableStatement.execute();
            resultSet = oracleCallableStatement.getCursor(3);
            jsonCursorImpl = new JsonCursorImpl(this.options, this.metrics, bl, (Statement)oracleCallableStatement, resultSet);
            if (this.internalDriver) {
                // empty if block
            }
            oracleCallableStatement = null;
            resultSet = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, resultSet);
        return jsonCursorImpl;
    }

    @Override
    public JsonCursor find(String string, boolean bl) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_NOT_IMPLEMENTED, this.options.uriName, "key range");
    }

    @Override
    public JsonCursor find(String string, String string2) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_NOT_IMPLEMENTED, this.options.uriName, "time range");
    }

    @Override
    public JsonCursor find(JsonDocument jsonDocument, JsonDocument jsonDocument2) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_PROJ_NOT_SUPP, this.options.uriName);
    }

    @Override
    public JsonCursor findKeys(JsonDocument jsonDocument) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_FILTERS_NOT_SUPP, this.options.uriName);
    }

    @Override
    public List<JsonDocument> findSet(Set<String> set) throws JsonStoreException {
        if (set == null) {
            return EMPTY_LIST;
        }
        int n = set.size();
        if (n == 0) {
            return EMPTY_LIST;
        }
        ArrayList<JsonDocument> arrayList = new ArrayList<JsonDocument>(n);
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        String string = this.buildGetSet();
        int n2 = n;
        n2 += 15;
        String[] stringArray = new String[n2 &= 0xFFFFFFF0];
        int n3 = 0;
        for (String string2 : set) {
            stringArray[n3++] = this.canonicalKey(string2);
        }
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setPlsqlIndexTable(1, (Object)stringArray, n2, n, 12, 255);
            oracleCallableStatement.setInt(2, n);
            oracleCallableStatement.registerOutParameter(3, -10);
            oracleCallableStatement.execute();
            this.metrics.recordCall();
            this.metrics.startTiming();
            resultSet = oracleCallableStatement.getCursor(3);
            int n4 = 0;
            while (resultSet.next()) {
                int n5 = 0;
                String string3 = resultSet.getString(++n5);
                String string4 = null;
                byte[] byArray = null;
                String string5 = null;
                String string6 = null;
                byArray = this.readPayloadColumn(resultSet, ++n5);
                if (this.options.timestampColumnName != null) {
                    string5 = resultSet.getString(++n5);
                }
                if (this.options.versionColumnName != null) {
                    string6 = resultSet.getString(++n5);
                }
                JsonDocumentImpl jsonDocumentImpl = new JsonDocumentImpl(string3, string6, string5, byArray);
                if (string4 != null) {
                    jsonDocumentImpl.setContentType(string4);
                }
                arrayList.add(jsonDocumentImpl);
                ++n4;
            }
            this.metrics.recordReads(n4, 16);
            resultSet.close();
            resultSet = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, resultSet);
        return arrayList;
    }

    @Override
    public JsonDocument findOne(String string, long l, int n) throws JsonStoreException {
        OracleCallableStatement oracleCallableStatement = null;
        Blob blob = null;
        String string2 = this.buildGet();
        string = this.canonicalKey(string);
        byte[] byArray = EMPTY_DATA;
        JsonDocument jsonDocument = null;
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            switch (this.options.contentDataType) {
                case 5: {
                    oracleCallableStatement.registerOutParameter(4, 2005);
                    break;
                }
                case 1: {
                    oracleCallableStatement.registerOutParameter(4, 1);
                    break;
                }
                case 6: {
                    oracleCallableStatement.registerOutParameter(4, 2011);
                    break;
                }
                case 3: {
                    oracleCallableStatement.registerOutParameter(4, -15);
                    break;
                }
                case 2: 
                case 4: {
                    oracleCallableStatement.registerOutParameter(4, 2004);
                }
            }
            oracleCallableStatement.execute();
            LobInputStream lobInputStream = null;
            String string3 = oracleCallableStatement.getString(2);
            String string4 = oracleCallableStatement.getString(3);
            String string5 = null;
            String string6 = "";
            switch (this.options.contentDataType) {
                case 5: {
                    if (this.internalDriver) {
                        // empty if block
                    }
                }
                case 1: {
                    string6 = oracleCallableStatement.getString(4);
                    if (string6 == null) break;
                    byArray = string6.getBytes(Configuration.DEFAULT_CHARSET);
                    break;
                }
                case 6: {
                    if (this.internalDriver) {
                        // empty if block
                    }
                }
                case 3: {
                    string6 = oracleCallableStatement.getNString(4);
                    if (string6 == null) break;
                    byArray = string6.getBytes(Configuration.DEFAULT_CHARSET);
                    break;
                }
                case 4: {
                    blob = oracleCallableStatement.getBlob(4);
                    break;
                }
                case 2: {
                    byArray = oracleCallableStatement.getBytes(4);
                }
            }
            if (blob != null) {
                long l2 = blob.length();
                InputStream inputStream = blob.getBinaryStream();
                if (inputStream != null) {
                    lobInputStream = new LobInputStream(blob, inputStream, (int)l2);
                    lobInputStream.setMetrics(this.metrics);
                }
                jsonDocument = new JsonDocumentImpl(string, string4, string3, lobInputStream, string5);
            } else {
                jsonDocument = new JsonDocumentImpl(string, string4, string3, byArray);
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                try {
                    if (jsonDocument != null) {
                        jsonDocument.close();
                    }
                }
                catch (IOException iOException) {
                    log.severe(iOException.toString());
                }
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, null);
        return jsonDocument;
    }

    @Override
    public JsonDocument findHeader(String string) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_NOT_IMPLEMENTED, new Object[0]);
    }

    @Override
    public JsonDocument findVersion(String string, String string2) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_NOT_IMPLEMENTED, new Object[0]);
    }

    @Override
    public JsonDocument findLastModified(String string, String string2) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_NOT_IMPLEMENTED, new Object[0]);
    }

    @Override
    public JsonDocument findOne(String string, JsonDocument jsonDocument) throws JsonStoreException {
        return this.findOne(string);
    }

    @Override
    public JsonDocument findFirst(JsonDocument jsonDocument) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_FILTERS_NOT_SUPP, this.options.uriName);
    }

    @Override
    public JsonDocument findFirst(JsonDocument jsonDocument, JsonDocument jsonDocument2) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_FILTERS_NOT_SUPP, this.options.uriName);
    }

    @Override
    public void createIndex(String string, boolean bl, JsonPath[] jsonPathArray) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_INDEX_NOT_ALLOWED, this.options.uriName);
    }

    @Override
    public void dropIndex(String string) throws JsonStoreException {
        throw this.makeException(CollectionsMessage.EX_INDEX_NOT_ALLOWED, this.options.uriName);
    }
}

