/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.json.JsonException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.json.api.JsonCursor;
import oracle.json.api.JsonDocument;
import oracle.json.api.JsonStoreException;
import oracle.json.common.LobInputStream;
import oracle.json.parser.AndORTree;
import oracle.json.parser.IndexColumn;
import oracle.json.parser.JsonPath;
import oracle.json.parser.Predicate;
import oracle.json.parser.ProjectionSpec;
import oracle.json.parser.QueryException;
import oracle.json.parser.ValueTypePair;
import oracle.json.rdbms.CollectionDescriptor;
import oracle.json.rdbms.CollectionsMessage;
import oracle.json.rdbms.JsonCollectionImpl;
import oracle.json.rdbms.JsonCursorImpl;
import oracle.json.rdbms.JsonDatabaseImpl;
import oracle.json.rdbms.JsonDocumentImpl;
import oracle.json.util.ByteArray;
import oracle.json.util.ComponentTime;
import oracle.json.util.JsonByteArray;
import oracle.json.util.LimitedInputStream;
import oracle.sql.Datum;

public class TableCollectionImpl
extends JsonCollectionImpl {
    private static final String JSON_CONTENT = "application/json";
    private static final int MAX_RANGE_TRANSFER = 0x100000;
    private static final int MIN_RANGE_TRANSFER = 4096;
    private static final boolean JDBC_WORKAROUND = true;
    private static final boolean CTX_122_FEATURES = false;
    private ProjectionSpec proj = null;
    private String tableAlias = null;
    private static final int SEQUENCE_BATCH_SIZE = 10;
    private final long[] seqCache = new long[10];
    private int seqCachePos = 10;
    private boolean save_qbe = false;

    TableCollectionImpl(JsonDatabaseImpl jsonDatabaseImpl, String string) {
        super(jsonDatabaseImpl, string);
    }

    TableCollectionImpl(JsonDatabaseImpl jsonDatabaseImpl, String string, CollectionDescriptor collectionDescriptor) {
        super(jsonDatabaseImpl, string, collectionDescriptor);
    }

    private void appendTable(StringBuilder stringBuilder) {
        stringBuilder.append("\"");
        if (this.options.dbSchema != null) {
            stringBuilder.append(this.options.dbSchema);
            stringBuilder.append("\".\"");
        }
        stringBuilder.append(this.options.dbObjectName);
        stringBuilder.append("\"");
    }

    private void buildSelect(boolean bl) {
        int n;
        int n2;
        this.sb.setLength(0);
        this.sb.append("select ");
        if (this.proj != null) {
            this.tableAlias = "TAB_";
        }
        switch (this.options.keyDataType) {
            case 3: {
                this.sb.append("to_char(\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\") ");
                break;
            }
            case 4: {
                this.sb.append("rawtohex(\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\")");
                break;
            }
            case 1: 
            case 2: {
                this.sb.append("\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\"");
            }
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\"");
        }
        if (this.proj != null) {
            n2 = this.proj.numColumns();
            for (n = 1; n <= n2; ++n) {
                this.sb.append(",JT_.C#");
                this.sb.append(Integer.toString(n));
            }
        } else if (!bl) {
            this.sb.append(",\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\"");
        }
        if (this.options.timestampColumnName != null) {
            this.sb.append(",to_char(\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\",'YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"')");
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",to_char(\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append("\",'YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"')");
        }
        if (this.options.versionColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        this.sb.append(" from ");
        this.appendTable(this.sb);
        if (this.proj != null) {
            this.sb.append(" ");
            this.sb.append(this.tableAlias);
            this.sb.append(", JSON_TABLE(");
            this.sb.append(this.tableAlias);
            this.sb.append(".\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\"");
            this.addFormat();
            this.sb.append(", '$' null on error columns ");
            n2 = this.proj.numColumns();
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    this.sb.append(", ");
                }
                this.sb.append("\"C#");
                this.sb.append(Integer.toString(n + 1));
                this.sb.append("\" path '");
                this.sb.append(this.proj.getColumnPath(n));
                this.sb.append("'");
            }
            this.sb.append(") JT_");
        }
    }

    private String buildQuery(boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, int n, int n2, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.buildSelect(bl);
        if (bl2) {
            this.addWhereKey(this.sb, bl6, bl9);
            if (bl3) {
                this.sb.append(" and \"");
                this.sb.append(this.options.versionColumnName);
                this.sb.append("\" = ");
                switch (this.options.versioningMethod) {
                    case 1: 
                    case 2: {
                        this.sb.append("to_number(?)");
                        break;
                    }
                    default: {
                        this.sb.append("?");
                        break;
                    }
                }
            } else if (bl4) {
                this.sb.append(" and \"");
                this.sb.append(this.options.timestampColumnName);
                this.sb.append("\" <= to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
            }
        } else if (n2 > 0) {
            this.sb.append(" where \"");
            this.sb.append(this.options.keyColumnName);
            this.sb.append("\" in (");
            int n3 = 0;
            while (n3 < n2) {
                if (++n3 == n2) {
                    this.sb.append("?)");
                    continue;
                }
                this.sb.append("?,");
            }
        } else if (bl7 || bl8) {
            this.sb.append(" where \"");
            this.sb.append(this.options.timestampColumnName);
            if (bl7) {
                this.sb.append("\" > to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
            }
            if (bl8) {
                if (bl7) {
                    this.sb.append(" and \"");
                    this.sb.append(this.options.timestampColumnName);
                }
                this.sb.append("\" <= to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
            }
        }
        if (!bl5) {
            this.sb.append(" order by \"");
            if (bl7 || bl8) {
                this.sb.append(this.options.timestampColumnName);
                this.sb.append("\",\"");
            }
            this.sb.append(this.options.keyColumnName);
            this.sb.append("\"");
            if (bl9) {
                this.sb.append(" desc");
            }
            if (l > 0L) {
                this.sb.append(" offset " + Long.toString(l) + " rows");
            }
            if (n > 0) {
                this.sb.append(" fetch next " + Integer.toString(n) + " rows only");
            }
        }
        return this.sb.toString();
    }

    private void addFormat() {
        if (this.options.contentDataType == 4 || this.options.contentDataType == 2) {
            this.sb.append(" format json");
        }
    }

    private void buildQBEWhereClause(AndORTree andORTree) {
        this.sb.append("JSON_EXISTS(\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        this.addFormat();
        this.sb.append(",");
        andORTree.appendJsonExists(this.sb);
        this.sb.append(")");
    }

    public void generateOrderByClause(AndORTree andORTree, StringBuilder stringBuilder) {
        ArrayList<Predicate> arrayList = andORTree.getOrderByArray();
        Predicate predicate = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            predicate = arrayList.get(i);
            if (i == 0) {
                stringBuilder.append(" order by");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(" JSON_VALUE(");
            stringBuilder.append("\"");
            stringBuilder.append(this.options.contentColumnName);
            stringBuilder.append("\"");
            this.addFormat();
            stringBuilder.append(", ");
            stringBuilder.append("'$." + predicate.getPath().toString());
            stringBuilder.append("')");
            if (predicate.getValue().equals("1")) {
                stringBuilder.append(" asc");
                continue;
            }
            stringBuilder.append(" desc");
        }
    }

    private void generatePredKeyClause(AndORTree andORTree) {
        if (andORTree.hasJsonExists()) {
            this.sb.append(" where \n");
            this.buildQBEWhereClause(andORTree);
        }
        if (andORTree.hasKeys()) {
            if (andORTree.hasJsonExists()) {
                this.sb.append(" and \n");
            } else {
                this.sb.append(" where \n");
            }
            this.sb.append("\"");
            this.sb.append(this.options.keyColumnName);
            this.sb.append("\"");
            this.sb.append(" in ");
            this.sb.append(this.generateKeysClause(andORTree).toString());
        }
    }

    private StringBuilder generateKeysClause(AndORTree andORTree) {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> hashSet = andORTree.getKeys();
        if (hashSet == null) {
            return stringBuilder;
        }
        int n = hashSet.size();
        if (n == 0) {
            return stringBuilder;
        }
        stringBuilder.append("(?");
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(",?");
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    private String buildQBEQuery(AndORTree andORTree, boolean bl) throws QueryException {
        this.buildSelect(bl);
        this.generatePredKeyClause(andORTree);
        if (andORTree.hasOrderBy()) {
            this.generateOrderByClause(andORTree, this.sb);
        }
        return this.sb.toString();
    }

    private String buildInsert(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.options.timestampColumnName != null || this.options.creationColumnName != null;
        this.sb.setLength(0);
        this.sb.append("insert into ");
        this.appendTable(this.sb);
        this.sb.append(" (\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\",\"");
        if (this.options.doctypeColumnName != null) {
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\",\"");
        }
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\"");
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append("\"");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        this.sb.append(") values (");
        if (this.options.keySequenceName != null && !bl) {
            bl2 = true;
            switch (this.options.keyDataType) {
                case 3: {
                    this.sb.append("\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL");
                    break;
                }
                case 4: {
                    this.sb.append("hextoraw(substr(to_char(\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL,'0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'),3))");
                    break;
                }
                default: {
                    this.sb.append("to_char(\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL)");
                    break;
                }
            }
        } else if (this.options.keyAssignmentMethod == 3 && !bl) {
            bl2 = true;
            switch (this.options.keyDataType) {
                case 3: {
                    this.sb.append("to_number(");
                    this.sb.append("rawtohex(SYS_GUID()),");
                    this.sb.append("'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX')");
                    break;
                }
                case 4: {
                    this.sb.append("SYS_GUID()");
                    break;
                }
                default: {
                    this.sb.append("rawtohex(SYS_GUID())");
                    break;
                }
            }
        } else {
            bl2 = false;
            switch (this.options.keyDataType) {
                case 3: {
                    this.sb.append("to_number(?)");
                    break;
                }
                default: {
                    this.sb.append("?");
                }
            }
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",?");
        }
        this.sb.append(",?");
        bl3 = bl2;
        if (this.options.timestampColumnName != null) {
            if (bl) {
                this.sb.append(",to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
            } else {
                this.sb.append(",sys_extract_utc(SYSTIMESTAMP)");
                bl3 = true;
            }
        }
        if (this.options.creationColumnName != null) {
            if (bl) {
                this.sb.append(",to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
            } else {
                this.sb.append(",sys_extract_utc(SYSTIMESTAMP)");
                bl3 = true;
            }
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",?");
        }
        this.sb.append(")");
        if (bl3) {
            this.sb.append(" returning ");
            if (bl2) {
                this.sb.append("\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\"");
            }
            if (bl4) {
                if (bl2) {
                    this.sb.append(", ");
                }
                this.sb.append("to_char(\"");
                if (this.options.timestampColumnName != null) {
                    this.sb.append(this.options.timestampColumnName);
                } else {
                    this.sb.append(this.options.creationColumnName);
                }
                this.sb.append("\",'YYYY-MM-DD\"T\"HH24.MI.SS.FF\"Z\"')");
            }
            if (bl2 && bl4) {
                this.sb.append(" into ?,?");
            } else {
                this.sb.append(" into ?");
            }
        }
        return this.sb.toString();
    }

    private void addWhereKey(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        stringBuilder.append(" where \"");
        stringBuilder.append(this.options.keyColumnName);
        if (!bl) {
            stringBuilder.append("\" = ");
        } else if (!bl2) {
            stringBuilder.append("\" > ");
        } else {
            stringBuilder.append("\" < ");
        }
        switch (this.options.keyDataType) {
            case 3: {
                stringBuilder.append("to_number(?)");
                break;
            }
            case 4: {
                stringBuilder.append("?");
                break;
            }
            default: {
                stringBuilder.append("?");
            }
        }
    }

    private String buildUpdate(boolean bl) {
        this.sb.setLength(0);
        this.sb.append("update ");
        this.appendTable(this.sb);
        this.sb.append(" set \"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\" = ?");
        if (this.options.timestampColumnName != null) {
            this.sb.append(", \"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\" = sys_extract_utc(SYSTIMESTAMP)");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(", \"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\" = ");
            if (this.options.versioningMethod == 2) {
                this.sb.append("(\"");
                this.sb.append(this.options.versionColumnName);
                this.sb.append("\" + 1)");
            } else {
                this.sb.append("?");
            }
        }
        this.addWhereKey(this.sb, false, false);
        if (bl) {
            this.sb.append(" and \"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\" = ?");
        }
        return this.sb.toString();
    }

    private String buildUpsert() {
        this.sb.setLength(0);
        this.sb.append("merge into ");
        this.appendTable(this.sb);
        this.sb.append(" JSON$TARGET using (select ");
        this.sb.append(" ? \"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\" from SYS.DUAL) JSON$SOURCE");
        this.sb.append(" on (JSON$TARGET.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\" = JSON$SOURCE.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\")");
        this.sb.append(" when matched then update set JSON$TARGET.\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\" = ?");
        if (this.options.timestampColumnName != null) {
            this.sb.append(", JSON$TARGET.\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\" = to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(", JSON$TARGET.\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\" = ");
            if (this.options.versioningMethod == 2) {
                this.sb.append("(JSON$TARGET.\"");
                this.sb.append(this.options.versionColumnName);
                this.sb.append("\" + 1)");
            } else {
                this.sb.append("?");
            }
        }
        this.sb.append("when not matched then insert (JSON$TARGET.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\",JSON$TARGET.\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\"");
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append("\"");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\"");
        }
        this.sb.append(") values (?,?");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",?");
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",?");
        }
        this.sb.append(")");
        return this.sb.toString();
    }

    private String buildCount() {
        this.sb.setLength(0);
        this.sb.append("select count(\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\") from ");
        this.appendTable(this.sb);
        return this.sb.toString();
    }

    private String buildDelete(boolean bl, AndORTree andORTree) throws QueryException {
        this.sb.setLength(0);
        this.sb.append("delete from ");
        this.appendTable(this.sb);
        if (bl) {
            this.addWhereKey(this.sb, false, false);
        } else if (andORTree != null) {
            this.generatePredKeyClause(andORTree);
        }
        return this.sb.toString();
    }

    private String buildCTXIndexDDL(String string) {
        this.sb.setLength(0);
        this.sb.append("create index \"");
        this.sb.append(string);
        this.sb.append("\" on ");
        this.appendTable(this.sb);
        this.sb.append(" (\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\") ");
        this.sb.append("indextype is ctxsys.context parameters(");
        this.sb.append("'section group CTXSYS.JSON_SECTION_GROUP ");
        this.sb.append("lexer CTXSYS.JSON_ENGLISH_LEXER ");
        this.sb.append("stoplist CTXSYS.EMPTY_STOPLIST ");
        this.sb.append("sync (on commit) ");
        this.sb.append("memory 100M");
        this.sb.append("') parallel 8");
        return this.sb.toString();
    }

    private String buildIndexDDL(String string, boolean bl, JsonPath[] jsonPathArray) throws JsonStoreException {
        this.sb.setLength(0);
        this.sb.append("create ");
        if (bl) {
            this.sb.append("unique ");
        }
        this.sb.append("index \"");
        this.sb.append(string);
        this.sb.append("\" on ");
        this.appendTable(this.sb);
        this.sb.append(" (");
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        for (JsonPath jsonPath : jsonPathArray) {
            String string2 = null;
            int n3 = 0;
            int n4 = 0;
            String string3 = null;
            if (jsonPath instanceof IndexColumn) {
                string2 = ((IndexColumn)jsonPath).getSqlTypeName();
                n3 = ((IndexColumn)jsonPath).getSqlType();
                n4 = ((IndexColumn)jsonPath).getMaxLength();
                string3 = ((IndexColumn)jsonPath).getOrder();
            }
            String[] stringArray = jsonPath.getSteps();
            if (bl2) {
                bl2 = false;
            } else {
                this.sb.append(", ");
            }
            boolean bl3 = false;
            if (n3 == 3) {
                this.sb.append("TO_DATE(");
            } else if (n3 == 4) {
                this.sb.append("TO_TIMESTAMP(");
            } else if (string2 != null) {
                bl3 = true;
            }
            this.sb.append("JSON_VALUE(\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\"");
            this.addFormat();
            this.sb.append(",'$");
            for (String string4 : stringArray) {
                this.sb.append(".");
                this.sb.append(string4);
                this.sb.append("[0]");
            }
            this.sb.append("'");
            if (bl3) {
                this.sb.append(" returning ");
                this.sb.append(string2);
                if (n3 == 1) {
                    if (n + 1 > 16) {
                        throw this.makeException(CollectionsMessage.EX_TOO_MANY_COLUMNS, Integer.toString(n));
                    }
                    if (n4 > 0) {
                        this.sb.append("(");
                        this.sb.append(n4);
                        this.sb.append(")");
                        n2 += n4;
                    } else {
                        this.sb.append("(\uffff)");
                        ++n;
                    }
                }
            }
            this.sb.append(") ");
            if (n3 == 3) {
                this.sb.append(", 'YYYY-MM-DD') ");
            } else if (n3 == 4) {
                this.sb.append(", 'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM') ");
            }
            if (string3 == null) continue;
            this.sb.append(string3);
        }
        this.sb.append(")");
        Object object = this.sb.toString();
        if (n > 0) {
            int n5 = 0;
            if (n2 < 2000) {
                n5 = (2000 - n2) / n;
            }
            if (n5 < 255) {
                n5 = 255;
            }
            if ((n2 += n5 * n2) > 4000) {
                log.warning("Total size of index " + string + " is " + n2);
            }
            object = ((String)object).replaceAll("\uffff", Integer.toString(n5));
        }
        return object;
    }

    private String dropIndexDDL(String string) {
        this.sb.setLength(0);
        this.sb.append("drop index \"");
        this.sb.append(string);
        this.sb.append("\"");
        return this.sb.toString();
    }

    @Override
    public long count() throws JsonStoreException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.buildCount();
        long l = 0L;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordReads(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, resultSet);
        return l;
    }

    private void setStreamBind(PreparedStatement preparedStatement, InputStream inputStream, int n) throws SQLException {
        long l = -1L;
        if (inputStream instanceof LimitedInputStream) {
            try {
                l = inputStream.available();
            }
            catch (IOException iOException) {
                l = -1L;
            }
        }
        if (l == 0L) {
            preparedStatement.setNull(n, -3);
        } else if (l > 0L) {
            preparedStatement.setBlob(n, inputStream, l);
        } else {
            preparedStatement.setBlob(n, inputStream);
        }
    }

    @Override
    public JsonDocument insert(JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("insert");
        OraclePreparedStatement oraclePreparedStatement = null;
        ResultSet resultSet = null;
        byte[] byArray = EMPTY_DATA;
        InputStream inputStream = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl3 = this.internalDriver;
        switch (this.options.keyAssignmentMethod) {
            case 4: {
                if (!bl3) {
                    bl = true;
                    break;
                }
                string = Long.toString(this.nextSequenceValue());
                break;
            }
            case 3: {
                if (!bl3) {
                    bl = true;
                    break;
                }
                string = this.db.nextGuid();
                if (this.options.keyDataType != 3) break;
                string = this.uidToDecimal(string);
                break;
            }
            case 2: {
                string = this.db.generateKey();
                if (this.options.keyDataType != 3) break;
                string = this.uidToDecimal(string);
                break;
            }
            default: {
                string = this.canonicalKey(jsonDocument.getKey());
                bl = false;
            }
        }
        bl2 = this.options.timestampColumnName != null || this.options.creationColumnName != null;
        String string5 = this.buildInsert(bl3);
        try {
            int n;
            long l;
            this.metrics.startTiming();
            oraclePreparedStatement = (OraclePreparedStatement)this.conn.prepareStatement(string5);
            int n2 = 0;
            if (!bl) {
                this.bindKeyColumn((PreparedStatement)oraclePreparedStatement, ++n2, string);
            }
            if (this.options.doctypeColumnName != null) {
                string4 = jsonDocument.getContentType();
                oraclePreparedStatement.setString(++n2, string4);
            }
            boolean bl4 = true;
            if (!this.payloadBasedVersioning() && this.isHeterogeneous() && ((JsonDocumentImpl)jsonDocument).hasStreamContent()) {
                inputStream = jsonDocument.getContentStream();
                if (this.options.contentDataType != 4) {
                    throw this.makeException(CollectionsMessage.EX_UNSUPPORTED_MODE, this.options.uriName, this.options.getContentDataType());
                }
                if (inputStream != null) {
                    this.setStreamBind((PreparedStatement)oraclePreparedStatement, inputStream, ++n2);
                } else {
                    oraclePreparedStatement.setNull(++n2, -3);
                }
                bl4 = false;
            } else {
                byArray = jsonDocument.getContent();
                if (byArray == null) {
                    byArray = EMPTY_DATA;
                }
                this.bindContent((PreparedStatement)oraclePreparedStatement, ++n2, byArray);
            }
            if (bl2 && bl3) {
                l = this.db.getDatabaseTime();
                string3 = ComponentTime.stampToString(l);
                oraclePreparedStatement.setString(++n2, string3);
                if (this.options.creationColumnName != null && this.options.timestampColumnName != null) {
                    oraclePreparedStatement.setString(++n2, string3);
                }
                bl2 = false;
            }
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        l = 1L;
                        oraclePreparedStatement.setLong(++n2, l);
                        string2 = Long.toString(l);
                        break;
                    }
                    case 1: {
                        long l2 = this.db.getDatabaseTime();
                        oraclePreparedStatement.setLong(++n2, l2);
                        string2 = Long.toString(l2);
                        break;
                    }
                    case 3: {
                        string2 = this.db.generateKey();
                        oraclePreparedStatement.setString(++n2, string2);
                        break;
                    }
                    default: {
                        if (!bl4) {
                            throw this.makeException(CollectionsMessage.EX_NO_HASH_VERSION, this.options.uriName, this.options.getVersioningMethod());
                        }
                        string2 = this.computeVersion(byArray);
                        oraclePreparedStatement.setString(++n2, string2);
                    }
                }
            }
            if (bl) {
                oraclePreparedStatement.registerReturnParameter(++n2, 12);
            }
            if (bl2) {
                oraclePreparedStatement.registerReturnParameter(++n2, 12);
            }
            if ((n = oraclePreparedStatement.executeUpdate()) != 1) {
                throw this.makeException(CollectionsMessage.EX_INSERT_FAILED, this.options.uriName);
            }
            if ((bl || bl2) && (resultSet = oraclePreparedStatement.getReturnResultSet()).next()) {
                int n3 = 0;
                if (bl) {
                    string = resultSet.getString(++n3);
                }
                if (bl2) {
                    string3 = resultSet.getString(++n3);
                    char[] cArray = string3.toCharArray();
                    cArray[13] = 58;
                    cArray[16] = 58;
                    string3 = new String(cArray);
                }
            }
            oraclePreparedStatement.close();
            oraclePreparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oraclePreparedStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oraclePreparedStatement, null);
        JsonDocumentImpl jsonDocumentImpl = new JsonDocumentImpl(string, string2, string3);
        if (string3 != null) {
            jsonDocumentImpl.setCreatedOn(string3);
        }
        if (string4 == null) {
            string4 = JSON_CONTENT;
        }
        jsonDocumentImpl.setContentType(string4);
        return jsonDocumentImpl;
    }

    @Override
    public List<JsonDocument> insert(Iterator<JsonDocument> iterator) throws JsonStoreException {
        if (iterator == null) {
            return EMPTY_LIST;
        }
        this.writeCheck("insert");
        ArrayList<JsonDocument> arrayList = new ArrayList<JsonDocument>();
        OraclePreparedStatement oraclePreparedStatement = null;
        String string = this.buildInsert(true);
        int n = 100;
        try {
            Object object;
            int n2 = 0;
            this.metrics.startTiming();
            oraclePreparedStatement = (OraclePreparedStatement)this.conn.prepareStatement(string);
            long l = this.db.getDatabaseTime();
            String string2 = ComponentTime.stampToString(l);
            while (iterator.hasNext()) {
                byte[] byArray;
                object = iterator.next();
                String string3 = null;
                String string4 = null;
                String string5 = null;
                switch (this.options.keyAssignmentMethod) {
                    case 4: {
                        string3 = Long.toString(this.nextSequenceValue());
                        break;
                    }
                    case 3: {
                        string3 = this.db.nextGuid();
                        if (this.options.keyDataType != 3) break;
                        string3 = this.uidToDecimal(string3);
                        break;
                    }
                    case 2: {
                        string3 = this.db.generateKey();
                        if (this.options.keyDataType != 3) break;
                        string3 = this.uidToDecimal(string3);
                        break;
                    }
                    default: {
                        string3 = object.getKey();
                    }
                }
                string3 = this.canonicalKey(string3);
                int n3 = 0;
                this.bindKeyColumn((PreparedStatement)oraclePreparedStatement, ++n3, string3);
                if (this.options.doctypeColumnName != null) {
                    string5 = object.getContentType();
                    oraclePreparedStatement.setString(++n3, string5);
                }
                if ((byArray = object.getContent()) == null) {
                    byArray = EMPTY_DATA;
                }
                this.bindContent((PreparedStatement)oraclePreparedStatement, ++n3, byArray);
                if (this.options.timestampColumnName != null) {
                    oraclePreparedStatement.setString(++n3, string2);
                }
                if (this.options.creationColumnName != null) {
                    oraclePreparedStatement.setString(++n3, string2);
                }
                if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                    switch (this.options.versioningMethod) {
                        case 2: {
                            long l2 = 1L;
                            oraclePreparedStatement.setLong(++n3, l2);
                            string4 = Long.toString(l2);
                            break;
                        }
                        case 1: {
                            oraclePreparedStatement.setLong(++n3, l);
                            string4 = Long.toString(l);
                            break;
                        }
                        case 3: {
                            string4 = this.db.generateKey();
                            oraclePreparedStatement.setString(++n3, string4);
                            break;
                        }
                        default: {
                            string4 = this.computeVersion(byArray);
                            oraclePreparedStatement.setString(++n3, string4);
                        }
                    }
                }
                oraclePreparedStatement.addBatch();
                if (++n2 % n == 0) {
                    int[] nArray = oraclePreparedStatement.executeBatch();
                }
                JsonDocumentImpl jsonDocumentImpl = new JsonDocumentImpl(string3, string4, string2);
                if (string2 != null) {
                    jsonDocumentImpl.setCreatedOn(string2);
                }
                if (string5 == null) {
                    string5 = JSON_CONTENT;
                }
                jsonDocumentImpl.setContentType(string5);
                arrayList.add(jsonDocumentImpl);
            }
            if (n2 % n != 0) {
                object = oraclePreparedStatement.executeBatch();
            }
            oraclePreparedStatement.close();
            oraclePreparedStatement = null;
            this.metrics.recordWrites(n2, n);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oraclePreparedStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oraclePreparedStatement, null);
        return arrayList;
    }

    private JsonDocument upsert(String string, JsonDocument jsonDocument) throws JsonStoreException {
        PreparedStatement preparedStatement = null;
        Object var4_4 = null;
        String string2 = null;
        if (this.options.doctypeColumnName != null && (string2 = jsonDocument.getContentType()) == null) {
            string2 = JSON_CONTENT;
        }
        String string3 = this.buildUpsert();
        JsonDocumentImpl jsonDocumentImpl = null;
        string = this.canonicalKey(string);
        try {
            int n;
            long l = this.db.getDatabaseTime();
            String string4 = ComponentTime.stampToString(l);
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string3);
            int n2 = 0;
            this.bindKeyColumn(preparedStatement, ++n2, string);
            byte[] byArray = jsonDocument.getContent();
            if (byArray == null) {
                byArray = EMPTY_DATA;
            }
            String string5 = null;
            switch (this.options.contentDataType) {
                case 1: {
                    string5 = this.stringFromBytes(byArray);
                    preparedStatement.setString(++n2, string5);
                    break;
                }
                case 5: {
                    string5 = this.stringFromBytes(byArray);
                    this.setPayloadClob(preparedStatement, ++n2, string5);
                    break;
                }
                case 3: {
                    string5 = this.stringFromBytes(byArray);
                    preparedStatement.setNString(++n2, string5);
                    break;
                }
                case 6: {
                    string5 = this.stringFromBytes(byArray);
                    this.setPayloadNclob(preparedStatement, ++n2, string5);
                    break;
                }
                case 2: {
                    preparedStatement.setBytes(++n2, byArray);
                    break;
                }
                case 4: {
                    preparedStatement.setBlob(++n2, new ByteArrayInputStream(byArray), byArray.length);
                }
            }
            if (this.options.timestampColumnName != null) {
                preparedStatement.setString(++n2, string4);
            }
            String string6 = null;
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        preparedStatement.setLong(++n2, l);
                        string6 = Long.toString(l);
                        break;
                    }
                    case 3: {
                        string6 = this.db.generateKey();
                        preparedStatement.setString(++n2, string6);
                        break;
                    }
                    default: {
                        string6 = this.computeVersion(byArray);
                        preparedStatement.setString(++n2, string6);
                    }
                }
            }
            this.bindKeyColumn(preparedStatement, ++n2, string);
            switch (this.options.contentDataType) {
                case 1: {
                    preparedStatement.setString(++n2, string5);
                    break;
                }
                case 5: {
                    this.setPayloadClob(preparedStatement, ++n2, string5);
                    break;
                }
                case 3: {
                    preparedStatement.setNString(++n2, string5);
                    break;
                }
                case 6: {
                    this.setPayloadNclob(preparedStatement, ++n2, string5);
                    break;
                }
                case 2: {
                    preparedStatement.setBytes(++n2, byArray);
                    break;
                }
                case 4: {
                    preparedStatement.setBlob(++n2, new ByteArrayInputStream(byArray), byArray.length);
                }
            }
            if (this.options.timestampColumnName != null) {
                preparedStatement.setString(++n2, string4);
            }
            if (this.options.creationColumnName != null) {
                preparedStatement.setString(++n2, string4);
            }
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        long l2 = 1L;
                        preparedStatement.setLong(++n2, l2);
                        string6 = Long.toString(l2);
                        break;
                    }
                    case 1: {
                        preparedStatement.setLong(++n2, l);
                        string6 = Long.toString(l);
                        break;
                    }
                    default: {
                        preparedStatement.setString(++n2, string6);
                    }
                }
            }
            if (this.options.doctypeColumnName != null) {
                preparedStatement.setString(++n2, string2);
            }
            if ((n = preparedStatement.executeUpdate()) == 1) {
                jsonDocumentImpl = new JsonDocumentImpl(string, string6, string4);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, null);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, null);
        return jsonDocumentImpl;
    }

    @Override
    public JsonDocument replace(String string, JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("replace");
        if (this.options.keyAssignmentMethod == 1) {
            return this.upsert(string, jsonDocument);
        }
        PreparedStatement preparedStatement = null;
        byte[] byArray = EMPTY_DATA;
        InputStream inputStream = null;
        String string2 = null;
        if (this.options.doctypeColumnName != null) {
            string2 = jsonDocument.getContentType();
        }
        String string3 = this.buildUpdate(string2 != null);
        JsonDocumentImpl jsonDocumentImpl = null;
        string = this.canonicalKey(string);
        try {
            int n;
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string3);
            int n2 = 0;
            boolean bl = true;
            if (!this.payloadBasedVersioning() && this.isHeterogeneous() && ((JsonDocumentImpl)jsonDocument).hasStreamContent()) {
                inputStream = jsonDocument.getContentStream();
                if (this.options.contentDataType != 4) {
                    throw this.makeException(CollectionsMessage.EX_UNSUPPORTED_MODE, this.options.uriName, this.options.getContentDataType());
                }
                if (inputStream != null) {
                    this.setStreamBind(preparedStatement, inputStream, ++n2);
                }
                bl = false;
            } else {
                byArray = jsonDocument.getContent();
                if (byArray == null) {
                    byArray = EMPTY_DATA;
                }
                this.bindContent(preparedStatement, ++n2, byArray);
            }
            String string4 = null;
            String string5 = null;
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        long l = this.db.getDatabaseTime();
                        preparedStatement.setLong(++n2, l);
                        string4 = Long.toString(l);
                        break;
                    }
                    case 3: {
                        string4 = this.db.generateKey();
                        preparedStatement.setString(++n2, string4);
                        break;
                    }
                    default: {
                        if (!bl) {
                            throw this.makeException(CollectionsMessage.EX_NO_HASH_VERSION, this.options.uriName, this.options.getVersioningMethod());
                        }
                        string4 = this.computeVersion(byArray);
                        preparedStatement.setString(++n2, string4);
                    }
                }
            }
            this.bindKeyColumn(preparedStatement, ++n2, string);
            if (string2 != null) {
                preparedStatement.setString(++n2, string2);
            }
            if ((n = preparedStatement.executeUpdate()) == 0) {
                throw this.makeException(CollectionsMessage.EX_NOT_FOUND, string, this.options.uriName);
            }
            if (n == 1) {
                jsonDocumentImpl = new JsonDocumentImpl(string, string4, string5);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, null);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, null);
        return jsonDocumentImpl;
    }

    @Override
    public boolean update(String string, JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("update");
        throw this.makeException(CollectionsMessage.EX_UPDATE_NO_IMPL, new Object[0]);
    }

    @Override
    public boolean update(Set<String> set, JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("update");
        throw this.makeException(CollectionsMessage.EX_UPDATE_NO_IMPL, new Object[0]);
    }

    @Override
    public boolean update(JsonDocument jsonDocument, JsonDocument jsonDocument2) throws JsonStoreException {
        this.writeCheck("update");
        throw this.makeException(CollectionsMessage.EX_UPDATE_NO_IMPL, new Object[0]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(String string) throws JsonStoreException {
        this.writeCheck("delete");
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        string = this.canonicalKey(string);
        try {
            String string2 = this.buildDelete(true, null);
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            this.bindKeyColumn(preparedStatement, 1, string);
            int n = preparedStatement.executeUpdate();
            bl = n == 1;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
                catch (QueryException queryException) {
                    log.severe(queryException.toString());
                    throw new JsonStoreException(queryException);
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, null);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, null);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int remove(Set<String> set) throws JsonStoreException {
        int n = 0;
        if (set == null) {
            return n;
        }
        int n2 = set.size();
        if (n2 == 0) {
            return n;
        }
        this.writeCheck("delete");
        PreparedStatement preparedStatement = null;
        if (n2 > 100) {
            n2 = 100;
        }
        try {
            String string = this.buildDelete(true, null);
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            int n3 = 0;
            for (String string2 : set) {
                string2 = this.canonicalKey(string2);
                this.bindKeyColumn(preparedStatement, 1, string2);
                preparedStatement.addBatch();
                if (++n3 % n2 != 0) continue;
                int[] nArray = preparedStatement.executeBatch();
                n += nArray.length;
            }
            if (n3 % n2 != 0) {
                Object object = preparedStatement.executeBatch();
                n += ((Object)object).length;
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(n3, n2);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
                catch (QueryException queryException) {
                    log.severe(queryException.toString());
                    throw new JsonStoreException(queryException);
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, null);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, null);
        return n;
    }

    @Override
    public int remove(JsonDocument jsonDocument) throws JsonStoreException {
        this.writeCheck("delete");
        PreparedStatement preparedStatement = null;
        int n = 0;
        int n2 = 0;
        InputStream inputStream = jsonDocument.getContentStream();
        try {
            AndORTree andORTree = AndORTree.createTree(inputStream);
            andORTree.generateJsonExists();
            String string = this.buildDelete(false, andORTree);
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            log.fine("Filtered delete:\n" + string);
            block10: for (ValueTypePair object : andORTree.getValueArray()) {
                switch (object.getType()) {
                    case 1: {
                        preparedStatement.setBigDecimal(++n, object.getNumberValue());
                        continue block10;
                    }
                    case 2: {
                        preparedStatement.setString(++n, object.getStringValue());
                        continue block10;
                    }
                    case 3: {
                        preparedStatement.setString(++n, String.valueOf(object.getBooleanValue()));
                        continue block10;
                    }
                    case 4: {
                        preparedStatement.setString(++n, "null");
                        continue block10;
                    }
                }
                log.warning("Unknown item type");
            }
            for (String string2 : andORTree.getKeys()) {
                String string3 = this.canonicalKey(string2);
                this.bindKeyColumn(preparedStatement, ++n, string3);
            }
            n2 = preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            log.severe(sQLException.toString());
            throw new JsonStoreException(sQLException);
        }
        catch (JsonException jsonException) {
            log.severe(jsonException.toString());
            throw new JsonStoreException((Exception)((Object)jsonException));
        }
        catch (QueryException queryException) {
            log.severe(queryException.toString());
            throw new JsonStoreException(queryException);
        }
        return n2;
    }

    @Override
    JsonCursor openCursor(boolean bl, int n, long l) throws JsonStoreException {
        JsonCursorImpl jsonCursorImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.buildQuery(bl, false, false, false, l, n, 0, false, false, false, false, false);
        try {
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.setFetchSize(1000);
            ((OraclePreparedStatement)preparedStatement).setLobPrefetchSize(65000);
            long l2 = this.metrics.getTime();
            resultSet = preparedStatement.executeQuery();
            l2 = this.metrics.getTimeDiff(l2);
            jsonCursorImpl = new JsonCursorImpl(this.options, this.metrics, bl, preparedStatement, resultSet);
            if (this.internalDriver) {
                // empty if block
            }
            preparedStatement = null;
            resultSet = null;
            jsonCursorImpl.setElapsedTime(l2);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, resultSet);
        return jsonCursorImpl;
    }

    @Override
    public JsonCursor find(String string, boolean bl) throws JsonStoreException {
        JsonCursorImpl jsonCursorImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl2 = false;
        String string2 = this.buildQuery(bl2, true, false, false, 0L, JsonDatabaseImpl.UNLIMITED, 0, false, true, false, false, bl);
        string = this.canonicalKey(string);
        try {
            preparedStatement = this.conn.prepareStatement(string2);
            preparedStatement.setFetchSize(1000);
            ((OraclePreparedStatement)preparedStatement).setLobPrefetchSize(65000);
            long l = this.metrics.getTime();
            this.bindKeyColumn(preparedStatement, 1, string);
            resultSet = preparedStatement.executeQuery();
            l = this.metrics.getTimeDiff(l);
            jsonCursorImpl = new JsonCursorImpl(this.options, this.metrics, bl2, preparedStatement, resultSet);
            if (this.internalDriver) {
                // empty if block
            }
            preparedStatement = null;
            resultSet = null;
            jsonCursorImpl.setElapsedTime(l);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, resultSet);
        return jsonCursorImpl;
    }

    @Override
    public JsonCursor find(String string, String string2) throws JsonStoreException {
        boolean bl;
        JsonCursorImpl jsonCursorImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl2 = false;
        boolean bl3 = string != null;
        boolean bl4 = bl = string2 != null;
        if (this.options.timestampColumnName == null) {
            throw this.makeException(CollectionsMessage.EX_NO_TIMESTAMP, this.options.uriName);
        }
        String string3 = this.buildQuery(bl2, false, false, false, 0L, JsonDatabaseImpl.UNLIMITED, 0, false, false, bl3, bl, false);
        try {
            preparedStatement = this.conn.prepareStatement(string3);
            preparedStatement.setFetchSize(1000);
            ((OraclePreparedStatement)preparedStatement).setLobPrefetchSize(65000);
            long l = this.metrics.getTime();
            int n = 0;
            if (bl3) {
                preparedStatement.setString(++n, string);
            }
            if (bl) {
                preparedStatement.setString(++n, string2);
            }
            resultSet = preparedStatement.executeQuery();
            l = this.metrics.getTimeDiff(l);
            jsonCursorImpl = new JsonCursorImpl(this.options, this.metrics, bl2, preparedStatement, resultSet);
            if (this.internalDriver) {
                // empty if block
            }
            preparedStatement = null;
            resultSet = null;
            jsonCursorImpl.setElapsedTime(l);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, resultSet);
        return jsonCursorImpl;
    }

    @Override
    public JsonCursor find(JsonDocument jsonDocument, JsonDocument jsonDocument2) throws JsonStoreException {
        if (jsonDocument2 != null) {
            this.proj = new ProjectionSpec(jsonDocument2.getContentStream());
            try {
                this.proj.parse();
            }
            catch (QueryException queryException) {
                throw new JsonStoreException(queryException);
            }
            if (this.proj.numColumns() <= 0) {
                this.proj = null;
            }
        }
        InputStream inputStream = jsonDocument.getContentStream();
        AndORTree andORTree = null;
        try {
            andORTree = AndORTree.createTree(inputStream);
            andORTree.generateJsonExists();
        }
        catch (JsonException jsonException) {
            log.warning(jsonException.toString());
            throw new JsonStoreException((Exception)((Object)jsonException));
        }
        catch (QueryException queryException) {
            log.warning(queryException.toString());
            throw this.makeException(CollectionsMessage.EX_INVALID_FILTER, new Object[0]);
        }
        return this.runQBEQuery(andORTree, false);
    }

    private void setPayloadBlob(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        if (this.internalDriver) {
            preparedStatement.setBlob(n, new ByteArrayInputStream(byArray), byArray.length);
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    private void setPayloadClob(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (this.internalDriver) {
            preparedStatement.setClob(n, new StringReader(string));
        } else {
            preparedStatement.setString(n, string);
        }
    }

    private void setPayloadNclob(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (this.internalDriver) {
            preparedStatement.setNClob(n, new StringReader(string));
        } else {
            preparedStatement.setNString(n, string);
        }
    }

    private void bindContent(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException, JsonStoreException {
        switch (this.options.contentDataType) {
            case 1: {
                String string = this.stringFromBytes(byArray);
                preparedStatement.setString(n, string);
                break;
            }
            case 5: {
                String string = this.stringFromBytes(byArray);
                this.setPayloadClob(preparedStatement, n, string);
                break;
            }
            case 3: {
                String string = this.stringFromBytes(byArray);
                preparedStatement.setNString(n, string);
                break;
            }
            case 6: {
                String string = this.stringFromBytes(byArray);
                this.setPayloadNclob(preparedStatement, n, string);
                break;
            }
            case 2: {
                preparedStatement.setBytes(n, byArray);
                break;
            }
            case 4: {
                this.setPayloadBlob(preparedStatement, n, byArray);
            }
        }
    }

    private void bindKeyColumn(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        switch (this.options.keyDataType) {
            case 3: {
                preparedStatement.setString(n, string);
                break;
            }
            case 4: {
                preparedStatement.setBytes(n, ByteArray.hexToRaw(string));
                break;
            }
            case 1: {
                preparedStatement.setString(n, string);
                break;
            }
            case 2: {
                preparedStatement.setNString(n, string);
            }
        }
    }

    @Override
    public List<JsonDocument> findSet(Set<String> set) throws JsonStoreException {
        if (set == null) {
            return EMPTY_LIST;
        }
        int n = set.size();
        if (n == 0) {
            return EMPTY_LIST;
        }
        ArrayList<JsonDocument> arrayList = new ArrayList<JsonDocument>(n);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.buildQuery(false, false, false, false, 0L, JsonDatabaseImpl.UNLIMITED, 16, true, false, false, false, false);
        try {
            preparedStatement = this.conn.prepareStatement(string);
            int n2 = 0;
            for (String string2 : set) {
                string2 = this.canonicalKey(string2);
                this.bindKeyColumn(preparedStatement, ++n2, string2);
                if (--n == 0) {
                    while (n2 < 16) {
                        switch (this.options.keyDataType) {
                            case 3: {
                                preparedStatement.setNull(++n2, 4);
                                break;
                            }
                            case 4: {
                                preparedStatement.setNull(++n2, -3);
                                break;
                            }
                            case 1: {
                                preparedStatement.setNull(++n2, 12);
                                break;
                            }
                            case 2: {
                                preparedStatement.setNull(++n2, -9);
                            }
                        }
                    }
                }
                if (n2 != 16) continue;
                this.metrics.startTiming();
                n2 = 0;
                resultSet = preparedStatement.executeQuery();
                int n3 = 0;
                while (resultSet.next()) {
                    int n4 = 0;
                    String string3 = resultSet.getString(++n4);
                    String string4 = null;
                    if (this.options.doctypeColumnName != null) {
                        string4 = resultSet.getString(++n4);
                    }
                    byte[] byArray = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    byArray = this.readPayloadColumn(resultSet, ++n4);
                    if (this.options.timestampColumnName != null) {
                        string5 = resultSet.getString(++n4);
                    }
                    if (this.options.creationColumnName != null) {
                        string6 = resultSet.getString(++n4);
                    }
                    if (this.options.versionColumnName != null) {
                        string7 = resultSet.getString(++n4);
                    }
                    JsonDocumentImpl jsonDocumentImpl = new JsonDocumentImpl(string3, string7, string5, byArray);
                    if (string4 != null) {
                        jsonDocumentImpl.setContentType(string4);
                    }
                    if (string6 != null) {
                        jsonDocumentImpl.setCreatedOn(string6);
                    }
                    arrayList.add(jsonDocumentImpl);
                    ++n3;
                }
                this.metrics.recordReads(n3, 16);
            }
        }
        catch (SQLException sQLException) {
            log.severe(sQLException.toString());
            throw new JsonStoreException(sQLException);
        }
        finally {
            this.closeCursor(preparedStatement, resultSet);
        }
        return arrayList;
    }

    @Override
    public JsonDocument findOne(String string, long l, int n) throws JsonStoreException {
        JsonDocumentImpl jsonDocumentImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        byte[] byArray = null;
        LobInputStream lobInputStream = null;
        boolean bl = false;
        String string2 = this.buildQuery(false, true, false, false, 0L, JsonDatabaseImpl.UNLIMITED, 0, true, false, false, false, false);
        string = this.canonicalKey(string);
        if (this.isHeterogeneous()) {
            bl = true;
        }
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            this.bindKeyColumn(preparedStatement, 1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n2 = 0;
                String string3 = resultSet.getString(++n2);
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                long l2 = -1L;
                if (this.options.doctypeColumnName != null) {
                    if ((string4 = resultSet.getString(++n2)) == null) {
                        bl = false;
                    } else if (string4.equalsIgnoreCase(JSON_CONTENT)) {
                        bl = false;
                    }
                }
                if (bl) {
                    Blob blob;
                    if (this.options.contentDataType != 4) {
                        throw this.makeException(CollectionsMessage.EX_UNSUPPORTED_MODE, this.options.uriName, this.options.getContentDataType());
                    }
                    if ((blob = resultSet.getBlob(++n2)) != null) {
                        l2 = blob.length();
                        if (l2 > 0L) {
                            InputStream inputStream;
                            if (n < 0 || (long)n + l > l2) {
                                n = (int)(l2 - l);
                            }
                            if ((l > 0L || (long)n + l < l2) && n <= 0x100000 && l2 > 4096L && l2 >> 1 > (long)n) {
                                byArray = blob.getBytes(l + 1L, n);
                                bl = false;
                            }
                            if (bl && (inputStream = blob.getBinaryStream()) != null) {
                                lobInputStream = new LobInputStream(blob, inputStream, (int)l2);
                                lobInputStream.setMetrics(this.metrics);
                            }
                        }
                        if (lobInputStream == null && byArray == null) {
                            lobInputStream = new LobInputStream();
                        }
                    }
                } else {
                    byArray = this.readPayloadColumn(resultSet, ++n2);
                }
                if (this.options.timestampColumnName != null) {
                    string5 = resultSet.getString(++n2);
                }
                if (this.options.creationColumnName != null) {
                    string6 = resultSet.getString(++n2);
                }
                if (this.options.versionColumnName != null) {
                    string7 = resultSet.getString(++n2);
                }
                if (lobInputStream != null) {
                    jsonDocumentImpl = new JsonDocumentImpl(string3, string7, string5, lobInputStream, string4);
                    lobInputStream = null;
                } else {
                    jsonDocumentImpl = new JsonDocumentImpl(string3, string7, string5, byArray);
                    if (string4 != null) {
                        jsonDocumentImpl.setContentType(string4);
                    }
                    if (l2 > 0L) {
                        jsonDocumentImpl.setFragmentInfo(l, l2);
                    }
                }
                if (string6 != null) {
                    jsonDocumentImpl.setCreatedOn(string6);
                }
            }
            this.metrics.recordReads(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                try {
                    if (lobInputStream != null) {
                        lobInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.severe(iOException.toString());
                }
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, resultSet);
        return jsonDocumentImpl;
    }

    private JsonDocument fetchHeader(String string, String string2, String string3) throws JsonStoreException {
        JsonDocumentImpl jsonDocumentImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = string2 != null;
        boolean bl2 = string3 != null;
        String string4 = this.buildQuery(true, true, bl, bl2, 0L, JsonDatabaseImpl.UNLIMITED, 0, true, false, false, false, false);
        string = this.canonicalKey(string);
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string4);
            this.bindKeyColumn(preparedStatement, 1, string);
            if (string2 != null) {
                preparedStatement.setString(2, string2);
            } else if (string3 != null) {
                preparedStatement.setString(2, string3);
            }
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = 0;
                String string5 = resultSet.getString(++n);
                String string6 = null;
                if (this.options.doctypeColumnName != null) {
                    string6 = resultSet.getString(++n);
                }
                String string7 = null;
                String string8 = null;
                String string9 = null;
                if (this.options.timestampColumnName != null) {
                    string7 = resultSet.getString(++n);
                }
                if (this.options.creationColumnName != null) {
                    string8 = resultSet.getString(++n);
                }
                if (this.options.versionColumnName != null) {
                    string9 = resultSet.getString(++n);
                }
                jsonDocumentImpl = new JsonDocumentImpl(string5, string9, string7);
                if (string6 != null) {
                    jsonDocumentImpl.setContentType(string6);
                }
                if (string8 != null) {
                    jsonDocumentImpl.setCreatedOn(string8);
                }
            }
            this.metrics.recordReads(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, resultSet);
        return jsonDocumentImpl;
    }

    @Override
    public JsonDocument findHeader(String string) throws JsonStoreException {
        return this.fetchHeader(string, null, null);
    }

    @Override
    public JsonDocument findVersion(String string, String string2) throws JsonStoreException {
        if (this.options.versionColumnName == null && string2 != null) {
            return null;
        }
        return this.fetchHeader(string, string2, null);
    }

    @Override
    public JsonDocument findLastModified(String string, String string2) throws JsonStoreException {
        if (this.options.timestampColumnName == null && string2 != null) {
            return null;
        }
        return this.fetchHeader(string, null, string2);
    }

    @Override
    public JsonDocument findOne(String string, JsonDocument jsonDocument) throws JsonStoreException {
        return this.findOne(string);
    }

    @Override
    public JsonCursor findKeys(JsonDocument jsonDocument) throws JsonStoreException {
        InputStream inputStream = jsonDocument.getContentStream();
        AndORTree andORTree = null;
        try {
            andORTree = AndORTree.createTree(inputStream);
            andORTree.generateJsonExists();
        }
        catch (JsonException jsonException) {
            log.warning(jsonException.toString());
            throw new JsonStoreException((Exception)((Object)jsonException));
        }
        catch (QueryException queryException) {
            log.warning(queryException.toString());
            throw this.makeException(CollectionsMessage.EX_INVALID_FILTER, new Object[0]);
        }
        return this.runQBEQuery(andORTree, true);
    }

    @Override
    public JsonDocument findFirst(JsonDocument jsonDocument) throws JsonStoreException {
        return this.findFirst(jsonDocument, null);
    }

    @Override
    public JsonDocument findFirst(JsonDocument jsonDocument, JsonDocument jsonDocument2) throws JsonStoreException {
        JsonDocument jsonDocument3 = null;
        JsonCursor jsonCursor = this.find(1);
        if (jsonCursor != null) {
            jsonDocument3 = jsonCursor.next();
            try {
                jsonCursor.close();
            }
            catch (IOException iOException) {
                Throwable throwable = iOException.getCause();
                if (throwable != null && throwable instanceof SQLException) {
                    throw new JsonStoreException((SQLException)throwable);
                }
                throw new JsonStoreException(iOException);
            }
        }
        return jsonDocument3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndex(String string, boolean bl, JsonPath[] jsonPathArray) throws JsonStoreException {
        PreparedStatement preparedStatement = null;
        string = CollectionDescriptor.stringToIdentifier(string);
        String string2 = null;
        string2 = jsonPathArray == null || jsonPathArray.length == 0 ? this.buildCTXIndexDDL(string) : this.buildIndexDDL(string, bl, jsonPathArray);
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            preparedStatement.execute();
            log.info("Created index " + string);
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            block4: {
                try {
                    if (sQLException.getErrorCode() == 955) break block4;
                    log.warning(sQLException.toString());
                    throw new JsonStoreException(sQLException);
                }
                catch (Throwable throwable) {
                    this.closeCursor(preparedStatement, null);
                    throw throwable;
                }
            }
            this.closeCursor(preparedStatement, null);
        }
        this.closeCursor(preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropIndex(String string) throws JsonStoreException {
        PreparedStatement preparedStatement = null;
        string = CollectionDescriptor.stringToIdentifier(string);
        String string2 = this.dropIndexDDL(string);
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            preparedStatement.execute();
            log.info("Dropped index " + string);
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            block4: {
                try {
                    if (sQLException.getErrorCode() == 942) break block4;
                    log.warning(sQLException.toString());
                    throw new JsonStoreException(sQLException);
                }
                catch (Throwable throwable) {
                    this.closeCursor(preparedStatement, null);
                    throw throwable;
                }
            }
            this.closeCursor(preparedStatement, null);
        }
        this.closeCursor(preparedStatement, null);
    }

    private long nextSequenceValue() throws JsonStoreException {
        if (this.seqCachePos >= this.seqCache.length) {
            this.fetchSequence();
        }
        return this.seqCache[this.seqCachePos++];
    }

    private String buildSequenceFetch() {
        this.sb.setLength(0);
        this.sb.append("declare\n");
        this.sb.append("  type NTAB is table of number index by binary_integer;\n");
        this.sb.append("  N number;\n");
        this.sb.append("  X number;\n");
        this.sb.append("  K ntab;\n");
        this.sb.append("begin\n");
        this.sb.append("  N := ?;\n");
        this.sb.append("  for I in 1..N loop\n");
        this.sb.append("    select \"");
        this.sb.append(this.options.keySequenceName);
        this.sb.append("\".NEXTVAL into X from SYS.DUAL;\n");
        this.sb.append("    K(I) := X;\n");
        this.sb.append("  end loop;\n");
        this.sb.append("  ? := K;\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private void fetchSequence() throws JsonStoreException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = this.buildSequenceFetch();
        int n = 10;
        try {
            Datum[] datumArray = null;
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setInt(1, n);
            oracleCallableStatement.registerIndexTableOutParameter(2, n, 2, 0);
            oracleCallableStatement.execute();
            datumArray = oracleCallableStatement.getOraclePlsqlIndexTable(2);
            n = datumArray.length;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.seqCache[i] = datumArray[i].longValue();
                }
            }
            this.seqCachePos -= n;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordReads(n, 1);
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
            }
            catch (Throwable throwable) {
                this.closeCursor((Statement)oracleCallableStatement, null);
                throw throwable;
            }
        }
        this.closeCursor((Statement)oracleCallableStatement, null);
    }

    public void returnQuery() {
        this.save_qbe = true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonCursor runQBEQuery(AndORTree andORTree, boolean bl) throws JsonStoreException {
        JsonCursorImpl jsonCursorImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            String string = this.buildQBEQuery(andORTree, bl);
            log.fine("Filtered search:\n" + string);
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            JsonByteArray jsonByteArray = null;
            if (this.save_qbe) {
                jsonByteArray = new JsonByteArray(1000);
                jsonByteArray.appendOpenBrace();
                jsonByteArray.appendValue("sql");
                jsonByteArray.appendColon();
                jsonByteArray.appendValue(string);
            }
            int n2 = 0;
            block11: for (ValueTypePair valueTypePair : andORTree.getValueArray()) {
                if (this.save_qbe) {
                    jsonByteArray.appendComma();
                    jsonByteArray.appendValue("B" + Integer.toString(n2++));
                    jsonByteArray.appendColon();
                }
                switch (valueTypePair.getType()) {
                    case 1: {
                        preparedStatement.setBigDecimal(++n, valueTypePair.getNumberValue());
                        if (!this.save_qbe) continue block11;
                        jsonByteArray.append(valueTypePair.getNumberValue().toString());
                        continue block11;
                    }
                    case 2: {
                        preparedStatement.setString(++n, valueTypePair.getStringValue());
                        if (!this.save_qbe) continue block11;
                        jsonByteArray.appendValue(valueTypePair.getStringValue());
                        continue block11;
                    }
                    case 3: {
                        preparedStatement.setString(++n, String.valueOf(valueTypePair.getBooleanValue()));
                        if (!this.save_qbe) continue block11;
                        jsonByteArray.append(valueTypePair.getBooleanValue() ? "true" : "false");
                        continue block11;
                    }
                    case 4: {
                        preparedStatement.setString(++n, "null");
                        if (!this.save_qbe) continue block11;
                        jsonByteArray.append("null");
                        continue block11;
                    }
                }
                if (!this.save_qbe) continue;
                jsonByteArray.append("null");
            }
            n2 = 0;
            for (String string2 : andORTree.getKeys()) {
                String string3 = this.canonicalKey(string2);
                this.bindKeyColumn(preparedStatement, ++n, string3);
                if (!this.save_qbe) continue;
                jsonByteArray.appendComma();
                jsonByteArray.appendValue("key:" + Integer.toString(n2++));
                jsonByteArray.appendColon();
                jsonByteArray.appendValue(string3);
            }
            if (this.save_qbe) {
                jsonByteArray.appendCloseBrace();
            }
            this.metrics.startTiming();
            resultSet = preparedStatement.executeQuery();
            jsonCursorImpl = new JsonCursorImpl(this.options, this.metrics, bl, true, preparedStatement, resultSet);
            if (this.internalDriver) {
                // empty if block
            }
            jsonCursorImpl.setProjection(this.proj);
            if (this.save_qbe) {
                jsonCursorImpl.setQuery(jsonByteArray.toArray());
            }
            preparedStatement = null;
            resultSet = null;
        }
        catch (SQLException sQLException) {
            try {
                log.severe(sQLException.toString());
                throw new JsonStoreException(sQLException);
                catch (QueryException queryException) {
                    log.severe(queryException.toString());
                    throw new JsonStoreException(queryException);
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(preparedStatement, resultSet);
                throw throwable;
            }
        }
        this.closeCursor(preparedStatement, resultSet);
        return jsonCursorImpl;
    }
}

