/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;

public final class CookieGenerator {
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";
    private static final int COOKIE_LEN = 16;
    private static final String ALGORITHM = "SHA-1";
    private static final String ENCODING = "utf-8";
    private final SecureRandom rand;

    public CookieGenerator() {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(RANDOM_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            secureRandom = new SecureRandom();
        }
        this.rand = secureRandom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generate() {
        if (this.rand != null) {
            byte[] byArray = new byte[16];
            SecureRandom secureRandom = this.rand;
            synchronized (secureRandom) {
                this.rand.nextBytes(byArray);
            }
            return CookieGenerator.digest(byArray);
        }
        UUID uUID = UUID.randomUUID();
        return CookieGenerator.digest(uUID.toString());
    }

    public static byte[] digest(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return byArray;
        }
        return messageDigest.digest(byArray);
    }

    public static byte[] digest(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return CookieGenerator.digest(byArray);
    }
}

