/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.json.common.MetricsCollector;
import oracle.soda.OracleClient;
import oracle.soda.OracleDatabase;
import oracle.soda.OracleException;
import oracle.soda.rdbms.OracleRDBMSMetadataBuilder;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.cache.CacheOfDescriptorCaches;
import oracle.soda.rdbms.impl.cache.DescriptorCache;

public class OracleRDBMSClient
implements OracleClient {
    private CacheOfDescriptorCaches cacheOfDescriptorCaches;
    private boolean localMetadataCache;
    private final MetricsCollector mcollector = new MetricsCollector();

    public OracleRDBMSClient() {
    }

    public OracleRDBMSClient(Properties properties) {
        this();
        if (properties != null) {
            String string = properties.getProperty("oracle.soda.sharedMetadataCache");
            String string2 = properties.getProperty("oracle.soda.localMetadataCache");
            if (string != null && string.equalsIgnoreCase("true")) {
                this.cacheOfDescriptorCaches = new CacheOfDescriptorCaches(100, 100);
            }
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                this.localMetadataCache = true;
            }
        }
    }

    @Override
    public OracleDatabase getDatabase(Connection connection) throws OracleException {
        return this.getDatabase(connection, false);
    }

    @Override
    public OracleDatabase getDatabase(Connection connection, boolean bl) throws OracleException {
        String string;
        Object object;
        OracleConnection oracleConnection = null;
        try {
            if (connection instanceof OracleConnection) {
                oracleConnection = (OracleConnection)connection;
            } else if (connection.isWrapperFor(OracleConnection.class)) {
                oracleConnection = connection.unwrap(OracleConnection.class);
            } else {
                throw SODAUtils.makeException(SODAMessage.EX_NOT_ORACLE_CONNECTION, new Object[0]);
            }
            object = oracleConnection.getMetaData();
            string = object.getURL();
            string = string + "/";
            string = string + oracleConnection.getCurrentSchema();
        }
        catch (SQLException sQLException) {
            throw new OracleException(sQLException);
        }
        if (string == null && this.cacheOfDescriptorCaches != null) {
            throw SODAUtils.makeException(SODAMessage.EX_SCHEMA_NAME_IS_NULL, new Object[0]);
        }
        object = null;
        if (this.cacheOfDescriptorCaches != null) {
            object = this.cacheOfDescriptorCaches.putIfAbsentAndGet(string);
        }
        return new OracleDatabaseImpl(oracleConnection, (DescriptorCache)object, this.mcollector, this.localMetadataCache, bl);
    }

    public OracleRDBMSMetadataBuilder createMetadataBuilder() {
        return CollectionDescriptor.createStandardBuilder();
    }
}

