/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.json.common.LobInputStream;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.util.ByteArray;
import oracle.soda.OracleCursor;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.Operation;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.TableCollectionImpl;

public class OracleCursorImpl
implements OracleCursor {
    private static final Logger log = Logger.getLogger(OracleCursorImpl.class.getName());
    private PreparedStatement stmt;
    private ResultSet resultSet;
    private Operation operation;
    private long cumTime;
    private int rowCount;
    private final CollectionDescriptor desc;
    private final MetricsCollector metrics;
    private OracleDocument nextDocument;
    boolean closed;
    private byte[] sql_query = null;

    OracleCursorImpl(CollectionDescriptor collectionDescriptor, MetricsCollector metricsCollector, Operation operation, ResultSet resultSet) throws OracleException {
        this.desc = collectionDescriptor;
        this.metrics = metricsCollector;
        this.operation = operation;
        this.stmt = operation.getPreparedStatement();
        this.resultSet = resultSet;
        this.closed = false;
    }

    void setElapsedTime(long l) {
        this.cumTime += l;
    }

    @Override
    public boolean hasNext() throws OracleException {
        if (this.closed) {
            return false;
        }
        if (this.nextDocument != null) {
            return true;
        }
        this.nextDocument = this.next();
        return this.nextDocument != null;
    }

    @Override
    public OracleDocument next() throws OracleException {
        if (this.closed) {
            throw SODAUtils.makeException(SODAMessage.EX_CANT_CALL_NEXT_ON_CLOSED_CURSOR, new Object[0]);
        }
        OracleDocumentImpl oracleDocumentImpl = null;
        if (this.nextDocument != null) {
            oracleDocumentImpl = (OracleDocumentImpl)this.nextDocument;
            this.nextDocument = null;
            return oracleDocumentImpl;
        }
        LobInputStream lobInputStream = null;
        long l = this.metrics.getTime();
        try {
            boolean bl = this.resultSet.next();
            if (bl) {
                int n = 0;
                byte[] byArray = null;
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                boolean bl2 = this.desc.doctypeColumnName != null;
                String string5 = this.resultSet.getString(++n);
                if (bl2) {
                    string4 = this.resultSet.getString(++n);
                }
                if (!this.operation.headerOnly()) {
                    switch (this.desc.contentDataType) {
                        case 1: 
                        case 5: {
                            String string6 = this.resultSet.getString(++n);
                            if (string6 == null) break;
                            byArray = string6.getBytes(ByteArray.DEFAULT_CHARSET);
                            break;
                        }
                        case 3: 
                        case 6: {
                            String string7 = this.resultSet.getNString(++n);
                            if (string7 == null) break;
                            byArray = string7.getBytes(ByteArray.DEFAULT_CHARSET);
                            break;
                        }
                        case 4: {
                            boolean bl3;
                            boolean bl4 = bl3 = bl2 && !this.operation.isFilterSpecBased();
                            if (this.operation.isSingleKeyBased()) {
                                if (string4 == null) {
                                    bl3 = false;
                                } else if (string4.equalsIgnoreCase("application/json")) {
                                    bl3 = false;
                                }
                            }
                            if (bl3) {
                                Blob blob;
                                if ((blob = this.resultSet.getBlob(++n)) != null) {
                                    long l2 = blob.length();
                                    if (l2 > Integer.MAX_VALUE) {
                                        blob.free();
                                        throw SODAUtils.makeException(SODAMessage.EX_2G_SIZE_LIMIT_EXCEEDED, string5, l2);
                                    }
                                    int n2 = (int)l2;
                                    if (l2 == 0L) {
                                        byArray = OracleCollectionImpl.EMPTY_DATA;
                                        blob.free();
                                    } else {
                                        InputStream inputStream = blob.getBinaryStream();
                                        if (inputStream != null) {
                                            lobInputStream = new LobInputStream(blob, inputStream, n2);
                                            lobInputStream.setMetrics(this.metrics);
                                        }
                                    }
                                }
                                if (lobInputStream != null || byArray != null) break;
                                lobInputStream = new LobInputStream();
                                break;
                            }
                        }
                        case 2: {
                            byArray = this.resultSet.getBytes(++n);
                        }
                    }
                }
                if (this.desc.timestampColumnName != null) {
                    string = this.resultSet.getString(++n);
                }
                if (this.desc.creationColumnName != null) {
                    string2 = this.resultSet.getString(++n);
                }
                if (this.desc.versionColumnName != null) {
                    string3 = this.resultSet.getString(++n);
                }
                oracleDocumentImpl = lobInputStream != null ? new OracleDocumentImpl(string5, string3, string, lobInputStream, string4) : new OracleDocumentImpl(string5, string3, string, byArray);
                if (string2 != null) {
                    oracleDocumentImpl.setCreatedOn(string2);
                }
                ((TableCollectionImpl)this.operation.getCollection()).setContentType(string4, oracleDocumentImpl);
                ++this.rowCount;
                this.cumTime += this.metrics.getTimeDiff(l);
            } else {
                this.closeInternal();
            }
        }
        catch (SQLException sQLException) {
            block36: {
                block35: {
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString());
                    }
                    try {
                        if (lobInputStream != null) {
                            lobInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!OracleLog.isLoggingEnabled()) break block35;
                        log.severe(iOException.toString());
                    }
                }
                try {
                    if (!this.closed) {
                        this.closeInternal();
                    }
                }
                catch (SQLException sQLException2) {
                    if (!OracleLog.isLoggingEnabled()) break block36;
                    log.severe(sQLException2.toString());
                }
            }
            throw new OracleException(sQLException);
        }
        return oracleDocumentImpl;
    }

    public byte[] getQuery() {
        return this.sql_query;
    }

    void setQuery(byte[] byArray) {
        this.sql_query = byArray;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal() throws SQLException {
        this.operation = null;
        this.closed = true;
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            this.resultSet = null;
            if (this.stmt != null) {
                this.stmt.close();
            }
            this.stmt = null;
        }
        finally {
            for (String string : SODAUtils.closeCursor(this.stmt, this.resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.operation = null;
        try {
            this.closeInternal();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException);
        }
        if (OracleLog.isLoggingEnabled()) {
            log.fine("Cursor read " + this.rowCount + " rows in " + this.metrics.nanosToString(this.cumTime));
        }
        this.metrics.recordCursorReads(this.rowCount, 1000, this.cumTime);
    }
}

