/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.SharedUtils;

public class HeatMapStyleModel
extends AbstractStyleModel {
    private static final long serialVersionUID = 5536355586759208793L;
    public static final int METHOD_KERNEL_ESTIMATE = 1;
    public static final int METHOD_IDW = 2;
    public static final int METHOD_FAST_ALPHAMAP = 3;
    private Color[] colorStops;
    private int numSteps = 256;
    private int alpha = 255;
    private SizeDefinition spotLightRadius = new SizeDefinition(5.0, null);
    private String containerThemeName = null;
    private double gridSampleFactor = 2.5;
    private int method = 1;
    private boolean globalCellValueRangeEnforced = false;
    private double maxPointsInSpotlight = 0.0;
    private Map zoomLevelMaxCellValueMap = null;
    static NumberFormat NF = new DecimalFormat("#.##");

    @Override
    public Object clone() {
        HeatMapStyleModel obj = (HeatMapStyleModel)super.clone();
        if (this.colorStops != null) {
            obj.colorStops = new Color[this.colorStops.length];
            for (int i = 0; i < this.colorStops.length; ++i) {
                try {
                    obj.colorStops[i] = this.colorStops[i];
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return obj;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    public void setColorStops(Color[] colorStops) {
        this.colorStops = colorStops;
    }

    public Color[] getColorStops() {
        return this.colorStops;
    }

    public void setNumSteps(int numSteps) {
        this.numSteps = numSteps;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setSpotLightRadius(double spotLightRadius) {
        this.spotLightRadius.setValue(spotLightRadius);
    }

    public double getSpotLightRadius() {
        return this.spotLightRadius.getValue();
    }

    public SizeDefinition getSpotLightRadiusSize() {
        return this.spotLightRadius;
    }

    public void setSpotLightRadiusSize(SizeDefinition size) {
        this.spotLightRadius = new SizeDefinition(5.0, null);
        if (size == null) {
            return;
        }
        this.spotLightRadius.setValue(size.getValue());
        this.spotLightRadius.setUnit(size.getUnit());
    }

    public String getSpotLightRadiusUnit() {
        return this.spotLightRadius.getUnit();
    }

    public void setSpotLightRadiusUnit(String unit) {
        this.spotLightRadius.setUnit(unit);
    }

    public void setContainerThemeName(String containerThemeName) {
        this.containerThemeName = containerThemeName;
    }

    public String getContainerThemeName() {
        return this.containerThemeName;
    }

    public void setGridSampleFactor(double gridSampleFactor) {
        this.gridSampleFactor = gridSampleFactor;
    }

    public double getGridSampleFactor() {
        return this.gridSampleFactor;
    }

    public Color[] createGradientColors() {
        return StyleUtils.createMultiStopGradient(this.colorStops, this.numSteps, this.alpha);
    }

    @Override
    public String toXMLString() {
        String spotlightradiusUnit = "";
        if (this.spotLightRadius.getUnit() != null && !this.spotLightRadius.getUnit().equalsIgnoreCase("px")) {
            spotlightradiusUnit = this.spotLightRadius.getUnit();
        }
        String spotlightradiusSz = StyleUtils.getUSLocaleFormat(this.spotLightRadius.getValue());
        spotlightradiusSz = StyleUtils.cleanDecimalZeros(spotlightradiusSz, 1);
        if (this.spotLightRadius.isPixelUnit()) {
            spotlightradiusSz = String.valueOf((int)this.spotLightRadius.getValue());
        }
        String xmlDef = "<?xml version=\"1.0\" ?>\n";
        xmlDef = xmlDef + "<AdvancedStyle>\n   <HeatMapStyle>\n";
        xmlDef = xmlDef + "      <color_stops num_steps=\"" + this.numSteps + "\" alpha=\"" + this.alpha + "\">\n";
        String colorStopsStr = "";
        if (this.colorStops != null) {
            for (int i = 0; i < this.colorStops.length - 1; ++i) {
                String cs = StyleUtils.getHexidecimalString(this.colorStops[i]);
                cs = cs.substring(1);
                colorStopsStr = colorStopsStr + cs + ",";
            }
            colorStopsStr = colorStopsStr + StyleUtils.getHexidecimalString(this.colorStops[this.colorStops.length - 1]).substring(1);
        }
        xmlDef = xmlDef + "           " + colorStopsStr + "\n";
        xmlDef = xmlDef + "      </color_stops>\n";
        xmlDef = xmlDef + "      <spot_light_radius>" + spotlightradiusSz + spotlightradiusUnit + "</spot_light_radius>\n";
        xmlDef = xmlDef + "      <grid_sample_factor>" + this.gridSampleFactor + "</grid_sample_factor>\n";
        xmlDef = xmlDef + "      <container_theme>" + this.containerThemeName + "</container_theme>\n";
        if (this.getMethod() == 2 || this.getMethod() == 3) {
            xmlDef = xmlDef + "      <method>" + HeatMapStyleModel.getMethodName(this.getMethod()) + "</method>\n";
        }
        if (this.globalCellValueRangeEnforced) {
            xmlDef = xmlDef + "      <enforce_global_range>true</enforce_global_range>\n";
            xmlDef = xmlDef + "      <max_records_in_raidus>" + NF.format(this.maxPointsInSpotlight) + "</max_records_in_raidus>\n";
        }
        xmlDef = xmlDef + "    </HeatMapStyle>\n";
        xmlDef = xmlDef + "</AdvancedStyle>\n";
        return xmlDef;
    }

    public static Color[] stringToColorStops(String str) {
        String s = str.trim();
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        List l = SharedUtils.splitBy(s, ",");
        Color[] res = new Color[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            String cs = (String)l.get(i);
            if (!cs.startsWith("#")) {
                cs = "#" + cs;
            }
            res[i] = StyleUtils.getColor(cs);
        }
        return res;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }

    public void setMethod(int method) {
        if (2 != method && 1 != method && 3 != method) {
            throw new IllegalArgumentException("Invalid method specified.");
        }
        this.method = method;
    }

    public int getMethod() {
        return this.method;
    }

    public static String getMethodName(int method) {
        switch (method) {
            case 1: {
                return "kernel_estimate";
            }
            case 2: {
                return "idw";
            }
            case 3: {
                return "fast_alphamap";
            }
        }
        return "kernel_estimate";
    }

    public boolean isGlobalCellValueRangeEnforced() {
        return this.globalCellValueRangeEnforced;
    }

    public void setGlobalCellValueRangeEnforced(boolean useGlobalCellValueRange) {
        this.globalCellValueRangeEnforced = useGlobalCellValueRange;
    }

    public double getMaxPointsInSpotlight() {
        return this.maxPointsInSpotlight;
    }

    public void setMaxPointsInSpotlight(double maxPointsInSpotlight) {
        this.maxPointsInSpotlight = maxPointsInSpotlight;
    }

    public double getGlobalMaxCellValue(double radiusPx) {
        if (this.zoomLevelMaxCellValueMap == null) {
            return -1.0;
        }
        Double key = new Double(radiusPx);
        Object val = this.zoomLevelMaxCellValueMap.get(key);
        if (val != null) {
            return (Double)val;
        }
        return -1.0;
    }

    public void setGlobalMaxCellValue(double globalMaxCellValue, double radiusPx) {
        Double key;
        if (this.zoomLevelMaxCellValueMap == null) {
            this.zoomLevelMaxCellValueMap = new HashMap();
        }
        if (this.zoomLevelMaxCellValueMap.get(key = new Double(radiusPx)) == null) {
            Double value = new Double(globalMaxCellValue);
            this.zoomLevelMaxCellValueMap.put(key, value);
        }
    }
}

