/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.PieSliceInfo;

public class PieChartStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 4490848579357926061L;
    SizeDefinition pieRadiusSize = new SizeDefinition(0.0, null);
    int numSlices = 0;
    PieSliceInfo[] pieSlices = null;
    Color strokeColor = Color.black;

    public PieChartStyleModel() {
        this.type = 9;
        this.pieSlices = new PieSliceInfo[0];
    }

    public PieChartStyleModel(int pieRadius, PieSliceInfo[] psi) {
        this.type = 9;
        if (pieRadius < 1 || psi == null || psi.length == 0) {
            throw new IllegalArgumentException("invalid argument(s).");
        }
        this.pieRadiusSize.setValue(pieRadius);
        this.pieSlices = psi;
        this.numSlices = psi.length;
    }

    @Override
    public Object clone() {
        PieChartStyleModel obj = (PieChartStyleModel)super.clone();
        if (this.pieSlices != null) {
            obj.pieSlices = new PieSliceInfo[this.pieSlices.length];
            for (int i = 0; i < this.pieSlices.length; ++i) {
                obj.pieSlices[i] = new PieSliceInfo(this.pieSlices[i].name, this.pieSlices[i].color);
            }
        }
        obj.setPieRadiusSize(this.pieRadiusSize);
        return obj;
    }

    public SizeDefinition getPieRadiusSize() {
        return this.pieRadiusSize;
    }

    public void setPieRadiusSize(SizeDefinition size) {
        this.pieRadiusSize = new SizeDefinition(0.0, null);
        if (size == null) {
            return;
        }
        this.pieRadiusSize.setValue(size.getValue());
        this.pieRadiusSize.setUnit(size.getUnit());
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    @Override
    public String toXMLString() {
        String pieradiusUnit = "";
        if (this.pieRadiusSize.getUnit() != null && !this.pieRadiusSize.getUnit().equalsIgnoreCase("px")) {
            pieradiusUnit = this.pieRadiusSize.getUnit();
        }
        String pieradiusSz = StyleUtils.getUSLocaleFormat(this.pieRadiusSize.getValue());
        pieradiusSz = StyleUtils.cleanDecimalZeros(pieradiusSz, 1);
        if (this.pieRadiusSize.isPixelUnit()) {
            pieradiusSz = String.valueOf((int)this.pieRadiusSize.getValue());
        }
        String xmlDef = "<?xml version=\"1.0\" ?>\n";
        xmlDef = xmlDef + "<AdvancedStyle>\n   <PieChartStyle";
        xmlDef = xmlDef + " pieradius=\"" + pieradiusSz + pieradiusUnit + "\"";
        if (this.strokeColor != null && (this.strokeColor.getRed() != 0 || this.strokeColor.getGreen() != 0 || this.strokeColor.getBlue() != 0 || this.strokeColor.getAlpha() != 255)) {
            String stroke = " stroke=\"" + StyleUtils.getHexidecimalString(this.strokeColor) + "\"";
            int alpha = this.strokeColor.getAlpha();
            if (alpha < 255) {
                stroke = stroke + " stroke-opacity=\"" + alpha + "\"";
            }
            xmlDef = xmlDef + stroke;
        }
        xmlDef = xmlDef + ">\n";
        if (this.pieSlices != null) {
            for (int i = 0; i < this.pieSlices.length; ++i) {
                PieSliceInfo _psi = this.pieSlices[i];
                xmlDef = xmlDef + "       <PieSlice name=\"" + XMLUtil.replaceXMLEntities(_psi.name) + "\"";
                if (_psi.color != null) {
                    xmlDef = xmlDef + " color=\"" + StyleUtils.getHexidecimalString(_psi.color) + "\"";
                }
                xmlDef = xmlDef + " />\n";
            }
        }
        xmlDef = xmlDef + "   </PieChartStyle>\n</AdvancedStyle>\n";
        return xmlDef;
    }

    public void setPieRadius(int pieRadius) {
        this.pieRadiusSize.setValue(pieRadius);
    }

    public void setPieRadius(double pieRadius) {
        this.pieRadiusSize.setValue(pieRadius);
    }

    public int getPieRadius() {
        return (int)this.pieRadiusSize.getValue();
    }

    public double getDoublePieRadius() {
        return this.pieRadiusSize.getValue();
    }

    public String getPieRadiusUnit() {
        return this.pieRadiusSize.getUnit();
    }

    public void setPieRadiusUnit(String unit) {
        this.pieRadiusSize.setUnit(unit);
    }

    public void setNumSlices(int numSlices) {
        this.numSlices = numSlices;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    public void setPieSlices(PieSliceInfo[] pieSlices) {
        this.pieSlices = pieSlices;
    }

    public PieSliceInfo[] getPieSlices() {
        return this.pieSlices;
    }

    public PieSliceInfo getPieSlice(int index) {
        return this.pieSlices != null ? this.pieSlices[index] : null;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor == null ? Color.black : strokeColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }
}

