/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.AbstractAggregator;
import com.tangosol.util.extractor.AbstractExtractor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.ext.SDataSet;
import oracle.mapviewer.share.ext.SObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.RTree;

public class CoherenceDataProvider
implements SDataProvider {
    public static final String PARAM_CACHENAME = "cacheName";
    public static final String PARAM_KEYATTRIBUTE = "keyAttribute";
    private static final String KEY_INDEX = "oracle.sdovis.CoherenceDataProvider.index";
    private static final String KEY_AREA = "oracle.sdovis.CoherenceDataProvider.area";
    private static final String[] specialKeys = new String[]{"oracle.sdovis.CoherenceDataProvider.index", "oracle.sdovis.CoherenceDataProvider.area"};
    protected static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected RTree index = null;
    protected Area cachedArea = null;
    protected NamedCache cache = null;
    protected String keyAttribute = null;
    protected SDataProvider provider = null;

    public CoherenceDataProvider() {
        this(null);
    }

    public CoherenceDataProvider(SDataProvider provider) {
        this.provider = provider;
    }

    @Override
    public String[] getInitParameterNames() {
        String[] pn;
        ArrayList<String> names = new ArrayList<String>(1);
        if (this.provider != null && (pn = this.provider.getInitParameterNames()) != null) {
            for (String n : pn) {
                names.add(n);
            }
        }
        names.add(PARAM_CACHENAME);
        names.add(PARAM_KEYATTRIBUTE);
        return names.toArray(new String[names.size()]);
    }

    @Override
    public String[] getRuntimeParameterNames() {
        if (this.provider != null) {
            return this.provider.getRuntimeParameterNames();
        }
        return null;
    }

    @Override
    public String getRuntimeParameterHintValue(String runtimeParam) {
        if (this.provider != null) {
            return this.provider.getRuntimeParameterHintValue(runtimeParam);
        }
        return null;
    }

    @Override
    public Field[] getAttributeList(Properties params) {
        if (this.provider != null) {
            return this.provider.getAttributeList(params);
        }
        return null;
    }

    @Override
    public Rectangle2D getDataExtents(Properties params) {
        if (this.provider != null) {
            return this.provider.getDataExtents(params);
        }
        Rectangle2D mbr = null;
        if (this.cachedArea != null) {
            mbr = this.cachedArea.getBounds2D();
        }
        return mbr;
    }

    @Override
    public void clearCache() {
        if (this.provider != null) {
            this.provider.clearCache();
        }
        this.cache.clear();
    }

    @Override
    public boolean canBuildSpatialIndex() {
        return true;
    }

    @Override
    public boolean buildSpatialIndex(Properties params) {
        this.index = new RTree(2, 8, 1);
        if (this.cache != null && this.cache.size() > 0) {
            block2: for (Object e : this.cache.keySet()) {
                String id = (String)e;
                for (String specialKey : specialKeys) {
                    if (id.equals(specialKey)) continue block2;
                }
                SSObject so = (SSObject)this.cache.get((Object)id);
                JGeometry geom = so.geom.getGeometry();
                try {
                    this.index.addEntry(CoherenceDataProvider.getSpan(geom), (Object)id);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.cache.put((Object)KEY_INDEX, (Object)this.index);
        }
        return true;
    }

    @Override
    public String[] getParametersToQuerySpatialMetadata() {
        if (this.provider != null) {
            return this.provider.getParametersToQuerySpatialMetadata();
        }
        return null;
    }

    @Override
    public String[][] getSpatialTables(Properties params) {
        if (this.provider != null) {
            return this.provider.getSpatialTables(params);
        }
        return null;
    }

    @Override
    public boolean init(Properties params) {
        if (params == null) {
            return false;
        }
        String cacheName = params.getProperty(PARAM_CACHENAME);
        if (cacheName == null || cacheName.trim().isEmpty()) {
            log.fine("Init properties does not define \"cacheName\" parameter.");
            return false;
        }
        this.keyAttribute = params.getProperty(PARAM_KEYATTRIBUTE);
        if (this.provider != null && (this.keyAttribute == null || this.keyAttribute.trim().isEmpty())) {
            this.keyAttribute = null;
            log.fine("Init properties does not define \"keyAttribute\" parameter.");
            return false;
        }
        CacheFactory.ensureCluster();
        this.cache = CacheFactory.getCache((String)cacheName);
        try {
            this.index = (RTree)this.cache.get((Object)KEY_INDEX);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.cachedArea = new Area((Shape)this.cache.get((Object)KEY_AREA));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.index == null) {
            this.buildSpatialIndex(null);
        }
        return true;
    }

    @Override
    public boolean destroy() {
        this.cache.release();
        if (this.provider != null) {
            this.provider.destroy();
        }
        return true;
    }

    @Override
    public SDataSet buildDataSet(Rectangle2D queryWin, String[] nonSpatialColumns, String queryCondition, Object[] bindingParameters, Properties params) {
        SDataSet dataSet = new SDataSet();
        TreeSet<String> IDsFromCache = new TreeSet<String>();
        Area loadingArea = new Area(queryWin);
        if (this.cachedArea != null) {
            loadingArea.intersect(this.cachedArea);
        }
        if (!loadingArea.isEmpty()) {
            List<Rectangle2D> recs = CoherenceDataProvider.areaToRectangles(loadingArea);
            for (Rectangle2D rect : recs) {
                ArrayList found = new ArrayList(this.index.getEntryCount());
                if (!this.index.search(CoherenceDataProvider.getSpan(rect), found)) continue;
                for (Object o : found) {
                    IDsFromCache.add((String)o);
                }
            }
            Map results = this.cache.getAll(IDsFromCache);
            for (Object o : results.values()) {
                SSObject so = (SSObject)o;
                SObject obj = new SObject(so.geom.getGeometry(), so.attributes);
                dataSet.addObject(obj);
            }
        }
        if (this.provider != null) {
            loadingArea = new Area(queryWin);
            if (this.cachedArea != null) {
                loadingArea.subtract(this.cachedArea);
            }
            if (!loadingArea.isEmpty()) {
                boolean saveIndex = false;
                List<Rectangle2D> recs = CoherenceDataProvider.areaToRectangles(loadingArea);
                for (Rectangle2D rect : recs) {
                    SDataSet ds = this.provider.buildDataSet(rect, nonSpatialColumns, queryCondition, bindingParameters, params);
                    if (ds == null) continue;
                    for (int i = 0; i < ds.getSize(); ++i) {
                        SObject obj = ds.getObject(i);
                        Field[] attrs = obj.getAtttributes();
                        String key = null;
                        for (Field f : attrs) {
                            if (!f.getName().equalsIgnoreCase(this.keyAttribute)) continue;
                            key = f.toString();
                            break;
                        }
                        if (key == null) {
                            log.fine("No key attribute found in feature, skipping");
                            continue;
                        }
                        if (IDsFromCache.contains(key)) continue;
                        JGeometry geom = (JGeometry)obj.getObject();
                        SSObject so = new SSObject(new JGeometryPOF(geom), obj.getAtttributes());
                        try {
                            this.index.addEntry(CoherenceDataProvider.getSpan(geom), (Object)key);
                            saveIndex = true;
                            this.cache.put((Object)key, (Object)so);
                            IDsFromCache.add(key);
                            dataSet.addObject(obj);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (saveIndex) {
                    this.cache.put((Object)KEY_INDEX, (Object)this.index);
                }
                if (this.cachedArea == null) {
                    this.cachedArea = new Area();
                }
                this.cachedArea.add(loadingArea);
                this.saveCachedArea();
            }
        }
        return dataSet;
    }

    private Object saveCachedArea() {
        return this.cache.put((Object)KEY_AREA, (Object)AffineTransform.getTranslateInstance(0.0, 0.0).createTransformedShape(this.cachedArea));
    }

    private Area getCachedArea() {
        return new Area((Shape)this.cache.get((Object)KEY_AREA));
    }

    private static double[][] getSpan(JGeometry geom) {
        return CoherenceDataProvider.getSpan(CoherenceDataProvider.getRectangleMBR(geom));
    }

    private static double[][] getSpan(Rectangle2D mbr) {
        double[][] span = new double[][]{new double[2], new double[2]};
        span[0][0] = mbr.getMinX();
        span[0][1] = mbr.getMaxX();
        span[1][0] = mbr.getMinY();
        span[1][1] = mbr.getMaxY();
        return span;
    }

    private static Rectangle2D getRectangleMBR(JGeometry geom) {
        double[] mbr = geom.getMBR();
        return new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
    }

    private static List<Rectangle2D> areaToRectangles(Area area) {
        TreeSet<Double> xCoords = new TreeSet<Double>();
        TreeSet<Double> yCoords = new TreeSet<Double>();
        if (area != null && !area.isEmpty()) {
            PathIterator pi = area.getPathIterator(null);
            double[] coords = new double[6];
            while (!pi.isDone()) {
                pi.currentSegment(coords);
                xCoords.add(coords[0]);
                yCoords.add(coords[1]);
                pi.next();
            }
        }
        int numX = xCoords.size();
        int numY = yCoords.size();
        ArrayList<Rectangle2D> rectangles = new ArrayList<Rectangle2D>((numX - 1) * (numY - 1));
        if (numX >= 2 && numY >= 2) {
            Double[] xs = xCoords.toArray(new Double[numX]);
            Double[] ys = yCoords.toArray(new Double[numY]);
            Rectangle2D[][] recs = new Rectangle2D[numX - 1][numY - 1];
            for (int i = 0; i < numX - 1; ++i) {
                for (int j = 0; j < numY - 1; ++j) {
                    Rectangle2D.Double rectangle = new Rectangle2D.Double(xs[i], ys[j], xs[i + 1] - xs[i], ys[j + 1] - ys[j]);
                    if (!area.contains(rectangle.getCenterX(), rectangle.getCenterY())) continue;
                    recs[i][j] = rectangle;
                    rectangles.add(rectangle);
                }
            }
        }
        return rectangles;
    }

    @Override
    public String getGlobalDataDirectory() {
        return null;
    }

    @Override
    public void setGlobalDataDirectory(String dir) {
    }

    private static class SSObject
    implements Serializable {
        static final long serialVersionUID = 0L;
        public JGeometryPOF geom = null;
        public Field[] attributes = null;

        public SSObject() {
        }

        public SSObject(JGeometryPOF geom, Field[] attrs) {
            this.geom = geom;
            this.attributes = attrs;
        }
    }

    private static class JGeometryPOF
    implements PortableObject,
    Serializable {
        static final long serialVersionUID = 0L;
        public static final int IDX_GTYPE = 0;
        public static final int IDX_SRID = 1;
        public static final int IDX_ELEMINFO = 2;
        public static final int IDX_ORDINATES = 3;
        public static final int IDX_MBR = 4;
        private JGeometry geom = null;

        public JGeometryPOF() {
        }

        public JGeometryPOF(JGeometry geom) {
            this.geom = geom;
        }

        public JGeometry getGeometry() {
            return this.geom;
        }

        public void readExternal(PofReader in) throws IOException {
            int gtype = in.readInt(0);
            int srid = in.readInt(1);
            int[] elemInfo = in.readIntArray(2);
            double[] ordinates = in.readDoubleArray(3);
            this.geom = new JGeometry(gtype, srid, elemInfo, ordinates);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(0, this.geom.getType());
            out.writeInt(1, this.geom.getSRID());
            out.writeIntArray(2, this.geom.getElemInfo());
            out.writeDoubleArray(3, this.geom.getOrdinatesArray());
            out.writeDoubleArray(4, this.geom.getMBR());
        }
    }

    private static class IndexMapAggregator
    extends AbstractAggregator {
        private transient Map<String, Rectangle2D> map;

        public IndexMapAggregator() {
            this((ValueExtractor)new AbstractExtractor(){

                public Object extractFromEntry(Map.Entry entry) {
                    String id = (String)entry.getKey();
                    SSObject obj = (SSObject)entry.getValue();
                    JGeometry geom = obj.geom.getGeometry();
                    double[] mbr = geom.getMBR();
                    Hashtable<String, Rectangle2D.Double> map = new Hashtable<String, Rectangle2D.Double>(1);
                    map.put(id, new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]));
                    return map;
                }
            });
        }

        public IndexMapAggregator(ValueExtractor valueExtractor) {
            super(valueExtractor);
        }

        public IndexMapAggregator(String propertyName) {
            super(propertyName);
        }

        protected void init(boolean isFinal) {
            this.map = new Hashtable<String, Rectangle2D>();
        }

        protected void process(Object value, boolean isFinal) {
            if (value != null) {
                Map partial = (Map)value;
                this.map.putAll(partial);
            }
        }

        protected Object finalizeResult(boolean isFinal) {
            return this.map;
        }
    }

    private static class AreaAggregator
    extends AbstractAggregator {
        static final long serialVersionUID = 0L;
        private transient Area area;

        public AreaAggregator() {
            this(new AreaExtractor());
        }

        public AreaAggregator(ValueExtractor valueExtractor) {
            super(valueExtractor);
        }

        public AreaAggregator(String propertyName) {
            super(propertyName);
        }

        protected void init(boolean isFinal) {
            this.area = new Area();
        }

        protected void process(Object value, boolean isFinal) {
            if (value != null) {
                this.area.add(new Area((Shape)value));
            }
        }

        protected Object finalizeResult(boolean isFinal) {
            return AffineTransform.getTranslateInstance(0.0, 0.0).createTransformedShape(this.area);
        }
    }

    private static class AreaExtractor
    implements ValueExtractor,
    Serializable {
        static final long serialVersionUID = 0L;

        public Object extract(Object obj) {
            JGeometry geom = (JGeometry)obj;
            return AffineTransform.getTranslateInstance(0.0, 0.0).createTransformedShape(new Area(CoherenceDataProvider.getRectangleMBR(geom)));
        }
    }
}

