/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.LegendColumn;
import oracle.sdovis.LegendEntry;
import oracle.sdovis.StyleCache;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.theme.ThemeDefinition;

public class Legend {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String NORTH = "NORTH";
    public static final String EAST = "EAST";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String NORTH_EAST = "NORTH_EAST";
    public static final String SOUTH_EAST = "SOUTH_EAST";
    public static final String SOUTH_WEST = "SOUTH_WEST";
    public static final String NORTH_WEST = "NORTH_WEST";
    public static final String CENTER = "CENTER";
    public static final int S = 0;
    public static final int M = 1;
    public static final int L = 2;
    Vector cols = new Vector(2);
    String[] POSITIONS = new String[]{"NORTH", "EAST", "SOUTH", "WEST", "NORTH_EAST", "SOUTH_EAST", "SOUTH_WEST", "NORTH_WEST", "CENTER"};
    LegendColumn currentLC = null;
    Color background = Color.white;
    Color borderColor = Color.black;
    Color textColor = Color.black;
    int borderWidth = 1;
    String position = "SOUTH_WEST";
    Point location = null;
    String fontFamily = null;
    public int profile = 1;
    int offset_x = 10;
    int offset_y = 10;
    String[] themes = null;

    public Legend() {
    }

    public Legend(int prof) {
        if (prof < 0 || prof > 2) {
            throw new IllegalArgumentException("Invalid legend profile");
        }
        this.profile = prof;
    }

    public int getOffsetX() {
        return this.offset_x;
    }

    public void setOffsetX(int offx) {
        this.offset_x = offx;
    }

    public int getOffsetY() {
        return this.offset_y;
    }

    public void setOffsetY(int offy) {
        this.offset_y = offy;
    }

    public void setProfile(int p) {
        if (p < 0 || p > 2) {
            throw new IllegalArgumentException("Invalid legend profile");
        }
        this.profile = p;
    }

    public int getProfile() {
        return this.profile;
    }

    public void setPositionHint(String pos) {
        boolean valid = false;
        for (int i = 0; i < this.POSITIONS.length; ++i) {
            if (!this.POSITIONS[i].equals(pos)) continue;
            valid = true;
            break;
        }
        if (valid) {
            this.position = pos;
        } else {
            log.severe("Invalid legend positioning hint given.");
        }
    }

    public String getPositionHint() {
        return this.position;
    }

    public int getNumColumns() {
        return this.cols.size();
    }

    public LegendColumn getCurrentLegendColumn() {
        return this.currentLC;
    }

    public LegendColumn addColumn() {
        this.currentLC = new LegendColumn(this);
        this.cols.add(this.currentLC);
        return this.currentLC;
    }

    public void setFontFamily(String family) {
        this.fontFamily = family;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBorderWidth(int w) {
        this.borderWidth = Math.max(1, w);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setTextColor(Color c) {
        this.textColor = c;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public LegendEntry setTitle(String title) {
        return this.currentLC.setTitle(title);
    }

    public void addEntry(LegendEntry le) {
        this.currentLC.addEntry(le);
    }

    public LegendEntry addStyle(String styleName, String shortDesc) {
        return this.currentLC.addStyle(styleName, shortDesc);
    }

    public void addSeparator() {
        this.currentLC.addSeparator();
    }

    public void deleteAllEntries() {
        for (int i = 0; i < this.cols.size(); ++i) {
            LegendColumn col = (LegendColumn)this.cols.get(i);
            col.deleteAllEntries();
        }
    }

    public void deleteAllColumns() {
        this.cols.removeAllElements();
    }

    public void destroy() {
        for (int i = 0; i < this.cols.size(); ++i) {
            LegendColumn col = (LegendColumn)this.cols.get(i);
            col.destroy();
        }
        this.cols.removeAllElements();
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void prepare(VisContext vc) {
        if (this.cols.size() > 0) {
            for (int i = 0; i < this.cols.size(); ++i) {
                LegendColumn col = (LegendColumn)this.cols.get(i);
                col.prepare(vc);
            }
        } else if (this.themes != null && this.themes.length > 0 && vc != null && vc.getMasterDataSourceName() != null) {
            StyleCache sc = DSManager.getStyleCache(vc.getMasterDataSourceName());
            if (vc.getTemporaryStyleCache() != null) {
                sc = vc.getTemporaryStyleCache();
            }
            if (sc == null) {
                return;
            }
            ThemeCache tCache = null;
            AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(vc.getMasterDataSourceName());
            tCache = ads.getThemeCache();
            if (tCache == null) {
                return;
            }
            ArrayList<ThemeDefinition> themeDefs = new ArrayList<ThemeDefinition>();
            for (int i = 0; i < this.themes.length; ++i) {
                Theme theme = null;
                ThemeDefinition themeDef = null;
                if (vc.getThemeList() != null) {
                    for (int j = 0; j < vc.getThemeList().size(); ++j) {
                        Theme th = vc.getThemeList().getTheme(j);
                        if (!th.getName().equalsIgnoreCase(this.themes[i])) continue;
                        theme = th;
                        themeDef = theme.getDefinition();
                        break;
                    }
                }
                if (themeDef == null) {
                    themeDef = tCache.getOrLoadThemeDefinition(this.themes[i]);
                }
                if (themeDef == null) continue;
                themeDefs.add(themeDef);
            }
            if (themeDefs.size() > 0) {
                ThemeDefinition[] tdefs = new ThemeDefinition[themeDefs.size()];
                for (int i = 0; i < themeDefs.size(); ++i) {
                    tdefs[i] = (ThemeDefinition)themeDefs.get(i);
                }
                this.prepare(tdefs, vc);
            }
        }
    }

    public void prepare(ThemeDefinition[] themeDef, VisContext vc) {
        if (themeDef == null || themeDef.length == 0 || vc == null) {
            return;
        }
        StyleCache sc = DSManager.getStyleCache(vc.getMasterDataSourceName());
        if (vc.getTemporaryStyleCache() != null) {
            sc = vc.getTemporaryStyleCache();
        }
        if (sc == null) {
            return;
        }
        this.cols.clear();
        int itemsPerColumn = 5;
        int itemCount = 0;
        Hashtable<String, Boolean> usedStyles = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> usedAdvStyles = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> usedLabelStyles = new Hashtable<String, Boolean>();
        for (int i = 0; i < themeDef.length; ++i) {
            usedStyles.clear();
            String[] renderStyles = themeDef[i].getRenderingStyles();
            if (renderStyles == null || renderStyles.length == 0) continue;
            for (int j = 0; j < renderStyles.length; ++j) {
                Style style = sc.get(renderStyles[j]);
                if (style == null || (!(style instanceof AdvancedStyle) ? usedStyles.get(renderStyles[j].toUpperCase()) != null : usedAdvStyles.get(renderStyles[j].toUpperCase()) != null)) continue;
                if (itemCount == itemsPerColumn) {
                    itemCount = 0;
                    this.addColumn();
                }
                if (this.getCurrentLegendColumn() == null) {
                    this.addColumn();
                }
                String label = themeDef[i].getName();
                String description = themeDef[i].getDescription();
                if (style instanceof AdvancedStyle) {
                    label = null;
                } else if (description != null && description.trim().length() > 0) {
                    label = description.trim();
                }
                LegendEntry le = this.addStyle(renderStyles[j], label);
                le.addTab();
                ++itemCount;
                if (style instanceof AdvancedStyle) {
                    usedAdvStyles.put(renderStyles[j].toUpperCase(), new Boolean(true));
                    continue;
                }
                usedStyles.put(renderStyles[j].toUpperCase(), new Boolean(true));
            }
            String[] labelStyles = themeDef[i].getLabelingStyles();
            if (labelStyles == null || labelStyles.length == 0) continue;
            for (int j = 0; j < labelStyles.length; ++j) {
                Style style = sc.get(labelStyles[j]);
                if (style == null || style instanceof StyleText || usedLabelStyles.get(labelStyles[j].toUpperCase()) != null || style instanceof AdvancedStyle && usedAdvStyles.get(labelStyles[j].toUpperCase()) != null) continue;
                if (itemCount == itemsPerColumn) {
                    itemCount = 0;
                    this.addColumn();
                }
                if (this.getCurrentLegendColumn() == null) {
                    this.addColumn();
                }
                String label = labelStyles[j];
                String description = style.getModel().getDescription();
                if (style instanceof AdvancedStyle) {
                    label = null;
                } else if (description != null && description.trim().length() > 0) {
                    label = description.trim();
                }
                LegendEntry le = this.addStyle(labelStyles[j], label);
                le.addTab();
                ++itemCount;
                usedLabelStyles.put(labelStyles[j].toUpperCase(), new Boolean(true));
            }
        }
        if (this.getNumColumns() < 1) {
            return;
        }
        this.prepare(vc);
    }

    public Rectangle2D computeMBR() {
        int gap = 3;
        double accuW = gap;
        double maxH = gap;
        for (int i = 0; i < this.cols.size(); ++i) {
            LegendColumn col = (LegendColumn)this.cols.get(i);
            Rectangle2D mbr = col.getMBR();
            accuW += mbr.getWidth() + (double)gap;
            if (!(maxH < mbr.getHeight())) continue;
            maxH = mbr.getHeight();
        }
        Rectangle2D.Double max = new Rectangle2D.Double(0.0, 0.0, accuW, maxH + (double)(2 * gap));
        return max;
    }

    public void paint(Graphics2D g2, int sx, int sy) {
        int gap = 3;
        Rectangle2D max = this.computeMBR();
        if (this.background != null) {
            g2.setColor(this.background);
            g2.fillRect(sx, sy, (int)max.getWidth(), (int)max.getHeight());
        }
        g2.translate(sx, sy);
        g2.setColor(this.textColor);
        int x = gap;
        int y = gap;
        for (int i = 0; i < this.cols.size(); ++i) {
            LegendColumn col = (LegendColumn)this.cols.get(i);
            col.paint(g2, x, y);
            Rectangle2D mbr = col.getMBR();
            x = (int)((double)x + (mbr.getWidth() + (double)gap));
        }
        g2.setColor(this.borderColor);
        g2.setStroke(new BasicStroke());
        g2.translate(-sx, -sy);
        g2.drawRect(sx, sy, (int)max.getWidth(), (int)max.getHeight());
    }

    public Rectangle2D getMBR() {
        return this.computeMBR();
    }

    public LegendColumn getColumn(int i) {
        if (i >= this.cols.size()) {
            return null;
        }
        return (LegendColumn)this.cols.get(i);
    }

    public void setLocation(Point loc) {
        this.location = loc;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setThemes(String[] themes) {
        this.themes = themes;
    }

    public String[] getThemes() {
        return this.themes;
    }
}

