/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMSMapTheme;

public class LoadThemeData
extends Thread {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    Theme mTheme = null;
    Rectangle2D mQueryWin = null;
    VisContext vc = null;
    long reqTimeout = 0L;
    Exception exception = null;

    public LoadThemeData(Theme mt, Rectangle2D mqw, VisContext vc) {
        this.mTheme = mt;
        this.mQueryWin = mqw;
        this.vc = vc;
        this.reqTimeout = mt instanceof WMSMapTheme || mt instanceof MapCacheTheme ? mt.getDecorator().getRequestTimeout() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.finer("LoadThemeData running thread: " + Thread.currentThread().getName());
        try {
            this.mTheme.prepareData(this.mQueryWin, this.vc);
            this.mTheme.postPreparation(this.vc);
        }
        catch (OutOfMemoryError om) {
            log.severe("Out of memory error while preparing " + this.mTheme.getName() + " : " + om.getMessage());
            if (this.vc != null) {
                this.vc.setDataException(new DataException("Out of memory."));
            }
        }
        catch (DataException de) {
            if (de.isAbortedByUser()) {
                log.log(Level.FINEST, "Theme " + this.mTheme.getName() + " is aborted per user's request.", de);
            } else {
                this.exception = de;
                if (this.vc != null) {
                    this.vc.setDataException(de);
                }
                log.log(Level.SEVERE, "Exception fetching data for theme " + this.mTheme.getName() + ".", de);
            }
        }
        finally {
            try {
                this.mTheme.getDecorator().setPrepared(true);
            }
            catch (Exception npe) {}
            this.mTheme = null;
            this.vc = null;
        }
    }
}

