/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ext.NSDataProvider;
import oracle.mapviewer.share.ext.NSDataSet;
import oracle.mapviewer.share.ext.NSRow;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NSDataProviderDefault
implements NSDataProvider {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    @Override
    public boolean init(Properties params) {
        return true;
    }

    @Override
    public NSDataSet buildDataSet(Hashtable params) {
        String file = (String)params.get("file");
        if (file != null) {
            return this.readFromFile(file);
        }
        String url = (String)params.get("url");
        if (url != null) {
            return this.readFromUrl(url);
        }
        String data = (String)params.get("xml");
        if (data != null) {
            return this.buildFromXml(data);
        }
        String xmlUrl = (String)params.get("xml_url");
        if (xmlUrl != null) {
            return this.buildFromXmlUrl(xmlUrl);
        }
        String xmlFile = (String)params.get("xml_file");
        if (xmlFile != null) {
            return this.buildFromXmlFile(xmlFile);
        }
        log.severe("Must supply either 'file', 'url', or 'xml' for default NS data provider.");
        return null;
    }

    @Override
    public void destroy() {
    }

    protected NSDataSet getDataFromReader(BufferedReader in) throws IOException {
        String[] colNames = null;
        String line = in.readLine();
        String delimiter = line.substring(0, 1);
        if (line.length() > 2 && (line = line.substring(2)) != null && line.length() > 1) {
            colNames = line.split(delimiter);
        }
        Vector<NSRow> rows = new Vector<NSRow>();
        while ((line = in.readLine()) != null) {
            NSRow row = this.buildRow(line, delimiter, colNames);
            if (row == null) continue;
            rows.add(row);
        }
        NSDataSet res = new NSDataSet(rows);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NSDataSet readFromFile(String file) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            NSDataSet nSDataSet = this.getDataFromReader(in);
            return nSDataSet;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            NSDataSet nSDataSet = null;
            return nSDataSet;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NSDataSet readFromUrl(String url) {
        BufferedReader in = null;
        InputStream is = null;
        try {
            URL u = new URL(url);
            is = u.openStream();
            InputStreamReader isr = new InputStreamReader(u.openStream());
            in = new BufferedReader(isr);
            NSDataSet nSDataSet = this.getDataFromReader(in);
            return nSDataSet;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            NSDataSet nSDataSet = null;
            return nSDataSet;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected NSRow buildRow(String line, String delimiter, String[] colNames) {
        if (line == null || line.length() < 1) {
            return null;
        }
        String[] fields = line.split(delimiter);
        if (fields == null || fields.length == 0) {
            return null;
        }
        Field[] row = new Field[fields.length];
        Field a = new Field(fields[0]);
        a.setKey(true);
        if (colNames != null && colNames.length > 0) {
            a.setName(colNames[0]);
        }
        row[0] = a;
        for (int i = 1; i < fields.length; ++i) {
            try {
                double d = Double.parseDouble(fields[i]);
                a = new Field(d);
                if (colNames != null && colNames.length > i) {
                    a.setName(colNames[i]);
                }
                row[i] = a;
                continue;
            }
            catch (Exception e) {
                log.warning("invalid row field (key=" + fields[0] + ")");
                return null;
            }
        }
        return new NSRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NSDataSet buildFromXml(String doc) {
        log.finest("Beginning of NSDP XML:\n" + doc);
        log.finest("\nEnd of NSDP XML.");
        try (XMLDOMParser parser = null;){
            parser = new XMLDOMParser();
            if (!parser.parse(doc)) {
                log.warning("Cannot parse the nsdp xml data document.");
                NSDataSet nSDataSet = null;
                return nSDataSet;
            }
            Node root = parser.getElementNode("nsdp_xml");
            if (root == null) {
                log.warning("root node <nsdp_xml> not found in xml doc.");
                NSDataSet nSDataSet = null;
                return nSDataSet;
            }
            String meta = XMLDOMParser.getAttribute(root, "meta");
            Node rrnode = XMLDOMParser.getSubElement(root, "rendering");
            RenderingRule[] rr = null;
            if (rrnode != null) {
                rr = StylingRule.getRenderRules(parser, rrnode);
            }
            Node table = XMLDOMParser.getSubElement(root, "table");
            ArrayList rows = XMLDOMParser.getSubElements(table, "tr");
            Node ths = (Node)rows.get(0);
            ArrayList heads = XMLDOMParser.getSubElements(ths, "th");
            if (heads == null || heads.size() == 0) {
                log.warning("must specify column headings using <th> element as first row.");
                NSDataSet nSDataSet = null;
                return nSDataSet;
            }
            String[] columnHeaderIDs = new String[heads.size()];
            String[] columnHeaderNames = new String[heads.size()];
            String[] types = new String[heads.size()];
            for (int i = 0; i < heads.size(); ++i) {
                Node th = (Node)heads.get(i);
                columnHeaderNames[i] = XMLDOMParser.getElementValue(th);
                columnHeaderIDs[i] = columnHeaderNames[i];
                String type = XMLDOMParser.getAttribute(th, "type");
                if (type == null) {
                    type = i > 0 ? "number" : "string";
                }
                types[i] = type;
                String id = XMLDOMParser.getAttribute(th, "id");
                if (id == null || id.length() <= 0) continue;
                columnHeaderIDs[i] = id;
            }
            Vector<NSRow> res = new Vector<NSRow>();
            for (int i = 1; i < rows.size(); ++i) {
                Node row = (Node)rows.get(i);
                NSRow dataRow = this.getRowFromXML(parser, row, columnHeaderIDs, columnHeaderNames, types);
                if (dataRow == null) continue;
                res.add(dataRow);
            }
            NSDataSet ds = new NSDataSet(res);
            if (rr != null) {
                ds.setCustomRenderingRules(rr);
            }
            if (meta != null && meta.length() > 0) {
                ds.setMetadata(meta);
            }
            NSDataSet nSDataSet = ds;
            return nSDataSet;
        }
    }

    protected NSRow getRowFromXML(XMLDOMParser parser, Node row, String[] columnHeadIDs, String[] columnHeaderNames, String[] types) {
        ArrayList cols = XMLDOMParser.getSubElements(row, "td");
        Field[] fs = new Field[cols.size()];
        for (int i = 0; i < fs.length; ++i) {
            try {
                NamedNodeMap attrs;
                Field a = null;
                Node td = (Node)cols.get(i);
                String col = XMLDOMParser.getElementValue(td);
                String type = types[i];
                if ("number".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type)) {
                    double d = 0.0;
                    if (col != null && col.length() > 0) {
                        try {
                            d = Double.parseDouble(col);
                        }
                        catch (Exception ex) {
                            log.warning("cannot parse numeric cell value.");
                        }
                        a = new Field(d);
                    } else {
                        a = new Field();
                        a.setNoData();
                    }
                } else if ("integer".equalsIgnoreCase(type)) {
                    long l = 0L;
                    if (col != null && col.length() > 0) {
                        try {
                            l = Long.parseLong(col);
                        }
                        catch (Exception ex) {
                            log.warning("cannot parse numeric cell value.");
                        }
                        a = new Field(l);
                    } else {
                        a = new Field();
                        a.setNoData();
                    }
                } else if (col == null) {
                    a = new Field();
                    a.setNoData();
                } else {
                    a = new Field(col);
                }
                if (i == 0) {
                    a.setKey(true);
                    if (a.isNoData()) {
                        log.warning("NSDP key column contains NODATA!");
                    }
                }
                if (columnHeadIDs != null && columnHeadIDs.length > i) {
                    a.setName(columnHeadIDs[i]);
                }
                if (columnHeaderNames != null && columnHeaderNames.length > i) {
                    a.setDisplayName(columnHeaderNames[i]);
                }
                if ((attrs = td.getAttributes()) != null && attrs.getLength() > 0) {
                    String[] c = new String[attrs.getLength() * 2];
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        Node v = attrs.item(k);
                        c[k * 2] = v.getNodeName();
                        c[k * 2 + 1] = v.getNodeValue();
                    }
                    a.setContexts(c);
                }
                fs[i] = a;
                continue;
            }
            catch (Exception e) {
                log.warning("invalid row  (key=" + fs[0] + ")");
                log.log(Level.WARNING, "exception when getting a row from XML.", e);
                return null;
            }
        }
        return new NSRow(fs);
    }

    protected NSDataSet buildFromXmlUrl(String url) {
        byte[] bs = Util.readBinaryFromURL(url);
        if (bs != null) {
            try {
                String doc = new String(bs, "UTF-8");
                return this.buildFromXml(doc);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        return null;
    }

    protected NSDataSet buildFromXmlFile(String file) {
        byte[] bs = null;
        try {
            bs = Util.readFile(file);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        if (bs != null) {
            try {
                String doc = new String(bs, "UTF-8");
                return this.buildFromXml(doc);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        return null;
    }
}

