/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class XFViewPort
implements Serializable,
Cloneable {
    boolean strict = false;
    int can_xl = 0;
    int can_yl = 0;
    int can_xh = 0;
    int can_yh = 0;
    int can_bits = 8;
    int can_xoff = 0;
    int can_yoff = 0;
    int scale_axis;
    double zoom_level = 1.0;
    double x_scalef = 1.0;
    double y_scalef = 1.0;
    double rotation = 0.0;
    double dview_xl;
    double dview_yl;
    double dview_xh;
    double dview_yh;
    boolean selecting = false;
    int select_sx = -1;
    int select_sy = -1;
    int select_ex = -1;
    int select_ey = -1;
    double scale_data_x = 1.0;
    double scale_data_y = 1.0;
    AffineTransform affXF;

    public Object clone() throws CloneNotSupportedException {
        XFViewPort obj = (XFViewPort)super.clone();
        if (this.affXF != null) {
            obj.affXF = (AffineTransform)this.affXF.clone();
        }
        return obj;
    }

    public void setStrict(boolean v) {
        this.strict = v;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public boolean forward(Point2D src, Point2D dst) {
        dst.setLocation((src.getX() - this.dview_xl) * this.x_scalef + (double)this.can_xoff, (this.dview_yh - src.getY()) * this.y_scalef + (double)this.can_yoff);
        return true;
    }

    public boolean inverse(Point2D src, Point2D dst) {
        dst.setLocation((src.getX() - (double)this.can_xoff) / this.x_scalef + this.dview_xl, this.dview_yh - (src.getY() - (double)this.can_yoff) / this.y_scalef);
        return true;
    }

    public boolean inverse(int[] src, double[] dst) {
        dst[0] = (double)(src[0] - this.can_xoff) / this.x_scalef + this.dview_xl;
        dst[1] = this.dview_yh - (double)(src[1] - this.can_yoff) / this.y_scalef;
        return true;
    }

    public double getScaleFactor() {
        return this.x_scalef;
    }

    public void setDeviceView(int xlow, int ylow, int xhi, int yhi) {
        this.can_xl = xlow;
        this.can_yl = ylow;
        this.can_xh = xhi;
        this.can_yh = yhi;
        if (this.strict) {
            this.setupXForm2();
        } else {
            this.setupXForm();
        }
    }

    public void setDeviceView(Rectangle2D env) {
        this.setDeviceView((int)env.getMinX(), (int)env.getMinY(), (int)env.getMaxX(), (int)env.getMaxY());
    }

    public void setupXForm() {
        double x_inc = (this.dview_xh - this.dview_xl) * this.scale_data_x;
        double xf = (double)(this.can_xh - this.can_xl - 2) / x_inc;
        double y_inc = this.dview_yh - this.dview_yl;
        double yf = (double)(this.can_yh - this.can_yl - 2) / y_inc;
        if (xf <= yf) {
            this.x_scalef = this.y_scalef = xf;
            this.scale_axis = 0;
            this.can_xoff = this.can_xl + 1;
            this.can_yoff = (int)(((double)(this.can_yh - this.can_yl + 1) - y_inc * xf) / 2.0) + this.can_yl + 1;
        } else {
            this.x_scalef = this.y_scalef = yf;
            this.scale_axis = 1;
            this.can_xoff = (int)(((double)(this.can_xh - this.can_xl + 1) - x_inc * yf) / 2.0) + this.can_xl + 1;
            this.can_yoff = this.can_yl + 1;
        }
        this.setupAffineTransform();
    }

    public void setupAffineTransform() {
        int sx = this.can_xl;
        int sy = this.can_yl;
        int ex = this.can_xh;
        int ey = this.can_yh;
        double rw = this.dview_xh - this.dview_xl;
        double rh = this.dview_yh - this.dview_yl;
        double scale = 0.0;
        double scaleX = (double)(ex - sx) / rw;
        double scaleY = (double)(ey - sy) / rh;
        scale = this.scale_data_x != 1.0 ? scaleY : (scaleX > scaleY ? scaleY : scaleX);
        double tx = (double)sx - this.dview_xl * scale * this.scale_data_x;
        double ty = (double)sy + this.dview_yl * scale;
        this.affXF = new AffineTransform(scale * this.scale_data_x, 0.0, 0.0, -scale, tx += ((double)(ex - sx) - rw * scale * this.scale_data_x) / 2.0, ty += (double)(ey - sy) - ((double)(ey - sy) - rh * scale) / 2.0);
    }

    public void setupXForm2() {
        double x_inc = (this.dview_xh - this.dview_xl) * this.scale_data_x;
        double y_inc = this.dview_yh - this.dview_yl;
        this.x_scalef = (double)(this.can_xh - this.can_xl - 2) / x_inc;
        this.y_scalef = (double)(this.can_yh - this.can_yl - 2) / y_inc;
        this.scale_axis = 0;
        this.can_xoff = this.can_xl + 1;
        this.can_yoff = this.can_yl + 1;
        this.setupAffineTransform2();
    }

    public void setupAffineTransform2() {
        int sx = this.can_xl;
        int sy = this.can_yl;
        int ex = this.can_xh;
        int ey = this.can_yh;
        double rw = this.dview_xh - this.dview_xl;
        double rh = this.dview_yh - this.dview_yl;
        double scaleX = (double)(ex - sx) / rw;
        double scaleY = (double)(ey - sy) / rh;
        double tx = (double)sx - this.dview_xl * scaleX;
        double ty = (double)sy + this.dview_yl * scaleY;
        this.affXF = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx += ((double)(ex - sx) - rw * scaleX) / 2.0, ty += (double)(ey - sy) - ((double)(ey - sy) - rh * scaleY) / 2.0);
    }

    public AffineTransform getAffineTransform() {
        return this.affXF;
    }

    public void setDataScaleOnX(double f) {
        this.scale_data_x = f;
    }

    public void setDataScaleOnY(double f) {
        this.scale_data_y = f;
    }

    public boolean setDataView(double xl, double yl, double xh, double yh) {
        if (xh - xl < 0.0 || yh - yl < 0.0) {
            return false;
        }
        if (xl == xh && yl == yh) {
            xl -= Math.abs(xl) * 0.005;
            yl -= Math.abs(yl) * 0.005;
            xh += Math.abs(xh) * 0.005;
            yh += Math.abs(yl) * 0.005;
        }
        this.dview_xl = xl;
        this.dview_yl = yl;
        this.dview_xh = xh;
        this.dview_yh = yh;
        if (this.strict) {
            this.setupXForm2();
        } else {
            this.setupXForm();
        }
        return true;
    }

    public void setDataView(Rectangle2D env) {
        this.setDataView(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
    }

    public int getDeviceMinX() {
        return this.can_xl;
    }

    public int getDeviceMinY() {
        return this.can_yl;
    }

    public int getDeviceMaxX() {
        return this.can_xh;
    }

    public int getDeviceMaxY() {
        return this.can_yh;
    }

    public int getDeviceOffsetX() {
        return this.can_xoff;
    }

    public int getDeviceOffsetY() {
        return this.can_yoff;
    }

    public int getScaleAxis() {
        return this.scale_axis;
    }

    public void printAll() {
        System.out.println("XFViewPort:");
        System.out.println("device_view=(" + this.can_xl + "," + this.can_yl + ", " + this.can_xh + "," + this.can_yh + ")");
        System.out.println("data_view=(" + this.dview_xl + "," + this.dview_yl + ", " + this.dview_xh + "," + this.dview_yh + ")");
        System.out.println("dev_off=(" + this.can_xoff + "," + this.can_yoff + ")");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("XFViewPort:").append("device_view=(" + this.can_xl + "," + this.can_yl + ", " + this.can_xh + "," + this.can_yh + ") ");
        sb.append("data_view=(" + this.dview_xl + "," + this.dview_yl + ", " + this.dview_xh + "," + this.dview_yh + ") ");
        sb.append("dev_off=(" + this.can_xoff + "," + this.can_yoff + ")\n" + this.affXF);
        return sb.toString();
    }
}

