/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.edit.session;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.edit.session.EditSessionDescriptor;
import oracle.sdovis.edit.session.store.EditSessionStore;

public class EditSessionCache {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String dsName;
    protected Hashtable editSessions;
    protected int maxSize = 9999;
    protected EditSessionStore editStore = null;

    public EditSessionCache(String dataSrc, EditSessionStore editStore) {
        this.dsName = dataSrc;
        this.editSessions = new Hashtable(37);
        this.editStore = editStore;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public synchronized EditSessionDescriptor getOrLoadSessionDefinition(String sessionName, String userName) {
        sessionName = sessionName.toUpperCase();
        CacheEntry ce = (CacheEntry)this.editSessions.get((userName = userName.toUpperCase()) + ":" + sessionName);
        if (ce != null) {
            ce.mark();
            return ce.sessionDef;
        }
        EditSessionDescriptor td = null;
        try {
            td = this.editStore.getEditSession(sessionName, userName);
            this.putSessionDefinition(sessionName, userName, td);
            return td;
        }
        catch (Exception e) {
            log.severe("[datasource:" + this.dsName + "] cannot load edit session " + sessionName + " for user " + userName);
            return null;
        }
    }

    public void putSessionDefinition(String sessionName, String userName, EditSessionDescriptor td) {
        sessionName = sessionName.toUpperCase();
        userName = userName.toUpperCase();
        if (this.editSessions.size() > this.maxSize) {
            this.purge();
        }
        CacheEntry ce = new CacheEntry(td);
        this.editSessions.put(userName + ":" + sessionName, ce);
    }

    public void remove(String sessionName, String userName) {
        sessionName = sessionName.toUpperCase();
        userName = userName.toUpperCase();
        this.editSessions.remove(userName + ":" + sessionName);
    }

    public void removeAll() {
        this.editSessions.clear();
    }

    public void removeUserSessions(String userName) {
        int i;
        if (userName == null) {
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        String[] cachedSessions = this.getCachedSessionNames();
        if (cachedSessions == null || cachedSessions.length == 0) {
            return;
        }
        for (i = 0; i < cachedSessions.length; ++i) {
            if (!cachedSessions[i].startsWith(userName.toUpperCase() + ":")) continue;
            toRemove.add(cachedSessions[i]);
        }
        if (toRemove.size() > 0) {
            for (i = 0; i < toRemove.size(); ++i) {
                this.editSessions.remove(toRemove.get(i));
            }
        }
    }

    private void purge() {
    }

    public String[] getCachedSessionNames() {
        if (this.editSessions == null) {
            return new String[0];
        }
        String[] res = new String[this.editSessions.size()];
        int i = 0;
        Enumeration e = this.editSessions.keys();
        while (e.hasMoreElements()) {
            res[i++] = (String)e.nextElement();
        }
        return res;
    }

    public void setEditStore(EditSessionStore editStore) {
        this.editStore = editStore;
    }

    public EditSessionStore getEditSessionStore() {
        return this.editStore;
    }

    static class CacheEntry {
        EditSessionDescriptor sessionDef;
        long lastUsed;

        public CacheEntry(EditSessionDescriptor _td) {
            this.sessionDef = _td;
            this.lastUsed = System.currentTimeMillis();
        }

        public void mark() {
            this.lastUsed = System.currentTimeMillis();
        }
    }
}

