/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.sam;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import oracle.mapviewer.share.stylex.HeatMapStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.HMPointFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VectorRenderer;
import oracle.sdovis.VisContext;
import oracle.spatial.util.RTree;

public class HeatMapCore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    int gridWidth = 0;
    int gridHeight = 0;
    double minCoordX = 0.0;
    double maxCoordX = 0.0;
    double minCoordY = 0.0;
    double maxCoordY = 0.0;
    Theme dataTheme = null;
    double[][] grid = null;
    double minGridCellValue = 0.0;
    double maxGridCellValue = 0.0;
    double gridCellValueRange = 0.0;
    RTree rTree = null;
    double cellWidth = 0.0;
    double cellHeight = 0.0;
    double spotlightRadiusPx = -1.0;
    VisContext vc = null;
    private static ArrayList emptyList = new ArrayList(1);
    private int method = 1;
    private HeatMapStyleModel styleModel = null;
    static Color TRC = new Color(0, 0, 0, 0);

    public HeatMapCore(int gridWidth, int gridHeight, HeatMapStyleModel model, double spotlightRadius) {
        if (gridWidth <= 0 || gridHeight <= 0) {
            throw new IllegalArgumentException("Invalid grid dimension specified.");
        }
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        try {
            this.grid = new double[gridWidth][gridHeight];
        }
        catch (OutOfMemoryError e) {
            throw new IllegalArgumentException("Out of memory error caused by grid allocation.", e);
        }
        this.styleModel = model;
        this.method = model.getMethod();
        this.spotlightRadiusPx = spotlightRadius;
        if (model.getMethod() != 3 && model.isGlobalCellValueRangeEnforced() && model.getGlobalMaxCellValue(spotlightRadius) < 0.0) {
            double globalMaxGridCellValue = HeatMapCore.estimateGlobalMaxCellValue((int)model.getMaxPointsInSpotlight(), this.spotlightRadiusPx, model);
            model.setGlobalMaxCellValue(globalMaxGridCellValue, spotlightRadius);
        }
    }

    public void setDataTheme(Theme dataTheme, VisContext vc) {
        this.dataTheme = dataTheme;
        this.vc = vc;
        this.rTree = null;
        if (dataTheme != null) {
            if (this.styleModel.getMethod() != 3) {
                this.buildRTree();
            } else {
                this.buildDataLocations();
            }
        }
    }

    public Theme getDataTheme() {
        return this.dataTheme;
    }

    public void setCoordBounds(double minX, double maxX, double minY, double maxY) {
        this.minCoordX = minX;
        this.maxCoordX = maxX;
        this.minCoordY = minY;
        this.maxCoordY = maxY;
        this.cellWidth = (this.maxCoordX - this.minCoordX) / (double)this.gridWidth;
        this.cellHeight = (this.maxCoordY - this.minCoordY) / (double)this.gridHeight;
    }

    public double[] getCoordBounds() {
        return new double[]{this.minCoordX, this.maxCoordX, this.minCoordY, this.maxCoordY};
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    protected double classicBandwidth(int n) {
        return 0.68 * Math.pow(n, -0.2);
    }

    protected static double kEstimate(double x, double y, List pts, double t) {
        double res = 0.0;
        double t2 = t * t;
        for (int i = 0; i < pts.size(); ++i) {
            double yi;
            StyledFeatureI sf = (StyledFeatureI)pts.get(i);
            double xi = sf.getX();
            double dist2 = (xi - x) * (xi - x) + ((yi = sf.getY()) - y) * (yi - y);
            if (dist2 > t2) continue;
            double k1 = 1.0 - dist2 / t2;
            double k2 = k1 * k1;
            double k3 = 3.0 * k2 / (Math.PI * t2);
            res += k3;
        }
        return res;
    }

    protected static double idw(double x, double y, List pts, double t) {
        double dist2;
        double yi;
        double xi;
        double u = 0.0;
        double t2 = t * t;
        HMPointFeature sf = null;
        double den = 0.0;
        for (int j = 0; j < pts.size(); ++j) {
            sf = (HMPointFeature)pts.get(j);
            xi = sf.getX();
            dist2 = (xi - x) * (xi - x) + ((yi = sf.getY()) - y) * (yi - y);
            if (dist2 > t2) continue;
            den += HeatMapCore.wk(x, y, sf, t);
        }
        for (int i = 0; i < pts.size(); ++i) {
            sf = (HMPointFeature)pts.get(i);
            xi = sf.getX();
            dist2 = (xi - x) * (xi - x) + ((yi = sf.getY()) - y) * (yi - y);
            if (dist2 > t2) continue;
            double weight = sf.getWeight();
            double wix = HeatMapCore.wk(x, y, sf, t);
            if (weight == 0.0) {
                weight = 1.0;
            }
            u += wix / den * weight;
        }
        return u;
    }

    protected static double wk(double x, double y, HMPointFeature sf, double t) {
        if (sf == null) {
            return 0.0;
        }
        double res = 0.0;
        double d = (x - sf.getX()) * (x - sf.getX());
        return 1.0 / (d += (y - sf.getY()) * (y - sf.getY()));
    }

    protected void buildRTree() {
        this.rTree = new RTree(2, 100, 5);
        int size = this.dataTheme.size();
        int batchSize = 10000;
        double[][][] mbh = new double[size][][];
        Object[] o = new Object[size];
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            Point2D pt;
            StyledFeatureI sf = this.dataTheme.getStyledFeature(i);
            mbh[i] = new double[2][];
            mbh[i][0] = new double[2];
            mbh[i][1] = new double[2];
            double x = 0.0;
            double y = 0.0;
            if (sf != null && (pt = VectorRenderer.getPointOfPointFeature(sf, this.vc)) != null) {
                x = pt.getX();
                y = pt.getY();
            }
            mbh[i][0][0] = x;
            mbh[i][0][1] = x;
            mbh[i][1][0] = y;
            mbh[i][1][1] = y;
            o[i] = sf;
        }
        try {
            this.rTree.packTree((double[][][])mbh, o);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.rTree = null;
        }
        log.finest("Elapsed time building HeatMap RTree: " + (System.currentTimeMillis() - t0) + " milliseconds for " + size + " geometries");
    }

    protected void buildDataLocations() {
        int size = this.dataTheme.size();
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            StyledFeatureI sf = this.dataTheme.getStyledFeature(i);
            if (sf == null) continue;
            VectorRenderer.getPointOfPointFeature(sf, this.vc);
        }
        log.finest("Elapsed time building HeatMap data locations: " + (System.currentTimeMillis() - t0) + " milliseconds for " + size + " geometries");
    }

    protected ArrayList findNeighbours(double[][] box) {
        if (this.rTree == null) {
            return emptyList;
        }
        ArrayList entries = new ArrayList(250);
        if (this.rTree.search(box, entries)) {
            return entries;
        }
        return emptyList;
    }

    public double[][] computeHeatMap() throws Exception {
        if (this.styleModel.getMethod() == 3) {
            return this.computeGridCounts();
        }
        if (this.maxCoordX - this.minCoordX == 0.0 || this.maxCoordY - this.minCoordY == 0.0) {
            throw new Exception("Must specify valid coordinate bounds first.");
        }
        this.minGridCellValue = Double.POSITIVE_INFINITY;
        this.maxGridCellValue = Double.NEGATIVE_INFINITY;
        int maxNumPointsWithinRadius = 0;
        long t1 = System.currentTimeMillis();
        double t = this.spotlightRadiusPx;
        if (t < 0.0) {
            t = (this.maxCoordY - this.minCoordY) * this.classicBandwidth(this.dataTheme.size());
            t *= 0.55;
        }
        for (int x = 0; x < this.gridWidth; ++x) {
            for (int y = 0; y < this.gridHeight; ++y) {
                int numPts;
                double x_ = this.minCoordX + this.cellWidth * (double)x + this.cellWidth / 2.0;
                double y_ = this.minCoordY + this.cellHeight * (double)y + this.cellHeight / 2.0;
                double[][] box = new double[][]{new double[2], new double[2]};
                box[0][0] = x_ - t;
                box[0][1] = x_ + t;
                box[1][0] = y_ - t;
                box[1][1] = y_ + t;
                ArrayList myPts = this.findNeighbours(box);
                double value = 0.0;
                value = this.method == 2 ? HeatMapCore.idw(x_, y_, myPts, t) : HeatMapCore.kEstimate(x_, y_, myPts, t);
                this.grid[x][y] = value;
                if (this.minGridCellValue > value) {
                    this.minGridCellValue = value;
                }
                if (this.maxGridCellValue < value) {
                    this.maxGridCellValue = value;
                }
                int n = numPts = myPts == null ? 0 : myPts.size();
                if (maxNumPointsWithinRadius >= numPts) continue;
                maxNumPointsWithinRadius = numPts;
            }
        }
        this.gridCellValueRange = this.maxGridCellValue - this.minGridCellValue;
        long t2 = System.currentTimeMillis();
        log.finest("Time spent on computing heat map: " + (t2 - t1) + "ms. Grid size: " + this.gridWidth + " x " + this.gridHeight + ". bandwidth: " + t + ".");
        return this.grid;
    }

    private double[][] computeGridCounts() throws Exception {
        if (this.maxCoordX - this.minCoordX == 0.0 || this.maxCoordY - this.minCoordY == 0.0) {
            throw new Exception("Must specify valid coordinate bounds first.");
        }
        this.minGridCellValue = Double.POSITIVE_INFINITY;
        this.maxGridCellValue = Double.NEGATIVE_INFINITY;
        int size = this.dataTheme.size();
        int gridSampleFactorX = (int)((this.maxCoordX - this.minCoordX) / (double)this.gridWidth);
        int gridSampleFactorY = (int)((this.maxCoordY - this.minCoordY) / (double)this.gridHeight);
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            StyledFeatureI sf = this.dataTheme.getStyledFeature(i);
            Point2D pt = sf.getPoint();
            if (pt == null) continue;
            int x = (int)pt.getX();
            int y = (int)pt.getY();
            if (gridSampleFactorX != 1) {
                x = (int)((pt.getX() - this.minCoordX - this.cellWidth / 2.0) / this.cellWidth);
            }
            if (gridSampleFactorY != 1) {
                y = (int)((pt.getY() - this.minCoordY - this.cellHeight / 2.0) / this.cellHeight);
            }
            if (x < 0 || x >= this.gridWidth || y < 0 || y >= this.gridHeight) continue;
            if (sf instanceof HMPointFeature) {
                double[] dArray = this.grid[x];
                int n = y;
                dArray[n] = dArray[n] + ((HMPointFeature)sf).getWeight();
            }
            if (this.minGridCellValue > this.grid[x][y]) {
                this.minGridCellValue = this.grid[x][y];
            }
            if (!(this.maxGridCellValue < this.grid[x][y])) continue;
            this.maxGridCellValue = this.grid[x][y];
        }
        this.gridCellValueRange = this.maxGridCellValue - this.minGridCellValue;
        long t2 = System.currentTimeMillis();
        log.finest("Time spent on computing heat map grid counts: " + (t2 - t1) + "ms. Grid size: " + this.gridWidth + " x " + this.gridHeight + ".");
        return this.grid;
    }

    public Color getMatchingColor(int x, int y, Color[] colorGradient, double t) {
        if (this.gridCellValueRange == 0.0) {
            return colorGradient[0];
        }
        double norm = 0.0;
        norm = this.styleModel.isGlobalCellValueRangeEnforced() && this.styleModel.getGlobalMaxCellValue(t) >= 0.0 ? (this.grid[x][y] - 0.0) / this.styleModel.getGlobalMaxCellValue(t) : (this.grid[x][y] - this.minGridCellValue) / this.gridCellValueRange;
        int colorIdx = (int)Math.floor(norm * (double)(colorGradient.length - 1));
        if (colorIdx < 0) {
            colorIdx = 0;
        }
        if (colorIdx >= colorGradient.length) {
            colorIdx = colorGradient.length - 1;
        }
        return colorGradient[colorIdx];
    }

    public void setSpotlightRadius(double spotlightRadius) {
        this.spotlightRadiusPx = spotlightRadius;
    }

    public double getSpotlightRadius() {
        return this.spotlightRadiusPx;
    }

    public void setMethod(int method) {
        if (2 != method && 1 != method) {
            throw new IllegalArgumentException("Invalid method specified.");
        }
        this.method = method;
    }

    public int getMethod() {
        return this.method;
    }

    protected static double estimateGlobalMaxCellValue(int N, double t, HeatMapStyleModel model) {
        double x = 0.0;
        double y = 0.0;
        double t2 = t * t;
        ArrayList<HMPointFeature> l = new ArrayList<HMPointFeature>(N);
        Random r1 = new Random(System.currentTimeMillis() / 2L);
        Random r2 = new Random(System.currentTimeMillis());
        while (l.size() < N) {
            double _y;
            double _x = r1.nextGaussian();
            x = _x * t;
            if (!(x * x + (y = (_y = r2.nextGaussian()) * t) * y <= t2)) continue;
            HMPointFeature f = new HMPointFeature(x, y);
            l.add(f);
        }
        if (model.getMethod() == 1) {
            return HeatMapCore.kEstimate(0.0, 0.0, l, t);
        }
        return HeatMapCore.idw(0.0, 0.0, l, t);
    }

    public HeatMapStyleModel getStyleModel() {
        return this.styleModel;
    }

    public void setStyleModel(HeatMapStyleModel styleModel) {
        this.styleModel = styleModel;
    }

    public double[][] getGrid() {
        return this.grid;
    }

    public double getMaxGridCellValue() {
        return this.maxGridCellValue;
    }

    public double getMinGridCellValue() {
        return this.minGridCellValue;
    }
}

