/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.Util;
import org.owasp.esapi.ESAPI;

public class AnnotationTextThemeDefinition
extends VectorThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String baseTable = null;
    protected String baseColumn = null;
    protected String keyColumn = "ROWID";
    protected String query = null;
    protected StylingRule[] styleRules = null;
    protected boolean isPredefined = false;
    protected String metadataExpression = null;
    protected String metadataAttributes = null;
    protected double metadataMapBaseScale = Double.NaN;
    protected boolean passThrough = false;
    protected String leaderLineStyle = null;
    protected String baseColumnAlias = null;
    protected ArrayList<String> tableColumns = null;
    protected String defaultTextExprColumn = null;

    public AnnotationTextThemeDefinition(String name, String dataSrc, String baseTable, String textColumn, String keyColumn, StylingRule[] styleRules, int srid) {
        this.name = name;
        this.dataSource = dataSrc;
        this.baseTable = baseTable;
        this.baseColumn = textColumn;
        if (keyColumn != null) {
            this.keyColumn = keyColumn;
        }
        this.styleRules = styleRules;
        this.srid = srid;
        this.isPredefined = true;
        if (styleRules != null && styleRules.length > 0) {
            this.passThrough = styleRules[0].isQueryPassThrough();
            this.setLeaderLineStyle(styleRules[0].getFeatureStyleName());
        }
        this.readMetadata();
    }

    public AnnotationTextThemeDefinition(String name, String dataSrc, String completeQuery, String baseTable, String textCol, int srid, boolean useFilter) {
        this.name = name;
        this.dataSource = dataSrc;
        this.baseTable = baseTable;
        String userQuery = completeQuery;
        log.finest("Before esapi canonicalizing: " + userQuery);
        this.query = ESAPI.encoder().canonicalize(userQuery, true);
        log.finest("After esapi canonicalizing: " + this.query);
        this.baseColumn = textCol;
        if (this.query != null && this.baseColumn != null && this.baseColumn.indexOf(46) > -1) {
            this.query = this.query.toLowerCase();
            this.baseColumn = this.baseColumn.toLowerCase().trim();
            int index = this.baseColumn.indexOf(" ");
            if (index < 0) {
                this.baseColumnAlias = "mv_antext_alias";
                this.query = this.query.replaceFirst(this.baseColumn, this.baseColumn + " " + this.baseColumnAlias);
            } else {
                this.baseColumnAlias = this.baseColumn.substring(index + 1, this.baseColumn.length()).trim();
                this.baseColumn = this.baseColumn.substring(0, index);
            }
        }
        this.srid = srid;
        this.passThrough = useFilter;
        this.readMetadata();
    }

    public AnnotationTextThemeDefinition(String name, String dataSrc, String completeQuery, String baseTable, String textCol, String defaultTextExpCol, int srid, boolean useFilter) {
        this(name, dataSrc, completeQuery, baseTable, textCol, srid, useFilter);
        this.defaultTextExprColumn = defaultTextExpCol;
    }

    public AnnotationTextThemeDefinition() {
    }

    public String getDefaultTextExpressionColumn() {
        if (this.isPredefined) {
            return null;
        }
        return this.defaultTextExprColumn;
    }

    public String getQuery() {
        String cond;
        if (!this.isPredefined) {
            return this.query;
        }
        String sql = "select " + this.keyColumn + "," + this.baseColumn + " from " + this.baseTable;
        if (this.styleRules != null && this.styleRules.length > 0 && (cond = this.styleRules[0].getFeatureCond()) != null) {
            sql = sql + " where " + cond;
        }
        return sql;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(String table) {
        this.baseTable = table;
    }

    public String getTextColumn() {
        return this.baseColumn;
    }

    public void setTextColumn(String atColumn) {
        this.baseColumn = atColumn;
    }

    @Override
    public String getXMLDefinition() {
        return null;
    }

    public void setKeyColumn(String keyCol) {
        this.keyColumn = keyCol;
    }

    @Override
    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getMetadataExpression() {
        return this.metadataExpression;
    }

    public void setMetadataExpression(String expression) {
        this.metadataExpression = expression;
    }

    public String getMetadataAttributes() {
        return this.metadataAttributes;
    }

    public void setMetadataAtributes(String xml) {
        this.metadataAttributes = xml;
    }

    public boolean refreshMetadata() {
        return this.readMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMetadata() {
        if (this.dataSource == null || this.baseTable == null || this.baseColumn == null) {
            return false;
        }
        AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (ds == null) {
            log.severe("Could not get data source: " + this.dataSource);
            return false;
        }
        String connectionUser = ds.getUser();
        Connection conn = null;
        String atName = this.baseTable;
        String atOwner = connectionUser;
        int idx = atName.indexOf(".");
        if (idx > -1) {
            atOwner = atName.substring(0, idx);
            atName = atName.substring(idx + 1, atName.length());
        }
        String atquery = "select * from all_annotation_text_metadata where table_name = ?  and column_name = ?  and owner = ?";
        log.finest("[Annotation Text Metadata Query] " + atquery);
        PreparedStatement atStmt = null;
        ResultSet rs = null;
        try {
            String currentSchema2;
            conn = ds.getConnection();
            if (idx < 0 && (currentSchema2 = Util.getCurrentSchema(conn, null)) != null) {
                atOwner = currentSchema2;
            }
            atStmt = conn.prepareStatement(atquery);
            atStmt.setString(1, atName.toUpperCase());
            atStmt.setString(2, this.baseColumn.toUpperCase());
            atStmt.setString(3, atOwner.toUpperCase());
            rs = atStmt.executeQuery();
            if (!rs.next()) {
                log.severe("Unable to load Annotation metadata for Table Name " + atName + ", Column Name " + this.baseColumn + ", Annotation Owner " + atOwner);
                boolean currentSchema2 = false;
                return currentSchema2;
            }
            this.metadataExpression = rs.getString("text_expression");
            this.metadataAttributes = rs.getString("text_attributes");
            if (rs.getObject("map_base_scale") != null) {
                this.metadataMapBaseScale = rs.getDouble("map_base_scale");
            }
            rs.close();
            atStmt.close();
            atquery = "select * from " + this.baseTable + " where rownum < 1";
            atStmt = conn.prepareStatement(atquery);
            rs = atStmt.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCnt = rsmeta.getColumnCount();
            this.tableColumns = new ArrayList();
            for (int i = 1; i <= colCnt; ++i) {
                String colname = rsmeta.getColumnName(i);
                this.tableColumns.add(colname);
            }
            if (this.srid == 0) {
                rs.close();
                atStmt.close();
                atquery = "select srid from all_sdo_geom_metadata where table_name = ?  and column_name = ?  and owner = ?";
                atStmt = conn.prepareStatement(atquery);
                atStmt.setString(1, atName.toUpperCase());
                atStmt.setString(2, this.baseColumn.toUpperCase() + ".PRIVATEENVELOPE");
                atStmt.setString(3, atOwner.toUpperCase());
                rs = atStmt.executeQuery();
                if (rs.next() && rs.getObject(1) != null) {
                    this.srid = rs.getInt(1);
                }
            }
        }
        catch (Exception ex) {
            log.finest("Table name: " + atName.toUpperCase());
            log.finest("Column name: " + this.baseColumn.toUpperCase());
            log.info("Owner: " + atOwner.toUpperCase());
            log.severe("Annotation load metadata Exception: " + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (atStmt != null) {
                try {
                    atStmt.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public boolean getFilterUse() {
        return this.passThrough;
    }

    public StylingRule[] getStylingRules() {
        return this.styleRules;
    }

    public void setStylingRules(StylingRule[] rules) {
        this.styleRules = rules;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public String getLeaderLineStyle() {
        return this.leaderLineStyle;
    }

    public void setLeaderLineStyle(String style) {
        this.leaderLineStyle = style;
        if (this.styleRules != null && this.styleRules.length > 0) {
            this.styleRules[0].setFeatureStyleName(style);
        }
    }

    @Override
    public String getThemeType() {
        return "ANNOTATION";
    }

    public double getMapBaseScale() {
        return this.metadataMapBaseScale;
    }

    public void setMapBaseScales(double baseScale) {
        this.metadataMapBaseScale = baseScale;
    }

    public String getBaseColumnAlias() {
        return this.baseColumnAlias;
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.baseTable);
        ti.setType("ANNOTATION");
        ti.setKeyColumn(this.getKeyColumn());
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.baseColumn);
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        if (this.leaderLineStyle != null) {
            String[] stys = new String[]{this.leaderLineStyle};
            return stys;
        }
        return null;
    }

    @Override
    public String[] getLabelingStyles() {
        return null;
    }

    public ArrayList<String> getTableColumns() {
        return this.tableColumns;
    }

    @Override
    public String[] getHighlightStyles() {
        return null;
    }

    @Override
    public String[] getLabelColumns() {
        return null;
    }
}

