/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.ext.NSDataSet;
import oracle.mapviewer.share.ext.NSRow;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.ext.SDataSet;
import oracle.mapviewer.share.ext.SObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.ShapefileDataProvider;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class CustomGeomThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static PhaseEvent customSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "CustomGeom", "Producer", "Time spent preparing data");
    protected Theme owner = null;
    private CustomGeomThemeDefinition def = null;
    private LocalThemeDataProducer features = null;
    private SDataProvider dataProvider = null;
    private Properties runtimeProperties = null;
    private String nsdpKeyColumn = null;
    private String[] nsdpKeyValues = null;
    private Object[] bindingParameters = null;
    private long maxFeaturesToBePrepared = -1L;

    public CustomGeomThemeProducer(Theme t) {
        this.owner = t;
        this.def = (CustomGeomThemeDefinition)t.getDefinition();
        this.dataProvider = this.def.getProvider();
    }

    public CustomGeomThemeProducer(Theme t, Object[] bindingVars) {
        this.owner = t;
        this.def = (CustomGeomThemeDefinition)t.getDefinition();
        this.dataProvider = this.def.getProvider();
        this.bindingParameters = bindingVars;
    }

    public SDataProvider getProvider() {
        return this.dataProvider;
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public int size() {
        return this.features != null ? this.features.size() : 0;
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(idx);
    }

    @Override
    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeatures();
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(window, name);
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(window);
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    public void setStyledFeatures(ArrayList sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenC = 0L;
        try {
            boolean workaround;
            tokenC = customSensor.start();
            this.clearFeatures();
            if (this.dataProvider == null) {
                vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01028"));
                int n = 0;
                return n;
            }
            boolean fullExtent = MapMaker.isSpecial(queryWin);
            double xl = queryWin.getMinX();
            double yl = queryWin.getMinY();
            double xh = queryWin.getMaxX();
            double yh = queryWin.getMaxY();
            String datasource = vc.getMasterDataSourceName();
            if (this.def.getDataSourceName() != null) {
                datasource = this.def.getDataSourceName();
            }
            if (datasource == null) {
                log.warning("Theme does not have a datasource. Theme preparation aborted.");
                int n = 0;
                return n;
            }
            DataSourceI ds = DSManager.get(datasource);
            Connection conn = null;
            try {
                conn = DSUtil.getDBConnection(datasource, vc);
            }
            catch (Exception e) {
                log.warning("Unable to get connection for data source " + datasource);
                int n = 0;
                customSensor.stop(tokenC);
                return n;
            }
            boolean isOracleDB = true;
            try {
                if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                    isOracleDB = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean transformSRid = false;
            int mySrid = this.def.getSrid();
            SRS srs = null;
            boolean isGeodetic = false;
            String unit = null;
            SRSCache sc = DSManager.getSRSCache(datasource);
            srs = sc.get(mySrid);
            if (srs != null) {
                isGeodetic = srs.isGeodetic();
                unit = srs.getUnit();
            } else if (this.def.getSrid() > 0) {
                log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
            }
            double xi = xl;
            double xf = xh;
            double yi = yl;
            double yf = yh;
            double masterScale = vc.getCurrentScale();
            if (vc.getMasterSRID() > 0 && mySrid > 0 && mySrid != vc.getMasterSRID() && isOracleDB) {
                if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                    double[] inmbr = new double[]{xl, yl, xh, yh};
                    double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), mySrid, conn);
                    if (outmbr == null) {
                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
                        int n = 0;
                        return n;
                    }
                    xl = outmbr[0];
                    yl = outmbr[1];
                    xh = outmbr[2];
                    yh = outmbr[3];
                    transformSRid = true;
                } else {
                    transformSRid = true;
                }
            }
            if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                double factor = Math.abs(yh - yl) / Math.abs(yf - yi);
                log.finer("[Master scale] " + masterScale + " [Theme scale factor] " + factor);
                double scale = masterScale * factor;
                if (this.getTheme().getScaleType() == "RATIO") {
                    double centery;
                    double centerx;
                    if (vc.getMasterSRID() > 0 && mySrid > 0 && mySrid != vc.getMasterSRID()) {
                        srs = sc.get(vc.getMasterSRID());
                        centerx = (xi + xf) / 2.0;
                        centery = (yi + yf) / 2.0;
                        factor = 1.0;
                    } else {
                        centerx = (xl + xh) / 2.0;
                        centery = (yl + yh) / 2.0;
                    }
                    if (vc.isTileRequest() && srs.isGeodetic()) {
                        centerx = 0.0;
                        centery = 0.0;
                    }
                    if (srs != null) {
                        scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                        log.finer("Ratio scale to compare: " + scale);
                    } else {
                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
                        int n = 0;
                        return n;
                    }
                }
                if (!this.getTheme().withinRenderScaleLimits(scale)) {
                    log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                    int centerx = 0;
                    return centerx;
                }
            }
            if (conn != null) {
                DSUtil.closeDBConnection(conn, datasource);
            }
            boolean bl = workaround = isGeodetic && xh - xl > 2.0 && xh - xl < 120.0;
            if (workaround) {
                xl = Math.floor(xl);
                log.finest("jtvpxfmfxed: xl=" + xl);
            }
            log.finest("[ " + this.def.getName() + " ]:  " + xl + "," + yl + "," + xh + "," + yh);
            ArrayList<StyledFeatureI> featureSet = new ArrayList<StyledFeatureI>(128);
            String[] nonSpatialColumns = null;
            ArrayList<String> nonsptcolumns = new ArrayList<String>();
            if (this.def.getLabelColumn() != null) {
                nonsptcolumns.add(this.def.getLabelColumn().toUpperCase());
            }
            if (this.def.getKeyColumn() != null && !this.def.getKeyColumn().equals("N/A") && !nonsptcolumns.contains(this.def.getKeyColumn().toUpperCase())) {
                nonsptcolumns.add(this.def.getKeyColumn().toUpperCase());
            }
            if (this.def.getNonSpatialColumns() != null) {
                String[] nspcol = this.def.getNonSpatialColumns();
                for (int i = 0; i < nspcol.length; ++i) {
                    if (nonsptcolumns.contains(nspcol[i].toUpperCase())) continue;
                    nonsptcolumns.add(nspcol[i].toUpperCase());
                }
            }
            if (this.def.getIdentifiableColumns() != null) {
                Field[] infoCols = this.def.getIdentifiableColumns();
                for (int k = 0; k < infoCols.length; ++k) {
                    if (nonsptcolumns.contains(infoCols[k].getName().toUpperCase())) continue;
                    nonsptcolumns.add(infoCols[k].getName().toUpperCase());
                }
            }
            if (nonsptcolumns.size() > 0) {
                nonSpatialColumns = nonsptcolumns.toArray(new String[nonsptcolumns.size()]);
            }
            Rectangle2D.Double searchWindow = new Rectangle2D.Double(xl, yl, xh - xl, yh - yl);
            boolean applyRotation = false;
            if (fullExtent && vc.getRotation() != 0.0) {
                log.warning("Rotation is currently ignored for full extent.");
            } else if (vc.getRotation() != 0.0 && !fullExtent) {
                if (vc.getRotation() < -360.0 || vc.getRotation() > 360.0) {
                    log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                } else {
                    double[] rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation());
                    if (rmbr != null) {
                        xl = Math.min(rmbr[0], xl);
                        yl = Math.min(rmbr[1], yl);
                        xh = Math.max(rmbr[2], xh);
                        yh = Math.max(rmbr[3], yh);
                        log.finest("Rotation angle: " + vc.getRotation());
                        log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
                        applyRotation = true;
                        searchWindow = new Rectangle2D.Double(xl, yl, xh - xl, yh - yl);
                    } else {
                        log.info("Rotated MBR is null. Rotation ignored.");
                    }
                }
            }
            if (this.dataProvider instanceof ShapefileDataProvider) {
                Point2D.Double filterResolution = null;
                if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0) {
                    double viewResX = vc.getDeviceWindow().getWidth();
                    double viewResY = vc.getDeviceWindow().getHeight();
                    double resx = (xh - xl) / viewResX;
                    double resy = (yh - yl) / viewResY;
                    filterResolution = new Point2D.Double();
                    ((Point2D)filterResolution).setLocation(resx *= (double)this.getTheme().getDecorator().getMinimumFeatureSizePx(), resy *= (double)this.getTheme().getDecorator().getMinimumFeatureSizePx());
                    ((ShapefileDataProvider)this.dataProvider).setFilterResolution(filterResolution);
                }
            }
            SDataSet dataset = null;
            long t1 = System.currentTimeMillis();
            if (this.runtimeProperties == null || this.runtimeProperties.size() == 0) {
                this.runtimeProperties = this.def.getRuntimeProperties();
            }
            this.checkNsdpHandler(vc);
            if (this.nsdpKeyColumn != null && this.nsdpKeyValues != null && this.nsdpKeyValues.length > 0) {
                if (this.runtimeProperties == null) {
                    this.runtimeProperties = new Properties();
                }
                this.runtimeProperties.setProperty("nsdpkeycolumn", this.nsdpKeyColumn);
                String nsdpValues = "'" + this.nsdpKeyValues[0] + "'";
                for (int i = 1; i < this.nsdpKeyValues.length; ++i) {
                    nsdpValues = nsdpValues + ",'" + this.nsdpKeyValues[i] + "'";
                }
                this.runtimeProperties.setProperty("nsdpkeyvalues", nsdpValues);
            }
            if (this.def.getIgnoreSpatialFilter()) {
                searchWindow = null;
            }
            log.finest("Calling data provider buildDataSet method.");
            dataset = this.dataProvider.buildDataSet(searchWindow, nonSpatialColumns, this.def.getQueryCondition(), this.bindingParameters, this.runtimeProperties);
            if (dataset == null) {
                log.info("Spatial provider returned a null data set.");
                int nsdpValues = 0;
                return nsdpValues;
            }
            long t2 = System.currentTimeMillis();
            log.info("Time to build data set from provider: " + (t2 - t1) + " ms.");
            if (vc.getMasterSRID() > 0 && transformSRid) {
                log.info("Feature geometries will have SRID conversion.");
                xl = xi;
                xh = xf;
                yl = yi;
                yh = yf;
            }
            if (applyRotation) {
                log.info("Feature geometries will be rotated by " + vc.getRotation() + " degrees.");
            }
            for (int i = 0; i < dataset.getSize() && (this.maxFeaturesToBePrepared <= 0L || (long)featureSet.size() < this.maxFeaturesToBePrepared); ++i) {
                JGeometry geomRot;
                SObject obj = dataset.getObject(i);
                if (obj == null) continue;
                Object geomobj = obj.getObject();
                if (geomobj == null) {
                    log.warning("Object geometry is null for element " + i + ". Object ignored.");
                    continue;
                }
                JSDOGeometry geom = null;
                geom = geomobj instanceof JGeometry ? JSDOGeometry.recast((JGeometry)geomobj) : (JSDOGeometry)obj.getObject();
                if (geom == null) continue;
                StyledFeatureI sf = this.getNewStyledFeatureInstance();
                sf.setRenderingRules(this.def.getRenderingRules());
                geom.setSRID(this.def.getSrid());
                if (vc.getMasterSRID() > 0 && transformSRid) {
                    JGeometry jgeom = null;
                    if (i % 50 == 0) {
                        log.finer("Transforming geometry " + i);
                    }
                    try {
                        jgeom = Util.processSRIDConversion(datasource, geom, vc.getMasterSRID());
                    }
                    catch (Exception e) {
                        jgeom = null;
                    }
                    if (jgeom != null) {
                        geom = JSDOGeometry.recast(jgeom);
                    }
                }
                if (applyRotation && (geomRot = Util.rotateGeometry(geom, (xl + xh) / 2.0, (yl + yh) / 2.0, vc.getRotation())) != null) {
                    geom = JSDOGeometry.recast(geomRot);
                }
                sf.setGeometry(geom);
                sf.setDataSource(datasource);
                if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                    sf.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                } else {
                    sf.setFeatureStyleName(this.def.getFeatureStyleName());
                }
                Field[] fields = obj.getAtttributes();
                ArrayList<Field> nonsptFields = new ArrayList<Field>();
                ArrayList<Field> infoFields = new ArrayList<Field>();
                if (fields != null) {
                    for (int k = 0; k < fields.length; ++k) {
                        Field attr;
                        int l;
                        String fname = fields[k].getName();
                        if (this.def.getLabelColumn() != null && fname.equalsIgnoreCase(this.def.getLabelColumn())) {
                            sf.setLabel(fields[k].getValue().toString());
                            sf.setLabelStyleName(this.def.getLabelStyleName());
                        }
                        if (this.def.getKeyColumn() != null && fname.equalsIgnoreCase(this.def.getKeyColumn())) {
                            sf.setID(fields[k].getValue().toString());
                        }
                        if (this.def.getNonSpatialColumns() != null) {
                            String[] nspcol = this.def.getNonSpatialColumns();
                            for (l = 0; l < nspcol.length; ++l) {
                                if (!fname.equalsIgnoreCase(nspcol[l])) continue;
                                attr = (Field)fields[k].clone();
                                nonsptFields.add(attr);
                            }
                        }
                        if (this.def.getIdentifiableColumns() == null) continue;
                        Field[] infoCols = this.def.getIdentifiableColumns();
                        for (l = 0; l < infoCols.length; ++l) {
                            if (!fname.equalsIgnoreCase(infoCols[l].getName())) continue;
                            attr = (Field)fields[k].clone();
                            attr.setDisplayName(infoCols[l].getDisplayName());
                            infoFields.add(attr);
                        }
                    }
                    if (nonsptFields.size() > 0) {
                        sf.setRenderableAttributes(nonsptFields.toArray(new Field[nonsptFields.size()]));
                    }
                    if (infoFields.size() > 0) {
                        sf.setIdentifiableAttributes(infoFields.toArray(new Field[infoFields.size()]));
                    }
                }
                featureSet.add(sf);
            }
            long t3 = System.currentTimeMillis();
            log.info("[ " + this.def.name + " ] total time loading " + featureSet.size() + " features: " + (t3 - t1) + "ms.");
            TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), "Custom theme spatial provider [" + this.def.getProviderID() + "]", "features loaded = " + featureSet.size());
            if (featureSet.size() <= 0) {
                int n = 0;
                return n;
            }
            this.setStyledFeatures(featureSet);
            featureSet = null;
            int n = this.features.size();
            return n;
        }
        finally {
            customSensor.stop(tokenC);
        }
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    @Override
    public void destroy() {
        if (this.features != null) {
            this.features.destroy();
        }
        this.features = null;
    }

    @Override
    public void abort() {
    }

    private void clearFeatures() {
        if (this.features != null) {
            this.features.setStyledFeatures((List)null);
        }
    }

    @Override
    public void postPreparation(VisContext vc) {
        if (this.features != null) {
            this.features.postPreparation(vc);
        }
    }

    public void setRuntimeProperties(Properties prop) {
        this.runtimeProperties = prop;
    }

    public Properties getRuntimeProperties() {
        return this.runtimeProperties;
    }

    private void checkNsdpHandler(VisContext vc) {
        Field key;
        int type;
        int i;
        boolean hasData;
        this.nsdpKeyColumn = null;
        this.nsdpKeyValues = null;
        if (vc == null || this.def == null) {
            return;
        }
        NsDpHandler ndh = Theme.getNsdpHandler(vc, this.def.getName());
        if (ndh == null) {
            return;
        }
        NsDpInfo ndi = ndh.getDef();
        if (ndi == null) {
            return;
        }
        NSDataSet ds = ndh.getData();
        boolean bl = hasData = ds != null && ds.size() > 0;
        if (!hasData) {
            log.warning("Your NSDP data set contains no data yet; no DB filtering will be done!");
            return;
        }
        NSRow[] rows = ds.getRows();
        NSRow row = rows[0];
        for (i = 0; i < rows.length && (type = (key = (row = rows[i]).getKeyAttribute()).getType()) == 0; ++i) {
        }
        this.nsdpKeyColumn = ndi.getJoinColumnSpatial();
        this.nsdpKeyValues = new String[rows.length];
        for (i = 0; i < rows.length; ++i) {
            this.nsdpKeyValues[i] = rows[i].getKeyAttribute().getString();
        }
    }

    public void setBindingParameters(Object[] params) {
        this.bindingParameters = params;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }
}

