/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class LocalThemeDataProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent localThemeSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "LocalTheme", "Producer", "Time spent preparing data");
    protected StyledFeatureI[] styledFeatures = null;
    protected JSDOGeometry[] origGeometries = null;
    protected double[] dataMBR = null;
    protected Theme theme = null;

    private LocalThemeDataProducer() {
    }

    public LocalThemeDataProducer(Theme p) {
        this.theme = p;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public int size() {
        return this.styledFeatures != null ? this.styledFeatures.length : 0;
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        if (this.styledFeatures == null) {
            return null;
        }
        try {
            return this.styledFeatures[idx];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public double[] getDataMBR() {
        if (this.styledFeatures == null || this.styledFeatures.length == 0) {
            return null;
        }
        if (this.dataMBR != null) {
            return this.dataMBR;
        }
        double[] gMBR = null;
        RectangularShape newMBR = null;
        for (int i = 0; i < this.styledFeatures.length; ++i) {
            gMBR = this.getStyledFeature(i).getGeomMBR();
            if (newMBR == null) {
                newMBR = new Rectangle2D.Double(gMBR[0], gMBR[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)newMBR).add(gMBR[0], gMBR[1]);
            }
            if (gMBR.length == 4) {
                ((Rectangle2D)newMBR).add(gMBR[2], gMBR[3]);
                continue;
            }
            ((Rectangle2D)newMBR).add(gMBR[3], gMBR[4]);
        }
        this.dataMBR = new double[4];
        this.dataMBR[0] = newMBR.getMinX();
        this.dataMBR[1] = newMBR.getMinY();
        this.dataMBR[2] = newMBR.getMaxX();
        this.dataMBR[3] = newMBR.getMaxY();
        return this.dataMBR;
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        return this.styledFeatures;
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
        this.styledFeatures = sfs;
        this.backupOriginalGeometries();
    }

    public void setStyledFeatures(List sfs) {
        this.styledFeatures = sfs != null ? sfs.toArray(new StyledFeatureI[sfs.size()]) : new StyledFeature[0];
        this.backupOriginalGeometries();
    }

    private void backupOriginalGeometries() {
        this.origGeometries = null;
        if (this.styledFeatures == null || this.styledFeatures.length == 0) {
            return;
        }
        this.origGeometries = new JSDOGeometry[this.styledFeatures.length];
        for (int i = 0; i < this.styledFeatures.length; ++i) {
            this.origGeometries[i] = this.styledFeatures[i].getGeometry();
        }
    }

    public void restoreOriginalGeometries() {
        if (this.origGeometries == null || this.styledFeatures == null || this.styledFeatures.length == 0) {
            return;
        }
        for (int i = 0; i < this.styledFeatures.length; ++i) {
            this.styledFeatures[i].setGeometry(this.origGeometries[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenL = 0L;
        try {
            int i;
            tokenL = localThemeSensor.start();
            if (this.styledFeatures == null) {
                int n = 0;
                return n;
            }
            this.restoreOriginalGeometries();
            Proj proj = vc.getProjection();
            double masterScale = vc.getCurrentScale();
            this.getTheme().setShowLabels(true);
            if (this.getTheme().getScaleType() == "RATIO") {
                SRS srs = vc.getSrs();
                if (srs != null) {
                    if (queryWin == null) {
                        masterScale = srs.getRatioScale(masterScale, null);
                    } else {
                        double centerx = queryWin.getCenterX();
                        double centery = queryWin.getCenterY();
                        masterScale = srs.getRatioScale(masterScale, new Point2D.Double(centerx, centery));
                    }
                    log.finer("Ratio scale to compare: " + masterScale);
                } else {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                    int centerx = 0;
                    return centerx;
                }
            }
            if (!this.getTheme().withinRenderScaleLimits(masterScale)) {
                log.fine("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                int srs = 0;
                return srs;
            }
            if (!this.getTheme().withinLabelScaleLimits(masterScale)) {
                log.info("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                this.getTheme().setShowLabels(false);
            }
            for (i = 0; i < this.styledFeatures.length; ++i) {
                JSDOGeometry geom = this.styledFeatures[i].getGeometry();
                if (geom == null) continue;
                if (geom.getSRID() > 0 && vc.getMasterSRID() > 0 && geom.getSRID() != vc.getMasterSRID() && this.styledFeatures[i].getDataSource() != null) {
                    JGeometry jgeom = null;
                    try {
                        jgeom = Util.processSRIDConversion(this.styledFeatures[i].getDataSource(), geom, vc.getMasterSRID());
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (jgeom == null) continue;
                    geom = JSDOGeometry.recast(jgeom);
                }
                if (vc.getRotation() != 0.0) {
                    JGeometry geomRot = Util.rotateGeometry(geom, queryWin.getCenterX(), queryWin.getCenterY(), vc.getRotation());
                    if (geomRot == null) continue;
                    geom = JSDOGeometry.recast(geomRot);
                }
                if ((geom = vc.getSrs().shift(geom, vc.getQueryWindow())) == null || proj != null && (geom = SRS.proj(geom, proj, 0)) == null) continue;
                this.styledFeatures[i].setGeometry(geom);
            }
            for (i = 0; i < this.styledFeatures.length; ++i) {
                this.styledFeatures[i].resetRenderableShape();
            }
            int n = this.styledFeatures.length;
            return n;
        }
        finally {
            localThemeSensor.stop(tokenL);
        }
    }

    @Override
    public void postPreparation(VisContext vc) {
        if (this.theme.getDecorator().isSortingNeeded() && this.styledFeatures != null && this.styledFeatures.length > 0) {
            this.sortFeatures(vc);
        }
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        StyledFeatureI[] selectedFeatures = this.getSelectedFeatures(window);
        if (selectedFeatures == null || selectedFeatures.length <= 0) {
            return null;
        }
        StyledFeatureI[] sf = new StyledFeatureI[selectedFeatures.length];
        System.arraycopy(selectedFeatures, 0, sf, 0, selectedFeatures.length);
        LocalTheme lt = new LocalTheme(name, sf);
        return lt;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        int i;
        GeneralPath sh = null;
        Point2D p = null;
        ArrayList<StyledFeatureI> sf = new ArrayList<StyledFeatureI>();
        StyledFeature[] selectedFeatures = null;
        for (i = 0; i < this.styledFeatures.length; ++i) {
            if (this.styledFeatures[i].getShape() != null) {
                sh = new GeneralPath(this.styledFeatures[i].getShape());
                if (this.styledFeatures[i].getGeomType() == 2 || this.styledFeatures[i].getGeomType() == 6) {
                    Rectangle2D r2d = sh.getBounds2D();
                    double r2wdt = r2d.getWidth();
                    double r2hgt = r2d.getHeight();
                    if (r2wdt == 0.0 && r2hgt == 0.0 && window.contains(r2d.getCenterX(), r2d.getCenterY())) {
                        sf.add(this.styledFeatures[i]);
                        continue;
                    }
                    if (!window.contains(r2d) && !ShapeUtil.intersects(sh, window)) continue;
                    sf.add(this.styledFeatures[i]);
                    continue;
                }
                if (!sh.intersects(window)) continue;
                sf.add(this.styledFeatures[i]);
                continue;
            }
            p = this.styledFeatures[i].getPoint();
            if (p == null || !window.contains(p)) continue;
            sf.add(this.styledFeatures[i]);
        }
        if (sf.size() > 0) {
            selectedFeatures = new StyledFeature[sf.size()];
            for (i = 0; i < sf.size(); ++i) {
                selectedFeatures[i] = (StyledFeatureI)sf.get(i);
            }
        }
        return selectedFeatures;
    }

    public void sortFeatures(VisContext vc) {
        int i;
        StyledFeatureI sf = this.styledFeatures[0];
        BucketStyle sty = null;
        try {
            sty = (BucketStyle)sf.getFeatureStyle();
            if (sty == null && (sty = (BucketStyle)vc.getDynamicStyle(sf.getFeatureStyleName())) == null) {
                DataSourceI ds = DSManager.get(this.theme.getDataSourceName());
                StyleCache sc = ds.getStyleCache();
                sty = (BucketStyle)sc.get(sf.getFeatureStyleName());
            }
            if (sty == null) {
                log.warning("cannot find style in sortFeatures()");
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failure sorting features.", e);
            return;
        }
        int total = this.styledFeatures.length;
        int nBuckets = sty.getNumBuckets();
        if (nBuckets <= 0) {
            return;
        }
        String themeName = this.theme != null ? this.theme.getName() : null;
        log.finest("Sorting features for theme " + themeName + " by order of buckets...");
        ArrayList[] lists = new ArrayList[nBuckets];
        for (i = 0; i < nBuckets; ++i) {
            lists[i] = new ArrayList(total / nBuckets);
        }
        for (i = 0; i < total; ++i) {
            sf = this.styledFeatures[i];
            int bucket = -1;
            try {
                Field val = sf.getRenderableAttribute(0);
                bucket = sty.getBucketIndex(val);
                Style primitiveSty = sty.chooseStyle(val);
                sf.setFeatureStyle(primitiveSty);
                String advStyleName = sf.getFeatureStyleName();
                sf.setFeatureStyleName(null);
                Style labelStyle = sty.chooseLabelStyle(val);
                if (labelStyle != null) {
                    sf.setLabelStyle(labelStyle);
                    sf.setLabelStyleName(null);
                } else if (advStyleName != null && advStyleName.equalsIgnoreCase(sf.getLabelStyleName()) || sf.getLabelStyle() == sty) {
                    sf.setLabel(null);
                    sf.setLabelStyle(null);
                    sf.setLabelStyleName(null);
                    sf.setForceLabel(false);
                }
                lists[bucket].add(sf);
                continue;
            }
            catch (Exception e) {
                lists[nBuckets - 1].add(sf);
            }
        }
        this.styledFeatures = new StyledFeature[total];
        int k = 0;
        for (i = 0; i < nBuckets; ++i) {
            System.arraycopy(lists[i].toArray(new StyledFeature[lists[i].size()]), 0, this.styledFeatures, k, lists[i].size());
            k += lists[i].size();
        }
    }

    public boolean isTextLabelPresent() {
        if (this.styledFeatures == null) {
            return false;
        }
        for (int i = 0; i < this.styledFeatures.length; ++i) {
            StyledFeatureI sf = this.styledFeatures[i];
            Style s = sf.getLabelStyle();
            String ls = sf.getLabelStyleName();
            if (s == null && ls == null || ls == null && (s == null || !(s instanceof StyleText))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void abort() {
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return -1L;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
    }
}

