/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.ORAWorkspaceJDBCUtil;
import org.owasp.esapi.ESAPI;

public class TopologyThemeDefinition
extends VectorThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final int YIELD_COUNT = 20;
    boolean passThrough = true;
    String topoOwner = null;
    String topologyName = null;
    int topologyId = 0;
    double tolerance = 0.0;
    String featureTable = null;
    String topoColumn = null;
    int tgLayerId = 0;
    String tgLayerType = null;
    int tgLayerLevel = 0;
    int childLayerId = 0;
    String tableOwner = null;
    int cachingMode = 1;
    String cacheSubRegionName = null;
    String cacheGeomGroup = null;
    Hashtable sridGeomCache = new Hashtable(5);
    String cacheEdgeGroup = null;
    Hashtable sridEdgeCache = new Hashtable(5);
    String cacheNodeGroup = null;
    Hashtable sridNodeCache = new Hashtable(5);
    String mQuery = null;
    boolean mPre9i = false;
    boolean predefined = false;
    String mKeyColumn = "ROWID";
    PreparedStatement pstmt = null;
    String currentKey = null;
    StylingRule[] mStyleRules = null;
    String renderStyleName = null;
    String labelColumnName = null;
    String labelStyleName = null;
    String edgeSpatialColumn = "geometry";
    String nodeSpatialColumn = "geometry";
    String edgeStyle = null;
    String edgeLabelStyle = null;
    String edgeMarkerStyle = null;
    int edgeMarkerSize = 8;
    String nodeStyle = null;
    String nodeLabelStyle = null;
    int nodeMarkerSize = 8;
    String faceStyle = null;
    String faceLabelStyle = null;
    boolean debugTheme = false;
    protected double minDistBetweenNodes = 0.5;
    int[] hierLayers = null;
    String topoView = null;
    String topoViewColumn = null;
    String connectionUser = null;
    String indexTableName = null;

    public TopologyThemeDefinition() {
    }

    public TopologyThemeDefinition(String name, String dataSource, String query, String srid, String topoName, String featureTableName, String topoColumnName, String renderStyle, String labelColumn, String labelStyle, boolean passThrough) {
        this.name = name;
        this.dataSource = dataSource;
        String userQuery = query;
        log.finest("Before esapi canonicalizing: " + userQuery);
        this.mQuery = ESAPI.encoder().canonicalize(userQuery, true);
        log.finest("After esapi canonicalizing: " + this.mQuery);
        if (!this.readMetadata(dataSource, topoName, featureTableName, topoColumnName)) {
            return;
        }
        this.passThrough = passThrough;
        this.renderStyleName = renderStyle;
        this.labelColumnName = labelColumn;
        this.labelStyleName = labelStyle;
        int id = 0;
        try {
            id = Integer.parseInt(srid);
        }
        catch (Exception e) {
            log.warning("Invalid SRID (0 is assigned).");
            id = 0;
        }
        this.srid = id;
    }

    public TopologyThemeDefinition(String name, String dataSource, String srid, String topoName, String featureTable, String edgeStyleName, String edgeMarkerStyleName, int edgeMarkerSize, String edgeLabelStyleName, String nodeStyleName, String nodeLabelStyleName, String faceStyleName, String faceLabelStyleName, boolean passThrough) {
        this.name = name;
        this.dataSource = dataSource;
        this.mQuery = null;
        this.topologyName = topoName;
        this.featureTable = featureTable;
        this.passThrough = passThrough;
        this.edgeStyle = edgeStyleName;
        this.nodeStyle = nodeStyleName;
        this.faceStyle = faceStyleName;
        this.edgeLabelStyle = edgeLabelStyleName;
        this.edgeMarkerStyle = edgeMarkerStyleName;
        this.edgeMarkerSize = edgeMarkerSize;
        this.nodeLabelStyle = nodeLabelStyleName;
        this.faceLabelStyle = faceLabelStyleName;
        this.debugTheme = true;
        int id = 0;
        try {
            id = Integer.parseInt(srid);
        }
        catch (Exception e) {
            log.warning("Invalid SRID (0 is assigned).");
            id = 0;
        }
        this.srid = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyThemeDefinition(String name, String dataSource, String topoName, String featureTableName, String topoColumnName, String keyColumnName, StylingRule[] styleRules, int srid, int cacheMode) {
        if (styleRules == null || styleRules.length < 1) {
            log.warning("There are no styling rules defined for this theme");
            return;
        }
        this.dataSource = dataSource;
        DBDataSource ds = (DBDataSource)DSManager.get(dataSource);
        if (ds == null) {
            log.severe("Could not get data source: " + dataSource);
            return;
        }
        this.mPre9i = ds.isPre9i();
        this.predefined = true;
        this.name = name;
        this.srid = srid;
        this.mStyleRules = styleRules;
        if (keyColumnName != null) {
            this.mKeyColumn = keyColumnName;
        }
        this.passThrough = false;
        if (!this.readMetadata(dataSource, topoName, featureTableName, topoColumnName)) {
            return;
        }
        this.cachingMode = cacheMode;
        if (cacheMode != 1 && cacheMode != 1 && cacheMode != 3) {
            this.cachingMode = 1;
        }
        this.cacheGeomGroup = topoName + "_" + featureTableName + "_" + topoColumnName + "_PDT_TOPO";
        this.cacheEdgeGroup = topoName + "_" + featureTableName + "_" + topoColumnName + "_PDT_EDGE_TOPO";
        this.cacheNodeGroup = topoName + "_" + featureTableName + "_" + topoColumnName + "_PDT_NODE_TOPO";
        Connection conn = null;
        boolean pinned = this.cachingMode == 2;
        try {
            conn = ds.getConnection();
            this.cacheSubRegionName = CacheMgr2.getSubRegionName(conn);
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.cacheGeomGroup, 0, pinned);
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.cacheEdgeGroup, 0, pinned);
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.cacheNodeGroup, 0, pinned);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {}
        }
        int i = 0;
        if (i < styleRules.length) {
            this.renderStyleName = styleRules[i].getFeatureStyleName();
            this.labelColumnName = styleRules[i].getLabelColumn();
            this.labelStyleName = styleRules[i].getLabelStyleName();
        }
        this.mQuery = this.createPredefinedQueryString();
        log.finer("[Predefined Query - Topology Theme] " + this.mQuery);
    }

    public void refreshPredefinedQueryString() {
        if (this.predefined) {
            this.mQuery = this.createPredefinedQueryString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMetadata(String dataSource, String topoName, String featureTableName, String topoColumnName) {
        AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(dataSource);
        if (ds == null) {
            log.severe("Could not get data source: " + dataSource);
            return false;
        }
        this.connectionUser = ds.getUser();
        Connection conn = null;
        String topName = topoName;
        String topOwner = this.connectionUser;
        int idx = topoName.indexOf(".");
        if (idx > -1) {
            topOwner = topoName.substring(0, idx);
            topName = topoName.substring(idx + 1, topoName.length());
        }
        String tbScheme = this.connectionUser;
        String tbName = featureTableName;
        int index = featureTableName.indexOf(".");
        if (index > -1) {
            tbScheme = featureTableName.substring(0, index);
            tbName = featureTableName.substring(index + 1, featureTableName.length());
        }
        String topoquery = "select * from all_sdo_topo_metadata where topology = ?  and table_name = ?  and column_name = ?  and table_owner = ?  and owner = ?";
        log.info("[Topology Metadata Query] " + topoquery);
        Statement topoStmt = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            boolean isVersionEnabled = ORAWorkspaceJDBCUtil.isVersionedTable(conn, null, tbName);
            topoStmt = conn.prepareStatement(topoquery);
            topoStmt.setString(1, topName.toUpperCase());
            if (!isVersionEnabled) {
                topoStmt.setString(2, tbName.toUpperCase());
            } else {
                topoStmt.setString(2, tbName.toUpperCase() + "_LT");
            }
            topoStmt.setString(3, topoColumnName.toUpperCase());
            topoStmt.setString(4, tbScheme.toUpperCase());
            topoStmt.setString(5, topOwner.toUpperCase());
            rs = topoStmt.executeQuery();
            if (!rs.next()) {
                log.severe("Unable to load Topology " + topName + ", Table Name " + tbName + ", Column Name " + topoColumnName + ", Table Owner " + tbScheme + ", Topology Owner " + topOwner);
                boolean bl = false;
                return bl;
            }
            this.topoOwner = rs.getString("owner");
            this.topologyName = rs.getString("topology");
            this.topologyId = rs.getInt("topology_id");
            this.tolerance = rs.getDouble("tolerance");
            this.featureTable = index < 0 ? rs.getString("table_name") : featureTableName.substring(0, index) + "." + rs.getString("table_name");
            this.topoColumn = rs.getString("column_name");
            this.tgLayerId = rs.getInt("tg_layer_id");
            this.tgLayerType = rs.getString("tg_layer_type");
            this.tgLayerLevel = rs.getInt("tg_layer_level");
            this.childLayerId = rs.getInt("child_layer_id");
            this.tableOwner = rs.getString("table_owner");
            if (this.tgLayerLevel > 0) {
                this.hierLayers = new int[this.tgLayerLevel + 1];
                if (this.tgLayerLevel == 1) {
                    this.hierLayers[1] = this.tgLayerId;
                    this.hierLayers[0] = this.childLayerId;
                } else {
                    if (rs != null) {
                        rs.close();
                    }
                    if (topoStmt != null) {
                        topoStmt.close();
                    }
                    String hiersql = "select tg_layer_id, child_layer_id from all_sdo_topo_metadata where topology_id = ? and owner = ?";
                    topoStmt = conn.prepareStatement(hiersql);
                    topoStmt.setInt(1, this.topologyId);
                    topoStmt.setString(2, this.topoOwner);
                    rs = topoStmt.executeQuery();
                    Hashtable<String, String> layerid = new Hashtable<String, String>(10);
                    while (rs.next()) {
                        if (rs.getString(2) == null) continue;
                        layerid.put(rs.getString(1), rs.getString(2));
                    }
                    int nextid = this.tgLayerId;
                    int pos = this.tgLayerLevel;
                    this.hierLayers[pos] = nextid;
                    while (pos > 0) {
                        nextid = Integer.parseInt(layerid.get(String.valueOf(nextid)).toString());
                        this.hierLayers[--pos] = nextid;
                    }
                }
            }
            this.getIndexTableName(conn);
        }
        catch (Exception ex) {
            log.severe("Topology load metadata Exception: " + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (topoStmt != null) {
                try {
                    topoStmt.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public void setASIS(boolean v) {
        this.passThrough = v;
    }

    public boolean getASIS() {
        return this.passThrough;
    }

    @Override
    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String getCacheGeomGroupName(int SRid) {
        Integer id = new Integer(SRid);
        Object obj = this.sridGeomCache.get(id);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public Hashtable getSRidGeomCache() {
        return this.sridGeomCache;
    }

    public void createCacheGeomGroup(int SRid) {
        Integer id = new Integer(SRid);
        if (this.sridGeomCache.get(id) != null) {
            log.info("Cache group for SRid " + SRid + " already exists.");
            return;
        }
        String CacheGeomGroup = this.topologyName + "_" + this.featureTable + "_" + this.topoColumn + "_" + SRid + "_PDT_TOPO";
        log.finer("Cache group: " + CacheGeomGroup);
        boolean pinned = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, CacheGeomGroup, 0, pinned);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        this.sridGeomCache.put(id, CacheGeomGroup);
    }

    public String getCacheEdgeGroupName(int SRid) {
        Integer id = new Integer(SRid);
        Object obj = this.sridEdgeCache.get(id);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public Hashtable getSRidEdgeCache() {
        return this.sridEdgeCache;
    }

    public void createCacheEdgeGroup(int SRid) {
        Integer id = new Integer(SRid);
        if (this.sridEdgeCache.get(id) != null) {
            log.info("Edge Cache group for SRid " + SRid + " already exists.");
            return;
        }
        String CacheEdgeGroup = this.topologyName + "_" + this.featureTable + "_" + this.topoColumn + "_" + SRid + "_PDT_EDGE_TOPO";
        log.finer("Edge Cache group: " + CacheEdgeGroup);
        boolean pinned = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, CacheEdgeGroup, 0, pinned);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        this.sridEdgeCache.put(id, CacheEdgeGroup);
    }

    public String getCacheNodeGroupName(int SRid) {
        Integer id = new Integer(SRid);
        Object obj = this.sridNodeCache.get(id);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public Hashtable getSRidNodeCache() {
        return this.sridNodeCache;
    }

    public void createCacheNodeGroup(int SRid) {
        Integer id = new Integer(SRid);
        if (this.sridNodeCache.get(id) != null) {
            log.info("Node Cache group for SRid " + SRid + " already exists.");
            return;
        }
        String CacheNodeGroup = this.topologyName + "_" + this.featureTable + "_" + this.topoColumn + "_" + SRid + "_PDT_EDGE_TOPO";
        log.finer("Node Cache group: " + CacheNodeGroup);
        boolean pinned = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, CacheNodeGroup, 0, pinned);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        this.sridNodeCache.put(id, CacheNodeGroup);
    }

    private String createPredefinedQueryString() {
        int i;
        String query = null;
        ArrayList<String> attrs = new ArrayList<String>(8);
        if (this.mStyleRules != null) {
            if (this.mStyleRules.length > 1) {
                log.warning("Topology theme uses just first styling rule. All other rules are ignored.");
            }
            for (int i2 = 0; i2 < 1; ++i2) {
                RenderingRule[] rrules;
                String[] attrColumns = this.mStyleRules[i2].getAttributeColumnsAsArray();
                if (attrColumns != null) {
                    for (int k = 0; k < attrColumns.length; ++k) {
                        String upAttr = attrColumns[k].toUpperCase();
                        if (attrs.contains(upAttr)) continue;
                        attrs.add(upAttr);
                    }
                }
                if ((rrules = this.mStyleRules[i2].getRenderingRules()) == null) continue;
                for (int k = 0; k < rrules.length; ++k) {
                    String[] styleColumns = rrules[k].getStyleColumns();
                    if (styleColumns != null) {
                        for (int l = 0; l < styleColumns.length; ++l) {
                            String styColumn = styleColumns[l].toUpperCase();
                            if (attrs.contains(styColumn)) continue;
                            attrs.add(styColumn);
                        }
                    }
                    String substyle = rrules[k].getSubStyleName();
                    String[] subColumns = rrules[k].getSubStyleColumns();
                    if (subColumns == null) continue;
                    for (int l = 0; l < subColumns.length; ++l) {
                        String styColumn = subColumns[l].toUpperCase();
                        if (attrs.contains(styColumn)) continue;
                        attrs.add(styColumn);
                    }
                }
            }
        }
        if (this.getIdentifiableColumns() != null) {
            Field[] infoCols = this.getIdentifiableColumns();
            for (int k = 0; k < infoCols.length; ++k) {
                int idx = attrs.indexOf(infoCols[k].getName());
                if (idx >= 0) continue;
                attrs.add(infoCols[k].getName());
            }
        }
        String table = this.featureTable;
        String column = this.topoColumn;
        if (this.topoView != null && this.topoViewColumn != null) {
            table = this.topoView;
            column = this.topoViewColumn;
        }
        String attrColumns = "";
        for (i = 0; i < attrs.size(); ++i) {
            attrColumns = attrColumns + ", " + attrs.get(i);
        }
        if (this.mStyleRules == null || this.mStyleRules.length < 1) {
            query = "SELECT " + column + ", null, null, null, -1" + attrColumns + " FROM " + table;
            return query;
        }
        query = "";
        for (i = 0; i < 1; ++i) {
            StylingRule rule = this.mStyleRules[i];
            String subQuery = "SELECT " + column + ", '" + rule.getFeatureStyleName() + "', " + rule.getLabelColumn() + ", '" + rule.getLabelStyleName() + "', " + rule.getLabelFunction() + attrColumns + " FROM " + table;
            if (this.mStyleRules[i].getFeatureCond() != null) {
                subQuery = subQuery + " WHERE " + this.mStyleRules[i].getFeatureCond();
            }
            if (this.mStyleRules.length == 1) {
                query = subQuery;
                continue;
            }
            if (i > 0) {
                query = query + " UNION ALL ";
            }
            query = query + subQuery;
        }
        return query;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public void setTopologyName(String topology) {
        this.topologyName = topology;
    }

    public int getTopologyID() {
        return this.topologyId;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public String getTopologyOwner() {
        return this.topoOwner;
    }

    public String getFeatureTable() {
        return this.featureTable;
    }

    public void setFeatureTable(String table) {
        this.featureTable = table;
    }

    public String getTopoGeometryColumn() {
        return this.topoColumn;
    }

    public void setTopoGeometryColumn(String column) {
        this.topoColumn = column;
    }

    public int getTopoLayerID() {
        return this.tgLayerId;
    }

    public String getTopoLayerType() {
        return this.tgLayerType;
    }

    public int getTopoLayerLevel() {
        return this.tgLayerLevel;
    }

    public int getChildLayerID() {
        return this.childLayerId;
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    public boolean isPre9i() {
        return this.mPre9i;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public String getRenderStyle() {
        return this.renderStyleName;
    }

    public void setRenderStyle(String style) {
        this.renderStyleName = style;
    }

    public String getLabelColumn() {
        return this.labelColumnName;
    }

    public void setLabelColumn(String column) {
        this.labelColumnName = column;
    }

    public String getLabelStyle() {
        return this.labelStyleName;
    }

    public void setLabelStyle(String style) {
        this.labelStyleName = style;
    }

    public String getEdgeGeometryColumn() {
        return this.edgeSpatialColumn;
    }

    public String getNodeGeometryColumn() {
        return this.nodeSpatialColumn;
    }

    public String getEdgeStyle() {
        return this.edgeStyle;
    }

    public String getEdgeLabelStyle() {
        return this.edgeLabelStyle;
    }

    public String getEdgeMarkerStyle() {
        return this.edgeMarkerStyle;
    }

    public int getEdgeMarkerSize() {
        return this.edgeMarkerSize;
    }

    public String getNodeStyle() {
        return this.nodeStyle;
    }

    public String getNodeLabelStyle() {
        return this.nodeLabelStyle;
    }

    public int getNodeMarkerSize() {
        return this.nodeMarkerSize;
    }

    public String getFaceStyle() {
        return this.faceStyle;
    }

    public String getFaceLabelStyle() {
        return this.faceLabelStyle;
    }

    public boolean getDebugTheme() {
        return this.debugTheme;
    }

    public int getCachingMode() {
        return this.cachingMode;
    }

    public String getCacheSubRegion() {
        return this.cacheSubRegionName;
    }

    public String getCacheGeomGroup() {
        return this.cacheGeomGroup;
    }

    public String getCacheEdgeGroup() {
        return this.cacheEdgeGroup;
    }

    public String getCacheNodeGroup() {
        return this.cacheNodeGroup;
    }

    public double getMinDistBetweenNodes() {
        return this.minDistBetweenNodes;
    }

    public void setMinDistBetweenNodes(double dist) {
        this.minDistBetweenNodes = dist;
    }

    public int[] getLayersHierarchy() {
        return this.hierLayers;
    }

    @Override
    public String getThemeType() {
        return "TOPOLOGY";
    }

    @Override
    public String getXMLDefinition() {
        StringBuffer xmlDef = new StringBuffer(2048);
        xmlDef.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(xmlDef);
        xmlDef.append(this.getAttributes());
        xmlDef.append(">\n");
        this.getInfoFields(xmlDef);
        StylingRule[] rules = this.mStyleRules;
        if (rules != null) {
            for (int i = 0; i < rules.length; ++i) {
                StylingRule sr = rules[i];
                xmlDef.append("  <rule" + PredGeomThemeDefinition.getRuleAttributes(sr) + ">\n");
                xmlDef.append(PredGeomThemeDefinition.getRuleFeatures(sr));
                xmlDef.append(PredGeomThemeDefinition.getRuleLabel(sr));
                xmlDef.append("  </rule>\n");
            }
        }
        xmlDef.append("</styling_rules>");
        return xmlDef.toString();
    }

    public String getAttributes() {
        String topoAttr = "";
        if (this.topologyName != null) {
            topoAttr = topoAttr + " topology_name=\"" + this.topologyName + "\"";
        }
        if (this.debugTheme) {
            topoAttr = topoAttr + " mode=\"debug\"";
        }
        return topoAttr;
    }

    void getCommonAttributes(StringBuffer xmlAttr) {
        String key;
        String themeType = this.getThemeType();
        if (themeType != null && themeType.trim().length() > 0) {
            xmlAttr.append(" theme_type=\"" + themeType + "\"");
        }
        if ((key = this.getKeyColumn()) != null && key.trim().length() > 0) {
            xmlAttr.append(" key_column=\"" + key + "\"");
        }
        int cm = this.getCachingMode();
        String caching = "normal";
        if (cm == 2) {
            caching = "all";
        } else if (cm == 3) {
            caching = "none";
        }
        if (caching != null && caching.trim().length() > 0) {
            xmlAttr.append(" caching=\"" + caching + "\"");
        }
    }

    void getInfoFields(StringBuffer infoFields) {
        if (this.identifiableColumns == null || this.identifiableColumns.length == 0) {
            return;
        }
        infoFields.append("  <hidden_info>\n");
        for (int i = 0; i < this.identifiableColumns.length; ++i) {
            infoFields.append("    <field column=\"" + this.identifiableColumns[i].getName() + "\"" + " name=\"" + this.identifiableColumns[i].getDisplayName() + "\"/>\n");
        }
        infoFields.append("  </hidden_info>\n");
    }

    public String getTopoView() {
        return this.topoView;
    }

    public String getTopoViewColumn() {
        return this.topoViewColumn;
    }

    public void setTopoViewParameters(String viewName, String viewcolumnName) {
        this.topoView = viewName;
        this.topoViewColumn = viewcolumnName;
        if (this.predefined && this.topoView != null && this.topoViewColumn != null) {
            this.mQuery = this.createPredefinedQueryString();
            log.finer("[Predefined Query - Topology Theme] " + this.mQuery);
        }
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public StylingRule[] getStylingRules() {
        return this.mStyleRules;
    }

    public void setStylingRules(StylingRule[] rules) {
        this.mStyleRules = rules;
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo ti = new BasicThemeInfo();
        ti.setName(this.getName());
        ti.setBaseTable(this.featureTable);
        ti.setType("TOPOLOGY");
        ti.setKeyColumn(this.getKeyColumn());
        ti.setSrid(this.getSrid());
        ti.setSpatialColumn(this.topoColumn);
        return ti;
    }

    @Override
    public String[] getRenderingStyles() {
        if (this.renderStyleName == null) {
            return null;
        }
        String[] styleNames = new String[]{this.renderStyleName.toUpperCase()};
        return styleNames;
    }

    @Override
    public String[] getLabelingStyles() {
        if (this.labelStyleName == null) {
            return null;
        }
        String[] styleNames = new String[]{this.labelStyleName.toUpperCase()};
        return styleNames;
    }

    @Override
    public String[] getLabelColumns() {
        String[] columns = null;
        if (!this.debugTheme) {
            if (this.labelColumnName != null) {
                columns = new String[]{this.labelColumnName};
            }
        } else {
            ArrayList<String> lbcols = new ArrayList<String>();
            if (this.edgeLabelStyle != null) {
                lbcols.add("edge_id");
            }
            if (this.nodeLabelStyle != null) {
                lbcols.add("node_id");
            }
            if (this.faceLabelStyle != null) {
                lbcols.add("face_id");
            }
            if (lbcols.size() > 0) {
                columns = lbcols.toArray(new String[lbcols.size()]);
            }
        }
        return columns;
    }

    public String getIndexTableName(Connection conn) {
        if (this.indexTableName != null) {
            return this.indexTableName;
        }
        this.indexTableName = JDBCUtil.getIndexTableName(conn, this.featureTable, this.tableOwner, this.topoColumn);
        return this.indexTableName;
    }
}

