/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

public class ComparisonOperator {
    public static String isEqualTo_OP = "=";
    public static String notEqual_OP = "!=";
    public static String notEqual2_OP = "<>";
    public static String lessThan_OP = "<";
    public static String greaterThan_OP = ">";
    public static String lessThanOrEqual_OP = "<=";
    public static String greaterThanOrEqual_OP = ">=";
    public static String like_OP = "like";
    public static String isNull_OP = "is null";
    public static String isNotNull_OP = "is not null";
    private String variable = null;
    private String operator = null;
    private String value = null;

    public ComparisonOperator() {
    }

    public ComparisonOperator(String var, String oper, String val) {
        this.variable = var;
        this.operator = oper;
        this.value = val;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String attr) {
        this.variable = attr;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String op) {
        if (op == null) {
            return;
        }
        this.operator = op;
        if (op.equalsIgnoreCase("is not null")) {
            this.value = "null";
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public String getAsWFSxml(int blankSpaces, String featName, String nameSpace) {
        if (this.variable == null || this.operator == null || this.value == null) {
            return "";
        }
        String tabs = "";
        for (int i = 0; i < blankSpaces; ++i) {
            tabs = tabs + " ";
        }
        String ns = "";
        if (nameSpace != null && nameSpace.trim().length() > 0) {
            ns = nameSpace.trim() + ":";
        }
        String op = null;
        if (this.operator.equalsIgnoreCase(isEqualTo_OP)) {
            op = "PropertyIsEqualTo";
        } else if (this.operator.equalsIgnoreCase(notEqual_OP) || this.operator.equalsIgnoreCase(notEqual2_OP)) {
            op = "PropertyIsNotEqualTo";
        } else if (this.operator.equalsIgnoreCase(lessThan_OP)) {
            op = "PropertyIsLessThan";
        } else if (this.operator.equalsIgnoreCase(greaterThan_OP)) {
            op = "PropertyIsGreaterThan";
        } else if (this.operator.equalsIgnoreCase(lessThanOrEqual_OP)) {
            op = "PropertyIsLessThanOrEqualTo";
        } else if (this.operator.equalsIgnoreCase(greaterThanOrEqual_OP)) {
            op = "PropertyIsGreaterThanOrEqualTo";
        } else if (this.operator.equalsIgnoreCase(like_OP)) {
            op = "PropertyIsLike";
        } else if (this.operator.equalsIgnoreCase(isNull_OP)) {
            op = "PropertyIsNull";
        } else if (this.operator.equalsIgnoreCase(isNotNull_OP)) {
            op = "PropertyIsNotEqualTo";
        } else {
            return "";
        }
        String fName = ns + featName;
        String atName = ns + this.variable.toUpperCase();
        String xml = tabs + "<ogc:" + op + ">\n";
        xml = xml + tabs + "  <ogc:PropertyName>" + atName + "</ogc:PropertyName>\n";
        if (!op.equals("PropertyIsNull")) {
            xml = xml + tabs + "  <ogc:Literal>" + this.value + "</ogc:Literal>\n";
        }
        xml = xml + tabs + "</ogc:" + op + ">\n";
        return xml;
    }

    public String getAsWFSstring() {
        if (this.variable == null || this.operator == null || this.value == null) {
            return "";
        }
        String op = null;
        if (this.operator.equalsIgnoreCase(isEqualTo_OP)) {
            op = "PropertyIsEqualTo";
        } else if (this.operator.equalsIgnoreCase(notEqual_OP) || this.operator.equalsIgnoreCase(notEqual2_OP)) {
            op = "PropertyIsNotEqualTo";
        } else if (this.operator.equalsIgnoreCase(lessThan_OP)) {
            op = "PropertyIsLessThan";
        } else if (this.operator.equalsIgnoreCase(greaterThan_OP)) {
            op = "PropertyIsGreaterThan";
        } else if (this.operator.equalsIgnoreCase(lessThanOrEqual_OP)) {
            op = "PropertyIsLessThanOrEqualTo";
        } else if (this.operator.equalsIgnoreCase(greaterThanOrEqual_OP)) {
            op = "PropertyIsGreaterThanOrEqualTo";
        } else if (this.operator.equalsIgnoreCase(like_OP)) {
            op = "PropertyIsLike";
        } else if (this.operator.equalsIgnoreCase(isNull_OP)) {
            op = "PropertyIsNull";
        } else if (this.operator.equalsIgnoreCase(isNotNull_OP)) {
            op = "PropertyIsNotEqualTo";
        } else {
            return "";
        }
        String atName = this.variable.toUpperCase();
        String xml = "<" + op + ">";
        xml = xml + "<PropertyName>" + atName + "</PropertyName>";
        if (!op.equals("PropertyIsNull")) {
            xml = xml + "<Literal>" + this.value + "</Literal>";
        }
        xml = xml + "</" + op + ">";
        return xml;
    }

    public static boolean isOperator(String op) {
        if (op == null) {
            return false;
        }
        return op.equalsIgnoreCase(isEqualTo_OP) || op.equalsIgnoreCase(notEqual_OP) || op.equalsIgnoreCase(notEqual2_OP) || op.equalsIgnoreCase(lessThan_OP) || op.equalsIgnoreCase(greaterThan_OP) || op.equalsIgnoreCase(lessThanOrEqual_OP) || op.equalsIgnoreCase(greaterThanOrEqual_OP) || op.equalsIgnoreCase(like_OP) || op.equalsIgnoreCase(isNull_OP) || op.equalsIgnoreCase(isNotNull_OP);
    }
}

