/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;

public class I18nUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static Hashtable rbCache = new Hashtable(100);

    public static final String getTranslation(String key, String className, String lang) {
        ResourceBundle rb = I18nUtil.getRB(className, lang);
        return I18nUtil.getTranslation(key, rb);
    }

    public static final String getTranslation(String key, ResourceBundle rb) {
        if (rb == null) {
            return key;
        }
        try {
            String res = rb.getString(key);
            return res;
        }
        catch (Exception ex) {
            log.finer("Cannot find translated text for '" + key + "'.");
            return key;
        }
    }

    public static ResourceBundle getRB(String className, String lang) {
        String country = null;
        int idx = lang.indexOf("-");
        if (idx >= 0) {
            country = lang.substring(idx + 1);
            lang = lang.substring(0, idx);
        }
        Locale locale = country == null ? new Locale(lang) : new Locale(lang, country);
        return I18nUtil.getRB(className, locale);
    }

    private static ResourceBundle getRB(String className, Locale locale) {
        String key;
        ResourceBundle res;
        String country = locale.getCountry();
        if (country != null && country.length() == 0) {
            country = null;
        }
        if ((res = (ResourceBundle)rbCache.get(key = className + "_" + locale.getLanguage() + (country == null ? "" : "_" + country))) != null) {
            return res;
        }
        try {
            res = ResourceBundle.getBundle(className, locale);
            if (res != null) {
                rbCache.put(key, res);
            }
            return res;
        }
        catch (MissingResourceException ex) {
            log.log(Level.WARNING, "Exception loading translated resources.", ex);
            return null;
        }
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isAscii(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (I18nUtil.isAsciiPrintable(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Locale locale = new Locale("zh", "cn");
        String country = locale.getCountry();
        System.out.println("locale lang: " + locale.getLanguage());
        System.out.println("locale country: " + locale.getCountry());
        System.out.println("country is empty:" + (country.length() == 0));
        String test = "R\u00e9al";
        System.out.println(test + " isPureAscii() : " + I18nUtil.isAscii(test));
        test = "Real";
        System.out.println(test + " isPureAscii() : " + I18nUtil.isAscii(test));
        test = "\u9608\u503c\u65e0\u6548\u3002";
        System.out.println(test + " isPureAscii() : " + I18nUtil.isAscii(test));
    }
}

