/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.lbs.foi.foiUtil;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.FieldArray;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.util.EPSG2SDO;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.mapviewer.share.util.SphereCG;
import oracle.mapviewer.utils.CSTransformUtils;
import oracle.mapviewer.utils.MapCSBean;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.SRSConstants;
import oracle.sdovis.Spheroid;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeList;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.Base64OutputStream;
import oracle.sdovis.util.EarthCGUtil;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.SSLUtil;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML3g;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class Util {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String WMTS_INFOFORMAT_GML = "APPLICATION/GML+XML; VERSION=3.1";
    public static final String WMTS_INFOFORMAT_XML = "TEXT/XML";
    public static final String WMTS_INFOFORMAT_PLAIN = "TEXT/PLAIN";
    public static final String WMTS_INFOFORMAT_HTML = "TEXT/HTML";
    public static final String WMTS_INFOFORMAT_JSON = "APPLICATION/JSON";
    public static final double METERS_PER_DEGREE = 111319.49079327358;
    public static final double PIXEL_SIZE = 2.8E-4;
    static String[] DDLKeys = new String[]{"CREATE ", "DROP ", "TRUNCATE ", "ALTER ", "ANALYZE ", "AUDIT ", "COMMENT ", "GRANT ", "NOAUDIT ", "RENAME ", "REVOKE ", "DELETE ", "INSERT ", "UPDATE ", "LOCK ", "CALL "};
    private static final double HalfPI = 1.5707963267948966;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] convert(String str) {
        int cnt = 0;
        double[] tmp = new double[str.length() / 2 + 1];
        StreamTokenizer nums = new StreamTokenizer(new StringReader(str.trim()));
        nums.whitespaceChars(44, 44);
        nums.whitespaceChars(59, 59);
        try {
            while (nums.nextToken() == -2) {
                tmp[cnt++] = nums.nval;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            double[] dArray = null;
            return dArray;
        }
        finally {
            nums = null;
        }
        if (cnt == 0) {
            return null;
        }
        double[] res = new double[cnt];
        for (int i = 0; i < cnt; ++i) {
            res[i] = tmp[i];
        }
        tmp = null;
        return res;
    }

    public static ArrayList splitBy(String str, String delim) {
        return (ArrayList)SharedUtils.splitBy(str, delim);
    }

    public static Shape getShape(double[] coords, boolean close) {
        GeneralPath gp = new GeneralPath(0);
        gp.moveTo((float)coords[0], (float)coords[1]);
        for (int i = 1; i < coords.length / 2; ++i) {
            gp.lineTo((float)coords[i * 2], (float)coords[i * 2 + 1]);
        }
        if (close) {
            gp.closePath();
        }
        return gp;
    }

    public static Rectangle2D.Double mbr(double[] coords) {
        double ymax;
        double xmax;
        double xmin = xmax = coords[0];
        double ymin = ymax = coords[1];
        for (int i = 1; i < coords.length / 2; ++i) {
            if (xmin > coords[i * 2]) {
                xmin = coords[i * 2];
            }
            if (xmax < coords[i * 2]) {
                xmax = coords[i * 2];
            }
            if (ymin > coords[i * 2 + 1]) {
                ymin = coords[i * 2 + 1];
            }
            if (!(ymax < coords[i * 2 + 1])) continue;
            ymax = coords[i * 2 + 1];
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinaryFromURL(URL u) {
        HttpURLConnection c = null;
        InputStream is = null;
        try {
            String proto = u.getProtocol();
            if (proto.equals("https")) {
                HttpsURLConnection sc = (HttpsURLConnection)u.openConnection();
                String hostName = u.getHost();
                SSLSocketFactory sslFactory = SSLUtil.getSSLSocketFactory(hostName);
                if (sslFactory != null) {
                    sc.setSSLSocketFactory(sslFactory);
                }
                c = sc;
            } else {
                c = (HttpURLConnection)u.openConnection();
            }
            c.setDefaultUseCaches(false);
            is = c.getInputStream();
            byte[] buf = new byte[65536];
            int len = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            len = is.read(buf);
            while (len > 0) {
                baos.write(buf, 0, len);
                len = is.read(buf);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignore) {}
            if (c != null) {
                c.disconnect();
            }
        }
    }

    public static byte[] readBinaryFromURL(String http) {
        try {
            URL u = new URL(http);
            return Util.readBinaryFromURL(u);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public static byte[] readFile(String file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        ByteArrayOutputStream bo = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int len = is.read(buffer);
        while (len >= 0) {
            bo.write(buffer, 0, len);
            len = is.read(buffer);
        }
        bo.close();
        is.close();
        return bo.toByteArray();
    }

    public static Connection connect(String user, String passwd, String tnsName, int rowPref) {
        String baseURL = "jdbc:oracle:oci8:@" + tnsName;
        Connection mConnection = null;
        if (rowPref <= 0) {
            rowPref = 32;
        }
        try {
            if (!DriverManager.getDrivers().hasMoreElements()) {
                DriverManager.registerDriver((Driver)new OracleDriver());
            }
            mConnection = DriverManager.getConnection(baseURL, user, passwd);
            ((OracleConnection)mConnection).setDefaultRowPrefetch(rowPref);
            mConnection.setAutoCommit(false);
            return mConnection;
        }
        catch (Exception er) {
            log.severe("Failed to connect using TNS name: " + tnsName);
            log.log(Level.SEVERE, er.getMessage(), er);
            return null;
        }
    }

    public static Connection connect(String host, String sid, String port, String user, String passwd, String mode, int rowPref) {
        String baseURL = Util.getConnStr(mode, host, port, sid);
        Connection mConnection = null;
        if (rowPref <= 0) {
            rowPref = 32;
        }
        try {
            if (!DriverManager.getDrivers().hasMoreElements()) {
                DriverManager.registerDriver((Driver)new OracleDriver());
            }
            mConnection = DriverManager.getConnection(baseURL, user, passwd);
            ((OracleConnection)mConnection).setDefaultRowPrefetch(rowPref);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            log.warning("connecting to database using jdbc thin driver...");
            baseURL = Util.getConnStr("thin", host, port, sid);
            try {
                if (!DriverManager.getDrivers().hasMoreElements()) {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                }
                mConnection = DriverManager.getConnection(baseURL, user, passwd);
                ((OracleConnection)mConnection).setDefaultRowPrefetch(rowPref);
            }
            catch (SQLException ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
        }
        catch (Error er) {
            log.log(Level.WARNING, er.getMessage(), er);
            log.warning("connecting to database using jdbc thin driver...");
            baseURL = Util.getConnStr("thin", host, port, sid);
            try {
                if (!DriverManager.getDrivers().hasMoreElements()) {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                }
                mConnection = DriverManager.getConnection(baseURL, user, passwd);
                ((OracleConnection)mConnection).setDefaultRowPrefetch(rowPref);
            }
            catch (SQLException ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
                return null;
            }
        }
        try {
            mConnection.setAutoCommit(false);
        }
        catch (SQLException as) {
            // empty catch block
        }
        return mConnection;
    }

    public static String getJDBCDriverVersion(Connection conn) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            return meta.getDriverVersion();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String getDBVersion(Connection conn) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            return meta.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String getDBName(Connection conn) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            return meta.getDatabaseProductName();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static boolean isPre9i(Connection conn) {
        String ver = Util.getDBVersion(conn);
        if (ver.indexOf("Oracle8i") >= 0) {
            return true;
        }
        if (ver.indexOf("Oracle9i") >= 0) {
            return false;
        }
        return ver.indexOf("Oracle7") >= 0;
    }

    public static boolean is9i(Connection conn) {
        String ver = Util.getDBVersion(conn);
        return ver.indexOf("Oracle9i") >= 0;
    }

    public static boolean is10g(Connection conn) {
        String ver = Util.getDBVersion(conn);
        return ver.indexOf("Oracle10") >= 0 && ver.indexOf(" 10.") > 0;
    }

    public static boolean is11g(Connection conn) {
        String ver = Util.getDBVersion(conn);
        return ver.indexOf(" 11.") > 0;
    }

    public static boolean is10gOrAfter(Connection conn) {
        String ver = Util.getDBVersion(conn);
        return Util.is10gOrAfter(ver);
    }

    public static boolean is10gOrAfter(String ver) {
        if (ver == null) {
            return false;
        }
        return ver.indexOf(" 10.") > 0 || Util.is11gOrAfter(ver);
    }

    public static boolean is11gOrAfter(Connection conn) {
        String ver = Util.getDBVersion(conn);
        return Util.is11gOrAfter(ver);
    }

    public static boolean is11gOrAfter(String ver) {
        if (ver == null) {
            return false;
        }
        return ver.indexOf(" 11.") > 0 || ver.indexOf(" 12.") > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentSchema(Connection conn, String dataSrc) {
        String query2;
        if (conn == null) {
            return null;
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            if (conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") > -1) {
                String query2 = "SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') from DUAL";
                st = conn.createStatement();
                rs = st.executeQuery(query2);
                if (rs.next()) {
                    String res;
                    String string = res = rs.getString(1);
                    return string;
                }
                log.warning("Empty result set when querying CURRENT_SCHEMA.");
                String res = null;
                return res;
            }
            query2 = conn.getMetaData().getUserName();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            String string = null;
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception e) {}
            }
        }
        return query2;
    }

    public static boolean isGeodetic(int srid) {
        return srid > 0 && srid < 32768;
    }

    public static String getConnStr(String mode, String host, String port, String sid) {
        if (host == null || host.length() == 0 || port == null || port.length() == 0 || sid == null || sid.length() == 0 || mode == null) {
            return "jdbc:oracle:oci8:@";
        }
        if (mode.equalsIgnoreCase("default")) {
            return "jdbc:oracle:oci8:@";
        }
        if (mode.equalsIgnoreCase("thin")) {
            if (sid.startsWith("//")) {
                String service = sid.substring(2);
                return "jdbc:oracle:thin:@//" + host + ":" + port + "/" + service;
            }
            return "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
        }
        if (mode.equalsIgnoreCase("oci8") || mode.equalsIgnoreCase("oci")) {
            return "jdbc:oracle:oci8:@(DESCRIPTION = (ADDRESS_LIST = (ADDRESS = (PROTOCOL = TCP)(HOST = " + host + ")(PORT = " + port + ")))" + "(CONNECT_DATA = (SID = " + sid + ")))";
        }
        if (mode.equalsIgnoreCase("kprb")) {
            return null;
        }
        return null;
    }

    public static boolean isQueryAllowed(String query) {
        if (query == null || query.length() < 10) {
            return false;
        }
        query = query.toUpperCase();
        String[] result = query.split("\\s");
        for (int x = 0; x < result.length; ++x) {
            String w = result[x];
            if (w.length() == 0) continue;
            w = w + " ";
            for (int i = 0; i < DDLKeys.length; ++i) {
                if (!DDLKeys[i].equals(w) && !(";" + DDLKeys[i]).equals(w)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] convertMBR(double[] mbr, int fromSRID, int toSRID, Connection conn) {
        if (mbr == null) {
            return null;
        }
        double xl = mbr[0];
        double yl = mbr[1];
        double xh = mbr[2];
        double yh = mbr[3];
        if (Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh)) {
            return mbr;
        }
        double[] cvmbr = null;
        if (MapCSBean.supported(fromSRID, toSRID)) {
            cvmbr = new double[4];
            double[] temp = new double[3];
            CSTransformUtils.doTransform(xl, yl, "" + fromSRID, "" + toSRID, temp);
            cvmbr[0] = temp[0];
            cvmbr[1] = temp[1];
            CSTransformUtils.doTransform(xh, yh, "" + fromSRID, "" + toSRID, temp);
            cvmbr[2] = temp[0];
            cvmbr[3] = temp[1];
            return cvmbr;
        }
        String cvquery = "select sdo_cs.transform(MDSYS.SDO_GEOMETRY( 2003,?, NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3),MDSYS.SDO_ORDINATE_ARRAY(?,?,?,?)),?) from dual";
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(cvquery);
            stmt.setInt(1, fromSRID);
            stmt.setDouble(2, xl);
            stmt.setDouble(3, yl);
            stmt.setDouble(4, xh);
            stmt.setDouble(5, yh);
            stmt.setInt(6, toSRID);
            rs = stmt.executeQuery();
            if (rs.next()) {
                STRUCT st = JDBCUtil.getOracleSTRUCT(rs, 1);
                JGeometry geom = JGeometry.load((STRUCT)st);
                cvmbr = geom.getMBR();
            }
        }
        catch (Exception ex) {
            log.warning("Exception while transforming input MBR: " + ex);
            double[] dArray = null;
            return dArray;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return cvmbr;
    }

    public static Rectangle2D geom2MBR(JGeometry geom, boolean isGeodetic) {
        if (!isGeodetic) {
            double[] mbr = geom.getMBR();
            return new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
        }
        double[] coords = geom.getOrdinatesArray();
        double[] longRange = new double[2];
        double[] latRange = new double[2];
        EarthCGUtil.unisphere2LongLat(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], longRange, latRange);
        return new Rectangle2D.Double(longRange[0], latRange[0], longRange[1] - longRange[0], latRange[1] - latRange[0]);
    }

    public static SRS WKTtoSRS(int srid, String wkt) throws Exception {
        SRS srs = null;
        if ((wkt == null || wkt.length() == 0) && srid == 999999) {
            srs = new SRS();
            srs.set(srid, null, 1.0, 0, null);
            return srs;
        }
        srs = new SRS(null);
        int csType = 0;
        String wkt_ = wkt.toUpperCase();
        if (wkt_.indexOf("PROJCS") >= 0) {
            csType = 2;
        } else if (wkt_.indexOf("GEOGCS") >= 0) {
            csType = 1;
        } else if (wkt_.indexOf("LOCAL_CS") >= 0) {
            csType = 3;
        }
        Spheroid spheroid = SRSCache.extractSpheroidInfo(wkt_);
        int idx = wkt_.lastIndexOf("UNIT");
        int idx2 = 0;
        if (idx < 0) {
            throw new Exception("Cannot find UNIT parameter in wkt.");
        }
        double cf = 0.0;
        String unit = null;
        try {
            while (wkt_.charAt(idx) != '[') {
                ++idx;
            }
            while (wkt_.charAt(idx) != '\"') {
                ++idx;
            }
            idx2 = ++idx;
            while (wkt_.charAt(idx2) != '\"') {
                ++idx2;
            }
            unit = wkt_.substring(idx, idx2);
            if (unit == null || unit.length() == 0) {
                throw new Exception("No unit name.");
            }
            idx = idx2;
            while (wkt_.charAt(idx) != ',') {
                ++idx;
            }
            idx2 = ++idx;
            while (wkt_.charAt(idx2) != ']') {
                ++idx2;
            }
            try {
                cf = Double.valueOf(wkt_.substring(idx, idx2));
            }
            catch (Exception ex) {
                throw new Exception("Cannot parse unit conversion factor.");
            }
        }
        catch (Exception e) {
            throw new Exception("Error parsing UNIT parameter in wkt.");
        }
        if (csType == 1) {
            Hashtable angularUnitList = SRSConstants.getAngularUnitList();
            if (angularUnitList.get(unit) == null) {
                angularUnitList.put(unit, new Double(cf));
            }
        } else {
            Hashtable distUnitList = SRSConstants.getDistanceUnitList();
            if (distUnitList.get(unit) == null) {
                distUnitList.put(unit, new Double(cf));
            }
        }
        srs.set(srid, unit, cf, csType, spheroid);
        return srs;
    }

    public static Point2D getLinePoint(double[] coords, double relativePosition) {
        double rPosition = relativePosition;
        double xprev = 0.0;
        double yprev = 0.0;
        double xpost = 0.0;
        double ypost = 0.0;
        if (coords == null || coords.length < 4) {
            return null;
        }
        if (relativePosition < 0.0 || relativePosition > 1.0) {
            return null;
        }
        double length = 0.0;
        for (int i = 0; i < coords.length / 2 - 1; ++i) {
            xprev = coords[2 * i];
            yprev = coords[2 * i + 1];
            xpost = coords[2 * i + 2];
            ypost = coords[2 * i + 3];
            length += Math.sqrt(Math.pow(xprev - xpost, 2.0) + Math.pow(yprev - ypost, 2.0));
        }
        double targetLen = length * relativePosition;
        double acumLen = 0.0;
        for (int i = 0; i < coords.length / 2 - 1; ++i) {
            xpost = coords[2 * i + 2];
            xprev = coords[2 * i];
            double dx = xpost - xprev;
            ypost = coords[2 * i + 3];
            yprev = coords[2 * i + 1];
            double dy = ypost - yprev;
            double segLen = Math.sqrt(dx * dx + dy * dy);
            if (!((acumLen += segLen) >= targetLen)) continue;
            double targetLenInSeg = targetLen - (acumLen - segLen);
            rPosition = targetLenInSeg / segLen;
            break;
        }
        double x = xprev + (xpost - xprev) * rPosition;
        double y = yprev + (ypost - yprev) * rPosition;
        Point2D.Double res = new Point2D.Double(x, y);
        return res;
    }

    public static double[] getLineSegment(double[] coords, double relativePosition) {
        double rPosition = relativePosition;
        double xprev = 0.0;
        double yprev = 0.0;
        double xpost = 0.0;
        double ypost = 0.0;
        if (coords == null || coords.length < 4) {
            return null;
        }
        if (relativePosition < 0.0 || relativePosition > 1.0) {
            return null;
        }
        double length = 0.0;
        for (int i = 0; i < coords.length / 2 - 1; ++i) {
            xprev = coords[2 * i];
            yprev = coords[2 * i + 1];
            xpost = coords[2 * i + 2];
            ypost = coords[2 * i + 3];
            length += Math.sqrt(Math.pow(xprev - xpost, 2.0) + Math.pow(yprev - ypost, 2.0));
        }
        double targetLen = length * relativePosition;
        double acumLen = 0.0;
        for (int i = 0; i < coords.length / 2 - 1; ++i) {
            xpost = coords[2 * i + 2];
            xprev = coords[2 * i];
            double dx = xpost - xprev;
            ypost = coords[2 * i + 3];
            yprev = coords[2 * i + 1];
            double dy = ypost - yprev;
            double segLen = Math.sqrt(dx * dx + dy * dy);
            if (!((acumLen += segLen) >= targetLen)) continue;
            double[] res = new double[]{xprev, yprev, xpost, ypost};
            return res;
        }
        return null;
    }

    public static double[] transform(Connection conn, double x, double y, double size, int inSrid, int targetSrid) {
        double half = size * 0.5;
        double[] res = Util.transform(conn, x - half, y - half, x + half, y + half, inSrid, targetSrid);
        if (res == null || res.length < 3) {
            return null;
        }
        double cx = (res[0] + res[2]) * 0.5;
        double cy = (res[1] + res[3]) * 0.5;
        double ns = Math.abs(res[3] - res[1]);
        res[0] = cx;
        res[1] = cy;
        res[2] = ns;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] transform(Connection conn, double minX, double minY, double maxX, double maxY, int inSrid, int targetSrid) {
        if (inSrid == targetSrid || targetSrid == 0 || inSrid == 0) {
            return new double[]{minX, minY, maxX, maxY};
        }
        if (MapCSBean.supported(inSrid, targetSrid)) {
            double[] cvmbr = new double[4];
            double[] temp = new double[3];
            CSTransformUtils.doTransform(minX, minY, "" + inSrid, "" + targetSrid, temp);
            cvmbr[0] = temp[0];
            cvmbr[1] = temp[1];
            CSTransformUtils.doTransform(maxX, maxY, "" + inSrid, "" + targetSrid, temp);
            cvmbr[2] = temp[0];
            cvmbr[3] = temp[1];
            return cvmbr;
        }
        String query = "SELECT sdo_cs.transform(MDSYS.SDO_GEOMETRY(2003, ?, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3),MDSYS.SDO_ORDINATE_ARRAY(?, ?, ?, ?)), ?) FROM dual";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(query);
            ps.setInt(1, inSrid);
            ps.setDouble(2, minX);
            ps.setDouble(3, minY);
            ps.setDouble(4, maxX);
            ps.setDouble(5, maxY);
            ps.setInt(6, targetSrid);
            rs = ps.executeQuery();
            if (rs.next()) {
                STRUCT st = JDBCUtil.getOracleSTRUCT(rs, 1);
                JGeometry geom = JGeometry.load((STRUCT)st);
                double[] mbr = geom.getMBR();
                double[] result = new double[]{mbr[0], mbr[1], mbr[2], mbr[3]};
                double[] dArray = result;
                return dArray;
            }
            double[] st = null;
            return st;
        }
        catch (Exception ex) {
            log.warning("unable to transform rectangle due to: " + ex.getMessage());
            double[] dArray = null;
            return dArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e1) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] transform(Connection conn, double x, double y, int inSrid, int targetSrid) {
        if (inSrid == targetSrid || targetSrid == 0 || inSrid == 0) {
            return new double[]{x, y};
        }
        if (MapCSBean.supported(inSrid, targetSrid)) {
            double[] temp = new double[2];
            CSTransformUtils.doTransform(x, y, "" + inSrid, "" + targetSrid, temp);
            return temp;
        }
        String query = "SELECT sdo_cs.transform(MDSYS.SDO_GEOMETRY(2001, ?,MDSYS.SDO_POINT_TYPE(?,?,null),null,null), ?) FROM DUAL";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(query);
            ps.setInt(1, inSrid);
            ps.setDouble(2, x);
            ps.setDouble(3, y);
            ps.setInt(4, targetSrid);
            rs = ps.executeQuery();
            if (rs.next()) {
                JGeometry geom = JGeometry.load((STRUCT)((STRUCT)rs.getObject(1)));
                double[] mbr = geom.getMBR();
                double[] res = new double[]{mbr[0], mbr[1]};
                double[] dArray = res;
                return dArray;
            }
            double[] geom = null;
            return geom;
        }
        catch (Exception ex) {
            log.warning(ex.getMessage());
            double[] dArray = null;
            return dArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e1) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSDOGeometry transform(Connection conn, JSDOGeometry inGeom, int inSrid, int targetSrid) {
        if (inSrid == targetSrid || targetSrid == 0 || inSrid == 0) {
            return inGeom;
        }
        if (MapCSBean.supported(inSrid, targetSrid)) {
            double[] temp = new double[2];
            return CSTransformUtils.doTransform(inGeom, "" + inSrid, "" + targetSrid);
        }
        String query = "select sdo_cs.transform(?, ?) from dual";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            JSDOGeometry oGeom;
            ps = conn.prepareStatement(query);
            Object[] descs = Util.createDBGeomDescriptors(conn);
            STRUCT st = JGeometry.store((JGeometry)inGeom, (Connection)conn, (Object[])descs);
            ps.setObject(1, st);
            ps.setInt(2, targetSrid);
            rs = ps.executeQuery();
            rs.next();
            JSDOGeometry jSDOGeometry = oGeom = JDBCUtil.loadGeometry(rs, 1, false);
            return jSDOGeometry;
        }
        catch (Exception ex) {
            log.severe("error transforming geometry: " + ex);
            JSDOGeometry jSDOGeometry = inGeom;
            return jSDOGeometry;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                ps.close();
            }
            catch (Exception e) {}
        }
    }

    public static final double dist(double[] p1, double[] p2, double smax, double t, double flat) {
        double phi1 = 1.5707963267948966 - Math.abs(p1[1]) < 1.0E-10 ? p1[1] : Math.atan(t * Math.tan(p1[1]));
        double phi2 = 1.5707963267948966 - Math.abs(p2[1]) < 1.0E-10 ? p2[1] : Math.atan(t * Math.tan(p2[1]));
        double phim = (phi1 + phi2) / 2.0;
        double dphim = (phi1 - phi2) / 2.0;
        double lamm = Math.abs(p1[0] - p2[0]);
        if (lamm > Math.PI) {
            lamm = Math.PI * 2 - lamm;
        }
        if ((lamm /= 2.0) < 5.0E-8 && Math.abs(dphim) < 5.0E-8) {
            return 0.0;
        }
        if (1.5707963267948966 - lamm < 5.0E-8 && Math.abs(phim) < 5.0E-8 || 1.5707963267948966 - Math.abs(dphim) < 5.0E-8) {
            return -1.0;
        }
        double sphim = Math.sin(phim);
        double cphim = Math.cos(phim);
        double sdphim = Math.sin(dphim);
        double cdphim = Math.cos(dphim);
        double slamm = Math.sin(lamm);
        double cl = sdphim * sdphim + slamm * slamm * (cdphim * cdphim - sphim * sphim);
        double d = Math.acos(1.0 - 2.0 * cl);
        double sd = Math.sin(d);
        double ce = 2.0 * (1.0 - 2.0 * cl);
        double cyp = 2.0 * sphim * sphim * cdphim * cdphim / (1.0 - cl);
        double ctp = 2.0 * sdphim * sdphim * cphim * cphim / cl;
        double cx = cyp + ctp;
        double cy = cyp - ctp;
        double ct = d / sd;
        double cd = 4.0 * ct * ct;
        double ca = cd * ce;
        return smax * sd * (ct - flat * (ct * cx - cy) / 4.0 + flat * flat * (cx * (ca + (ct - (ca - ce) / 2.0) * cx) - cy * (2.0 * cd + ce * cy) + cd * cx * cy) / 64.0);
    }

    public static Field getFieldFromResultSet(int sqlType, ResultSet rs, int index) throws SQLException, IOException {
        Field f = new Field();
        switch (sqlType) {
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                f.setString(rs.getString(index));
                return f;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setDouble(rs.getDouble(index));
                return f;
            }
            case 4: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setInt(rs.getInt(index));
                return f;
            }
            case 6: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setFloat(rs.getFloat(index));
                return f;
            }
            case -5: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setLong(rs.getLong(index));
                return f;
            }
            case 5: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setShort(rs.getShort(index));
                return f;
            }
            case 16: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setBoolean(rs.getBoolean(index));
                return f;
            }
            case 91: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setDate(rs.getDate(index).getTime());
                return f;
            }
            case 92: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setDate(rs.getTime(index).getTime());
                return f;
            }
            case 93: {
                if (rs.getObject(index) == null) {
                    return f;
                }
                f.setDate(rs.getTimestamp(index).getTime());
                return f;
            }
            case 2005: {
                f.setString(Util.getClobContents(rs.getClob(index)));
                return f;
            }
            case 2003: {
                double[] array;
                if (rs.getObject(index) == null) {
                    return new FieldArray(null, "double");
                }
                ARRAY a = (ARRAY)rs.getObject(index);
                if (a == null) {
                    return new FieldArray(null, "double");
                }
                String basetype = a.getBaseTypeName();
                String arrayType = "double";
                if (basetype != null && !basetype.equalsIgnoreCase("NUMBER")) {
                    arrayType = "string";
                }
                if ((array = a.getDoubleArray()) == null || array.length == 0) {
                    return new FieldArray(null, arrayType);
                }
                String[] varray = new String[array.length];
                for (int k = 0; k < array.length; ++k) {
                    varray[k] = String.valueOf(array[k]);
                }
                f = new FieldArray(varray, arrayType);
                return f;
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getClobContents(Clob clob) throws SQLException, IOException {
        if (clob == null) {
            return null;
        }
        try (BufferedReader reader = null;){
            int chunkSize = ((CLOB)clob).getChunkSize();
            StringBuffer sb = new StringBuffer(chunkSize);
            char[] buffer = new char[chunkSize];
            reader = new BufferedReader(clob.getCharacterStream());
            int len = -1;
            while ((len = reader.read(buffer, 0, chunkSize)) != -1) {
                sb.append(buffer, 0, len);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static final void putClobContents(Clob clob, String s) throws SQLException, IOException {
        Writer writer = clob.setCharacterStream(1L);
        writer.write(s);
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBlobContents(Blob blob) throws SQLException, IOException {
        if (blob == null) {
            return null;
        }
        InputStream byteStream = null;
        ByteArrayOutputStream baos = null;
        try {
            byteStream = blob.getBinaryStream();
            int len = -1;
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((len = byteStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (byteStream != null) {
                byteStream.close();
            }
        }
    }

    public static final void putBlobContents(Blob blob, byte[] b) throws SQLException, IOException {
        OutputStream os = blob.setBinaryStream(1L);
        os.write(b);
        os.flush();
        os.close();
    }

    public static final Style getStyle(String styleName, StyleCache sc, Hashtable tempStyles) {
        if (styleName == null) {
            return null;
        }
        styleName = styleName.toUpperCase();
        Style style = null;
        if (tempStyles != null) {
            style = (Style)tempStyles.get(styleName);
        }
        if (style == null && sc != null) {
            style = sc.get(styleName);
        }
        return style;
    }

    public static final boolean isBindingParameterAllowed(Object parameter) {
        return true;
    }

    public static Object[] createDBGeomDescriptors(Connection conn) throws SQLException {
        StructDescriptor geomDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)conn);
        StructDescriptor pointDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)conn);
        ArrayDescriptor elemInfoDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)conn);
        ArrayDescriptor ordinatesDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)conn);
        return new Object[]{geomDesc, pointDesc, elemInfoDesc, ordinatesDesc};
    }

    public static JGeometry processSRIDConversion(String dataSrc, JGeometry geometry, int outSRID) throws Exception {
        if (geometry == null) {
            return null;
        }
        if (geometry.getSRID() <= 0 || outSRID <= 0) {
            return geometry;
        }
        if (geometry.isPoint()) {
            double[] coords = geometry.getPoint();
            double[] result = Util.processPointSRIDConversion(dataSrc, geometry.getSRID() + "", outSRID + "", coords[0], coords[1]);
            if (result == null) {
                return null;
            }
            return new JGeometry(result[0], result[1], outSRID);
        }
        String query = "select sdo_cs.transform(?,?) from dual";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(dataSrc, null);
            if (conn.isClosed()) {
                log.severe("connection obtained is already closed!");
                throw new Exception("error obtaining connection!");
            }
            stmt = conn.prepareStatement(query);
            STRUCT obj = null;
            Object[] descs = Util.createDBGeomDescriptors(conn);
            obj = JGeometry.store((JGeometry)geometry, (Connection)conn, (Object[])descs);
            stmt.setObject(1, obj);
            stmt.setInt(2, outSRID);
            rs = stmt.executeQuery();
            if (rs.next()) {
                JGeometry geom;
                STRUCT st = JDBCUtil.getOracleSTRUCT(rs, 1);
                JGeometry jGeometry = geom = JGeometry.load((STRUCT)st);
                return jGeometry;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception("error while processing info_request.", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return null;
    }

    private static double[] processPointSRIDConversion(String dataSrc, String inSRID, String outSRID, double x, double y) throws Exception {
        double[] result = null;
        if (inSRID == null || outSRID == null || inSRID.equals(outSRID) || inSRID.equals("0") || outSRID.equals("0")) {
            result = new double[]{x, y};
            return result;
        }
        int _inSRID = Integer.parseInt(inSRID);
        int _outSRID = Integer.parseInt(outSRID);
        JGeometry p = JGeometry.createPoint((double[])new double[]{x, y}, (int)2, (int)_inSRID);
        String query = "select sdo_cs.transform(\nMDSYS.SDO_GEOMETRY(2001, ?, MDSYS.SDO_POINT_TYPE(?,?,null), null, null), ?)\nfrom dual";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(dataSrc, null);
            if (conn.isClosed()) {
                log.severe("connection obtained is already closed!");
                throw new Exception("error obtaining connection!");
            }
            STRUCT st = null;
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, _inSRID);
            stmt.setDouble(2, x);
            stmt.setDouble(3, y);
            stmt.setInt(4, _outSRID);
            rs = stmt.executeQuery();
            if (rs.next()) {
                double[] mbr;
                st = JDBCUtil.getOracleSTRUCT(rs, 1);
                JGeometry geom = JGeometry.load((STRUCT)st);
                double[] dArray = mbr = geom.getPoint();
                return dArray;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            result = null;
            throw new Exception("error while processing info_request.", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int EPSGsrid_To_Oraclesrid(String datasource, int epsg_srid) {
        if (datasource == null) {
            return 0;
        }
        int srid = 0;
        String query = "select sdo_cs.map_epsg_srid_to_oracle(?) from dual";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(datasource, null);
            if (conn == null) {
                int n = 0;
                return n;
            }
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, epsg_srid);
            rs = stmt.executeQuery();
            if (rs.next()) {
                srid = rs.getInt(1);
            }
        }
        catch (Exception e) {
            log.severe("Unable to convert EPSG SRID to SDO: " + e.getMessage());
            srid = 0;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                DSUtil.closeDBConnection(conn, datasource);
            }
        }
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int Oraclesrid_To_EPSGsrid(String datasource, int sdo_srid) {
        if (datasource == null) {
            return 0;
        }
        int srid = 0;
        String query = "select sdo_cs.map_oracle_srid_to_epsg(?) from dual";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(datasource, null);
            if (conn == null) {
                int n = 0;
                return n;
            }
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, sdo_srid);
            rs = stmt.executeQuery();
            if (rs.next()) {
                srid = rs.getInt(1);
            }
        }
        catch (Exception e) {
            log.severe("Unable to convert Oracle SRID to EPSG: " + e.getMessage());
            srid = 0;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                DSUtil.closeDBConnection(conn, datasource);
            }
        }
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsOracleSRID(String datasource, int srid) {
        if (datasource == null) {
            return false;
        }
        String query = "select cs_name from cs_srs where srid = ?";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(datasource, null);
            if (conn == null) {
                boolean bl = false;
                return bl;
            }
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, srid);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.severe("Exception in exitsOracleSRID: " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                DSUtil.closeDBConnection(conn, datasource);
            }
        }
        return false;
    }

    public static String issueHttpGetRequest(String urlRequest) throws IOException {
        if (urlRequest == null || urlRequest.trim().length() == 0) {
            return null;
        }
        InputStream is = null;
        String s = null;
        URL wu = null;
        BufferedReader d = null;
        StringBuffer sb = new StringBuffer(1000);
        String result = "";
        try {
            wu = new URL(urlRequest);
            is = wu.openStream();
            d = new BufferedReader(new InputStreamReader(is));
            while ((s = d.readLine()) != null) {
                sb.append(s + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (d != null) {
                try {
                    d.close();
                }
                catch (Exception ex) {}
            }
            if (is != null) {
                is.close();
            }
            wu = null;
        }
        return sb.toString();
    }

    public static String issueGZIPHttpGetRequest(String urlRequest) throws IOException {
        if (urlRequest == null || urlRequest.trim().length() == 0) {
            return null;
        }
        InputStream is = null;
        GZIPInputStream gis = null;
        String s = null;
        URL wu = null;
        URLConnection uc = null;
        BufferedReader d = null;
        StringBuffer sb = new StringBuffer(1000);
        String result = "";
        try {
            wu = new URL(urlRequest);
            uc = wu.openConnection();
            uc.setRequestProperty("Accept-Encoding", "gzip");
            is = uc.getInputStream();
            gis = new GZIPInputStream(is);
            d = new BufferedReader(new InputStreamReader(gis));
            while ((s = d.readLine()) != null) {
                sb.append(s + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (d != null) {
                try {
                    d.close();
                }
                catch (Exception ex) {}
            }
            if (gis != null) {
                gis.close();
            }
            wu = null;
        }
        return sb.toString();
    }

    public static String normalize(String nodeName) {
        if (nodeName == null) {
            return null;
        }
        if (nodeName.indexOf(":") >= 0) {
            return nodeName.substring(nodeName.indexOf(":") + 1);
        }
        return nodeName;
    }

    public static JGeometry linearizeCircle(JGeometry g) {
        double[] mbr = g.getMBR();
        double radius = (mbr[2] - mbr[0]) / 2.0;
        double arcTol = radius / 20.0;
        return g.densifyArcs(arcTol);
    }

    public static Field getField(String fieldname, Field[] searchfields) {
        if (fieldname == null || searchfields == null) {
            return null;
        }
        Field f = null;
        for (int i = 0; i < searchfields.length; ++i) {
            String name = searchfields[i].getName();
            if (!name.equalsIgnoreCase(fieldname)) continue;
            f = searchfields[i];
            break;
        }
        return f;
    }

    public static boolean isFullExtent(double xl, double yl, double xh, double yh) {
        return Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getColumnTypeName(String dataSource, String table, String column) {
        if (dataSource == null) return null;
        if (table == null) return null;
        if (column == null) {
            return null;
        }
        String query = "select data_type from all_tab_columns where owner = ? and table_name = ? and column_name = ?";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            AbstractDBDataSource adb = (AbstractDBDataSource)DSManager.get(dataSource);
            if (adb == null) {
                String string = null;
                return string;
            }
            String user = adb.getUser();
            conn = adb.getConnection();
            if (conn == null || conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") == -1) {
                String ex = null;
                return ex;
            }
            String owner = user;
            String tbName = table;
            int index = table.indexOf(".");
            if (index > -1) {
                owner = table.substring(0, index);
                tbName = table.substring(index + 1, table.length());
            } else {
                String currentSchema = Util.getCurrentSchema(conn, null);
                if (currentSchema != null) {
                    owner = currentSchema;
                }
            }
            stmt = conn.prepareStatement(query);
            stmt.setString(1, owner.toUpperCase());
            stmt.setString(2, tbName.toUpperCase());
            stmt.setString(3, column.toUpperCase());
            rs = stmt.executeQuery();
            if (!rs.next()) return null;
            String string = rs.getString(1);
            return string;
        }
        catch (Exception e) {
            log.severe("Exception in getColumnTypeName: " + e.getMessage());
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JGeometry[] getGeometries(String dataSource, String table, String spatial_column, String key_column, String[] keys, String workspace, boolean fastUnpickle) {
        if (dataSource == null || table == null || spatial_column == null || key_column == null || keys == null || keys.length == 0) {
            return null;
        }
        String inclause = " in (";
        for (int i = 0; i < keys.length; ++i) {
            inclause = i == 0 ? inclause + "'" + keys[i] + "'" : inclause + ",'" + keys[i] + "'";
        }
        inclause = inclause + ")";
        String query = "select " + spatial_column + " from " + table + " where " + key_column + inclause;
        ArrayList<JSDOGeometry> geometries = new ArrayList<JSDOGeometry>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            if (workspace != null) {
                Util.gotoWorkspace(conn, workspace);
            }
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                JSDOGeometry geom = JDBCUtil.loadGeometry(rs, 1, fastUnpickle);
                if (geom == null) continue;
                geometries.add(geom);
            }
        }
        catch (Exception e) {
            log.severe("Exception in getGeometries: " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                try {
                    if (workspace != null) {
                        Util.gotoWorkspace(conn, "LIVE");
                    }
                    DSUtil.closeDBConnection(conn, dataSource);
                }
                catch (Exception ex) {}
            }
        }
        if (geometries.size() == 0) {
            return null;
        }
        return geometries.toArray(new JGeometry[geometries.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map peekDynamicQuery(String query, String ds, String geomColumn) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String queryM = "select * from ( " + query + " ) where rownum = 1";
        try {
            AbstractDBDataSource adb = (AbstractDBDataSource)DSManager.get(ds);
            if (adb == null) {
                Map map = null;
                return map;
            }
            String user = adb.getUser();
            conn = adb.getConnection();
            if (conn == null || conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") == -1) {
                Map ex = null;
                return ex;
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery(queryM);
            ResultSetMetaData md = rs.getMetaData();
            int srid = 0;
            int geomColIndex = -1;
            String colName = null;
            String colType = null;
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                colName = md.getColumnName(i);
                colType = md.getColumnTypeName(i);
                if (colType.indexOf("SDO_GEOMETRY") <= 0 && !Util.isSTGeometryType(colType) || geomColumn != null && !geomColumn.equalsIgnoreCase(colName)) continue;
                geomColIndex = i;
                break;
            }
            if (geomColIndex < 0) {
                log.severe("Cannot find a geometry column.");
                Map i = null;
                return i;
            }
            boolean hasRecord = false;
            if (rs.next()) {
                JSDOGeometry geom = JDBCUtil.loadGeometry(rs, geomColIndex, true);
                srid = geom.getSRID();
                hasRecord = true;
            }
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("gc", colName);
            res.put("srid", "" + srid);
            res.put("hasrecord", "" + hasRecord);
            HashMap<String, String> hashMap = res;
            return hashMap;
        }
        catch (Exception e) {
            log.warning("Exception in peeking a query's result set: " + e.getMessage());
            Map map = null;
            return map;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static boolean isSTGeometryType(String typeName) {
        if (typeName == null) {
            return false;
        }
        String type = typeName.toUpperCase();
        return type.equals("ST_GEOMETRY") || type.equals("MDSYS.ST_GEOMETRY") || type.equals("ST_POINT") || type.equals("MDSYS.ST_POINT") || type.equals("ST_LINESTRING") || type.equals("MDSYS.ST_LINESTRING") || type.equals("ST_POLYGON") || type.equals("MDSYS.ST_POLYGON") || type.equals("ST_GEOMCOLLECTION") || type.equals("MDSYS.ST_GEOMCOLLECTION") || type.equals("ST_CURVE") || type.equals("MDSYS.ST_CURVE") || type.equals("ST_SURFACE") || type.equals("MDSYS.ST_SURFACE") || type.equals("ST_CIRCULARSTRING") || type.equals("MDSYS.ST_CIRCULARSTRING") || type.equals("ST_COMPOUNDCURVE") || type.equals("MDSYS.ST_COMPOUNDCURVE") || type.equals("ST_MULTIPOINT") || type.equals("MDSYS.ST_MULTIPOINT") || type.equals("ST_MULTILINESTRING") || type.equals("MDSYS.ST_MULTILINESTRING") || type.equals("ST_MULTIPOLYGON") || type.equals("MDSYS.ST_MULTIPOLYGON") || type.equals("ST_MULTICURVE") || type.equals("MDSYS.ST_MULTICURVE") || type.equals("ST_MULTISURFACE") || type.equals("MDSYS.ST_MULTISURFACE") || type.equals("ST_CURVEPOLYGON") || type.equals("MDSYS.ST_CURVEPOLYGON");
    }

    public static Point2D rotatePoint(double x, double y, double centerx, double centery, double degrees) {
        if (degrees < -360.0 || degrees > 360.0) {
            return null;
        }
        double Pi = Math.PI;
        double angle = degrees * Pi / 180.0;
        double Xo = centerx;
        double Yo = centery;
        double dx = x - Xo;
        double dy = y - Yo;
        double nx = dx * Math.cos(angle) - dy * Math.sin(angle) + Xo;
        double ny = dx * Math.sin(angle) + dy * Math.cos(angle) + Yo;
        return new Point2D.Double(nx, ny);
    }

    public static double[] rotateMBR(double xl, double yl, double xh, double yh, double degrees) {
        double Xo = (xl + xh) / 2.0;
        double Yo = (yl + yh) / 2.0;
        double[] mbr = new double[4];
        Point2D xlyl = Util.rotatePoint(xl, yl, Xo, Yo, degrees);
        if (xlyl == null) {
            return null;
        }
        mbr[0] = xlyl.getX();
        mbr[1] = xlyl.getY();
        mbr[2] = xlyl.getX();
        mbr[3] = xlyl.getY();
        Point2D xlyh = Util.rotatePoint(xl, yh, Xo, Yo, degrees);
        if (xlyh == null) {
            return null;
        }
        mbr[0] = Math.min(mbr[0], xlyh.getX());
        mbr[1] = Math.min(mbr[1], xlyh.getY());
        mbr[2] = Math.max(mbr[2], xlyh.getX());
        mbr[3] = Math.max(mbr[3], xlyh.getY());
        Point2D xhyh = Util.rotatePoint(xh, yh, Xo, Yo, degrees);
        if (xhyh == null) {
            return null;
        }
        mbr[0] = Math.min(mbr[0], xhyh.getX());
        mbr[1] = Math.min(mbr[1], xhyh.getY());
        mbr[2] = Math.max(mbr[2], xhyh.getX());
        mbr[3] = Math.max(mbr[3], xhyh.getY());
        Point2D xhyl = Util.rotatePoint(xh, yl, Xo, Yo, degrees);
        if (xhyl == null) {
            return null;
        }
        mbr[0] = Math.min(mbr[0], xhyl.getX());
        mbr[1] = Math.min(mbr[1], xhyl.getY());
        mbr[2] = Math.max(mbr[2], xhyl.getX());
        mbr[3] = Math.max(mbr[3], xhyl.getY());
        return mbr;
    }

    public static JGeometry rotateGeometry(JGeometry geom, double centerX, double centerY, double angle) {
        if (geom == null) {
            return null;
        }
        JGeometry centerGeom = new JGeometry(1, 0, new int[]{1, 1, 1}, new double[]{centerX, centerY});
        JGeometry geomRot = null;
        try {
            geomRot = geom.affineTransforms(false, 0.0, 0.0, 0.0, false, null, 0.0, 0.0, 0.0, true, centerGeom, null, angle * Math.PI / 180.0, -1, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 0, false, null, null);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
        return geomRot;
    }

    public static JGeometry scaleGeometry(JGeometry geom, double refPointX, double refPointY, double scaleX, double scaleY, double scaleZ) {
        if (geom == null || scaleX < 0.0 || scaleY < 0.0 || scaleZ < 0.0) {
            return null;
        }
        JGeometry centerGeom = new JGeometry(1, 0, new int[]{1, 1, 1}, new double[]{refPointX, refPointY});
        JGeometry geomScale = null;
        try {
            geomScale = geom.affineTransforms(false, 0.0, 0.0, 0.0, true, centerGeom, scaleX, scaleY, scaleZ, false, null, null, 0.0, 0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 0, false, null, null);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
        return geomScale;
    }

    public static String getRatioScale(String dsrc, String sdoSRID, String nativeScale) {
        if (dsrc == null || sdoSRID == null || nativeScale == null) {
            return null;
        }
        int id = 0;
        String idstr = null;
        int index = sdoSRID.indexOf(":");
        idstr = index == -1 ? sdoSRID : sdoSRID.substring(index + 1, sdoSRID.length());
        double nvScale = 0.0;
        try {
            id = Integer.parseInt(idstr);
            nvScale = Double.parseDouble(nativeScale);
        }
        catch (Exception ex) {
            return null;
        }
        SRSCache sc = DSManager.getSRSCache(dsrc);
        if (sc == null) {
            return null;
        }
        SRS srs = sc.get(id);
        if (srs == null) {
            return null;
        }
        double scale = srs.getRatioScale(nvScale, null);
        if (scale <= 0.0) {
            return null;
        }
        return String.valueOf((long)(scale + 0.5));
    }

    public static Point2D[] getJavaPointsForGeometryCollection(JGeometry geom) {
        if (geom == null) {
            return null;
        }
        if (geom.getType() != 4) {
            return null;
        }
        double[] ordinates = geom.getOrdinatesArray();
        int[] elemInfo = geom.getElemInfo();
        int dim = geom.getDimensions();
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        for (int i = 0; i < elemInfo.length; i += 3) {
            int etype = elemInfo[i + 1] % 10;
            if (etype != 1) continue;
            int numpts = elemInfo[i + 2];
            int pos = elemInfo[i];
            for (int k = 0; k < numpts; ++k) {
                Point2D.Double pt = new Point2D.Double(ordinates[pos - 1 + k * dim], ordinates[pos + k * dim]);
                points.add(pt);
            }
        }
        if (points.size() == 0) {
            return null;
        }
        return points.toArray(new Point2D[points.size()]);
    }

    public static boolean gotoWorkspace(Connection conn, String wspName) throws Exception {
        try {
            return Util.gotoWorkspace(conn, wspName, null, null, null, null, false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public static boolean gotoWorkspaceSavedPoint(Connection conn, String wspName, String wspSavedPoint) throws Exception {
        try {
            return Util.gotoWorkspace(conn, wspName, wspSavedPoint, null, null, null, false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public static boolean gotoWorkspaceDate(Connection conn, String wspName, String wspDate, String wspDateFormat, String wspDateNlsParam, boolean wspDateTsWtz) throws Exception {
        try {
            return Util.gotoWorkspace(conn, wspName, null, wspDate, wspDateFormat, wspDateNlsParam, wspDateTsWtz);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public static boolean gotoWorkspace(Connection conn, String wspName, String wspSavedPoint, String wspDate, String wspDateFormat, String wspDateNlsParam, boolean wspDateTsWtz) throws Exception {
        if (conn == null) {
            return false;
        }
        Statement callstmt = null;
        if (wspName != null) {
            try {
                String callexe = "{ call dbms_wm.GotoWorkspace('" + wspName + "') }";
                callstmt = conn.prepareCall(callexe);
                callstmt.execute();
                callstmt.close();
                if (wspSavedPoint != null) {
                    callexe = "{ call dbms_wm.GotoSavepoint('" + wspSavedPoint + "') }";
                    callstmt = conn.prepareCall(callexe);
                    callstmt.execute();
                    callstmt.close();
                }
                if (wspDate != null) {
                    callexe = "{ call dbms_wm.GotoDate('" + wspDate + "','" + wspDateFormat + "'";
                    callexe = wspDateNlsParam != null ? callexe + ",'" + wspDateNlsParam + "'," + wspDateTsWtz + ") }" : callexe + ",null," + wspDateTsWtz + ") }";
                    callstmt = conn.prepareCall(callexe);
                    callstmt.execute();
                    callstmt.close();
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw new Exception(ex);
            }
            finally {
                try {
                    if (callstmt != null) {
                        callstmt.close();
                        callstmt = null;
                    }
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    public static final byte[] int2bytes(int i) {
        return new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
    }

    public static final int bytes2int(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public static JGeometry to2DGeom(JGeometry geom) {
        int i;
        if (geom == null) {
            return null;
        }
        int dim_ = geom.getDimensions();
        if (dim_ == 2) {
            return geom;
        }
        int srid_ = geom.getSRID();
        int gtype_ = geom.getType();
        if (gtype_ == 1) {
            double[] pt_ = geom.getPoint();
            double[] pt = new double[]{pt_[0], pt_[1]};
            return JGeometry.createPoint((double[])pt, (int)2, (int)srid_);
        }
        int[] elemInfo_ = geom.getElemInfo();
        double[] ords_ = geom.getOrdinatesArray();
        int numPoints = ords_.length / dim_;
        int numElements = elemInfo_.length / 3;
        int[] elemInfo = new int[elemInfo_.length];
        double[] ords = new double[numPoints * 2];
        elemInfo[0] = elemInfo_[0];
        elemInfo[1] = elemInfo_[1];
        elemInfo[2] = elemInfo_[2];
        for (i = 1; i < numElements; ++i) {
            elemInfo[i * 3] = elemInfo_[i * 3];
            elemInfo[i * 3 + 1] = elemInfo_[i * 3 + 1];
            int pointIndex = (elemInfo_[i * 3 + 2] - 1) / dim_;
            elemInfo[i * 3 + 2] = pointIndex * 2 + 1;
        }
        for (i = 0; i < numPoints; ++i) {
            ords[i * 2] = ords_[i * dim_];
            ords[i * 2 + 1] = ords_[i * dim_ + 1];
        }
        int gtype = 2000 + gtype_;
        return new JGeometry(gtype, srid_, elemInfo, ords);
    }

    public static Rectangle2D getOptimalFilterQueryWindow(double xmin, double ymin, double xmax, double ymax, boolean isGeodetic, String unit) {
        double minx = xmin;
        double miny = ymin;
        double maxx = xmax;
        double maxy = ymax;
        boolean adjusted = false;
        if (isGeodetic && unit != null && "DECIMAL DEGREE".equals(unit)) {
            double h;
            double w = Math.abs(maxx - minx);
            if (w > 360.0) {
                double cx_;
                double d = cx_ = 180.0 - Math.abs((minx + maxx) / 2.0) >= Math.abs((minx + maxx) / 2.0) ? 0.0 : 180.0;
                if (cx_ == 0.0) {
                    minx = -180.0;
                    maxx = 180.0;
                } else {
                    minx = 0.0;
                    maxx = 360.0;
                }
                adjusted = true;
            }
            if ((h = Math.abs(maxy - miny)) > 180.0) {
                double cy_;
                double d = cy_ = 90.0 - Math.abs((miny + maxy) / 2.0) >= Math.abs((miny + maxy) / 2.0) ? 0.0 : 90.0;
                if (cy_ == 0.0) {
                    miny = -90.0;
                    maxy = 90.0;
                } else {
                    miny = 0.0;
                    maxy = 180.0;
                }
                adjusted = true;
            }
            if (adjusted) {
                log.info("Adjusted filter query window: " + minx + " , " + miny + " , " + maxx + " , " + maxy);
            }
        }
        Rectangle2D.Double out = new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
        return out;
    }

    public static String base64Encode(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            Base64OutputStream bo = new Base64OutputStream(bytes, false);
            bo.write(data);
            bo.flush();
            bo.close();
            return bytes.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getSRSAxisOrder(String dataSource, int srid) {
        if (dataSource == null) {
            return null;
        }
        String query = "select COORD_AXIS_ORIENTATION, \"ORDER\" from sdo_coord_axes a, sdo_coord_ref_sys b where b.srid = ? and a.COORD_SYS_ID = b.COORD_SYS_ID order by \"ORDER\"";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> axis = new ArrayList<String>();
        try {
            AbstractDBDataSource adb = (AbstractDBDataSource)DSManager.get(dataSource);
            if (adb == null) {
                String[] stringArray = null;
                return stringArray;
            }
            conn = adb.getConnection();
            if (conn == null || conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") == -1) {
                String[] stringArray = null;
                return stringArray;
            }
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, srid);
            rs = stmt.executeQuery();
            while (rs.next()) {
                axis.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            log.severe("Exception in getSRSAxisOrder: " + e.getMessage());
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
        if (axis.size() != 0) return axis.toArray(new String[axis.size()]);
        return null;
    }

    public static double convertToPixelSize(SizeDefinition size, VisContext vc) {
        double pixelY;
        if (size == null || vc == null) {
            return Double.NaN;
        }
        if (size.isPixelUnit()) {
            return size.getValue();
        }
        Rectangle2D deviceWindow = vc.getDeviceWindow();
        Rectangle2D queryWindow = vc.getQueryWindow();
        if (deviceWindow == null || queryWindow == null || Util.isFullExtent(queryWindow.getMinX(), queryWindow.getMinX(), queryWindow.getMaxX(), queryWindow.getMaxY()) || queryWindow.getWidth() == 0.0 && queryWindow.getHeight() == 0.0) {
            return size.getValue();
        }
        double pixelX = queryWindow.getWidth() / deviceWindow.getWidth();
        pixelX = pixelY = queryWindow.getHeight() / deviceWindow.getHeight();
        Double convFactor = null;
        if (size.getUnit() != null) {
            convFactor = SRS.getDistanceConversionFactor(size.getUnit());
        }
        if (size.isPixelUnit()) {
            return size.getValue();
        }
        if (convFactor != null) {
            double cv = size.getValue() * convFactor;
            if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                double dgw = SphereCG.convertRadius(0.0, 0.0, cv);
                return dgw / pixelY + 0.5;
            }
            return cv / pixelY + 0.5;
        }
        return size.getValue();
    }

    public static int getOracleSRID(String dataSource, String nameSRS) {
        int index;
        if (nameSRS == null) {
            return 0;
        }
        String srsName = nameSRS;
        int srid = 0;
        if ((srsName.indexOf("epsg.xml") > -1 || srsName.indexOf("#") > -1) && (index = srsName.indexOf("#")) > -1) {
            srsName = "EPSG:" + srsName.substring(index + 1, srsName.length());
        }
        String sridS = "";
        sridS = srsName;
        int index2 = srsName.indexOf(":");
        if (index2 > -1) {
            sridS = srsName.substring(index2 + 1, srsName.length());
        }
        int srsid = 0;
        try {
            srsid = Integer.parseInt(sridS);
        }
        catch (Exception ex) {
            return 0;
        }
        if (srsName.toUpperCase().indexOf("EPSG:") == -1) {
            srid = srsid;
        } else {
            if (dataSource == null) {
                return 0;
            }
            int sdosrid = 0;
            String sridmap = EPSG2SDO.EPSGtoSDO(String.valueOf(srsid));
            sdosrid = sridmap != null ? Integer.parseInt(sridmap) : Util.EPSGsrid_To_Oraclesrid(dataSource, srsid);
            srid = sdosrid > 0 ? sdosrid : (Util.existsOracleSRID(dataSource, srsid) ? srsid : 0);
        }
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reverseAxisOrder(String dataSource, int srid) {
        if (dataSource == null || srid <= 0) {
            return false;
        }
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(dataSource, null);
            int axisOrder = GML3g.reverseAxisOrder((int)1, (int)srid, (Connection)conn);
            if (axisOrder == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                DSUtil.closeDBConnection(conn, dataSource);
            }
        }
    }

    public static String getFeatureInfoInHTML(VisContext vc, JSDOGeometry geomRect) {
        double[] mbr = geomRect.getMBR();
        log.finest("query mbr: " + mbr[0] + "," + mbr[1] + "," + mbr[2] + "," + mbr[3]);
        double tol = (mbr[3] - mbr[1]) / 1000.0;
        if (tol <= 0.0) {
            tol = 1.0E-8;
            log.warning("tolerance is reset to 1.0e-8.");
        }
        String isGeodetic = vc.getSrs().isGeodetic() ? "true" : "false";
        StringBuffer sb = new StringBuffer(512);
        try {
            int i;
            ThemeList themes = vc.getThemeList();
            Vector<Theme> vectorTmp = new Vector<Theme>(themes.size());
            for (i = 0; i < themes.size(); ++i) {
                Theme t = themes.getTheme(i);
                if (!(t instanceof PredefinedGeometryTheme)) continue;
                vectorTmp.addElement(t);
            }
            for (i = vectorTmp.size() - 1; i >= 0; --i) {
                PredefinedGeometryTheme theme = (PredefinedGeometryTheme)vectorTmp.elementAt(i);
                StyledFeatureI[] sf = theme.getProducer().getStyledFeatures();
                String strNames = null;
                String[] attrArray = null;
                sb.append("<table border=\"1\">");
                int featureCount = 0;
                for (int j = 0; j < sf.length; ++j) {
                    int k;
                    String strVal;
                    JSDOGeometry geom = sf[j].getGeometry();
                    if (geom == null) {
                        log.warning("No geometry object in a styled features.");
                        continue;
                    }
                    if (!geom.anyInteract(geomRect, tol, isGeodetic)) {
                        log.finest("Skipping feature in theme: " + ((Theme)theme).getName() + " with geometry: " + geom.toString());
                        continue;
                    }
                    if (featureCount == 0) {
                        strNames = foiUtil.getJSONAttrNamesString((Field[])Util.getFeatureAttributes(sf[j], false));
                        if (strNames == null || strNames.trim().length() == 0) {
                            log.warning("Failed to get attribute names from styled features.");
                            break;
                        }
                        attrArray = Util.convertJSONArrayToStringArray(strNames);
                        if (attrArray == null || attrArray.length == 0) {
                            log.warning("Failed to get the attribute names from: " + strNames);
                            break;
                        }
                    }
                    if ((strVal = foiUtil.getJSONAttrString((Field[])Util.getFeatureAttributes(sf[j], false))) == null || strVal.trim().length() == 0) {
                        log.warning("Failed to get attribute values from styled features.");
                        break;
                    }
                    String[] valArray = Util.convertJSONArrayToStringArray(strVal);
                    if (attrArray == null || valArray == null || attrArray.length <= 0 || attrArray.length != valArray.length) continue;
                    if (featureCount == 0) {
                        sb.append("<tr>");
                        for (k = 0; k < attrArray.length; ++k) {
                            sb.append("<th>" + attrArray[k] + "</th>");
                        }
                        sb.append("</tr>");
                    }
                    sb.append("<tr>");
                    for (k = 0; k < attrArray.length; ++k) {
                        sb.append("<td>" + valArray[k] + "</td>");
                    }
                    sb.append("</tr>");
                    ++featureCount;
                }
                sb.append("</table>");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFeatureInfoInJSON(VisContext vc, JSDOGeometry geomRect) {
        double[] mbr = geomRect.getMBR();
        log.finest("query mbr: " + mbr[0] + "," + mbr[1] + "," + mbr[2] + "," + mbr[3]);
        double tol = (mbr[3] - mbr[1]) / 100.0;
        if (tol <= 0.0) {
            tol = 1.0E-8;
            log.warning("tolerance is reset to 1.0e-8.");
        }
        String isGeodetic = vc.getSrs().isGeodetic() ? "true" : "false";
        try {
            ThemeList themes = vc.getThemeList();
            Vector<Theme> vectorTmp = new Vector<Theme>(themes.size());
            for (int i = 0; i < themes.size(); ++i) {
                Theme t = themes.getTheme(i);
                if (!(t instanceof PredefinedGeometryTheme)) continue;
                vectorTmp.addElement(t);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"layers\":[");
            for (int i = vectorTmp.size() - 1; i >= 0; --i) {
                sb.append("{");
                PredefinedGeometryTheme theme = (PredefinedGeometryTheme)vectorTmp.elementAt(i);
                StyledFeatureI[] sf = theme.getProducer().getStyledFeatures();
                sb.append("\"layer_name\":\"" + ((Theme)theme).getName() + "\"");
                int featureCount = 0;
                for (int j = 0; j < sf.length; ++j) {
                    String strVal;
                    JSDOGeometry geom = sf[j].getGeometry();
                    if (geom == null) {
                        log.warning("No geometry object in a styled features.");
                        continue;
                    }
                    if (!geom.anyInteract(geomRect, tol, isGeodetic)) {
                        log.finest("Skipping feature in theme: " + ((Theme)theme).getName() + " with geometry: " + geom.toString());
                        continue;
                    }
                    String strAttr = null;
                    if (featureCount == 0) {
                        strAttr = foiUtil.getJSONAttrNamesString((Field[])Util.getFeatureAttributes(sf[j], false));
                        if (strAttr != null && strAttr.trim().length() > 0) {
                            sb.append(", \"attr_names\":" + strAttr + ",");
                        } else {
                            log.warning("Failed to get attribute names from styled features.");
                            break;
                        }
                    }
                    if ((strVal = foiUtil.getJSONAttrString((Field[])Util.getFeatureAttributes(sf[j], false))) != null && strVal.trim().length() > 0) {
                        if (featureCount == 0) {
                            sb.append("\"attr_values\":");
                        }
                        if (featureCount == 0 && sf.length > 1) {
                            sb.append("[");
                        }
                        sb.append(strVal);
                        if (featureCount < sf.length - 1) {
                            sb.append(",");
                        }
                        ++featureCount;
                        continue;
                    }
                    log.warning("Failed to get attribute values from styled features.");
                }
                if (featureCount > 0 && sf.length > 1) {
                    sb.append("]");
                }
                sb.append("}");
                if (vectorTmp.size() <= 1 || i == 0) continue;
                sb.append(",");
            }
            sb.append("]}");
            String strResult = sb.toString();
            int length1 = strResult.length();
            strResult = strResult.replaceAll(",]", "]");
            strResult = strResult.replaceAll(",}", "}");
            int length2 = strResult.length();
            log.finest("trailing ',' removed: " + (length1 - length2));
            return strResult;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFeatureInfoInXML(VisContext vc, JSDOGeometry geomRect) {
        double[] mbr = geomRect.getMBR();
        log.finest("query mbr: " + mbr[0] + "," + mbr[1] + "," + mbr[2] + "," + mbr[3]);
        double tol = (mbr[3] - mbr[1]) / 100.0;
        if (tol <= 0.0) {
            tol = 1.0E-8;
            log.warning("tolerance is reset to 1.0e-8.");
        }
        String isGeodetic = vc.getSrs().isGeodetic() ? "true" : "false";
        StringBuffer sb = new StringBuffer(512);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        try {
            int i;
            ThemeList themes = vc.getThemeList();
            Vector<Theme> vectorTmp = new Vector<Theme>(themes.size());
            for (i = 0; i < themes.size(); ++i) {
                Theme t = themes.getTheme(i);
                if (!(t instanceof PredefinedGeometryTheme)) continue;
                vectorTmp.addElement(t);
            }
            sb.append("<layers>\n");
            for (i = vectorTmp.size() - 1; i >= 0; --i) {
                PredefinedGeometryTheme theme = (PredefinedGeometryTheme)vectorTmp.elementAt(i);
                StyledFeatureI[] sf = theme.getProducer().getStyledFeatures();
                String strNames = null;
                String[] attrArray = null;
                sb.append("  <layer name=\"" + ((Theme)theme).getName() + "\">\n");
                int featureCount = 0;
                for (int j = 0; j < sf.length; ++j) {
                    JSDOGeometry geom = sf[j].getGeometry();
                    if (geom == null) {
                        log.warning("No geometry object in a styled features.");
                        continue;
                    }
                    if (!geom.anyInteract(geomRect, tol, isGeodetic)) {
                        log.finest("Skipping feature in theme: " + ((Theme)theme).getName() + " with geometry: " + geom.toString());
                        continue;
                    }
                    String strVal = null;
                    String[] valArray = null;
                    if (featureCount == 0) {
                        strNames = foiUtil.getJSONAttrNamesString((Field[])Util.getFeatureAttributes(sf[j], false));
                        if (strNames == null || strNames.trim().length() == 0) break;
                        attrArray = Util.convertJSONArrayToStringArray(strNames);
                        if (attrArray == null || attrArray.length == 0) {
                            log.warning("Failed to get the attribute names from: " + strNames);
                            break;
                        }
                    }
                    if ((strVal = foiUtil.getJSONAttrString((Field[])Util.getFeatureAttributes(sf[j], false))) == null || strVal.length() == 0) break;
                    valArray = Util.convertJSONArrayToStringArray(strVal);
                    if (attrArray == null || valArray == null || attrArray.length <= 0 || attrArray.length != valArray.length) continue;
                    sb.append("    <feature id=\"" + (featureCount + 1) + "\">\n");
                    for (int k = 0; k < attrArray.length; ++k) {
                        sb.append("      <" + attrArray[k] + ">" + valArray[k] + "</" + attrArray[k] + ">\n");
                    }
                    sb.append("    </feature>\n");
                    ++featureCount;
                }
                sb.append("  </layer>\n");
            }
            sb.append("</layers>\n");
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Field[] getFeatureAttributes(StyledFeatureI sf, boolean hasNSDP) {
        int i;
        if (sf == null) {
            return null;
        }
        Field[] attrs1 = sf.getIdentifiableAttributes();
        if (!hasNSDP) {
            return attrs1;
        }
        Field[] attrs2 = sf.getRenderableAttributes();
        if (attrs2 == null || attrs2.length == 0) {
            return attrs1;
        }
        if (attrs1 == null || attrs2.length == 0) {
            return attrs2;
        }
        Field[] result = new Field[attrs1.length + attrs2.length];
        for (i = 0; i < attrs1.length; ++i) {
            result[i] = attrs1[i];
        }
        for (i = 0; i < attrs2.length; ++i) {
            result[i + attrs1.length] = attrs2[i];
        }
        return result;
    }

    public static String[] convertJSONArrayToStringArray(String strJSON) {
        int pos2;
        if (strJSON == null || strJSON.length() == 0) {
            log.info("JSON string is empty.");
            return null;
        }
        int pos1 = Math.max(strJSON.indexOf(91), 0);
        String subStr = strJSON.substring(pos1 + 1, pos2 = Math.min(strJSON.lastIndexOf(93), strJSON.length() - 1));
        String[] arr = subStr.split(",");
        if (arr == null) {
            log.info("JSON array is empty.");
            return null;
        }
        String[] arr2 = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr2[i] = arr[i].substring(1, arr[i].length() - 1);
        }
        return arr2;
    }

    public static double getWMTSMetersPerUnit(SRS srs) throws Exception {
        if (srs == null) {
            throw new Exception("Spatial reference system not specified.");
        }
        Double df_ = SRS.getDistanceConversionFactor(srs.getUnit());
        if (df_ == null && !srs.isGeodetic()) {
            log.warning("Failed to get meters per unit for: " + srs.getUnit());
            return 1.0;
        }
        double metersPerUnit = 0.0;
        if (srs.isGeodetic()) {
            return 111319.49079327358;
        }
        metersPerUnit = df_;
        return metersPerUnit;
    }

    public static double getMapViewerMetersPerUnit(double[] lc, double[] uc, SRS srs) throws Exception {
        if (srs == null) {
            throw new Exception("Spatial reference system not specified.");
        }
        Double df_ = SRS.getDistanceConversionFactor(srs.getUnit());
        if (df_ == null && !srs.isGeodetic()) {
            log.warning("Failed to get meters per unit for: " + srs.getUnit());
            return 1.0;
        }
        double metersPerUnit = 0.0;
        if (srs.isGeodetic()) {
            Spheroid spheroid = srs.getSpheroid();
            if (spheroid == null) {
                return 0.0;
            }
            double[] p1 = new double[2];
            double[] p2 = new double[2];
            p1[0] = (lc[0] + uc[0]) * 0.5 * (Math.PI / 180);
            p2[0] = p1[0];
            p1[1] = (lc[1] + (uc[1] - lc[1]) * 0.25) * (Math.PI / 180);
            p2[1] = (lc[1] + (uc[1] - lc[1]) * 0.75) * (Math.PI / 180);
            metersPerUnit = 2.0 * Util.dist(p1, p2, spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - spheroid.getEccentricity2()), spheroid.getFlattening()) / (uc[1] - lc[1]);
        } else {
            metersPerUnit = df_;
        }
        return metersPerUnit;
    }
}

