/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<E>
implements Iterator<E> {
    private final Iterator<E>[] components;
    private int curr = 0;
    private boolean hasNext;

    public CompositeIterator(Iterator<E>[] components) {
        this.components = components;
        this.setHasNext();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    private final void setHasNext() {
        do {
            if (!this.components[this.curr].hasNext()) continue;
            this.hasNext = true;
            return;
        } while (++this.curr < this.components.length);
        this.hasNext = false;
    }

    @Override
    public E next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        E n = this.components[this.curr].next();
        this.setHasNext();
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

