/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.objectmerge.logging;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.adfinternal.share.objectmerge.logging.MergeRecord;
import oracle.adfinternal.share.objectmerge.logging.SandboxLogRecord;
import oracle.adfinternal.share.objectmerge.logging.SandboxLogger;

public class ADFObjectMergeLogger<Rec extends SandboxLogRecord> {
    private SandboxLogger logger = null;

    public ADFObjectMergeLogger(String sandboxId, Class recordClass) {
        if (this.logger == null) {
            this.logger = SandboxLogger.getLogger(sandboxId, recordClass);
        }
    }

    public void log(Rec record, boolean isResourceBundleMergeResolverSet) {
        if (isResourceBundleMergeResolverSet) {
            this.log(record);
        } else {
            this.logger.log(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Rec record) {
        PrintWriter writer = null;
        try {
            MergeRecord rec = (MergeRecord)record;
            String currDir = System.getProperty("user.dir");
            String fileName = currDir + "/ADFObjectMergeLogger.log";
            writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
            writer.println();
            writer.println("Summary\t\t :: \t" + rec.getSummary());
            writer.println("objectName\t\t :: \t" + rec.objectName);
            writer.println("objectType\t\t :: \t" + rec.objectType);
            writer.println("changeType\t\t :: \t" + rec.get("changeType"));
            writer.println("Conflict\t\t\t :: \t" + rec.get("isConflict"));
            writer.println("elementPath\t\t :: \t" + rec.get("elementPath"));
            writer.println("mainlineValue\t :: \t" + rec.get("mainlineValue"));
            writer.println("sandboxValue\t\t :: \t" + rec.get("sandboxValue"));
            writer.println("result\t\t\t :: \t" + rec.get("result"));
            writer.println("objectId\t\t\t :: \t" + rec.get("objectId"));
            writer.println("loggedBy\t\t :: \t" + rec.get("loggedBy"));
            writer.println("changeDate\t\t :: \t" + rec.get("changeDate"));
            writer.flush();
        }
        catch (IOException ex) {
            System.out.println("Exception while creating file to write");
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }
}

