/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.panel.Action;
import oracle.dbtools.raptor.metrics.panel.ConnectionNameAttribute;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

public class JobRefresh
implements Action {
    private Context context;
    private final StringProperty connectionTypeNameProperty = new SimpleStringProperty((Object)this, "connectionTypeName");
    private final StringProperty pathProperty = new SimpleStringProperty((Object)this, "path");

    public JobRefresh() {
        this.init(new Listener());
    }

    public String getConnectionTypeName() {
        return (String)this.connectionTypeNameProperty.get();
    }

    public void setConnectionTypeName(String string) {
        this.connectionTypeNameProperty.set((Object)string);
    }

    public StringProperty connectionTypeNameProperty() {
        return this.connectionTypeNameProperty;
    }

    public String getPath() {
        return (String)this.pathProperty.get();
    }

    public void setPath(String string) {
        this.pathProperty.set((Object)string);
    }

    public StringProperty pathProperty() {
        return this.pathProperty;
    }

    @Override
    public Boolean get() {
        URI uRI = DXIds.newId(this.getConnectionTypeName(), ConnectionNameAttribute.get(this.context), this.getPath());
        DXService.requestJobRun(uRI, dXError -> {
            if (dXError.getException() != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to request job refresh", dXError.getException());
            }
        });
        return true;
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            JobRefresh.this.context = context;
        }
    }
}

