/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.actionobject.AbstractConsumerAction;
import oracle.dbtools.raptor.metrics.actionobject.BackgroundTask;
import oracle.dbtools.raptor.metrics.panel.ConnectionNameAttribute;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.GeneratedDataObject;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class RunSQLScript
extends AbstractConsumerAction<GeneratedDataObject> {
    private String connectionName;
    private final ObjectProperty<EventHandler<ActionEvent>> onCompleteProperty = new SimpleObjectProperty((Object)this, "onComplete");

    public RunSQLScript() {
        this.init(new Listener());
    }

    public EventHandler<ActionEvent> getOnComplete() {
        return (EventHandler)this.onCompleteProperty.get();
    }

    public void setOnComplete(EventHandler<ActionEvent> eventHandler) {
        this.onCompleteProperty.set(eventHandler);
    }

    public ObjectProperty<EventHandler<ActionEvent>> onCompleteProperty() {
        return this.onCompleteProperty;
    }

    @Override
    protected boolean onInvokeAction(final GeneratedDataObject generatedDataObject) {
        BackgroundTask backgroundTask = new BackgroundTask(){

            @Override
            protected void doTask(BackgroundTask.Context context) {
                RunSQLScript.this.processScript(context, generatedDataObject);
                Platform.runLater(() -> {
                    EventHandler<ActionEvent> eventHandler = RunSQLScript.this.getOnComplete();
                    if (eventHandler != null) {
                        eventHandler.handle((Event)new ActionEvent());
                    }
                });
            }
        };
        backgroundTask.enqueue();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScript(BackgroundTask.Context context, GeneratedDataObject generatedDataObject) {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this.connectionName, true);
        }
        catch (DBException dBException) {
            context.setStatus(false, MetricsResources.format("METRICS_SQL_FAILURE", dBException.getLocalizedMessage()));
        }
        if (connection != null) {
            ScriptParser scriptParser = new ScriptParser(generatedDataObject.getValue(), connection);
            scriptParser.parse();
            ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
            if (Connections.getInstance().lock(connection)) {
                try {
                    for (ISQLCommand iSQLCommand : iSQLCommandArray) {
                        if (context.isCancelled()) break;
                        String string = iSQLCommand.getSql().replace("\r", " ");
                        try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                            preparedStatement.execute();
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "processed -> {0}", string);
                        }
                    }
                    context.setStatus(true, MetricsResources.getString("METRICS_SQL_SUCCESS"));
                }
                catch (SQLException sQLException) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException2) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to rollback following error", sQLException2);
                    }
                    context.setStatus(false, MetricsResources.format("METRICS_SQL_FAILURE", sQLException.getLocalizedMessage()));
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    protected class Listener
    extends AbstractConsumerAction.Listener {
        protected Listener() {
        }

        @Override
        public void onLoad(Context context) {
            RunSQLScript.this.connectionName = ConnectionNameAttribute.get(context);
        }
    }
}

