/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.util.HashSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import oracle.dbtools.raptor.metrics.console.JobView;
import oracle.dbtools.raptor.metrics.console.SourceTypeView;
import oracle.dbtools.raptor.metrics.console.ViewObject;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.listener.SourceChange;

public class SourceView
extends ViewObject<SourceChange> {
    private ObjectProperty<SourceTypeView> sourceTypeProperty;
    private ObservableSet<JobView> jobsProperty;
    private ObservableSet<JobView> unmodifiableJobsProperty;
    private final StringProperty connectionDisplayNameProperty = new SimpleStringProperty((Object)this, "connectionDisplayName", "");
    private final BooleanProperty connectedProperty = new SimpleBooleanProperty((Object)this, "connected", false);

    public SourceTypeView getSourceType() {
        return (SourceTypeView)this.sourceTypeProperty().get();
    }

    public ObservableObjectValue<SourceTypeView> sourceTypeProperty() {
        return this.sourceTypeProperty;
    }

    public ObservableSet<JobView> getJobs() {
        return this.unmodifiableJobsProperty;
    }

    public String getConnectionDisplayName() {
        return (String)this.connectionDisplayNameProperty.get();
    }

    public ObservableStringValue connectionDisplayNameProperty() {
        return this.connectionDisplayNameProperty;
    }

    public boolean isConnected() {
        return this.connectedProperty.get();
    }

    public ObservableBooleanValue connectedProperty() {
        return this.connectedProperty;
    }

    @Override
    public String toString() {
        String string = this.getConnectionDisplayName();
        String string2 = DXIds.getConnectionParametersAsString(this.getId());
        if (string2 != null) {
            string = string + '&' + string2;
        }
        return string;
    }

    SourceView() {
    }

    @Override
    void onAdd(ViewObject.Context context, SourceChange sourceChange) {
        super.onAdd(context, sourceChange);
        this.sourceTypeProperty = new SimpleObjectProperty((Object)this, "sourceType", (Object)context.lookupObject(SourceTypeView.class, sourceChange.getTypeId()));
        this.jobsProperty = FXCollections.observableSet(new HashSet());
        this.unmodifiableJobsProperty = FXCollections.unmodifiableObservableSet(this.jobsProperty);
    }

    @Override
    void onUpdate(SourceChange sourceChange) {
        super.onUpdate(sourceChange);
        this.connectionDisplayNameProperty.set((Object)sourceChange.getConnectionDisplayName());
        this.connectedProperty.set(sourceChange.isConnected());
    }

    void addJobView(JobView jobView) {
        this.jobsProperty.add((Object)jobView);
    }

    void removeJobView(JobView jobView) {
        this.jobsProperty.remove((Object)jobView);
    }
}

